<?php

namespace Verifone\Hosted\Model;

use Magento\Checkout\Model\ConfigProviderInterface;
use Magento\Payment\Helper\Data as PaymentHelper;

class VerifoneConfigProvider implements ConfigProviderInterface
{
    protected $methodCode = "verifone_hosted";

    protected $method;

    /**
     * VerifoneConfigProvider constructor.
     *
     * @param PaymentHelper $paymentHelper
     *
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function __construct(
        PaymentHelper $paymentHelper
    ) {
        $this->method = $paymentHelper->getMethodInstance($this->methodCode);
    }

    /**
     * @return array|\array[][]
     */
    public function getConfig()
    {
        $accountSettings = $this->method->getConfigData('account_settings');

        return ($this->method->isAvailable() && null !== $accountSettings) ? [
            'payment' => [
                'verifone_hosted' => [
                    'redirectUrl' => $this->method->getRedirectUrl(),
                    'shouldPlaceOrder' => $accountSettings['order_before_redirect']
                ]
            ]
        ] : [];
    }

    /**
     * @return mixed
     */
    protected function getRedirectUrl()
    {
        return $this->method->getRedirectUrl();
    }
}
