<?php

namespace Verifone\Hosted\Model;

use VerifoneEcomAPI\ApiWrapper\Settings;

/**
 * @api
 * @since 100.0.2
 */
class Invoice4uReceiptType implements \Magento\Framework\Option\ArrayInterface
{
    /**
     * @return array|array[]
     */
    public function toOptionArray()
    {
        return [
            ['value' => Settings::INVOICE_4U_RECEIPT_TYPE_INVOICE, 'label' => __('Invoice')],
            ['value' => Settings::INVOICE_4U_RECEIPT_TYPE_FULL_RECEIPT, 'label' => __('Full receipt')],
            ['value' => Settings::INVOICE_4U_RECEIPT_TYPE_INVOICE_RECEIPT, 'label' => __('Invoice receipt')],
        ];
    }

    /**
     * @return array
     */
    public function toArray()
    {
        return [
            Settings::INVOICE_4U_RECEIPT_TYPE_INVOICE => __('Invoice'),
            Settings::INVOICE_4U_RECEIPT_TYPE_FULL_RECEIPT => __('Full receipt'),
            Settings::INVOICE_4U_RECEIPT_TYPE_INVOICE_RECEIPT => __('Invoice receipt'),
        ];
    }
}
