<?php

namespace Verifone\Hosted\Cron;

use Magento\Sales\Model\Order;
use \Psr\Log\LoggerInterface;
use \Magento\Sales\Model\ResourceModel\Order\CollectionFactory;

class CancelPendingOrders
{
    const PAYMENT_METHOD = 'verifone_hosted';

    protected $_logger;
    protected CollectionFactory $_orderCollectionFactory;

    public function __construct(
        CollectionFactory $orderCollectionFactory,
        LoggerInterface   $logger
    ) {
        $this->_orderCollectionFactory = $orderCollectionFactory;
        $this->_logger = $logger;
    }

    public function execute()
    {
        $this->_logger->info("Cancel pending orders - starting cron");

        $durationInSeconds = 3600;
        $currentTime = gmdate('Y-m-d H:i:s', time() - $durationInSeconds);

        $orders = $this->_orderCollectionFactory
            ->create()
            ->addAttributeToSelect('*')
            ->addFieldToFilter('created_at', ['lt' => $currentTime])
            ->addFieldToFilter('status', ['eq' => 'pending']);

        $orders->getSelect();

        foreach ($orders as $order) {
            if ($order->getPayment()->getMethod() == self::PAYMENT_METHOD) {
                $order->addStatusHistoryComment(__('Order has been canceled automatically'), Order::STATE_CANCELED)
                    ->setIsVisibleOnFront(true)
                    ->setIsCustomerNotified(false)
                    ->setStatus(Order::STATE_CANCELED)
                    ->setState(Order::STATE_CANCELED);

                $order->save();
                $this->_logger->info("Canceled pending order ".$order->getIncrementId());
            }
        }

        $this->_logger->info("Cancel pending orders completed - stopping cron");

        return $this;
    }
}
