<?php

namespace Verifone\Hosted\Controller\Standard;

use Magento\Framework\Controller\ResultFactory;

class Response extends \Verifone\Hosted\Controller\Checkout
{

    /**
     * @return \Magento\Framework\App\ResponseInterface|\Magento\Framework\Controller\ResultInterface|void
     * @throws \Magento\Framework\Exception\LocalizedException
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     * @throws \Exception
     */
    public function execute()
    {

        // Get params from response
        $params = $this->getRequest()->getParams();
        $paymentMethod = $this->getPaymentMethod();
        $result = $this->getCheckoutHelper()->checkPaymentResponse($paymentMethod, $params);

        if (!$result || $result['status'] !== "COMPLETED") {
            $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
            $messageManager = $objectManager->get('Magento\Framework\Message\ManagerInterface');
            $messageManager->addErrorMessage('Something went wrong. Your payment was not successful. Please try again!');
            $returnUrl = $this->getCheckoutHelper()->getUrl('checkout/cart');
            return $this->getResponse()->setRedirect($returnUrl);
        }

        $transactionId = $result['transaction_id'];
        $quoteId = $this->getQuote()->getId()??$result['merchant_reference'];
        $quote = $quoteId ? $this->_quoteRepository->get($quoteId) : $this->getCheckoutHelper()->getQuoteByIncrementId($transactionId);

        if ($quote) {
            $this->getCheckoutSession()->replaceQuote($quote);
        }

        // Get payment method code
        $code = $paymentMethod->getCode();
        $order = $this->getCheckoutHelper()->getOrderByIncrementId($quote->getReservedOrderId());

        if (!$order && !$quote) {
            $this->messageManager->addExceptionMessage(
                new \Exception(__('Missing order and quote data!')),
                __('Missing order and quote data!')
            );
        }

        if ($quote && !$order) {
            if ($this->getCustomerSession()->isLoggedIn()) {
                if (isset($params['email']) && !empty($params['email'])) {
                    $quote->setCustomerEmail($params['email']);
                }
                $quote->setCheckoutMethod(\Magento\Checkout\Model\Type\Onepage::METHOD_CUSTOMER);
            } else {
                $quote->setCheckoutMethod(\Magento\Checkout\Model\Type\Onepage::METHOD_GUEST);
            }

            $quote->setPaymentMethod($code);
            $quote->getPayment()->importData(['method' => $code]);
            $this->_quoteRepository->save($quote);
        }

        if (!$order) {
            try {
                //Quote has been updated. From now, we process the checkout
                $this->initCheckout();
                $this->_cartManagement->placeOrder(
                    $quote->getId(),
                    $quote->getPayment()
                );
                $order = $this->getOrder();

                if (!$this->_checkoutHelper->checkVerifoneTransactionIdInOrderLogHistory($transactionId, $order)) {
                    $order->addStatusHistoryComment(__('Order created when redirected from payment page. Transaction ID: "%1"', $transactionId));
                }

            } catch (\Exception $e) {
            }
        } else {
            // set the checkoutSession for the redirect
            $this->getCheckoutSession()
                 ->setLastSuccessQuoteId($quote->getId())
                 ->setLastQuoteId($quote->getId())
                 ->setLastRealOrderId($order->getIncrementId())
                 ->setLastOrderId($order->getId())
                 ->setLastOrderStatus($order->getStatus());
        }

        if ($order && !$this->_checkoutHelper->checkVerifoneTransactionIdInOrderLogHistory($transactionId, $order)) {
            $order->setExtOrderId($transactionId);
            $order->save();

            $manualCapture = $this->getCheckoutHelper()->checkManualCapture();

            $paymentMethod->postProcessing($order, $result, $manualCapture, $result['payment_method_used'], (int) $result['amount']);
        }

        $returnUrl = $this->getCheckoutHelper()->getUrl('checkout/onepage/success');

        $this->getResponse()->setRedirect($returnUrl);
    }
}
