<?php

namespace Overdose\Quote\Plugin\Controller\Cart;

use Magento\Checkout\Model\Cart as CustomerCart;
use Magento\Checkout\Model\Cart\RequestQuantityProcessor;
use Magento\Checkout\Model\Session;
use Magento\Framework\App\Action\Context;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\App\ResponseInterface;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Framework\Data\Form\FormKey\Validator;
use Magento\Framework\App\ResourceConnection;
use Magento\CatalogInventory\Model\StockRegistry;

class UpdatePost extends \Magento\Checkout\Controller\Cart\UpdatePost
{
    /**
     * @var ResourceConnection
     */
    protected ResourceConnection $resource;

    /**
     * @var StockRegistry
     */
    protected StockRegistry $stockRegistry;

    /**
     * @var RequestQuantityProcessor
     */
    private $quantityProcessor;

    /**
     * @param Context $context
     * @param ScopeConfigInterface $scopeConfig
     * @param Session $checkoutSession
     * @param StoreManagerInterface $storeManager
     * @param Validator $formKeyValidator
     * @param CustomerCart $cart
     * @param ResourceConnection $resource
     * @param StockRegistry $stockRegistry
     * @param RequestQuantityProcessor|null $quantityProcessor
     */
    public function __construct
    (
        Context                  $context,
        ScopeConfigInterface     $scopeConfig,
        Session                  $checkoutSession,
        StoreManagerInterface    $storeManager,
        Validator                $formKeyValidator,
        CustomerCart             $cart,
        ResourceConnection       $resource,
        StockRegistry            $stockRegistry,
        RequestQuantityProcessor $quantityProcessor = null
    ) {
        $this->quantityProcessor = $quantityProcessor;
        $this->resource = $resource;
        $this->stockRegistry = $stockRegistry;
        parent::__construct($context, $scopeConfig, $checkoutSession, $storeManager, $formKeyValidator, $cart, $quantityProcessor);
    }

    public function execute()
    {
        try {
            $this->messageManager->getMessages(true);
            $cartData = $this->getRequest()->getParam('cart');
            if (is_array($cartData)) {
                $productRequest = [];
                $quoteItemIds = [];
                $productWithNewQty = [];
                foreach ($cartData as $quoteItemId => $data) {
                    $quoteItemIds[] = $quoteItemId;
                    $productRequest[$quoteItemId] = $data['qty'];
                }

                $select = $this->getConnection()->select()->from(
                    ['qi' => $this->getConnection()->getTableName('quote_item')],
                    ['item_id', 'product_id', 'qty']
                )->where(
                    'qi.item_id IN (' . implode(',', $quoteItemIds) . ')'
                );
                $result = $this->getConnection()->fetchAll($select);
                foreach ($result as $data) {
                    if (isset($productRequest[$data['item_id']])) {
                        if (isset($productWithNewQty[$data['product_id']])) {
                            $productWithNewQty[$data['product_id']] += (int)$productRequest[$data['item_id']];
                        } else {
                            $productWithNewQty[$data['product_id']] = (int)$productRequest[$data['item_id']];
                        }
                        $stockData = $this->stockRegistry->getStockItem($data['product_id'], $this->_storeManager->getWebsite()->getId());
                        $allowMaxQty = (int)$stockData->getMaxSaleQty();
                        if ($productWithNewQty[$data['product_id']] > $allowMaxQty) {
                            $this->messageManager->addErrorMessage("The requested quantity exceeds the maximum quantity allowed in shopping cart");
                            $url = $this->_checkoutSession->getRedirectUrl(true);
                            if (!$url) {
                                $url = $this->_redirect->getRedirectUrl($this->getCartUrl());
                            }
                            return $this->goBackWithMessage($url, $data['product_id'], $productWithNewQty[$data['product_id']], $allowMaxQty);
                        }
                    }
                }
            }
        } catch (\Exception $e) {

        }

        return parent::execute();
    }

    /**
     * @return \Magento\Framework\DB\Adapter\AdapterInterface
     */
    public function getConnection()
    {
        return $this->resource->getConnection(\Magento\Framework\App\ResourceConnection::DEFAULT_CONNECTION);
    }

    /**
     * @param $backUrl
     * @param $quoteId
     * @param $qtyCheck
     * @param $allowMaxQty
     * @return ResponseInterface|\Magento\Framework\Controller\Result\Redirect
     */
    protected function goBackWithMessage($backUrl, $productId, $qtyCheck, $allowMaxQty)
    {
        if (!$this->getRequest()->isAjax()) {
            return parent::_goBack($backUrl);
        }
        $result = [];
        $result['odMaxQtyError'] = 'The requested quantity exceeds the maximum quantity allowed in shopping cart';
        $result['product_id'] = $productId;
        $result['check_qty'] = $qtyCheck;
        $result['allow_max_qty'] = $allowMaxQty;

        $this->getResponse()->representJson(
            json_encode($result)
        );

        return $this->getResponse();
    }

    /**
     * Returns cart url
     *
     * @return string
     */
    private function getCartUrl()
    {
        return $this->_url->getUrl('checkout/cart', ['_secure' => true]);
    }
}
