# Overdose ProductBanners

M2 module.  Add new type of product - banners
Overdose Product banner  

# Installation

**COMPOSER INSTALLATION VIA BITBUCKET IS NOT RECOMMENDED**

You should use [packagist](https://overdosedigital.atlassian.net/wiki/spaces/DM/pages/752844873/Composer+and+Git) for this

But if you want to use install via bitbucket anyway:

```bash
composer config repositories.overdose/product-banners vcs git@bitbucket.org:overdosedigital/module-product-banners.git
composer require overdose/module-product-banners
```

## Functionality

- Adds new type product(banner). This product can be used as a promotional banner in the product listing.  
- This product can't be purchased or opened as product page.  
- You can use the attribute "banner_url" for set URL of promotion banner.  
- added possibility display product description instead of image (settings:  Configurations->Overdose Product Banners->Theme Settings->Use description field instead product image)  

Additional you can hide some html elements from product item banner 
(in order to do it need set css selector Configurations->Overdose Product Banners->Theme Settings->Selector to hide from banner item) 

### Screenshots
- product listing: https://i.imgur.com/AFcPF9X.jpg
- new type product: https://i.imgur.com/EPT2XWa.jpg
- set url for banner: https://i.imgur.com/dT7xcbR.jpg
- settings: 

## Configurations

- `overdose_product_banner/general/enable`. Global disable all product banners. Default: Yes.
- `overdose_product_banner/general/is_filter_sensitive`. If NO - banner shows always.Yes - depends from filter.
- `overdose_product_banner/general/search_exclude`. Should exclude Product Banner product type from search?. Default: No.
- `overdose_product_banner/theme_settings/product_item_selector`. Product item selector from category page. Default: `.item.product.product-item`.
- `overdose_product_banner/theme_settings/selector_to_hide`. You can add css selectors to hide this element from banner item. Default: `.product-item-details`.
- `overdose_product_banner/theme_settings/use_description_instead_product_image`. Show banner description or image. Default: Yes (image).

## Additional
### Exclude banner from algolia popup
If you are using Overdose Algolia module and want to exclude a banner product from search popup:
1. 
   Override Overdose js in you theme
   ```bash
   vendor/overdose/module-algolia-autocomplete-filters/view/frontend/web/js/autocomplete-filters.js
   ```
2. Find initialization of **allWidgetConfiguration** variable
3. Add
   ```bash
   data.helper.addNumericRefinement('visibility_search', '=', 1);
   ```
   to a **render** function. Content should look like:
   ```bash
   allWidgetConfiguration = {
        ...
        custom: [
            {
                render: function (data) {
                    if (data.results.hits.length) {
                        $('#algolia_instant_selector').show();
                        $('#empty-container').hide();
                        data.helper.addNumericRefinement('visibility_search', '=', 1);
                    } else {...}
                }
            }
        ],
        ...
    };
   ```
