<?php
namespace Overdose\ProductBanners\Observer;

use Magento\Catalog\Api\Data\ProductInterface;
use Magento\Catalog\Model\Product\Action as ProductAction;
use Magento\Catalog\Model\Product\Visibility;
use Magento\Framework\Api\SearchCriteriaBuilder;
use Magento\Framework\Event\Observer as EventObserver;
use Magento\Framework\Event\ObserverInterface;
use Overdose\ProductBanners\Helper\Data as ProductBannerHelper;
use Overdose\ProductBanners\Model\Product\Type\Banner;
use Magento\Catalog\Api\ProductRepositoryInterface;

/**
 * Class SearchExcludeChange
 * @package Overdose\ProductBanner\Observer
 */
class SearchExcludeChange implements ObserverInterface
{
    /**
     * @var ProductAction
     */
    private $productAction;

    /**
     * @var SearchCriteriaBuilder
     */
    private $searchCriteriaBuilder;

    /**
     * @var ProductBannerHelper
     */
    private $productBannerHelper;

    /**
     * @var ProductRepositoryInterface
     */
    private $productRepository;

    /**
     * SearchExcludeChange constructor.
     * @param ProductAction $action
     * @param SearchCriteriaBuilder $searchCriteriaBuilder
     * @param ProductBannerHelper $productBannerHelper
     * @param ProductRepositoryInterface $productRepository
     */
    public function __construct(
        ProductAction $action,
        SearchCriteriaBuilder $searchCriteriaBuilder,
        ProductBannerHelper $productBannerHelper,
        ProductRepositoryInterface $productRepository
    ) {
        $this->productAction = $action;
        $this->searchCriteriaBuilder = $searchCriteriaBuilder;
        $this->productBannerHelper = $productBannerHelper;
        $this->productRepository = $productRepository;
    }

    /**
     * @param EventObserver $observer
     * @return $this|void
     */
    public function execute(EventObserver $observer)
    {
        if ($this->productBannerHelper->isExcludedFromSearch()) {
            $this->setVisibility(Visibility::VISIBILITY_IN_CATALOG);
        } else {
            $this->setVisibility(Visibility::VISIBILITY_BOTH);
        }
        return $this;
    }

    /**
     * @param int $visibilityOption
     */
    public function setVisibility(int $visibilityOption)
    {
        $searchCriteria = $this->searchCriteriaBuilder->addFilter(
            ProductInterface::TYPE_ID,
            Banner::PRODUCT_TYPE_BANNER
        )->create();

        $productList = $this->productRepository->getList($searchCriteria);
        $productIdsByWebsiteId = [];
        foreach ($productList->getItems() as $product) {
            $websiteIds = $product->getExtensionAttributes()->getWebsiteIds() ?: [];
            foreach ($websiteIds as $websiteId) {
                $productIdsByWebsiteId[$websiteId][] = $product->getId();
            }
        }

        foreach ($productIdsByWebsiteId as $websiteId => $productIds) {
            $this->productAction->updateAttributes(
                $productIds,
                ['visibility' => $visibilityOption],
                $websiteId
            );
        }
    }
}
