<?php
/**
 * @author: Muhammad Shahbaz
 * @email: shahbaz.sial@overdose.digital
 */
namespace Overdose\LazyLoadJavascript\Block;

use Magento\Framework\App\Request\Http;
use Magento\Framework\View\DesignInterface;
use MageSuite\Magepack\Model\FileManager;
use Magento\Framework\View\Element\Template\Context;
use Magento\Framework\Filesystem\DirectoryList;
use Magento\Framework\View\Page\Config as PageConfig;
use Magento\Framework\RequireJs\Config as RequireJsConfig;
use Magento\Framework\View\Asset\Minification;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Store\Model\ScopeInterface;

/**
 * Block needed to handle JS bundles in layout.
 */
class BundlesLoader extends \MageSuite\Magepack\Block\BundlesLoader
{
    private const XML_PATH_ENABLE_MAGEPACK_BUNDLING = 'dev/js/enable_magepack_js_bundling';

    /**
     * @var ScopeConfigInterface
     */
    private  $scopeConfig;

    /**
     * @var Http
     */
    private  $request;


    /**
     * @param Context $context
     * @param DirectoryList $dir
     * @param FileManager $fileManager
     * @param PageConfig $pageConfig
     * @param RequireJsConfig $requireJsConfig
     * @param ScopeConfigInterface $scopeConfig
     * @param Minification $minification
     * @param Http $request
     * @param array $data
     */
    public function __construct(
        Context $context,
        DirectoryList $dir,
        FileManager $fileManager,
        PageConfig $pageConfig,
        RequireJsConfig $requireJsConfig,
        ScopeConfigInterface $scopeConfig,
        Minification $minification,
        DesignInterface $design,
        Http $request,
        array $data = []
    ) {
        $this->scopeConfig = $scopeConfig;
        $this->request = $request;
        parent::__construct($context, $dir, $fileManager, $pageConfig, $requireJsConfig, $scopeConfig, $minification, $data);
    }

    /**
     * @return bool
     */
    public function isEnabled(): bool
    {
        return $this->scopeConfig->isSetFlag(self::XML_PATH_ENABLE_MAGEPACK_BUNDLING, ScopeInterface::SCOPE_STORE) &&
            (
                $this->request->getFullActionName() == "cms_index_index" ||
                $this->request->getFullActionName() == "catalog_category_view" ||
                $this->request->getFullActionName() == "catalog_product_view"
            );
    }
}
