<?php

declare(strict_types=1);

namespace Overdose\InventoryShipping\Model\SourceSelection;

use Magento\InventoryApi\Api\Data\SourceItemInterface;
use Magento\InventoryInStorePickupSales\Model\SourceSelection\GetSourceItemQtyAvailableService as DefaultGetSourceItemQtyAvailableService;

/**
 * Get source item qty available for usage in SSA
 * Return source item qty without any modifications
 */
class GetSourceItemQtyAvailableService extends DefaultGetSourceItemQtyAvailableService
{
    /**
     * @inheritDoc
     */
    public function execute(SourceItemInterface $sourceItem): float
    {
        return $sourceItem->getQuantity();
    }
}
