<?php

namespace Overdose\InventoryShipping\Model\ResourceModel\OrderSource;

use Magento\Framework\App\ResourceConnection;

/**
 * Save Source for order items
 */
class SaveOrderSource
{
    /**
     * Constant for fields in data array
     */
    const ORDER_ID    = 'order_id';
    const SOURCE_CODE = 'source_code';
    const SKU         = 'sku';
    const QUANTITY    = 'quantity';

    /**
     * @var ResourceConnection
     */
    private ResourceConnection $resourceConnection;

    /**
     * @param ResourceConnection $resourceConnection
     */
    public function __construct(
        ResourceConnection $resourceConnection
    ) {
        $this->resourceConnection = $resourceConnection;
    }

    /**
     * Save source for order items
     *
     * @param int $orderId
     * @param string $sourceCode
     * @param string $sku
     * @param float $quantity
     * @return void
     */
    public function execute(int $orderId, string $sourceCode, string $sku, float $quantity)
    {
        $connection = $this->resourceConnection->getConnection();
        $tableName = $this->resourceConnection->getTableName('inventory_order_source');
        $data = [
            self::ORDER_ID    => $orderId,
            self::SOURCE_CODE => $sourceCode,
            self::SKU         => $sku,
            self::QUANTITY    => $quantity
        ];
        $connection->insertOnDuplicate($tableName, $data, [self::SOURCE_CODE, self::SKU, self::QUANTITY]);
    }
}
