<?php

namespace Overdose\InventoryShipping\Model\Order;

use Magento\Framework\Exception\LocalizedException;
use Magento\InventoryInStorePickupSales\Model\Order\CreateShippingArguments;
use Magento\InventoryInStorePickupSalesApi\Model\IsOrderReadyForPickupInterface;
use Magento\Sales\Api\Data\OrderInterface;
use Magento\Sales\Api\ShipOrderInterface;

/**
 * Create shipping document for provided order.
 */
class CreateShippingDocument extends \Magento\InventoryInStorePickupSales\Model\Order\CreateShippingDocument
{
    /**
     * @var IsOrderReadyForPickupInterface
     */
    private $isOrderReadyForPickup;
    /**
     * @var ShipOrderInterface
     */
    private $shipOrder;
    /**
     * @var CreateShippingArguments
     */
    private $createShippingArguments;

    /**
     * @param IsOrderReadyForPickupInterface $isOrderReadyForPickup
     * @param ShipOrderInterface $shipOrder
     * @param CreateShippingArguments $createShippingArguments
     */
    public function __construct(
        IsOrderReadyForPickupInterface $isOrderReadyForPickup,
        ShipOrderInterface $shipOrder,
        CreateShippingArguments $createShippingArguments
    ) {
        $this->isOrderReadyForPickup = $isOrderReadyForPickup;
        $this->shipOrder = $shipOrder;
        $this->createShippingArguments = $createShippingArguments;
        parent::__construct(
            $this->isOrderReadyForPickup,
            $this->shipOrder,
            $this->createShippingArguments
        );
    }

    /**
     * Create order shipping document
     *
     * @param OrderInterface $order
     * @throws LocalizedException
     * @return void
     */
    public function execute(OrderInterface $order) : void
    {

        $this->shipOrder->execute(
            (int)$order->getEntityId(),
            [],
            false,
            false,
            null,
            [],
            [],
            $this->createShippingArguments->execute($order)
        );
    }
}
