<?php
namespace Overdose\GiftCardAccountApi\Model;

use Overdose\GiftCardAccountApi\Api\Data\GiftCardAccountInterface;

class Giftcardaccount extends \Magento\GiftCardAccount\Model\Giftcardaccount implements GiftCardAccountInterface
{
    /**#@+
     * Constants defined for keys of the data array. Identical to the name of the getter in snake case
     */
    const ID = 'id';
    const CODE = 'code';
    const DATE_CREATED = 'date_created';
    const DATE_EXPIRES = 'date_expires';
    const WEBSITE_ID = 'website_id';
    const BALANCE = 'balance';
    const STATE = 'state';
    const STATUS = 'status';
    const EMAIL_TEMPLATE = 'email_template';
    const RECIPIENT_NAME = 'recipient_name';
    const RECIPIENT_EMAIL = 'recipient_email';
    const EMAIL_SENT = 'email_sent';
    const IS_REDEEMABLE = 'is_redeemable';
    /**#@-*/

    /**
     * @inheritDoc
     */
    public function getId(): ?int
    {
        $id = parent::getId();

        return $id ? (int)$id : null;
    }

    /**
     * @inheritDoc
     */
    public function setId($id)
    {
        return $this->setData(self::ID, $id);
    }

    /**
     * @inheritDoc
     */
    public function getCode()
    {
        return $this->getData(self::CODE);
    }

    /**
     * @inheritDoc
     */
    public function setCode($code)
    {
        return $this->setData(self::CODE, $code);
    }

    /**
     * @inheritDoc
     */
    public function getStatus()
    {
        return $this->getData(self::STATUS);
    }

    /**
     * @inheritDoc
     */
    public function setStatus($status)
    {
        return $this->setData(self::STATUS, $status);
    }

    /**
     * @inheritDoc
     */
    public function getDateCreated()
    {
        return $this->getData(self::DATE_CREATED);
    }

    public function setDateCreated($date)
    {
        return $this->setData(self::DATE_CREATED, $date);
    }

    /**
     * @inheritDoc
     */
    public function getDateExpires()
    {
        return $this->getData(self::DATE_EXPIRES);
    }

    /**
     * @inheritDoc
     */
    public function setDateExpires($dateExpires)
    {
        return $this->setData(self::DATE_EXPIRES, $dateExpires);
    }

    /**
     * @inheritDoc
     */
    public function getWebsiteId()
    {
        return $this->getData(self::WEBSITE_ID);
    }

    /**
     * @inheritDoc
     */
    public function setWebsiteId($websiteId)
    {
        return $this->setData(self::WEBSITE_ID, $websiteId);
    }

    /**
     * @inheritDoc
     */
    public function getState()
    {
        return $this->getData(self::STATE);
    }

    /**
     * @inheritDoc
     */
    public function setState($state)
    {
        return $this->setData(self::STATE, $state);
    }

    /**
     * @inheritDoc
     */
    public function getBalance()
    {
        return $this->getData(self::BALANCE);
    }

    /**
     * @inheritDoc
     */
    public function setBalance($balance)
    {
        return $this->setData(self::BALANCE, $balance);
    }

    /**
     * @inheritDoc
     */
    public function getIsRedeemable()
    {
        return $this->getData(self::IS_REDEEMABLE);
    }

    /**
     * @inheritDoc
     */
    public function setIsRedeemable($isRedeemable)
    {
        return $this->setData(self::IS_REDEEMABLE, $isRedeemable);
    }
}
