<?php

namespace Overdose\DataLayer\Observer;

use Magento\Framework\Event\ObserverInterface;
use Magento\Framework\Stdlib\CookieManagerInterface;
use Overdose\DataLayer\Helper\Ec;
use Magento\Customer\Model\Session as CustomerSession;

class AddAttribute implements ObserverInterface
{
    /**
     * @var Ec
     */
    protected $ec;

    /**
     * @var CookieManagerInterface
     */
    protected CookieManagerInterface $cookieManager;

    /**
     * @var CustomerSession
     */
    protected $customerSession;

    /**
     * @param Ec $ec
     * @param CookieManagerInterface $cookieManager
     * @param CustomerSession $customerSession
     */
    public function __construct(Ec $ec, CookieManagerInterface $cookieManager, CustomerSession $customerSession)
    {
        $this->ec = $ec;
        $this->cookieManager = $cookieManager;
        $this->customerSession = $customerSession;
    }

    /**
     * @param \Magento\Framework\Event\Observer $observer
     * @return $this|void
     */
    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        $odAddToCartSessionData = [];
        $transport = $observer->getData('transport');
        $productClickData = $this->cookieManager->getCookie('od-product-click');
        $product = $transport->getData('product');
        $categoryData = $this->ec->getCategoryData($product);
        $productWidth = $this->ec->getProductWidth($product);
        $productColor = $this->ec->getProductColor($product);
        $discountAndSizeMapping = $this->ec->getDiscountandSizeMapping($product);
        $affiliation = $this->ec->getAffiliation($product);
        $attributes = $transport->getAttributes();
        $attributes['affiliation'] = $affiliation;
        $attributes['item_brand'] = $affiliation;
        $attributes['item_variant'] = $productColor;
        if ($productWidth) {
            $attributes['item_width'] = $productWidth;
        }
        $attributes['item_list_id'] = $this->ec->getItemListId($productClickData, $product);
        $attributes['item_list_name'] = $this->ec->getItemListname($productClickData, $product);
        $odAddToCartSession = $this->customerSession->getOdAddToCartSession();
        if ($odAddToCartSession && is_array($odAddToCartSession)) {
            $odAddToCartSession[$product->getId()] = [
                'item_list_id' => $attributes['item_list_id'],
                'item_list_name' => $attributes['item_list_name'],
            ];
            $odAddToCartSessionData = $odAddToCartSession;
        } else {
            $odAddToCartSessionData[$product->getId()] = [
                'item_list_id' => $attributes['item_list_id'],
                'item_list_name' => $attributes['item_list_name'],
            ];
        }
        $this->customerSession->setOdAddToCartSession($odAddToCartSessionData);
        $attributes = array_merge($attributes, $categoryData, $discountAndSizeMapping);
        $transport->setAttributes($attributes);
        return $this;
    }
}
