<?php

namespace Overdose\Customer\Plugin\Magento\Newsletter\Controller\Manage;

use Magento\Customer\Api\CustomerRepositoryInterface as CustomerRepository;
use Magento\Customer\Model\CustomerFactory;
use Magento\Newsletter\Model\SubscriptionManagerInterface;

class SavePlugin extends \Magento\Newsletter\Controller\Manage\Save
{
    /**
     * @var CustomerFactory
     */
    private $customerFactory;


    public function __construct(
        \Magento\Framework\App\Action\Context $context,
        \Magento\Customer\Model\Session $customerSession,
        \Magento\Framework\Data\Form\FormKey\Validator $formKeyValidator,
        \Magento\Store\Model\StoreManagerInterface $storeManager,
        CustomerRepository $customerRepository,
        SubscriptionManagerInterface $subscriptionManager,
        CustomerFactory $customerFactory
    ) {
        parent::__construct(
            $context,
            $customerSession,
            $formKeyValidator,
            $storeManager,
            $customerRepository,
            $subscriptionManager
        );

        $this->customerFactory = $customerFactory;
    }

    public function afterExecute(\Magento\Newsletter\Controller\Manage\Save $subject, $result)
    {
        if (!$this->formKeyValidator->validate($this->getRequest())) {
            return $result;
        }

        $customerId = $this->_customerSession->getCustomerId();
        $customer = $this->customerFactory->create()->load($customerId);

        $interestedInGender = $this->getRequest()->getParam('interested_in_gender');
        $interestedIn = $this->getRequest()->getParam('interested_in');

        if ($interestedIn) {
            $interestedIn = implode(',', $interestedIn);
        }

        $customer->setData('interested_in_gender', $interestedInGender);
        $customer->setData('interested_in', $interestedIn);
        $customer->save();
        return $result;
    }
}
