<?php

namespace Overdose\Customer\CustomerData;

use Magento\Customer\CustomerData\SectionSourceInterface;
use Magento\Customer\Model\Session as CustomerSession;
use Magento\Sales\Model\Order\Config;
use Magento\Sales\Model\OrderFactory;
use Magento\Wishlist\Model\Wishlist;

/**
 * Class Counters
 * @package Overdose\Customer\CustomerData
 */
class Counters extends \Magento\Framework\DataObject implements SectionSourceInterface
{
    /**
     * @var CustomerSession
     */
    private $customerSession;

    /**
     * @var OrderFactory
     */
    private $orderFactory;
    /**
     * @var Config
     */
    private $orderConfig;
    /**
     * @var Wishlist
     */
    private $wishlist;



    /**
     * Counters constructor.
     * @param CustomerSession $customerSession
     * @param OrderFactory $orderFactory
     * @param Config $orderConfig
     * @param Wishlist $wishlist
     */
    public function __construct(
        CustomerSession $customerSession,
        OrderFactory $orderFactory,
        Config $orderConfig,
        Wishlist $wishlist
    ) {
        $this->customerSession = $customerSession;
        $this->orderFactory = $orderFactory;
        $this->orderConfig = $orderConfig;
        $this->wishlist = $wishlist;
        parent::__construct();
    }

    /**
     * @return array
     */
    public function getSectionData()
    {
        return [
            'wishListCounter' => $this->getWishlist(),
            'orderCounter' => $this->getOrders(),
        ];
    }

    /**
     * @return int|void
     */
    public function getWishlist()
    {
        $id = $this->customerSession->getCustomer()->getId();
        $wishlist = $this->wishlist->loadByCustomerId($id)->getItemCollection();

        return count($wishlist);
    }

    /**
     * @return int|void
     */
    public function getOrders()
    {
        if (!($customerId = $this->customerSession->getCustomerId())) {
            return 0;
        }
        $customerId = $this->customerSession->getCustomer()->getId();
        return count($this->orderFactory->create()->getCollection()->addFieldToSelect(
            '*'
        )->addFieldToFilter(
            'customer_id',
            $customerId
        )->addFieldToFilter(
            'status',
            ['in' => $this->orderConfig->getVisibleOnFrontStatuses()]
        )->setOrder(
            'created_at',
            'desc'
        ));
    }

}
