<?php

namespace Overdose\CheckoutSuccess\ViewModel;

use Magento\Catalog\Helper\Image;
use Magento\Sales\Model\Order\Item;
use Overdose\DataLayer\Helper\Cookies;
use Magento\Directory\Model\ResourceModel\Country\Collection as CountryCollection;
use Magento\Framework\Pricing\Helper\Data as PriceHelper;
class Success implements \Magento\Framework\View\Element\Block\ArgumentInterface
{
    const PRODUCT_IMAGE_WIDTH = 200;
    const PRODUCT_IMAGE_HEIGHT = 200;

    /** @var Image */
    protected $imageHelper;
    /**
     * @var Cookies
     */
    protected $cookie;
    /**
     * @var CountryCollection
     */
    protected $countryCollection;

    /**
     * @var PriceHelper
     */
    protected $priceHelper;

    /**
     * @param Cookies $cookie
     * @param CountryCollection $countryCollection
     * @param PriceHelper $priceHelper
     * @param Image $imageHelper
     */
    public function __construct
    (
        Cookies                        $cookie,
        CountryCollection              $countryCollection,
        PriceHelper                    $priceHelper,
        Image                          $imageHelper,
    ) {
        $this->cookie = $cookie;
        $this->countryCollection = $countryCollection;
        $this->priceHelper = $priceHelper;
        $this->imageHelper = $imageHelper;
    }

    /**
     * @return Cookies
     */
    public function getHelperDataLayer()
    {
        return $this->cookie;
    }

    /**
     * @param $countryId
     * @return mixed
     */
    public function getCountryNameById($countryId)
    {
        $country = $this->countryCollection->addFieldToFilter('country_id', $countryId)->getFirstItem();
        return $country->getName();
    }

    /**
     * @return PriceHelper
     */
    public function getPriceHelper()
    {
        return $this->priceHelper;
    }

    /**
     * @param Item $item
     * @return string
     */
    public function getProductImage(Item $item)
    {
        $imageUrl = $this->imageHelper->init($item->getProduct(), 'product_page_image_medium')
            ->setImageFile($item->getProduct()->getImage())->resize(
                static::PRODUCT_IMAGE_WIDTH,
                static::PRODUCT_IMAGE_HEIGHT
            )->getUrl();

        return $imageUrl;
    }
}
