<?php
/**
 * BSS Commerce Co.
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the EULA
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://bsscommerce.com/Bss-Commerce-License.txt
 *
 * @category   BSS
 * @package    Bss_LazyImageLoader
 * @author     Extension Team
 * @copyright  Copyright (c) 2018-2019 BSS Commerce Co. ( http://bsscommerce.com )
 * @license    http://bsscommerce.com/Bss-Commerce-License.txt
 */
namespace Overdose\BssLazyLoad\Helper;

use Bss\LazyImageLoader\Helper\Data as BaseData;
use Magento\Framework\App\Helper\Context;
use Magento\Framework\View\Asset\Repository;
use Magento\Store\Model\StoreManagerInterface;
use Overdose\BssLazyLoad\Model\Config;

class Data extends BaseData
{

    /**
     * @var Repository
     */
    private $assetRepo;

    public function __construct(
        StoreManagerInterface $storeManager,
        Context $context,
        Repository $assetRepo
    ) {
        parent::__construct(
            $storeManager,
            $context
        );
        $this->assetRepo = $assetRepo;
    }

    /**
     * @inheritdoc
     */
    public function lazyLoad($html)
    {
        $selector = '';
        if(!$this->isIncludeAllImagesEnabled()){
            $selector = 'product-image-photo';
        }

        $lazyImage = $this->getLazyImg();

        if (isset($_SERVER['HTTP_USER_AGENT'])) {
            $regex = '#<img class="' . $selector. '([^>]*) src="([^"/]*/?[^".]*\.[^"]*)"(?!.*?notlazy)([^>]*)>#';
            if (preg_match('/MSIE/i', $_SERVER['HTTP_USER_AGENT'])) {
                $replace = '<noscript><img$1 src="$2" $3></noscript>';
                $replace .= '<img class="lazy lazyload $1 src="' . $lazyImage . '" data-src="$2"$3>';
            } else {
                $replace = '<img class="$1 loading="lazy" src="$2"$3>';
            }
            $html = preg_replace($regex, $replace, $html);
        }
        return $html;
    }

    /**
     * @return mixed
     */
    private function isIncludeAllImagesEnabled()
    {
        return $this->scopeConfig
            ->getValue(
                Config::INCLUDE_ALL_IMAGES,
                \Magento\Store\Model\ScopeInterface::SCOPE_STORE
            );
    }


    /**
     * @return array
     */
    private function getExcludeClasses()
    {
        $result = [];

        $classes = $this->scopeConfig
            ->getValue(
                Config::EXCLUDE_CLASSES,
                \Magento\Store\Model\ScopeInterface::SCOPE_STORE
            );

        $classes = str_replace(["\r\n", "\n'\r", "\n"], "\r", $classes ?? '');
        $classes = explode("\r", $classes);
        foreach ($classes as $class) {
            if ($class = trim($class)) {
                $result[] = $class;
            }
        }

        return $result;
    }
}
