<?php

namespace BrittainWynyard\Sales\Observer;

use Magento\Framework\Event\Observer as EventObserver;
use Magento\Framework\Event\ObserverInterface;

class OrderLoadAfter implements ObserverInterface
{

    /**
     * When an order is loaded add our custom attribute 'accredo_fetched_at' to its extension attributes
     *
     * @param EventObserver $observer
     */
    public function execute(EventObserver $observer)
    {
        /** @var \Magento\Sales\Api\Data\OrderInterface $order */
        $order = $observer->getOrder();

        if (!$order) {
            return;
        }

        $extensionAttributes = $order->getExtensionAttributes();

        if ($extensionAttributes === null) {
            /** @var $extensionAttributes \Magento\Sales\Api\Data\OrderExtension */
            $extensionAttributes = $this->getOrderExtensionDependency();

        }

        $attr = $order->getData('accredo_fetched_at');
        $extensionAttributes->setAccredoFetchedAt($attr);
        $order->setExtensionAttributes($extensionAttributes);

        $billing = $order->getBillingAddress();

        if (!$billing) {
            return;
        }

        $billingExtensionAttributes = $billing->getExtensionAttributes();

//        if ($extensionAttributes === null) {
//            /** @var $billingExtensionAttributes \Magento\Sales\Api\Data\OrderExtension */
//            $billingExtensionAttributes = $this->getOrderExtensionDependency();
//
//        }

        $billingExtensionAttributes->setSuburb($billing->getSuburb());
        $billingExtensionAttributes->setBuilding($billing->getBuilding());


        $billing->setExtensionAttributes($billingExtensionAttributes);
    }

    private function getOrderExtensionDependency()
    {
        $orderExtension = \Magento\Framework\App\ObjectManager::getInstance()->get(
            '\Magento\Sales\Api\Data\OrderExtension'
        );

        return $orderExtension;
    }
}
