<?php

namespace BrittainWynyard\RecentlyViewedWidget\Ui\DataProvider\Product\Listing\Collector;

use Magento\Catalog\Api\Data\ProductInterface;
use Magento\Catalog\Api\Data\ProductRenderExtensionFactory;
use Magento\Catalog\Api\Data\ProductRenderInterface;
use Magento\Catalog\Model\Product\Attribute\Source\Status;
use Magento\Catalog\Ui\DataProvider\Product\ProductRenderCollectorInterface;
use Overdose\Catalog\ViewModel\DiscountLableViewModel;

class AsicsDiscount implements ProductRenderCollectorInterface
{
    const KEY = "has_tier_price";

    /**
     * Material constructor.
     * @param ProductRenderExtensionFactory $productRenderExtensionFactory
     * @param DiscountLableViewModel $discountLabel
     */
    public function __construct(
        private readonly ProductRenderExtensionFactory $productRenderExtensionFactory,
        private readonly DiscountLableViewModel $discountLabel
    ) {
    }

    /**
     * @inheritdoc
     */
    public function collect(ProductInterface $product, ProductRenderInterface $productRender)
    {
        $extensionAttributes = $productRender->getExtensionAttributes();

        if (!$extensionAttributes) {
            $extensionAttributes = $this->productRenderExtensionFactory->create();
        }
        $extensionAttributes->setHasTierPrice($this->discountLabel->hasGeneralTierPrice($product));
        $extensionAttributes->setDiscountText($this->discountLabel->getDiscountText());
        $extensionAttributes->setFormattedSku($this->replaceIllegalCharacters($this->getProductId($product)));

        $productRender->setExtensionAttributes($extensionAttributes);
    }

    private function replaceIllegalCharacters($sku)
    {
        $rawProductId = preg_replace_callback('/\./s', function ($match) {
            return "_bv".ord($match[0])."_";
        }, $sku);

        /**
         * We need to use a reversible replacement so that we can reconstruct the original ID later.
         * Example rawId = qwerty$%@#asdf
         * Example encoded = qwerty_bv36__bv37__bv64__bv35_asdf
         */
        return preg_replace_callback('/[^\w\d\*\-_]/s', function ($match) {
            return "_bv".ord($match[0])."_";
        }, $rawProductId);
    }

    private function getProductId($product)
    {
        $productId = $product->getData('style_code').'-'.$product->getData('colour_code');

        if ($product->getTypeId() == 'simple') {
            $productId .= '-'.$product->getData('size');
        }
        return $productId;
    }
}
