<?php


namespace BrittainWynyard\BazaarVoice\Plugin;


use Bazaarvoice\Connector\Api\StringFormatterInterface;
use Bazaarvoice\Connector\Model\CurrentProductProvider;

class ViewModelReviewsPlugin
{
    protected $helper;

    protected $stringFormatter;

    protected $currentProductProvider;


    /**
     * ViewModelReviewsPlugin constructor.
     * @param StringFormatterInterface $stringFormatter
     * @param CurrentProductProvider $currentProductProvider
     */
    public function __construct(
        StringFormatterInterface $stringFormatter,
        CurrentProductProvider $currentProductProvider,
        \BrittainWynyard\BazaarVoice\Helper\Data $helper

    ) {
        $this->helper = $helper;
        $this->stringFormatter = $stringFormatter;
        $this->currentProductProvider = $currentProductProvider;
    }

    /**
     * @param \Bazaarvoice\Connector\ViewModel\Reviews $subject
     * @param callable $proceed
     */
    public function aroundGetProductSku(\Bazaarvoice\Connector\ViewModel\Reviews $subject, callable $proceed)
    {
        $currentProduct = $this->currentProductProvider->getProduct();

        if ($currentProduct) {
            return $this->stringFormatter->getFormattedProductSku(
                $this->helper->getProductId($currentProduct)
            );
        }

        return null;
    }
}
