<?php
declare(strict_types=1);

namespace BrittainWynyard\BazaarVoice\Plugin\ProductList;

use Bazaarvoice\Connector\Api\ConfigProviderInterface;
use Bazaarvoice\Connector\Api\StringFormatterInterface;
use Bazaarvoice\Connector\Model\Source\ProductList;
use Overdose\Catalog\ViewModel\DiscountLableViewModel;

/**
 * Class NewProductsWidget
 * @package BrittainWynyard\BazaarVoice\Plugin\ProductList
 */
class NewProductsWidget extends Widget
{
    /**
     * @var string
     */
    protected $type = ProductList::CATALOG_NEW_PRODUCTS_LIST_WIDGET;

    /**
     * @param ConfigProviderInterface $configProvider
     * @param StringFormatterInterface $stringFormatter
     * @param DiscountLableViewModel $discountLabel
     */
    public function __construct(
        ConfigProviderInterface $configProvider,
        StringFormatterInterface $stringFormatter,
        DiscountLableViewModel $discountLabel
    ) {
        parent::__construct($configProvider, $stringFormatter, $discountLabel);
    }

    /**
     * @param $subject
     * @param $product
     */
    public function beforeGetProductPriceHtml(
        /** @noinspection PhpUnusedParameterInspection */
        // @codingStandardsIgnoreLine Squiz.Functions.MultiLineFunctionDeclaration.FirstParamSpacing
        $subject,
        $product
    ) {
        if ($this->isHostedInlineRatingsEnabled()) {
            $this->product = $product;
        }
    }

    /**
     * @param $subject
     * @param $result
     *
     * @return string
     */
    public function afterGetProductPriceHtml(
        /** @noinspection PhpUnusedParameterInspection */
        // @codingStandardsIgnoreLine Squiz.Functions.MultiLineFunctionDeclaration.FirstParamSpacing
        $subject,
        $result
    ) {
        if ($this->isHostedInlineRatingsEnabled()) {
            $productIdentifier = $this->stringFormatter->getFormattedProductSku($this->product);
            $productUrl = $this->product->getProductUrl();

            if ($this->discountLabel->hasGeneralTierPrice($this->product)) {
                $result = $result . sprintf('<div class="discount-text">%s</div>', $this->discountLabel->getDiscountText());
            }

            $result = $result.'
            <!-- '. $this->getExtensionInjectionMessage() .' -->
            <div data-bv-show="inline_rating"
                 data-bv-seo="false"
				 data-bv-product-id="'.$productIdentifier.'"
				 data-bv-redirect-url="'.$productUrl.'"></div>';
        }

        return $result;
    }
}
