<?php
namespace BrittainWynyard\BazaarVoice\Plugin\ProductList;

use Bazaarvoice\Connector\Api\ConfigProviderInterface;
use Bazaarvoice\Connector\Api\StringFormatterInterface;
use Magento\Catalog\Model\Product\Attribute\Source\Status;
use Overdose\Catalog\ViewModel\DiscountLableViewModel;

class Item extends \Bazaarvoice\Connector\Plugin\ProductList\Item
{
    /**
     * @param ConfigProviderInterface $configProvider
     * @param StringFormatterInterface $stringFormatter
     * @param DiscountLableViewModel $discountLabel
     */
    public function __construct(
        ConfigProviderInterface $configProvider,
        StringFormatterInterface $stringFormatter,
        protected readonly DiscountLableViewModel $discountLabel
    ) {
        parent::__construct($configProvider, $stringFormatter);
    }

    /** Override to move price section to above the review
     * @param $subject
     * @param $result
     *
     * @return string
     */
    public function afterGetProductPrice(
        $subject,
        $result
    ) {
        if ($this->isHostedInlineRatingsEnabled()) {
            $productIdentifier = $this->stringFormatter->getFormattedProductSku($this->product);
            $productUrl = $this->product->getProductUrl();

            if ($this->discountLabel->hasGeneralTierPrice($this->product)) {
                $result = $result . sprintf('<div class="discount-text">%s</div>', $this->discountLabel->getDiscountText());
            }

            $result = $result.'
            <!-- '. $this->getExtensionInjectionMessage() .' -->
            <div data-bv-show="inline_rating"
                 data-bv-seo="false"
				 data-bv-product-id="'.$productIdentifier.'"
				 data-bv-redirect-url="'.$productUrl.'"></div>';
        }

        return $result;
    }
}
