<?php

namespace Asics\Verifone\Controller\Standard;

use Magento\Checkout\Model\Type\Onepage;
use Throwable;
use Verifone\Hosted\Controller\Standard\Redirect;

class RedirectRewrite extends Redirect
{
    public function execute()
    {
        if (!$this->getRequest()->isAjax()) {
            $this->_cancelPayment();
            $returnUrl = $this->getCheckoutHelper()->getUrl('checkout', ['_fragment' => 'payment']);
            $this->getResponse()->setRedirect($returnUrl);
        } else {
            $paymentMethod = $this->getPaymentMethod();
            $this->getCheckoutHelper()->setUpVerifoneSettings($paymentMethod);
            if ($this->getCheckoutHelper()->getVerifoneSettings()->isOrderBeforeRedirect()) {
                $order = $this->getOrder();
                try {
                    $quote = $this->_quoteRepository->get($order->getQuoteId());
                } catch (Throwable $exception) {
                    $this->_logger->error(
                        'Error loading quote from order',
                        ['order_id' => $order->getId(), 'exception' => $exception]
                    );
                    try {
                        $quote = $this->getQuote();
                    } catch (Throwable $exception) {
                        $this->_logger->error(
                            'Error loading quote from session',
                            ['order_id' => $order->getId(), 'exception' => $exception]
                        );
                    }
                }
            } else {
                $quote = $this->getQuote();
                $email = $this->getRequest()->getParam('email');
                $this->getCheckoutHelper()->setUpVerifoneSettings($paymentMethod);
                $quote->setCustomerEmail($email);

                if (!$quote->getReservedOrderId()) {
                    $quote->reserveOrderId();
                }

                $this->getCheckoutSession()->loadCustomerQuote();
                if (!$this->getCustomerSession()->isLoggedIn()) {
                    $quote->setCheckoutMethod(Onepage::METHOD_GUEST);
                } else {
                    $quote->updateCustomerData($this->getQuote()->getCustomer());
                    $quote->setCheckoutMethod(Onepage::METHOD_CUSTOMER);
                }

                $this->_quoteRepository->save($quote);
            }

            $params = [];
            $params['result'] = 'failed';

            if (!isset($quote)) {
                $this->_logger->warning('Quote not found in Verifone redirect');
                $params['messages'] = 'An unexpected error occurred. Please retry the payment. No money has been charged.';
                return $this->_resultJsonFactory->create()->setData($params);
            }

            try {
                $result = $this->getCheckoutHelper()->processPayment($paymentMethod, $quote);
            } catch (\Exception $e) {
                $this->_logger->info($e->getMessage());
                $this->_logger->info($e->getTraceAsString());
                $params['messages'] = "An unexpected error occurred. Please retry the payment. No money has been charged.";
            }

            if (isset($result['url']) && isset($result['method']) && $result['method'] == "iframe") {
                $params['result'] = 'success';
                $params['method'] = $result['method'];
                $params['url'] = $result['url'];
            }

            if (isset($result['redirect']) && isset($result['method']) && $result['method'] == "hpp") {
                $params['result'] = 'success';
                $params['method'] = $result['method'];
                $params['redirect'] = $result['redirect'];
            }

            return $this->_resultJsonFactory->create()->setData($params);
        }
    }
}
