<?php

namespace Windcave\Payments\Observer;

use Magento\Quote\Api\Data\PaymentInterface;

// This observer is used primarily by HPP and triggered when a customer click "Back" from the browser.
// The main purpose of this observer is to allow the restoration of the cart for failed payment.
class PreDispatchCheckoutObserver implements \Magento\Framework\Event\ObserverInterface
{
    private const STATUS_PENDING = 'pending';

    /**
     * @var \Magento\Checkout\Model\Session
     */
    private $checkoutSession;

    /**
     * @var \Magento\Quote\Model\QuoteFactory
     */
    private $quoteFactory;

    /**
     * @var \Magento\Framework\Message\ManagerInterface
     */
    private $messageManager;

    /**
     * Constructor
     *
     * @param \Magento\Checkout\Model\Session $checkoutSession
     * @param \Magento\Quote\Model\QuoteFactory $quoteFactory
     * @param \Magento\Framework\Message\ManagerInterface $messageManager
     */
    public function __construct(
        \Magento\Checkout\Model\Session $checkoutSession,
        \Magento\Quote\Model\QuoteFactory $quoteFactory,
        \Magento\Framework\Message\ManagerInterface $messageManager
    ) {
        $this->checkoutSession = $checkoutSession;
        $this->quoteFactory = $quoteFactory;
        $this->messageManager = $messageManager;
    }

    /**
     * Process the event
     *
     * @param \Magento\Framework\Event\Observer $observer
     */
    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        $lastRealOrder = $this->checkoutSession->getLastRealOrder();
        $payment = $lastRealOrder->getPayment();
        if (!isset($payment) || $payment === null) {
            return;
        }
        $info = $payment->getAdditionalInformation();
        if (isset($info) && !empty($info['DpsTxnRef'])) {
            return;
        }
        
        if ($lastRealOrder->getState() === \Magento\Sales\Model\Order::STATE_PENDING_PAYMENT
            && $lastRealOrder->getStatus() === \Magento\Sales\Model\Order::STATE_PENDING_PAYMENT) {
            $this->messageManager->addSuccessMessage(
                "The previous order has now been cancelled. Please proceed to place new order."
            );
            $this->messageManager->addWarningMessage(
                "We strongly advice NOT to use the browser Forward button this time."
            );
            $this->checkoutSession->restoreQuote();
            $lastRealOrder->cancel()->save();
        }
    }
}
