<?php
namespace Windcave\Payments\Observer;

class CouponObserver implements \Magento\Framework\Event\ObserverInterface
{
    /**
     * Process the action on event
     *
     * @param \Magento\Framework\Event\Observer $observer
     */
    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        $objectManager = \Magento\Framework\App\ObjectManager::getInstance();

        $logger = $objectManager->get(\Windcave\Payments\Logger\DpsLogger::class);

        $logger->info(__METHOD__);

        $event = $observer->getEvent();
        $order = $event->getPayment()->getOrder();
        if (!$order->canCancel()) {
            return $this;
        }

        $code = $order->getCouponCode();
        if (isset($code) && $code !== null) {
            $couponProcessor = $objectManager->get(\Magento\SalesRule\Model\Coupon\Usage\Processor::class);
            $updateInfo = $objectManager->get(\Magento\SalesRule\Model\Coupon\Usage\UpdateInfo::class);
            $rules = preg_split("/\,/", $order->getAppliedRuleIds());
            $updateInfo->setAppliedRuleIds($rules);
            $updateInfo->setCouponCode($code);
            $updateInfo->setCustomerId($order->getCustomerId());
            $updateInfo->setIsIncrement(false);
            $logger->info(__METHOD__ . " restore coupon code " . $code);
            $couponProcessor->process($updateInfo);
        }

        return $this;
    }
}
