<?php

namespace Windcave\Payments\Observer;

use Magento\Quote\Api\Data\PaymentInterface;

class CaptureOfflineObserver implements \Magento\Framework\Event\ObserverInterface
{
    /**
     * Process the action
     *
     * @param \Magento\Framework\Event\Observer $observer
     */
    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        if (!$observer->getEvent() || !$observer->getEvent()->getInvoice()) {
            return;
        }
        $invoice = $observer->getEvent()->getInvoice();
        if ($invoice->getRequestedCaptureCase() == \Magento\Sales\Model\Order\Invoice::CAPTURE_OFFLINE) {
            $invoice->getOrder()->setState(\Magento\Sales\Model\Order::STATE_PROCESSING)
            ->setStatus(\Magento\Sales\Model\Order::STATE_PROCESSING);
        }
    }
}
