<?php
namespace Windcave\Payments\Model\Config\Source;

class ApplePayButtonOptions
{
    private const BUY = 'buy';
    private const DONATE = 'donate'; /* only for approved nonprofit otherwise good as plain */
    private const APPLEPAY = 'plain';
    private const BOOK = 'book';
    private const ORDER  = 'order';
    
    /**
     * Returns list of options
     *
     * @return array
     */
    public function toOptionArray()
    {
        return [
            [
                'value' => self::BUY,
                'label' => 'Buy with Apple Pay'
            ],
            [
                'value' => self::DONATE,
                'label' => 'Donate with Apple Pay'
            ],
            [
                'value' => self::BOOK,
                'label' => 'Book with Apple Pay'
            ],
            [
                'value' => self::ORDER,
                'label' => 'Order with Apple Pay'
            ],
            [
                'value' => self::APPLEPAY,
                'label' => 'Apple Pay'
            ]
        ];
    }
}
