<?php
namespace Windcave\Payments\Model\ApplePay;

use \Magento\Checkout\Model\ConfigProviderInterface;

// Invoked by Magento\Checkout\Block\Onepage::getCheckoutConfig
class ConfigProvider implements ConfigProviderInterface
{
    /**
     * @var \Windcave\Payments\Logger\DpsLogger
     */
    private $_logger;

    /**
     * @var \Windcave\Payments\Helper\ApplePay\Configuration
     */
    private $_configuration;

    /**
     * @var \Magento\Framework\App\ObjectManager
     */
    private $_objectManager;

    /**
     * Constructor
     *
     * @param \Magento\Framework\ObjectManagerInterface $objectManager
     */
    public function __construct(\Magento\Framework\ObjectManagerInterface $objectManager)
    {
        $this->_objectManager = $objectManager;
        $this->_configuration = $this->_objectManager->get(\Windcave\Payments\Helper\ApplePay\Configuration::class);
        $this->_logger = $this->_objectManager->get(\Windcave\Payments\Logger\DpsLogger::class);
        $this->_logger->info(__METHOD__);
    }

    /**
     * Returns the configuration
     *
     * @return array
     */
    public function getConfig()
    {
        $this->_logger->info(__METHOD__);
        return [
            'payment' => [
                'windcave' => [
                    'applepay' => [
                        'supportedNetworks' => $this->_configuration->getSupportedNetworks(),
                        'merchantIdentifier' => $this->_configuration->getMerchantIdentifier(),
                        'merchantName' => $this->_configuration->getMerchantName(),
                        'buttonType' => $this->_configuration->getPaymentButtonType(),
                        'buttonColor' => $this->_configuration->getPaymentButtonColor(),
                        'method' => \Windcave\Payments\Model\ApplePay\Payment::APPLEPAY_CODE
                    ]
                ]
            ]
        ];
    }
}
