<?php
namespace Windcave\Payments\Logger\Handler;

use \Magento\Framework\Filesystem\DriverInterface;
use \Magento\Framework\Logger\Handler\Base;
use \Monolog\Logger;

class All extends Base
{
    /**
     * @var int
     */
    protected $level = Logger::DEBUG;

    /**
     * Constructor
     *
     * @param \Magento\Framework\Filesystem\DriverInterface $filesystem
     * @param string|null $filePath
     */
    public function __construct(DriverInterface $filesystem, $filePath = null)
    {
        $now = new \DateTime('now');
        $strToday = $now->format('Y-m-d');
        $this->fileName = "/var/log/windcave_{$strToday}.log";
        parent::__construct($filesystem, $filePath);
    }
}
