<?php
/**
 * Copyright © 2016 Magento. All rights reserved.
 * See COPYING.txt for license details.
 */
namespace Windcave\Payments\Console\Command;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Helper\ProgressBar;
use \Magento\Framework\Setup\SchemaSetupInterface;

/**
 * Migrate Data command
 */
class MigrateData extends Command
{
    /**
     * @var \Magento\Framework\Setup\SchemaSetupInterface
     */
    private $setupInterface;

    /**
     * @param \Magento\Framework\Setup\SchemaSetupInterface $setup
     */
    public function __construct(SchemaSetupInterface $setup)
    {
        $this->setupInterface = $setup;
        parent::__construct();
    }

    /**
     * Configures the command
     */
    protected function configure()
    {
        $this->setName('windcave:migrate')
            ->setDescription('Migrate data from PaymentExpress to Windcave');
        parent::configure();
    }

    /**
     * Executes the command
     *
     * @param Symfony\Component\Console\Input\InputInterface $input
     * @param Symfony\Component\Console\Output\OutputInterface $output
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
        $migrationHandler = $objectManager->create(\Windcave\Payments\Helper\MigrationHandler::class);

        $this->setupInterface->startSetup();
        $migrationHandler->migrate($this->setupInterface, $output);
        $this->setupInterface->endSetup();
    }
}
