<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-seo
 * @version   2.10.12
 * @copyright Copyright (C) 2025 Mirasvit (https://mirasvit.com/)
 */


declare(strict_types=1);

namespace Mirasvit\Seo\Api\Service;

interface TemplateEngineServiceInterface
{
    /**
     * @param string|null $template
     * @param array  $vars
     * @return string
     */
    public function render(?string $template = null, array $vars = []): string;

    /**
     * @return \Mirasvit\Seo\Service\TemplateEngine\Data\AbstractData[]
     */
    public function getData(): array;
}
