<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-core
 * @version   1.5.0
 * @copyright Copyright (C) 2025 Mirasvit (https://mirasvit.com/)
 */


declare(strict_types=1);

namespace Mirasvit\Core\Service;

use Magento\Framework\App\ObjectManager;

class CspService
{
    public static function getObjectManager()
    {
        return ObjectManager::getInstance();
    }

    public function getHtmlRenderer(): ?object
    {
        if (class_exists('Magento\Framework\View\Helper\SecureHtmlRenderer')) {
            return self::getObjectManager()
                ->create(\Magento\Framework\View\Helper\SecureHtmlRenderer::class);
        }
        return null;
    }

    public static function getNonce(): ?string
    {
        if (class_exists('Magento\Csp\Helper\CspNonceProvider')) {
            return self::getObjectManager()
                ->create(\Magento\Csp\Helper\CspNonceProvider::class)->generateNonce();
        }
        return null;
    }
}
