<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2025 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */
declare(strict_types=1);

namespace Magento\AdobeCommerceEventsClient\Event\EventDataPreparer;

use Magento\AdobeCommerceEventsClient\Event\EventInitializationException;

/**
 * Interface for preparing event data before sending the payload to Eventing service
 */
interface EventDataPreparerInterface
{
    /**
     * Prepares event data before sending the payload to Eventing service
     *
     * @param array $waitingEvents
     * @return array
     * @throws EventInitializationException
     */
    public function execute(array $waitingEvents): array;
}
