<?php

namespace Fastly\Cdn\Controller\Adminhtml\FastlyCdn\ImportExport;

use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Framework\App\Filesystem\DirectoryList;
use Magento\Framework\App\Response\Http\FileFactory;
use Fastly\Cdn\Model\Config;

/**
 * Class DownloadExportData
 * @package Fastly\Cdn\Controller\Adminhtml\FastlyCdn\ImportExport
 */
class DownloadExportData extends Action
{
    const ADMIN_RESOURCE = 'Magento_Config::config';

    /**
     * @var FileFactory
     */
    private $fileFactory;

    /**
     * DownloadExportData constructor.
     * @param Context $context
     * @param FileFactory $fileFactory
     */
    public function __construct(
        Context $context,
        FileFactory $fileFactory
    ) {
        $this->fileFactory = $fileFactory;
        parent::__construct($context);
    }

    /**
     * @return \Magento\Framework\App\ResponseInterface|\Magento\Framework\Controller\ResultInterface
     */
    public function execute()
    {
        try {
            return $this->fileFactory->create(
                Config::EXPORT_FILE_NAME,
                [
                    'type'  => 'filename',
                    'value' => Config::EXPORT_FILE_NAME,
                    'rm'    => true
                ],
                DirectoryList::VAR_DIR
            );
        } catch (\Exception $e) {
            $this->messageManager->addErrorMessage($e->getMessage());
            return $this->_redirect($this->_redirect->getRefererUrl());
        }
    }
}
