<?php

namespace EightWire\SuperStyleSwatch\Block\Catalog\Product\View;


class Swatch extends \Magento\Catalog\Block\Product\View\abstractView
{

    protected $relatedProducts;

    /**
     * Swatch constructor.
     * @param \Magento\Catalog\Block\Product\Context $context
     * @param \Magento\Framework\Stdlib\ArrayUtils $arrayUtils
     * @param \Magento\Catalog\Api\ProductRepositoryInterface $productRepository
     * @param \Magento\Framework\Api\SearchCriteriaBuilder $searchCriteriaBuilder
     * @param array $data
     */
    public function __construct(
        \Magento\Catalog\Block\Product\Context $context,
        \Magento\Framework\Stdlib\ArrayUtils $arrayUtils,
        \Magento\Catalog\Api\ProductRepositoryInterface $productRepository,
        \Magento\Framework\Api\SearchCriteriaBuilder $searchCriteriaBuilder,
        \Magento\Catalog\Model\Product\Gallery\ReadHandler $galleryReadHandler,
        \Magento\Catalog\Helper\Image $imageHelper,
        array $data = []
    ) {
        $this->productRepository = $productRepository;
        $this->searchCriteriaBuilder = $searchCriteriaBuilder;
        $this->galleryReadHandler = $galleryReadHandler;
        $this->imageHelper = $imageHelper;

        parent::__construct($context, $arrayUtils, $data);
    }


    /** Add image gallery to $product */
    public function addGallery($product)
    {
        $this->galleryReadHandler->execute($product);
    }


    public function isEnabled()
    {
        /**
         * @todo allow swatch to be disabled through configuration
         */
        return true;
    }

    /**
     * Get the products that are related to the current product
     *
     * @return mixed
     */
    public function getRelatedProducts()
    {
        //updated filter from configurable products only, to products visible by catalog,search
        if (empty($this->relatedProducts)) {
            $this->searchCriteriaBuilder->addFilter('super_style_id', $this->getProduct()->getSuperStyleId(), 'eq');
            $this->searchCriteriaBuilder->addFilter('status', '1', 'eq');
            $this->searchCriteriaBuilder->addFilter('visibility', '4', 'eq');
            $this->searchCriteriaBuilder->addFilter('website_id',
                $this->_storeManager->getWebsite()->getWebsiteId(),
                'eq'
            );
            $searchCriteria = $this->searchCriteriaBuilder->create();

            $this->relatedProducts =  $this->productRepository->getList($searchCriteria)->getItems();

            foreach ($this->relatedProducts as $product) {
                $this->galleryReadHandler->execute($product);
            }
        }

        return $this->relatedProducts;
    }


    public function getThumbnailUrl($product, $image = 'thumbnail', $imageId = 'product_page_image_small')
    {
        $image = $product->getData($image);
        $url = $this->imageHelper->init($product, $imageId)
                                ->setImageFile($image)
                                ->getUrl();
        return $url;
    }

    public function getSwatchClasses($product)
    {

        $classes = ['superswatch'];

        if ($this->isCurrent($product)) {
            $classes[] = 'is-current';
        }

        return $classes;
    }


    public function getLabel($product, $labelAttribute = null)
    {

        if ($labelAttribute === null) {
            /**
             * @todo make this configurable so different attributes can be used
             */
            $labelAttribute = 'name';
        }
        return $product->getData($labelAttribute);
    }


    public function isCurrent($product)
    {
        return $product->getId() == $this->getProduct()->getId();
    }


    /**
     * Get the url for a product
     *
     * @param \Magento\Catalog\Model\Product $product
     * @return bool|string
     */
    public function getProductUrl($product, $additional = [])
    {

        /**
         * only way to get product url without category is using getUrlInStore
         * but that comes with extra params that we don't want - so we strip them off again
         *
         * @see https://magento.stackexchange.com/questions/14458/product-getproducturl-giving-url-path-without-url-key
         */

        $additional['_ignore_category'] = true;
        $additional['_nosid'] = true;

        $url = $product->getUrlInStore($additional);

        return $url;
    }
}
