<?php

/**
 * New Zealand Region Data
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 *
 * @copyright 2017 8 Wire Digital (https://www.8wiredigital.co.nz/)
 * @author    Andrew Kett <andrew@8wiredigital.co.nz>
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 */

namespace EightWire\NewZealandDirectory\Setup;

use Magento\Directory\Helper\Data;
use Magento\Framework\Setup\InstallDataInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\ModuleDataSetupInterface;

/**
 * @codeCoverageIgnore
 */
class InstallData implements InstallDataInterface
{
    /**
     * Directory data
     *
     * @var Data
     */
    private $directoryData;

    /**
     * Init
     *
     * @param Data $directoryData
     */
    public function __construct(Data $directoryData)
    {
        $this->directoryData = $directoryData;
    }

    /**
     * {@inheritdoc}
     * @SuppressWarnings(PHPMD.ExcessiveMethodLength)
     */
    public function install(ModuleDataSetupInterface $setup, ModuleContextInterface $context)
    {

        /**
         * Fill table directory/country_region with NZ regions
         * Fill table directory/country_region_name for en_NZ locale
         * @see https://en.wikipedia.org/wiki/Regions_of_New_Zealand
         */
        $data = [
          ['NZ', 'AUK', 'Auckland'],
          ['NZ', 'BOP', 'Bay of Plenty'],
          ['NZ', 'CAN', 'Canterbury'],
          ['NZ', 'GIS', 'Gisborne'],
          ['NZ', 'HKB', 'Hawkes Bay'],
          ['NZ', 'MBH', 'Marlborough'],
          ['NZ', 'MWT', 'Manawatu-Wanganui'],
          ['NZ', 'NSN', 'Nelson'],
          ['NZ', 'NTL', 'Northland'],
          ['NZ', 'OTA', 'Otago'],
          ['NZ', 'STL', 'Southland'],
          ['NZ', 'TAS', 'Tasman'],
          ['NZ', 'TKI', 'Taranaki'],
          ['NZ', 'WKO', 'Waikato'],
          ['NZ', 'WGN', 'Wellington'],
          ['NZ', 'WTC', 'West Coast'],
          ['NZ', 'CIT', 'Chatham Islands Territory'],
        ];

        foreach ($data as $row) {
            $bind = ['country_id' => $row[0], 'code' => $row[1], 'default_name' => $row[2]];
            $setup->getConnection()->insert($setup->getTable('directory_country_region'), $bind);
            $regionId = $setup->getConnection()->lastInsertId($setup->getTable('directory_country_region'));

            $bind = ['locale' => 'en_NZ', 'region_id' => $regionId, 'name' => $row[2]];
            $setup->getConnection()->insert($setup->getTable('directory_country_region_name'), $bind);
        }
    }
}
