<?php
namespace EightWire\LogRocket\Block;

use Magento\Framework\App\ObjectManager;
use \Magento\Framework\View\Element\Template;


class Tracking extends Template
{

    protected $configHelper;

    /**
     * @param \Magento\Framework\View\Element\Template\Context $context
     * @param \Magento\Sales\Model\ResourceModel\Order\CollectionFactory $salesOrderCollection
     * @param \Magento\GoogleAnalytics\Helper\Data $googleAnalyticsData
     * @param array $data
     * @param \Magento\Cookie\Helper\Cookie|null $cookieHelper
     */
    public function __construct(
        \Magento\Framework\View\Element\Template\Context $context,
        \EightWire\LogRocket\Helper\Config $configHelper,
        array $data = []
    ) {
        $this->configHelper = $configHelper;
        parent::__construct($context, $data);
    }


    public function isEnabled()
    {
        return $this->configHelper->isEnabled();
    }

    public function getIdentifier()
    {
        return $this->configHelper->getIdentifier();
    }

    public function isDebugEnabled()
    {
        return $this->configHelper->isDebugEnabled();
    }

    public function trackCustomer()
    {
        return $this->configHelper->trackCustomer();
    }
}

