<?php

namespace EightWire\CronHealth\Console\Command;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

class HealthCheck extends Command
{

    private $healthCheck;

    /**
     * Constructor
     *
     * @param \Magento\Framework\App\Action\Context  $context
     * @param \Magento\Framework\View\Result\PageFactory $resultPageFactory
     */
    public function __construct(
        \EightWire\CronHealth\Model\HealthCheck $healthCheck
    ) {
        $this->healthCheck = $healthCheck;

        parent::__construct();
    }

    /**
     * Console config
     */
    protected function configure()
    {
        $this->setName('cron:healthcheck')
            ->setDescription('');
    }

    /**
     * Run cron healthcheck and show result in cli output
     *
     * @param InputInterface $input
     * @param OutputInterface $output
     * @return int|void|null
     * @throws \Exception
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {

        if (!$this->healthCheck->cronIsHealthy()) {
            $output->writeln(
                '<error>⚠️  Cron is not healthy</error>
<comment>Heartbeat last run '.$this->healthCheck->getMinutesSinceRun().' minutes ago</comment>'
            );
            return;
        }

        $output->writeln(
            '<info>👍  Cron is healthy</info>
<comment>Heartbeat last run '.$this->healthCheck->getMinutesSinceRun().' minutes ago</comment>'
        );
    }
}
