<?php
namespace EightWire\DisableNewsletterEmail\Plugin\Newsletter\Model;

use Magento\Store\Model\ScopeInterface;

class Subscriber
{
    public function __construct(\EightWire\DisableNewsletterEmail\Helper\Config $configHelper)
    {
        $this->configHelper = $configHelper;
    }

    /**
     * @param \Magento\Newsletter\Model\Subscriber $subject
     * @param callable $proceed
     * @return mixed
     */
    public function aroundSendConfirmationSuccessEmail(
        \Magento\Newsletter\Model\Subscriber $subject,
        callable $proceed
    ) {
        // Only call proceed function if subscribe emails are enabled
        if ($this->configHelper->enableSubscribeEmail()) {
            return $proceed();
        }
    }

    /**
     * @param \Magento\Newsletter\Model\Subscriber $subject
     * @param callable $proceed
     * @return mixed
     */
    public function aroundSendUnsubscriptionEmail(
        \Magento\Newsletter\Model\Subscriber $subject,
        callable $proceed
    ) {
        // Only call proceed function if unsubscribe emails are enabled
        if ($this->configHelper->enableUnsubscribeEmail()) {
            return $proceed();
        }
    }
}
