<?php
namespace EightWire\DisableNewsletterEmail\Helper;

use Magento\Store\Model\ScopeInterface;

class Config extends \Magento\Framework\App\Helper\AbstractHelper
{
    /**
     * Config paths for using throughout the code
     */
    const XML_PATH_ENABLE_SUBSCRIBE_EMAIL = 'newsletter/subscription/enable_subscribe_email';

    const XML_PATH_ENABLE_UNSUBSCRIBE_EMAIL = 'newsletter/subscription/enable_unsubscribe_email';



    public function enableSubscribeEmail()
    {
        return (bool)$this->scopeConfig->getValue(
            self::XML_PATH_ENABLE_SUBSCRIBE_EMAIL,
            ScopeInterface::SCOPE_STORE
        );
    }


    public function enableUnsubscribeEmail()
    {
        return (bool)$this->scopeConfig->getValue(
            self::XML_PATH_ENABLE_UNSUBSCRIBE_EMAIL,
            ScopeInterface::SCOPE_STORE
        );
    }
}
