<?php
/** Adminer - Compact database management
* @link https://www.adminer.org/
* @author Jakub Vrana, https://www.vrana.cz/
* @copyright 2007 Jakub Vrana
* @license https://www.apache.org/licenses/LICENSE-2.0 Apache License, Version 2.0
* @license https://www.gnu.org/licenses/gpl-2.0.html GNU General Public License, version 2 (one or other)
* @version 5.2.0
*/namespace
Adminer;const
VERSION="5.2.0";error_reporting(24575);set_error_handler(function($Bc,$Dc){return!!preg_match('~^Undefined (array key|offset|index)~',$Dc);},E_WARNING|E_NOTICE);$Yc=!preg_match('~^(unsafe_raw)?$~',ini_get("filter.default"));if($Yc||ini_get("filter.default_flags")){foreach(array('_GET','_POST','_COOKIE','_SERVER')as$X){$aj=filter_input_array(constant("INPUT$X"),FILTER_UNSAFE_RAW);if($aj)$$X=$aj;}}if(function_exists("mb_internal_encoding"))mb_internal_encoding("8bit");function
connection($h=null){return($h?:Db::$ge);}function
adminer(){return
Adminer::$ge;}function
driver(){return
Driver::$ge;}function
connect(){$Eb=adminer()->credentials();$J=Driver::connect($Eb[0],$Eb[1],$Eb[2]);return(is_object($J)?$J:null);}function
idf_unescape($v){if(!preg_match('~^[`\'"[]~',$v))return$v;$_e=substr($v,-1);return
str_replace($_e.$_e,$_e,substr($v,1,-1));}function
q($Q){return
connection()->quote($Q);}function
escape_string($X){return
substr(q($X),1,-1);}function
idx($xa,$y,$l=null){return($xa&&array_key_exists($y,$xa)?$xa[$y]:$l);}function
number($X){return
preg_replace('~[^0-9]+~','',$X);}function
number_type(){return'((?<!o)int(?!er)|numeric|real|float|double|decimal|money)';}function
remove_slashes(array$Ig,$Yc=false){if(function_exists("get_magic_quotes_gpc")&&get_magic_quotes_gpc()){while(list($y,$X)=each($Ig)){foreach($X
as$re=>$W){unset($Ig[$y][$re]);if(is_array($W)){$Ig[$y][stripslashes($re)]=$W;$Ig[]=&$Ig[$y][stripslashes($re)];}else$Ig[$y][stripslashes($re)]=($Yc?$W:stripslashes($W));}}}}function
bracket_escape($v,$Ea=false){static$Ji=array(':'=>':1',']'=>':2','['=>':3','"'=>':4');return
strtr($v,($Ea?array_flip($Ji):$Ji));}function
min_version($rj,$Me="",$h=null){$h=connection($h);$Ch=$h->server_info;if($Me&&preg_match('~([\d.]+)-MariaDB~',$Ch,$B)){$Ch=$B[1];$rj=$Me;}return$rj&&version_compare($Ch,$rj)>=0;}function
charset(Db$g){return(min_version("5.5.3",0,$g)?"utf8mb4":"utf8");}function
ini_bool($be){$X=ini_get($be);return(preg_match('~^(on|true|yes)$~i',$X)||(int)$X);}function
sid(){static$J;if($J===null)$J=(SID&&!($_COOKIE&&ini_bool("session.use_cookies")));return$J;}function
set_password($qj,$N,$V,$F){$_SESSION["pwds"][$qj][$N][$V]=($_COOKIE["adminer_key"]&&is_string($F)?array(encrypt_string($F,$_COOKIE["adminer_key"])):$F);}function
get_password(){$J=get_session("pwds");if(is_array($J))$J=($_COOKIE["adminer_key"]?decrypt_string($J[0],$_COOKIE["adminer_key"]):false);return$J;}function
get_val($H,$n=0,$sb=null){$sb=connection($sb);$I=$sb->query($H);if(!is_object($I))return
false;$K=$I->fetch_row();return($K?$K[$n]:false);}function
get_vals($H,$d=0){$J=array();$I=connection()->query($H);if(is_object($I)){while($K=$I->fetch_row())$J[]=$K[$d];}return$J;}function
get_key_vals($H,$h=null,$Fh=true){$h=connection($h);$J=array();$I=$h->query($H);if(is_object($I)){while($K=$I->fetch_row()){if($Fh)$J[$K[0]]=$K[1];else$J[]=$K[0];}}return$J;}function
get_rows($H,$h=null,$m="<p class='error'>"){$sb=connection($h);$J=array();$I=$sb->query($H);if(is_object($I)){while($K=$I->fetch_assoc())$J[]=$K;}elseif(!$I&&!$h&&$m&&(defined('Adminer\PAGE_HEADER')||$m=="-- "))echo$m.error()."\n";return$J;}function
unique_array($K,array$x){foreach($x
as$w){if(preg_match("~PRIMARY|UNIQUE~",$w["type"])){$J=array();foreach($w["columns"]as$y){if(!isset($K[$y]))continue
2;$J[$y]=$K[$y];}return$J;}}}function
escape_key($y){if(preg_match('(^([\w(]+)('.str_replace("_",".*",preg_quote(idf_escape("_"))).')([ \w)]+)$)',$y,$B))return$B[1].idf_escape(idf_unescape($B[2])).$B[3];return
idf_escape($y);}function
where(array$Z,array$o=array()){$J=array();foreach((array)$Z["where"]as$y=>$X){$y=bracket_escape($y,true);$d=escape_key($y);$n=idx($o,$y,array());$Wc=$n["type"];$J[]=$d.(JUSH=="sql"&&$Wc=="json"?" = CAST(".q($X)." AS JSON)":(JUSH=="sql"&&is_numeric($X)&&preg_match('~\.~',$X)?" LIKE ".q($X):(JUSH=="mssql"&&strpos($Wc,"datetime")===false?" LIKE ".q(preg_replace('~[_%[]~','[\0]',$X)):" = ".unconvert_field($n,q($X)))));if(JUSH=="sql"&&preg_match('~char|text~',$Wc)&&preg_match("~[^ -@]~",$X))$J[]="$d = ".q($X)." COLLATE ".charset(connection())."_bin";}foreach((array)$Z["null"]as$y)$J[]=escape_key($y)." IS NULL";return
implode(" AND ",$J);}function
where_check($X,array$o=array()){parse_str($X,$Xa);remove_slashes(array(&$Xa));return
where($Xa,$o);}function
where_link($t,$d,$Y,$Jf="="){return"&where%5B$t%5D%5Bcol%5D=".urlencode($d)."&where%5B$t%5D%5Bop%5D=".urlencode(($Y!==null?$Jf:"IS NULL"))."&where%5B$t%5D%5Bval%5D=".urlencode($Y);}function
convert_fields(array$e,array$o,array$M=array()){$J="";foreach($e
as$y=>$X){if($M&&!in_array(idf_escape($y),$M))continue;$ya=convert_field($o[$y]);if($ya)$J
.=", $ya AS ".idf_escape($y);}return$J;}function
cookie($C,$Y,$Ge=2592000){header("Set-Cookie: $C=".urlencode($Y).($Ge?"; expires=".gmdate("D, d M Y H:i:s",time()+$Ge)." GMT":"")."; path=".preg_replace('~\?.*~','',$_SERVER["REQUEST_URI"]).(HTTPS?"; secure":"")."; HttpOnly; SameSite=lax",false);}function
get_settings($Ab){parse_str($_COOKIE[$Ab],$Gh);return$Gh;}function
get_setting($y,$Ab="adminer_settings"){$Gh=get_settings($Ab);return$Gh[$y];}function
save_settings(array$Gh,$Ab="adminer_settings"){$Y=http_build_query($Gh+get_settings($Ab));cookie($Ab,$Y);$_COOKIE[$Ab]=$Y;}function
restart_session(){if(!ini_bool("session.use_cookies")&&(!function_exists('session_status')||session_status()==1))session_start();}function
stop_session($gd=false){$ij=ini_bool("session.use_cookies");if(!$ij||$gd){session_write_close();if($ij&&@ini_set("session.use_cookies",'0')===false)session_start();}}function&get_session($y){return$_SESSION[$y][DRIVER][SERVER][$_GET["username"]];}function
set_session($y,$X){$_SESSION[$y][DRIVER][SERVER][$_GET["username"]]=$X;}function
auth_url($qj,$N,$V,$k=null){$ej=remove_from_uri(implode("|",array_keys(SqlDriver::$fc))."|username|ext|".($k!==null?"db|":"").($qj=='mssql'||$qj=='pgsql'?"":"ns|").session_name());preg_match('~([^?]*)\??(.*)~',$ej,$B);return"$B[1]?".(sid()?SID."&":"").($qj!="server"||$N!=""?urlencode($qj)."=".urlencode($N)."&":"").($_GET["ext"]?"ext=".urlencode($_GET["ext"])."&":"")."username=".urlencode($V).($k!=""?"&db=".urlencode($k):"").($B[2]?"&$B[2]":"");}function
is_ajax(){return($_SERVER["HTTP_X_REQUESTED_WITH"]=="XMLHttpRequest");}function
redirect($Ie,$Ze=null){if($Ze!==null){restart_session();$_SESSION["messages"][preg_replace('~^[^?]*~','',($Ie!==null?$Ie:$_SERVER["REQUEST_URI"]))][]=$Ze;}if($Ie!==null){if($Ie=="")$Ie=".";header("Location: $Ie");exit;}}function
query_redirect($H,$Ie,$Ze,$Rg=true,$Ic=true,$Rc=false,$xi=""){if($Ic){$Vh=microtime(true);$Rc=!connection()->query($H);$xi=format_time($Vh);}$Ph=($H?adminer()->messageQuery($H,$xi,$Rc):"");if($Rc){adminer()->error
.=error().$Ph.script("messagesPrint();")."<br>";return
false;}if($Rg)redirect($Ie,$Ze.$Ph);return
true;}class
Queries{static$Mg=array();static$Vh=0;}function
queries($H){if(!Queries::$Vh)Queries::$Vh=microtime(true);Queries::$Mg[]=(preg_match('~;$~',$H)?"DELIMITER ;;\n$H;\nDELIMITER ":$H).";";return
connection()->query($H);}function
apply_queries($H,array$T,$Ec='Adminer\table'){foreach($T
as$R){if(!queries("$H ".$Ec($R)))return
false;}return
true;}function
queries_redirect($Ie,$Ze,$Rg){$Mg=implode("\n",Queries::$Mg);$xi=format_time(Queries::$Vh);return
query_redirect($Mg,$Ie,$Ze,$Rg,false,!$Rg,$xi);}function
format_time($Vh){return
lang(0,max(0,microtime(true)-$Vh));}function
relative_uri(){return
str_replace(":","%3a",preg_replace('~^[^?]*/([^?]*)~','\1',$_SERVER["REQUEST_URI"]));}function
remove_from_uri($gg=""){return
substr(preg_replace("~(?<=[?&])($gg".(SID?"":"|".session_name()).")=[^&]*&~",'',relative_uri()."&"),0,-1);}function
get_file($y,$Qb=false,$Vb=""){$Xc=$_FILES[$y];if(!$Xc)return
null;foreach($Xc
as$y=>$X)$Xc[$y]=(array)$X;$J='';foreach($Xc["error"]as$y=>$m){if($m)return$m;$C=$Xc["name"][$y];$Ei=$Xc["tmp_name"][$y];$xb=file_get_contents($Qb&&preg_match('~\.gz$~',$C)?"compress.zlib://$Ei":$Ei);if($Qb){$Vh=substr($xb,0,3);if(function_exists("iconv")&&preg_match("~^\xFE\xFF|^\xFF\xFE~",$Vh))$xb=iconv("utf-16","utf-8",$xb);elseif($Vh=="\xEF\xBB\xBF")$xb=substr($xb,3);}$J
.=$xb;if($Vb)$J
.=(preg_match("($Vb\\s*\$)",$xb)?"":$Vb)."\n\n";}return$J;}function
upload_error($m){$Ue=($m==UPLOAD_ERR_INI_SIZE?ini_get("upload_max_filesize"):0);return($m?lang(1).($Ue?" ".lang(2,$Ue):""):lang(3));}function
repeat_pattern($qg,$z){return
str_repeat("$qg{0,65535}",$z/65535)."$qg{0,".($z%65535)."}";}function
is_utf8($X){return(preg_match('~~u',$X)&&!preg_match('~[\0-\x8\xB\xC\xE-\x1F]~',$X));}function
format_number($X){return
strtr(number_format($X,0,".",lang(4)),preg_split('~~u',lang(5),-1,PREG_SPLIT_NO_EMPTY));}function
friendly_url($X){return
preg_replace('~\W~i','-',$X);}function
table_status1($R,$Sc=false){$J=table_status($R,$Sc);return($J?reset($J):array("Name"=>$R));}function
column_foreign_keys($R){$J=array();foreach(adminer()->foreignKeys($R)as$q){foreach($q["source"]as$X)$J[$X][]=$q;}return$J;}function
fields_from_edit(){$J=array();foreach((array)$_POST["field_keys"]as$y=>$X){if($X!=""){$X=bracket_escape($X);$_POST["function"][$X]=$_POST["field_funs"][$y];$_POST["fields"][$X]=$_POST["field_vals"][$y];}}foreach((array)$_POST["fields"]as$y=>$X){$C=bracket_escape($y,true);$J[$C]=array("field"=>$C,"privileges"=>array("insert"=>1,"update"=>1,"where"=>1,"order"=>1),"null"=>1,"auto_increment"=>($y==driver()->primary),);}return$J;}function
dump_headers($Od,$jf=false){$J=adminer()->dumpHeaders($Od,$jf);$cg=$_POST["output"];if($cg!="text")header("Content-Disposition: attachment; filename=".adminer()->dumpFilename($Od).".$J".($cg!="file"&&preg_match('~^[0-9a-z]+$~',$cg)?".$cg":""));session_write_close();if(!ob_get_level())ob_start(null,4096);ob_flush();flush();return$J;}function
dump_csv(array$K){foreach($K
as$y=>$X){if(preg_match('~["\n,;\t]|^0|\.\d*0$~',$X)||$X==="")$K[$y]='"'.str_replace('"','""',$X).'"';}echo
implode(($_POST["format"]=="csv"?",":($_POST["format"]=="tsv"?"\t":";")),$K)."\r\n";}function
apply_sql_function($s,$d){return($s?($s=="unixepoch"?"DATETIME($d, '$s')":($s=="count distinct"?"COUNT(DISTINCT ":strtoupper("$s("))."$d)"):$d);}function
get_temp_dir(){$J=ini_get("upload_tmp_dir");if(!$J){if(function_exists('sys_get_temp_dir'))$J=sys_get_temp_dir();else{$p=@tempnam("","");if(!$p)return'';$J=dirname($p);unlink($p);}}return$J;}function
file_open_lock($p){if(is_link($p))return;$r=@fopen($p,"c+");if(!$r)return;chmod($p,0660);if(!flock($r,LOCK_EX)){fclose($r);return;}return$r;}function
file_write_unlock($r,$Kb){rewind($r);fwrite($r,$Kb);ftruncate($r,strlen($Kb));file_unlock($r);}function
file_unlock($r){flock($r,LOCK_UN);fclose($r);}function
first(array$xa){return
reset($xa);}function
password_file($i){$p=get_temp_dir()."/adminer.key";if(!$i&&!file_exists($p))return'';$r=file_open_lock($p);if(!$r)return'';$J=stream_get_contents($r);if(!$J){$J=rand_string();file_write_unlock($r,$J);}else
file_unlock($r);return$J;}function
rand_string(){return
md5(uniqid(strval(mt_rand()),true));}function
select_value($X,$A,array$n,$wi){if(is_array($X)){$J="";foreach($X
as$re=>$W)$J
.="<tr>".($X!=array_values($X)?"<th>".h($re):"")."<td>".select_value($W,$A,$n,$wi);return"<table>$J</table>";}if(!$A)$A=adminer()->selectLink($X,$n);if($A===null){if(is_mail($X))$A="mailto:$X";if(is_url($X))$A=$X;}$J=adminer()->editVal($X,$n);if($J!==null){if(!is_utf8($J))$J="\0";elseif($wi!=""&&is_shortable($n))$J=shorten_utf8($J,max(0,+$wi));else$J=h($J);}return
adminer()->selectVal($J,$A,$n,$X);}function
is_mail($sc){$za='[-a-z0-9!#$%&\'*+/=?^_`{|}~]';$ec='[a-z0-9]([-a-z0-9]{0,61}[a-z0-9])';$qg="$za+(\\.$za+)*@($ec?\\.)+$ec";return
is_string($sc)&&preg_match("(^$qg(,\\s*$qg)*\$)i",$sc);}function
is_url($Q){$ec='[a-z0-9]([-a-z0-9]{0,61}[a-z0-9])';return
preg_match("~^(https?)://($ec?\\.)+$ec(:\\d+)?(/.*)?(\\?.*)?(#.*)?\$~i",$Q);}function
is_shortable(array$n){return
preg_match('~char|text|json|lob|geometry|point|linestring|polygon|string|bytea~',$n["type"]);}function
count_rows($R,array$Z,$le,array$ud){$H=" FROM ".table($R).($Z?" WHERE ".implode(" AND ",$Z):"");return($le&&(JUSH=="sql"||count($ud)==1)?"SELECT COUNT(DISTINCT ".implode(", ",$ud).")$H":"SELECT COUNT(*)".($le?" FROM (SELECT 1$H GROUP BY ".implode(", ",$ud).") x":$H));}function
slow_query($H){$k=adminer()->database();$yi=adminer()->queryTimeout();$Kh=driver()->slowQuery($H,$yi);$h=null;if(!$Kh&&support("kill")){$h=connect();if($h&&($k==""||$h->select_db($k))){$ue=get_val(connection_id(),0,$h);echo
script("const timeout = setTimeout(() => { ajax('".js_escape(ME)."script=kill', function () {}, 'kill=$ue&token=".get_token()."'); }, 1000 * $yi);");}}ob_flush();flush();$J=@get_key_vals(($Kh?:$H),$h,false);if($h){echo
script("clearTimeout(timeout);");ob_flush();flush();}return$J;}function
get_token(){$Pg=rand(1,1e6);return($Pg^$_SESSION["token"]).":$Pg";}function
verify_token(){list($Fi,$Pg)=explode(":",$_POST["token"]);return($Pg^$_SESSION["token"])==$Fi;}function
lzw_decompress($Ka){$ac=256;$La=8;$gb=array();$ch=0;$dh=0;for($t=0;$t<strlen($Ka);$t++){$ch=($ch<<8)+ord($Ka[$t]);$dh+=8;if($dh>=$La){$dh-=$La;$gb[]=$ch>>$dh;$ch&=(1<<$dh)-1;$ac++;if($ac>>$La)$La++;}}$Zb=range("\0","\xFF");$J="";$_j="";foreach($gb
as$t=>$fb){$rc=$Zb[$fb];if(!isset($rc))$rc=$_j.$_j[0];$J
.=$rc;if($t)$Zb[]=$_j.$rc[0];$_j=$rc;}return$J;}function
script($Mh,$Ii="\n"){return"<script".nonce().">$Mh</script>$Ii";}function
script_src($fj,$Sb=false){return"<script src='".h($fj)."'".nonce().($Sb?" defer":"")."></script>\n";}function
nonce(){return' nonce="'.get_nonce().'"';}function
input_hidden($C,$Y=""){return"<input type='hidden' name='".h($C)."' value='".h($Y)."'>\n";}function
input_token(){return
input_hidden("token",get_token());}function
target_blank(){return' target="_blank" rel="noreferrer noopener"';}function
h($Q){return
str_replace("\0","&#0;",htmlspecialchars($Q,ENT_QUOTES,'utf-8'));}function
nl_br($Q){return
str_replace("\n","<br>",$Q);}function
checkbox($C,$Y,$ab,$we="",$If="",$eb="",$ye=""){$J="<input type='checkbox' name='$C' value='".h($Y)."'".($ab?" checked":"").($ye?" aria-labelledby='$ye'":"").">".($If?script("qsl('input').onclick = function () { $If };",""):"");return($we!=""||$eb?"<label".($eb?" class='$eb'":"").">$J".h($we)."</label>":$J);}function
optionlist($Nf,$vh=null,$jj=false){$J="";foreach($Nf
as$re=>$W){$Of=array($re=>$W);if(is_array($W)){$J
.='<optgroup label="'.h($re).'">';$Of=$W;}foreach($Of
as$y=>$X)$J
.='<option'.($jj||is_string($y)?' value="'.h($y).'"':'').($vh!==null&&($jj||is_string($y)?(string)$y:$X)===$vh?' selected':'').'>'.h($X);if(is_array($W))$J
.='</optgroup>';}return$J;}function
html_select($C,array$Nf,$Y="",$Hf="",$ye=""){static$we=0;$xe="";if(!$ye&&substr($Nf[""],0,1)=="("){$we++;$ye="label-$we";$xe="<option value='' id='$ye'>".h($Nf[""]);unset($Nf[""]);}return"<select name='".h($C)."'".($ye?" aria-labelledby='$ye'":"").">".$xe.optionlist($Nf,$Y)."</select>".($Hf?script("qsl('select').onchange = function () { $Hf };",""):"");}function
html_radios($C,array$Nf,$Y="",$zh=""){$J="";foreach($Nf
as$y=>$X)$J
.="<label><input type='radio' name='".h($C)."' value='".h($y)."'".($y==$Y?" checked":"").">".h($X)."</label>$zh";return$J;}function
confirm($Ze="",$wh="qsl('input')"){return
script("$wh.onclick = () => confirm('".($Ze?js_escape($Ze):lang(6))."');","");}function
print_fieldset($u,$Ee,$uj=false){echo"<fieldset><legend>","<a href='#fieldset-$u'>$Ee</a>",script("qsl('a').onclick = partial(toggle, 'fieldset-$u');",""),"</legend>","<div id='fieldset-$u'".($uj?"":" class='hidden'").">\n";}function
bold($Na,$eb=""){return($Na?" class='active $eb'":($eb?" class='$eb'":""));}function
js_escape($Q){return
addcslashes($Q,"\r\n'\\/");}function
pagination($E,$Hb){return" ".($E==$Hb?$E+1:'<a href="'.h(remove_from_uri("page").($E?"&page=$E".($_GET["next"]?"&next=".urlencode($_GET["next"]):""):"")).'">'.($E+1)."</a>");}function
hidden_fields(array$Ig,array$Rd=array(),$Bg=''){$J=false;foreach($Ig
as$y=>$X){if(!in_array($y,$Rd)){if(is_array($X))hidden_fields($X,array(),$y);else{$J=true;echo
input_hidden(($Bg?$Bg."[$y]":$y),$X);}}}return$J;}function
hidden_fields_get(){echo(sid()?input_hidden(session_name(),session_id()):''),(SERVER!==null?input_hidden(DRIVER,SERVER):""),input_hidden("username",$_GET["username"]);}function
enum_input($U,$_a,array$n,$Y,$vc=null){preg_match_all("~'((?:[^']|'')*)'~",$n["length"],$Pe);$J=($vc!==null?"<label><input type='$U'$_a value='$vc'".((is_array($Y)?in_array($vc,$Y):$Y===$vc)?" checked":"")."><i>".lang(7)."</i></label>":"");foreach($Pe[1]as$t=>$X){$X=stripcslashes(str_replace("''","'",$X));$ab=(is_array($Y)?in_array($X,$Y):$Y===$X);$J
.=" <label><input type='$U'$_a value='".h($X)."'".($ab?' checked':'').'>'.h(adminer()->editVal($X,$n)).'</label>';}return$J;}function
input(array$n,$Y,$s,$Da=false){$C=h(bracket_escape($n["field"]));echo"<td class='function'>";if(is_array($Y)&&!$s){$Y=json_encode($Y,128|64|256);$s="json";}$bh=(JUSH=="mssql"&&$n["auto_increment"]);if($bh&&!$_POST["save"])$s=null;$pd=(isset($_GET["select"])||$bh?array("orig"=>lang(8)):array())+adminer()->editFunctions($n);$bc=stripos($n["default"],"GENERATED ALWAYS AS ")===0?" disabled=''":"";$_a=" name='fields[$C]'$bc".($Da?" autofocus":"");$Ac=driver()->enumLength($n);if($Ac){$n["type"]="enum";$n["length"]=$Ac;}echo
driver()->unconvertFunction($n)." ";$R=$_GET["edit"]?:$_GET["select"];if($n["type"]=="enum")echo
h($pd[""])."<td>".adminer()->editInput($R,$n,$_a,$Y);else{$Bd=(in_array($s,$pd)||isset($pd[$s]));echo(count($pd)>1?"<select name='function[$C]'$bc>".optionlist($pd,$s===null||$Bd?$s:"")."</select>".on_help("event.target.value.replace(/^SQL\$/, '')",1).script("qsl('select').onchange = functionChange;",""):h(reset($pd))).'<td>';$de=adminer()->editInput($R,$n,$_a,$Y);if($de!="")echo$de;elseif(preg_match('~bool~',$n["type"]))echo"<input type='hidden'$_a value='0'>"."<input type='checkbox'".(preg_match('~^(1|t|true|y|yes|on)$~i',$Y)?" checked='checked'":"")."$_a value='1'>";elseif($n["type"]=="set"){preg_match_all("~'((?:[^']|'')*)'~",$n["length"],$Pe);foreach($Pe[1]as$t=>$X){$X=stripcslashes(str_replace("''","'",$X));$ab=in_array($X,explode(",",$Y),true);echo" <label><input type='checkbox' name='fields[$C][$t]' value='".h($X)."'".($ab?' checked':'').">".h(adminer()->editVal($X,$n)).'</label>';}}elseif(preg_match('~blob|bytea|raw|file~',$n["type"])&&ini_bool("file_uploads"))echo"<input type='file' name='fields-$C'>";elseif($s=="json"||preg_match('~^jsonb?$~',$n["type"]))echo"<textarea$_a cols='50' rows='12' class='jush-js'>".h($Y).'</textarea>';elseif(($ui=preg_match('~text|lob|memo~i',$n["type"]))||preg_match("~\n~",$Y)){if($ui&&JUSH!="sqlite")$_a
.=" cols='50' rows='12'";else{$L=min(12,substr_count($Y,"\n")+1);$_a
.=" cols='30' rows='$L'";}echo"<textarea$_a>".h($Y).'</textarea>';}else{$Ui=driver()->types();$We=(!preg_match('~int~',$n["type"])&&preg_match('~^(\d+)(,(\d+))?$~',$n["length"],$B)?((preg_match("~binary~",$n["type"])?2:1)*$B[1]+($B[3]?1:0)+($B[2]&&!$n["unsigned"]?1:0)):($Ui[$n["type"]]?$Ui[$n["type"]]+($n["unsigned"]?0:1):0));if(JUSH=='sql'&&min_version(5.6)&&preg_match('~time~',$n["type"]))$We+=7;echo"<input".((!$Bd||$s==="")&&preg_match('~(?<!o)int(?!er)~',$n["type"])&&!preg_match('~\[\]~',$n["full_type"])?" type='number'":"")." value='".h($Y)."'".($We?" data-maxlength='$We'":"").(preg_match('~char|binary~',$n["type"])&&$We>20?" size='".($We>99?60:40)."'":"")."$_a>";}echo
adminer()->editHint($R,$n,$Y);$Zc=0;foreach($pd
as$y=>$X){if($y===""||!$X)break;$Zc++;}if($Zc&&count($pd)>1)echo
script("qsl('td').oninput = partial(skipOriginal, $Zc);");}}function
process_input(array$n){if(stripos($n["default"],"GENERATED ALWAYS AS ")===0)return;$v=bracket_escape($n["field"]);$s=idx($_POST["function"],$v);$Y=$_POST["fields"][$v];if($n["type"]=="enum"||driver()->enumLength($n)){if($Y==-1)return
false;if($Y=="")return"NULL";}if($n["auto_increment"]&&$Y=="")return
null;if($s=="orig")return(preg_match('~^CURRENT_TIMESTAMP~i',$n["on_update"])?idf_escape($n["field"]):false);if($s=="NULL")return"NULL";if($n["type"]=="set")$Y=implode(",",(array)$Y);if($s=="json"){$s="";$Y=json_decode($Y,true);if(!is_array($Y))return
false;return$Y;}if(preg_match('~blob|bytea|raw|file~',$n["type"])&&ini_bool("file_uploads")){$Xc=get_file("fields-$v");if(!is_string($Xc))return
false;return
driver()->quoteBinary($Xc);}return
adminer()->processInput($n,$Y,$s);}function
search_tables(){$_GET["where"][0]["val"]=$_POST["query"];$yh="<ul>\n";foreach(table_status('',true)as$R=>$S){$C=adminer()->tableName($S);if(isset($S["Engine"])&&$C!=""&&(!$_POST["tables"]||in_array($R,$_POST["tables"]))){$I=connection()->query("SELECT".limit("1 FROM ".table($R)," WHERE ".implode(" AND ",adminer()->selectSearchProcess(fields($R),array())),1));if(!$I||$I->fetch_row()){$Eg="<a href='".h(ME."select=".urlencode($R)."&where[0][op]=".urlencode($_GET["where"][0]["op"])."&where[0][val]=".urlencode($_GET["where"][0]["val"]))."'>$C</a>";echo"$yh<li>".($I?$Eg:"<p class='error'>$Eg: ".error())."\n";$yh="";}}}echo($yh?"<p class='message'>".lang(9):"</ul>")."\n";}function
on_help($mb,$Ih=0){return
script("mixin(qsl('select, input'), {onmouseover: function (event) { helpMouseover.call(this, event, $mb, $Ih) }, onmouseout: helpMouseout});","");}function
edit_form($R,array$o,$K,$dj,$m=''){$hi=adminer()->tableName(table_status1($R,true));page_header(($dj?lang(10):lang(11)),$m,array("select"=>array($R,$hi)),$hi);adminer()->editRowPrint($R,$o,$K,$dj);if($K===false){echo"<p class='error'>".lang(12)."\n";return;}echo"<form action='' method='post' enctype='multipart/form-data' id='form'>\n";if(!$o)echo"<p class='error'>".lang(13)."\n";else{echo"<table class='layout'>".script("qsl('table').onkeydown = editingKeydown;");$Da=!$_POST;foreach($o
as$C=>$n){echo"<tr><th>".adminer()->fieldName($n);$l=idx($_GET["set"],bracket_escape($C));if($l===null){$l=$n["default"];if($n["type"]=="bit"&&preg_match("~^b'([01]*)'\$~",$l,$Yg))$l=$Yg[1];if(JUSH=="sql"&&preg_match('~binary~',$n["type"]))$l=bin2hex($l);}$Y=($K!==null?($K[$C]!=""&&JUSH=="sql"&&preg_match("~enum|set~",$n["type"])&&is_array($K[$C])?implode(",",$K[$C]):(is_bool($K[$C])?+$K[$C]:$K[$C])):(!$dj&&$n["auto_increment"]?"":(isset($_GET["select"])?false:$l)));if(!$_POST["save"]&&is_string($Y))$Y=adminer()->editVal($Y,$n);$s=($_POST["save"]?idx($_POST["function"],$C,""):($dj&&preg_match('~^CURRENT_TIMESTAMP~i',$n["on_update"])?"now":($Y===false?null:($Y!==null?'':'NULL'))));if(!$_POST&&!$dj&&$Y==$n["default"]&&preg_match('~^[\w.]+\(~',$Y))$s="SQL";if(preg_match("~time~",$n["type"])&&preg_match('~^CURRENT_TIMESTAMP~i',$Y)){$Y="";$s="now";}if($n["type"]=="uuid"&&$Y=="uuid()"){$Y="";$s="uuid";}if($Da!==false)$Da=($n["auto_increment"]||$s=="now"||$s=="uuid"?null:true);input($n,$Y,$s,$Da);if($Da)$Da=false;echo"\n";}if(!support("table")&&!fields($R))echo"<tr>"."<th><input name='field_keys[]'>".script("qsl('input').oninput = fieldChange;")."<td class='function'>".html_select("field_funs[]",adminer()->editFunctions(array("null"=>isset($_GET["select"]))))."<td><input name='field_vals[]'>"."\n";echo"</table>\n";}echo"<p>\n";if($o){echo"<input type='submit' value='".lang(14)."'>\n";if(!isset($_GET["select"]))echo"<input type='submit' name='insert' value='".($dj?lang(15):lang(16))."' title='Ctrl+Shift+Enter'>\n",($dj?script("qsl('input').onclick = function () { return !ajaxForm(this.form, '".lang(17)."…', this); };"):"");}echo($dj?"<input type='submit' name='delete' value='".lang(18)."'>".confirm()."\n":"");if(isset($_GET["select"]))hidden_fields(array("check"=>(array)$_POST["check"],"clone"=>$_POST["clone"],"all"=>$_POST["all"]));echo
input_hidden("referer",(isset($_POST["referer"])?$_POST["referer"]:$_SERVER["HTTP_REFERER"])),input_hidden("save",1),input_token(),"</form>\n";}function
shorten_utf8($Q,$z=80,$bi=""){if(!preg_match("(^(".repeat_pattern("[\t\r\n -\x{10FFFF}]",$z).")($)?)u",$Q,$B))preg_match("(^(".repeat_pattern("[\t\r\n -~]",$z).")($)?)",$Q,$B);return
h($B[1]).$bi.(isset($B[2])?"":"<i>…</i>");}function
icon($Nd,$C,$Md,$_i){return"<button type='submit' name='$C' title='".h($_i)."' class='icon icon-$Nd'><span>$Md</span></button>";}if(isset($_GET["file"])){if(substr(VERSION,-4)!='-dev'){if($_SERVER["HTTP_IF_MODIFIED_SINCE"]){header("HTTP/1.1 304 Not Modified");exit;}header("Expires: ".gmdate("D, d M Y H:i:s",time()+365*24*60*60)." GMT");header("Last-Modified: ".gmdate("D, d M Y H:i:s")." GMT");header("Cache-Control: immutable");}@ini_set("zlib.output_compression",1);if($_GET["file"]=="default.css"){header("Content-Type: text/css; charset=utf-8");echo
lzw_decompress("h:Mhgб\"PimcCd<fa:;NBqR;1Lf9u7%d\\;3A`%E!e9&r4MAv2\r&:Φs0*3Má-;LC@i:dt3-8aI\$ãe	#9lT!Ѻ>e\0ddC:6\\cArhM4kZ|O+f9X7h\"Si|+9ƣ-4W~T:zkHb{&єt:ܸ.Kv8#\",7!pp2\0\\ \$r7ތ#i\"aT(L2#:\0ΤxXFǉd&jvڗ@dE!,9.+`JahbDP<|\"Cp>ˑ+b2	L{FQ|rKlɏ_t=bK|\r=R>0(kbJU,PUumI.tA-KX4z)MPk3e`N>D#9\\(YT@hL1]ȴͺNKն2\\73i/VlYҗBA/[JĘВ\r;'2^텪bۣ3T=0H8\r+6kfC]qW)²C2`A82!hmвGD2-CYc`<s629uyҝMgy=,CZO~^302<k0wM{d#`Zۀ޺6C%=Rq_+-K>\n'GA\$^j><gfhmb*/\$\$lشg)Aj w#ᣃTN]T%ZjJCf4zF'* xho&k\r,r:>s(LAs5Ctn6 ll\\9D\\!mv\0A{9`.סSlg6!.20PԠi\r\$7w;G\$0CI^J\nLPc'*Ehb;pB(x:DL.j9AC@I3jf5sI`X}Ҕ#7T`djhH49S\nqHJQ H`,FP0\\{m\r~@20u!	\$PoQ4ǚ\nZLMBk)@dSLpvyЃB^o*R\"#rͥS;\r4&GIT	r9=6QT\0\0f#=\$H6PY:G\$09:a3Hz;G\r!hJn7	oYWLvېi|%-d\$pDR2T\rpaUn5rj\$r%D)\$GڃBu:`(lSD)I	9*ꁗ\rt2 zIg[Xc,u\rvJ5?\":^.uJPo\$t\$18\nnKT%EZ,6DHV󆪹i&zxpdrx*}ʐR25+ѓf2wq0X12dXߢ̏WËV8f\"냐q(uEGqM#а#K3WAvYÞeK]t]Ej=SX@Ӈ\rӘ\$9ܬ0P7\"D.匎<;Nj=^mmڒG68 C%v'yk/^53@.ڛka*D:7C}```)7|	3 i騽4\0.:QL؜ͨf'%ݩM	Y3\0##tP6(Bdoy6|5IH7z?(Ŗ\$RWT谦:(`r϶is=D\\,kr1ٓ2`A9&n~Ҭ6;vp M#]ɴAiJ.tYsOPwĸmZAUʷJN?z3\$PqsU9,#5PnbuNѐ{N`饙۝iw\rb&E\\tgba1+mpw#vlU\0e.(wb@\\w()E;Z]/&|>Q\"c	<F\r7ϵ\\'Sfe\rRVlo/.\nFo ehejנTsa422 `o\\A?]IoB[{7'Q%6s7\$Ó~%u)5i0#\rfMXN\\ɇ\0,TETo\0{oRr^C @Z.C,c'J-BL\rPCD\"b^.\"h\0\r\0\n`	  no	\r\r0`0	\rp 	0\n F@` V\0\n\r\0\nj\n@\0\r\n	 \n@@\r\0& \n@ @ zƂ*wq0g5aPxG		\n\n\rp\rp\r	0\r`\r@@ ^\r \0\rd@3 1Q9AB<t1N?Sv-ap	pP\n0\0@Ѱ\r^\"i@\n 6 \0	 p\n\n` qޒQDBMd9TUq12	\n2rR#2+\r/#@\" Q\r\r@\nh\n〪\0`	@!;CoUҋ2e Qk p !P3с!r%p	 ,`\n`\n@ff ` \n@	F#`p# o\\%Bl?M-jPr3/3*Qlp	p\r`=\n\0_>1'#\0>\0\r \n@ f0'@Ā\0\rdFhI\$`,CȕPݔT>7\0]E̣ʉDGAC\\BMDԈfmd(\rOGFiDNɜn24tΔwFtFHCԈu+\$K6蔓E.AKԏL*1JK>MH\"GNPjE> H&5HLM#EPcc8l,CNPt@V t\nݴI	kGH	)D(JPl1jnlԍJ~*&n\\HUfLkKrF<|HNx\\ NlNI\0rzMtU|ZĸԘ\rHC΀B\"@bcnAJ9OrtA4\r@hA^`^V0^!LjU.^\r\"kalpd }\0NIGPUYtyMPrYEԥx6``jg1SB܂X8V?Id[IQ.`i̲vԞU)Ԝ\n2PV~ \"\"&r]- p*\0f\"Kj`q\nJ\"qF.\"@r(`3q>\"f\r\$ح R1h&H`ZV	u+Moʬ\n3J\r Đ2I D'!S0W0J?ypjZ.\n\r pw\"-+zr!`|v2\nlf(m<=F\rQ}~7\r#o3}x<~WiEã[8\nbjj\r: )v'{Vq\no{)C߂i\r%遀C(kk4ؐd jXLN(A}xe|wGxhXx\r%K޼oqx8s4exρn*4Fc8~hIp]{%( Ӓ<VCB{wOƣ}Q8[[{cT%&o:*bE`mIYWk8You)Y5o9ަى<8(?\0[s@*8}ߟ9g\rӟ\0\n'w±x)݌٩92Z1@[I+_57=Dqz!}KNd3\0q+CY_g8yډK4{S82ZzX\0ϨzSڱe \r>:Ǭ_ZÏe:u{UMaBzɈb2YSWJ(wOwӁwmتZNl˧C98BD6Zyx{;![m{})#4[(bɘՆu,O\"F7y?9nd}{ݍs{eʦ>\"ccdcs{vdCN[GMC瓭DE@");}elseif($_GET["file"]=="dark.css"){header("Content-Type: text/css; charset=utf-8");echo
lzw_decompress("h:Mhgh0LЁd91S!	F!v}0fa	G2Na'3IdK%	m(\r&Xo;NBy>2S*^#Q1=JW^Loc!f6mal4&1Lf9u7VDc3n82IΆ,:5rP1m>5W/FcDh2L\rNWo&hke2ٌb12Ƽ~0 D}N\0f4MCn=pZشN~;-C %z99P\";\0f89p:m8@\nX:r3#C[Cx#I2\\\"p]#5Rr6#L7!H\$\$IRd'ˉ8]	x+>C@-;b<2ÔN4,-Mr6IcX4a5KETh@1@RK9\r(9#8GCpwID52l\"_'UBU9c@G=C\nS0j7PU9J]<׋\nƲσz?B24\r/P\rM[XF_jHbnC&¡f%@cC^.28׎C}^swL/5OMڳ	*X?b.Ig&aq݊>FN-`y4sj\\&:SaP;HXޯdkt?.,ZO@@8Z3c\"ß\n=AH1\\Z^/k΃LuC\\c)0OMlpr7\rqWRac@wmk/8*?̐45\\mk>d1nUQ#w憟Lo&hĪPrnR,5z\"\$3dYH(p\rALAC)pTPl!\"L8R&\0Z౒0P8J	`e0	1	DJsH)k [Cypjx,\rAm!<h1");}elseif($_GET["file"]=="functions.js"){header("Content-Type: text/javascript; charset=utf-8");echo
lzw_decompress("':̢i11	4Q6a&:OAIe:NFD|!Cym2\"r<̱/C#:DbqSeJ˦Cܺ\n\nǱS\rZH\$RAܞS+XKvtdg:6EvXŞjmҩej2MB&ʮLC3Q0L-x\nDyNaPn:s͐(cL/(5{Qy4g-i4ڃf(bUko7&ä*ACb`.\r\nCh<\r)`إ`7CʒZX<Q1X@0dp9EQfF\r!(h)\np'#ČH(i*r&<#7K~# A:N6l,\rJP3!@2>CrhN](a0M326UE2'!<#3R<XCH7#n+a\$!2P0.wdr:YE!]<j@\\pl_\rZғTͩZs3\"~9jP)QYbݕDYc`zcѨ'#tBOh*2<ŒOfg-Z#8a^+r2b\\~0Wnp!#`Z612@ky9\rB3pޅ6<!pG9no6s#F3bA69Z#6%?s\"|؂)bJc\rNsih8ݟ:;HތuI5@1APaH^\$Hv@ÛL~b9'S?P-0C\nRm4ȓ:Ը24h(k\njI6\"EY#Wr\rG8@tXԓBS\nc0kC I\rʰ<u`A!)2C\0= P1ӢK!!pIs,6di1+k<^	\n20Fԉ_\$)f\0C8E^/3W!א)u*&\$2Y\n]EkDV\$JxTse!RY R`=Lޫ\nl_.!V!\r\nHk\$א`{1	|i<jRrPTG|w4b\r4d,E6<h[Nq@Oi>'ѩ\r;]#}0ASIJdA/Q⸵@t\rUG_G<<y-Iz򄤝\"PB\0q`vAa̡JRʮ)JB.TLyCpp\0(7cYYaM1em4crS)opC!ISb0m(dEH߳X/PyX85\$+֖gdyϝJ lEur,dCX}em]2̽(-zZ;I\\) ,\n>)\rVS\njx*w`ⴷSFid,ZJFM}Њ \\ZP`zZE]dɟOcmԁ] %\"w4\n\$zVSQD:6GwMS0B-s)Zcǁ2δA;nWz/AZhG~cc%[D&lFR77|I3g0Lac0RJ2%F S L^ trtʩ;.喚Ł>[aN^(!g@1Nz<bݖO,CuDtj޹I;)݀\nncȂW<s	\0hNP9{ueut뵕3=gJWQ0w9p-	'5\nOe)M)_kz\0V;jl\nxPf-`C.@&]#\0ڶpy͖ƛtd b}	G1mru*_xD3qBsQus%\n5sut{syN4,J{4@\0P^=l`e~F١h3o\"qR<iUT[QUM6T. 0'pe\\5pCe	ٕ\"*M	D?h2zU@7C4aiE!f\$B<9o*\$lH\$ @P\rNYn<\$	Q=F&*@]\0 W'd z\$jP[\$0#&_`+B)wv%	LcJRSi`Ů	FW	\nBP\n\r\0}	瑩0Z/`j\$: 8ieφxa GnsgOU%VU@Nϐd+(oJ@XzM'F٣WhVI^٢1>@\" QR!\\`[.0fbF;Fpp/t`(VbȲ(Hlԯ1vH1T3q1Ѫf\nT\$Nq+`ލvǜ\rVmr'ϸg%\"Lm((CLz\"hXm=\\H\n0U f&M\$g\$U`a\rP>`#gh`R4H'GK;\"MۨThBEn\"b>\r#\0N:#_	QQ1{	f:BR&)JBr+K.\$Pq-rS%TIT&Q{#2o(*P5`1H'	<Tds,N ^\r%3\r&4B/\0kLH\$4d>/ඵH*3JА<Hhp'O/&2I.x3V.s5e3ێZ(9Eg;R;JQ@vgz@'dZ&,UFb*DH! \r;%x'G#͠w#֠2;#BvXa\nb{4KG%GuE`\\\rB\r\0-mW\rM\"#EcFbFnz@4J[\$%2V%&TVd4hemN-;Eľ%EEr<\"@FPL ߭4Ez`u7N4\0F:hKh/:\"MZ\r+P4\r?SO;B0\$FCEpM\"%H4D|LNFtEg5=J\r\"޼54KP\rbZ\r\"pEQ'DwKW0g'l\"hQFC,CcIHPhF]5& fTiSTUS[4[uNe\$oKO b\" 5\0D)E%\"]/ЌJ6Ud`a)V-0DӔbM)`%ELt+6C7jd:V4ơ3 -R\rGIT#<4-CgCP{V\$'gR@'S=%Fk:k9e]aOG9;-68W*x\"UYlB	\nplZm\05Oq̨bW1s@K-pESpw\nGWoQqG}vpw}qq\\7RZ@tt;pG}w׀/%\"LE\0th)\rJ\\W@	|D#SƃVRz2v	}(\0y<X\rxq<Isk1S-Q4Yq8#vd.ֹS;q!,'(<.J7H\".u#Q\rerXv[h\${-YJBgiM8'\nƘtDZ~/b8\$DbROO`O5S>[Dꔸ_3X)'Jd\rXUDUX8x-旅PN`	\nZ@Ra48:\0xN\\0%f\\>\"@^\0ZxZ\0ZaBr#X\r{˕flFb\0[ވ\0[6	 =\nWB\$'kG(\$ye9(8& hRܔoȼ ǇY47_d9'z\r  vGO8MOh'XS0\0\0	9s?IMY8 9HO,4	xsP*Gc8QɠwB|z	@	9cKQGbFjXoS\$dFHĂP@ѧ<嶴,}mr\"'k`cxeCC::X T^dÆqhsLvҮ0\r,4\r_vLjjMb[  lsZ@;f`2Yce'MerF\$!\n	*0\rANLPjٓ;ƣVQ|(3[p8|^\rBf/DҞ B_N5M \$\naZЦ~UlerŧrZaZգs8RGZwN_ƱYϣm];ƚLcŰIQ3O|y*` 54;&v8#R8+`XbV6ƫi3FEoc82M\"GWb\rOCVdӭw\\ͯ*cSiQүR`d7}	)ϴ,+bd۹FN3L\\eRn\$&\\r+d]O5kq,&\"DCU6jp\\'@o~5N=|&!BwHyyz7(Ǎb5(3փ_\0`zbУr8	Zv8L˓)SM<*7\$\rRbB%ƴDszR>[Q&Q'\rppz/<}L#ΕZ\"t\n.4gPpDnʹNFd\0`^\rnȂ׳#_ w(2<7-X޹\0s,^hC,!:\rK.ӢŢ\\+vZ\0Q9eʛ˞Ew?>\$}D#c0MV3%Y\rtj57{ŝLz=<8IMGL\$2{(pe?u,Rd*X4\0\"@}<.@	N\$XUjs/<>\"* #\$&CPI	t? 	O\\_Q5YH@bch뱖O0T'8wj+Hv_#06w֎Xd+ܓ\\\n\0	\\>sA	PFd8m'@\nH\0cOwSY`RDna\"~?m|@6+GxV\0WӰnw.؃b9ÍE|E\rЈr\"x-\rN6n\$Ҭ-BH^)y&ךWǧbvR	N\0n	T`8XA\r:{O@\" !\$KqojY֪Jh}d<1IxdTT4NeeC0䥿:DF5L*::HjZFRMրnS\n>PO[\$V8;#K\\'BRدR_8j*Ej\\~vvp@TX\0002dE	HVD\"Q'EDJB~AAIl*'\nY.+9pg/\"180IAFCȨV*aPdУ5H\"A6sY;訞/0v}y\rץ1u\"ˋm_0焄`\\B1^\nk\r]lh}]HBW`0꨹rFf)W,ҧ]sm9'OxԽ,9J8?4\"҅۽<-SM;v6y|Z%a#8TC!p\nCZ(wa?9|0<BL\r\n]PB0&+tHօDx^,L}[Bx}ru\0\0005S@\"Uؔ@\0\$ސ\"Ҡ]l/	IB4.6d7\r@=߬*G jf`:HnbĀ71)C<@AY#eoY!IDM\nlt/)\\43)2ɸ)f[ ppp1#Ðp\0œl^{ATH6\n\0PH.\r|TFD0Sy'1KdBC&)Ws Hee+@4 rۚ*Lp1<fNY'-	XKVaL\"\"lq.YJHm HV/lC&H)o&\\2%z\n^Q(6D Jq\00a#6\0vr,M&A9%YdBh!W\0b\r{@1I22A)Ha@r0G7Dd.LM<2,k/Me}Ғ3=\0&B\nPd.\"F3XSd(*J6 F:)11?lQ&h<J͋fdEպ*x\n\0.\"B -#ΗtIΫ	I8 8dh	x~	L!K(BX-hc/rPIN2|׶|\"M'K,\\He5*o]4FP	2<)To\nIڢ!(_8Xr;uNJ[rDC:@ͳl\0e\\*x@Aȡ&(5,#1x !TD(QDJ|D D:\0Aй baE?rnWkxX=i,\$3[r9BƱd\0H4<(z?sIbJg U\n(}J\"AB19~I#\$%d  e\"`t'O=@\$O\nmTo+Z-PF?_IJX ģ2-V;?20*P3_T<EJ\\(2)IQ鬩RL&!ȯKiцtKHRlȬEsDxǴi!faBFe>V-QjI7\"%Rh gM-b58R*9ꊰ92Q0IR[ZN\020\\[@Q\0JxEC{\$lp1=\0Rо>E~:0%R+)\0	ƑQ@(\"_jTX\0\r1\0P9#\0H;B|LZ6/B\nB{|H,	*;(`2@6>	?P\0/\0|\\eB`jqU/\rc҆6(N\0/\$\n8j*U\$y*=;\$f8XBCEr\"/kځ%\\9kB0F('UƮm@kT\0EsEhye\n))b7(W%,Jr2DrhE\n0Q3 U9TPO8j|}R<0Zl T*\$U\r\". Ts~~(3a@+l`:`:OiBX?ʄ7Lj|:nK:ز}\0UMc`P%nn\n,4Q'%+H.\"#G3`\n1fg\0М'kqxD<\",a|{~C<SiB\nkNG}k:g)JDhÛf\"kV~mM`HOkD^0/tjl\r!f<GTv#@ek@2w0ܭtį1uyvː%8?1lxtmpfK3ZJ=\0@^pۑ]Ҳ't١@Cb\r[V-o-ݠe}Y	--mI\0+VD[B+(-4>qi>=/0-cLpJ b\nd)#Gs\"QN`.ȍyȐEtPqI]J8rWTIfaG.떄7ylA7'1	S-xImL:eΉAWζEIWz3W)*/)Cx*c]%}_IvͲ'\$US4k5WʏJC7*b%<WC@	c{޴3)X&&eLI,N 2k#p5f4Ǻz#\\NbUoyS4`q~1=8厉*OOJC'Dd,@kL\\j2ͩ<@_q2\0ձ)`sF\0\nF<*x*`-\r|@7H@wH]\0_wh0!s1ϏǬhW.=WR*A_EDԷ?1,Ub9=t4èW^;@(1<DÊHxT()0z`_;AL)\nK[fHWo@bBKiMd+>vI(z:.݀9uiѤDYO`]I\0RĆ,K,6L\"\"1g(|T.,9vb+\rk]u&|bSd[,gaJ(Ck\rF+	9L))UABUhgc3x-n9x2qibrY7kyf,)٪J:N8Rcly\n2W;.>v6Q#A0{έi7~@VX^11-+v|]Vf.{	\r;1lp/uFd\$PЮ0=@kS0hɈ@/*(OV.G>(r!6Y=XZ@:'&06kE|'|H;Ng%W+4;̓'x|f9(Odw%9]f}Gs¾XM0gQ8̄+O}͝0}9Nh/mgDs\n74勳P~}O)Ug9j8Pݸ(%j7oABi)Ku }s1=odV[Ĵ\nzlMзr:F#{*#xܰ<Dsk/mw :^1ύD2z*n%iÙ *!8-tH'\rк48`\"i]ZZ>Z\0ަ9+䟂~\$ޭLP\\쇁XAizh\$SMT'1D	5E\0Ğ\$ttԮ:\rMƷSӖlsAfKk,NlD^zzdS/rtN>o%i\0JBpoR/֘٫x\ny+,e4q5Q'JD]B@mRSki~t0[ 1z	&^\nOVGV@T*H9ωG0\0'`Ѱ\rbQKsLd*;\n.ĔUNp,L@TRebFyn> IKrG	@?cIݓu%GO1Ch5TyI:\\0X>ʊ0޾QBEI/-LBT!b6k`jp\0K>kd/ISk.+*R|gRW\\wt.)^Zc8Z~FSǵSm̕;b>\0jz=T'>qy}:u&WDQc-6<[exؠ[L\0wmltz<S&dbxoigK\r`µ?D5u@bNO𤷤Y[{Nr鉞t\0tMscBW?*D.p'2Ge\rp*#eC\"QI\nhiQ@\rl	_.t*^s9Whq~,YθdQs¦\rBjDǡ<<T)C\n&D{\rl-R\r@rkϢ+ZPu8Ȩsوo#gu\$F&\n-v\"Pjnnt1VAwbx߄D5-0a\0\r/!I|/hnGf-Mdna^(ea¨YZ,SEN\\=4~Mʹ\rFtŦu\"|`ERzD`{@k/KY3sJ䃿5XGͪ%9)Q Q1th!TRHQ\rCE0#wG2//=^ /ԺΐE\0{+t+qбIt|vqԈƌ&\r\\Vߠ=EbnOrnX({ɹuzK`=:\n\0[%:pq+RldY\"[Vu{H-H_8jV5\"\0\"N?E;+O~wN];L'SOF䁻D-!#sN< ¯muG8Tn]:zIMn O8z5o\\57<Ų#8?sNL	}x&4?[z󳷶<*We}{HZ,(<ooxWt2#A*o\\R}xH>NP|Qɚ|x'- 2\0?ƾ2*\r|]tp\"ڲJuuXybD\nZ|H7_WGuXyH>T\rGQln!u'*C5>U2!b	9Pw4}yW|a\$gTU&~9(\\*!b_w7\\]=\\*@#N7ͪ5QN`@<\06!9l\$wI\$42\$&.RZYuyᤳp&SI@EJiLcV1F1Z\r\rhkHH˿K?x-0\ndN3KC59)ľ:B#dN5A1ƉOd[3ڠh[s~)9DNy>X'ȽϐH,)ڂ\"e0;\0qeo>=|2G+B@z@]}rQ k/|G:ѯW\0a4>^|goXE9pLrgA6pe1*7[>]#?jB~/}3:U\$?<Ga\n>0#!i>.{A}'hQLw~W_Th#dûdFQ*{\"\"P{}4Ni\r_e?l42?\nF	qUĽ_`_j{_k_o~c*#(/!DnF`?@sB!?;E\0k	*ND;+d\nZZdB `B5P\n8c#oukˊMݯw.FJ!|Ĉ2FcY).XHy[~#/&[Y@(|\r\0,O0YbβŬ\$0aˑ A\$0,@Ӱ>>9\\ti<\0q\0}@`\0fVjdߠ'(	!_n0+ciig8a]'=-B!(8_xj)\rH5HYn	,fr}-d\$H2n鴆ܛ=-dFE-daN_z4@[n\$x!!i0Tu8ɸ\0PZ8Zc+ЊAAF(`mg*vS, ǆKcA۬ &9c0w+n=)\$Q~Aa\0004\0u{(\$y	!B A<aAz ZA4\$ZY9.aX\rdALv|oOz|Z(eZĆ");}elseif($_GET["file"]=="jush.js"){header("Content-Type: text/javascript; charset=utf-8");echo
lzw_decompress("v0F==FS	_6MƳr:ECIo:CXc\r؄J(:=Ea28x?'iSANNxsNBVl0S	Ul(D|҄P>E㩶yHch-3Eb bpEp9.~\n?Kbiw|`d.x8EN!23\rYy6GFmY8o7\n\r0<d4E'\n#\r.C!^t(bqH.s2Nq٤9#{c3nӸ2r:<+9CȨ\n<\r`/b\\!H2SڙF#8ЈI78K*ں!鎑+:+&2|:9:NpA/# 0D\\'12a@+J.c,1@^.Bь`OK=`BP6>(eK%! ^!ϬBHSs8^93O1.Xj+M	#+F:7S\$0V(FQ\r!I*X/̊67=۪X3݆؇^gf#Wg8ߋh7Ek\rŹG)tWe4V؝&7\0RN!01WyCP!i|gn.\r09Aݸ۶^8vl\"b|yHY290߅.:y6:ؿn\0Q7bk<\0湸-B{;W&/nw2A׵A0yu)kLƹtk\0;d=%m.ŏc5f*@4 cƸ܆|\"맳h\\fPNqsf~PpHp\n~>T_QOQ\$VSpn1ʚ}=LJeucaA|;ȓN-Z@Rͳ 	.2`RE^iP1&ވ(\$CY5؃axh@=Ʋ+>`ע\r!br2p(=!esX4GHhc MS.|YjHzBSV0j\nf\rDo%\\1MI`(:!-3=0SgWe5z(hdrӫKi@Y.\$@sѱEI&DfSR}rڽ?x\"@ngPI\\U<5X\"E0t8Y=`=>Q4Bk+p`(8/NqSKriO*[JRJY&u7#>Xû?APCDD\$Y<X[dd:a\$ΠW/ɂ!+eYIw=9i;q\r\n1x0]Q<zI9~W9RDKI6LCz\"0NWWzH4xgתx&FaӃ\\x=^ԓKHxٓ0EÝ҂ɚXk,R~	̛NySz6\0D	؏hs|.=Ix}/uN'Rn'|so8rta\05P֠dẘ̕q5(XHp|K2`]FU~!= |,up\\CoTe╙C}*f#shp5mZxfn~v)DH4evVbyT̥,<y,̫֞2z^K2xo	 2 Iah~cej6)]5͍dG׊Et'N=Vɜ@b^p:k1StTԙFF``{{47pcPطV9ىLt	M{Cln47sPL!9{l a!pG%)<2*<9rV)|AIp=\n7d>j^6\09#՗7T[i:XD'&8/;#f%Kj3;Z^]NQwtȬ\$ҹǎ-;LX+P̄:N \0ǲPyjt>.[<w\"|so-;';ǟt\rt	IT\nL\n)(Aa\" 	&P@O\n師0(M&b\0@@\n`=*̔8/kHF\"FB&,<4beN)FEONSNO\r.x\"kD\r 0p[2RI0Z'fixP0d|hOmkHΒ7\nneP\"0xP02n6WχN[!6ﰣ\r.u\rpP.(mGt\rox1!\n\r:z+lV'|?PP:0 bTaux`co}O1Wq8l\\u@\$NePKqgA(mcL'`Bh\r-!b`k `N0	nN`D\0@~`K]|ʾA#iYxf\r4 ,v\0ދQɠNRom 1&Ǫpr np6%%ly\rbʕ(S)')@ޯDMIs {&KH@dlwf0x6~3OPh0\"D+A\$I`b\$\$RL Q\"R%RFVNy+F\n	 %fz*TMɾR%@ڝ6\"bN5.r\0Wd4'l|9.#`憀أj6Τvvڥ\rh\rs7i\"@\\DŰi8#q8	\0ֶbL. \rdTb@E c2`P( B'0/|3R.So*cA)4K}:S\0O8B@@CC@A'B\0N=;S7S;D	MW7sED\rŨp<DȺ9 }4_o.rԉI\rHQzEsB\0eJ KwHtJ4,^25h2i%;=LL6}7#w<lrT;tPl76PrJ\n@5\0P!`\\\r@\"C-\0RSH~F倵ņO@ǭg)F*h\0pCOu6ҎYORg w9BӚL\"䘵_63gU5\r7,6\"1yV%VğWX]OJ	#XQGIXɰSq+(qRGH.l6[R0\0%HC}Sr77cYK).Cr;Ц)M+3 4|Ϊ1ZJ`׉5WL-SmxHdR*JЦ\r|52-C-1RRT`Ne@'Ʀ**`>\0|C!nE,ag.bfÝ8ӓ_a`Gp`m6Rz\0[-#mO1H\rdMMNMqnMnqR6mOn-tvæ\r]`-`jXMo]`OUAF37p>'J'm('M=j9jVZbBn<@<fe:\0K(NuN-!1vҍH(QgµxC<@ c[c\\2o,5˃q0m}i~+eѶ*}Ƞ}M~|̘\r @\"hB\$B2c\$g\$5b?6!w+~l1`	s	.v7mEc`Qecb6`\"&fx\"2E~Fz\$[/0,w~`u>w%X\$دvV\"-R%WD@ʀVoE@yh1\"tЙO/![`:x}@]b @5U(KyS>8D͸yw=|T,'LY\\L͌d.@ђ9<`9EZCײ\\h=qR`GGWX{5-LRJ\$JP+7XulӘh̵YPgzuiwyLycY7yF<v\r57dOgkYq8p	\n*'9\"`w[GHDy_]ciR˖ow9	{]Oݍ8C67:IvS:_U71zڵyy͹M0ͬc0z?z7}W'5_eƸzml\nCX_(Ý{@}X`SgBլDuñ!k~YOvK\0crr(^`n;y7z+{W:\$M\"I%omŠ	,PK9ʅg\n޸a~x%~WؽRٌ݋Xx%zSzթX?y#}L);!yߕsو:xz+UԺ|1uHO'cϩ{c<g/V:퉠Ɋ<\\3e\0ZTxZq\nl_I_Zy,ۙ]9ۚ͠,회k:;}-E\0S~2\\	UͺTV3oE|E CmϠI=\0НzkGٹ\0ّ91	y=5ۛ<Й]GЙScՇ!\rDR]P'pLtǚH+`Ӿ=e9ڇQ{9_b\$5lUzynz`xbkM	3 Z\rq])ֽ{#cWI\r8\r3䩽aSI'^a~eD稟>o2 NސP>cΞ^GY͞~x^Rg\\\$+ՍPkY*4~,MݶW-hhG_Iԉv-?ive>T\"\$[Ը+,)Kuq?KW\rkL%}tԻ~0|Pk՟T=?hEn=Es~xJHKVuk?X?7B)ciD\rא>D',ʟ>v@X+\rr@\rUXׯӀ1P>U,3G>>tѥ}\"=D}<T%9iʫo1e]hi&]|*l1D\r)XZRYl\"E/8ײ*ByK45Nrz\\pӽ9YzJHS>/4C&sCI;Z,ۆb3\rϖ{|vD\nٟNpÁ^Ay0az<ԜMPS0ڠjew=Ooz4>h1L%RS	}u82𦴮9oncM<uƶ0\rp~A\njQ3z(;3Ea]eUl40,uffH0݆\$1CAfi嬇>XcʂT\"6pHgDH?\"pl&K/?`2lm*TBK\"ϋɠ\$P\"oeVk<oIr:=(x2*Ȁ@=hCEF6u+,ZYir^lPx,g*ȖQE)1ihJ\"IFlY|TfV}Ueo	5Q?)\0cMFʼڑjllPm4\r*`⨸LMiqbV)QWR^a.>g	ox\n\0P`@`\$4鏍rZ#H&ncv)lF	 NcoXF9 g\"9'4t^!<	#0#hG|\nBx\0PT06\0TD~#<Ԑ@)Hb1I[hGj7_!0	CX@\0\n1@Z@\"ǎ8N\0jH\0E#ۊi:i#hDs#!TL\$\$)B׎v)-?hcP	 Oto\$pօB7#~D#-0dbDH	RlJ?\"`\nA?\0T,(RMp\$\":ISRzt\$'I>쓜'QM262PR	\\cxF&69^	pN)OHj:Q~y\0GyzFcĹ)s*<mQ\n(228zT#~[ G?-1.P;\\&5֍\0mTQn)p\$\\vZrK(c\nYws/gK]nbe.KPp:KC{6arؘl1)/04KUS@x˜QvT̄c.ʚ: 0ķL1چT0bhZL]AqVNL\nr0V#\0Ta2``2,\r-imMhSITxC,L.IOt	7_TrgIKxq8gIqMcDŦA3	 r`\\ULӜ'A9[8PQ0821 rBK`P%Tq	CF_hQu<C\n@<y,&Cv0%PO\"x*綔2&X)=p.\0{(N'y.2\$>a&)@\0Ov#X\nNz,xbiꁦ=iZyRg3MVs\n\nq\0?AhA;`;m(KAz\r!O\0EBJPBޡXO\0@Q4V0kuXtYK٫h=n{@f=6d)}* 95FB\0N'\0ѵЦ`)P˔o#ڀF>#BjQ1r*)/Rl	qXzA|Q9)H	҃@=*JD+p`+d\nE؀g(\0P,̤IXtmk64۔\r.K+ߤmIp&t=:OKQM\0	@O]<MzJLS@UrwJ1ڧ\n\$)ɨ	@aH]Bj.\0U \0'Ǵ\0B\0+TWRY4	 T9O\nsS9`N>>&MFԊ'4 \nj@*T1pf*9Li@5@/QRTvUeHjFUcY@Vzg槍[iNUT%\"R\nRhZXJ56EkUje1YF7?e#oJVnW\rV@QY>3ۀ*!L\0Lj\0I)\nLd1P!Z)]Z!8u̥ob (TB&CV|/%p)`ȅ\\ȮHb\nLSPGf󇶹JsԊAZLR`<׌55]Lw*:Ҹ@l`'fqEJ7Hގ/\nm\n܏o\0Q`9.qѬFV-!\n-3X5U]2\0\r!Ŋd)Ʊ\rXlb,n4qdK1d!wLofrW-Cvm\0p	צ*ɖx==yd[ V0(e+;:7͑	\"b,u\0{\n)F<\$T'RV`2\\VJ8P+`ɋ;Wd4FJJdRΦ4KL԰d矵富l|5.L\"U~`NmUmQTzN7U:\0v[J\0(S'*[k>T8=ANWpԊtoLYsX숲,0\0\nqVLulsn\0] /iا1 c<Ku֝zfTŇm\$+[1hXB`7c.kv067j؉5v2]FDdKueexvQ5B[2\"eE#^Yotli7jt][qM	dc}ȭhƁ%̷PQ_pۨqkj޻\\ei	D8*д1@+\n7B2@x4&\"W<\nme7mKD;G;Cf봿	d9+Z@w].Xw }n_uQTcԋxA5(T-X *f\0\"n*<W3po,p+s2\"\"މPMrQ +A82rpFp@}	uf7L|×-m?j>SpEz@>`?\0\ncx.!a꾯aZ+ʫ%MXw0zDĊhXUJlM#|S`Jck~EM^(eю.yP;+ᕕ@ۈ)Gbjōqh +%zp=0\nmIƀ+\nS|Βc@ƠpR޸H6	\0w_\"8r>aw\n:	\"\\qJLwO<|cV\0x݆@|*Wk6pOpLm[FTA\nC R9]vDF9w%F}<h#\0N~6'ȦJUV8v\0F\nR;.N3\rs/ -zxp[<F].:'ѠFG*q6G1Gܚ3]l@dÜJ;Ș\0007,Vc\r#weP\nqAZ^VzR't|kqqk>LߑR9g&fE\0R<d/wSeE7cQ*ec2eHk2c00¶o;2!Ijp?Y93[(`e(Hw3\"J=*W<큝a32@s27 <Y[&y˶^37g6 L|ǬqSsݓ>#rQ4Rh4Iסbg694@w.E3;/q]1WX7qΜ3%OYs}~f&Y1Αq]A\"|+~-2(,mcp6s<(6e4@[mӽU,=9y ^<2Hx e#cXIW|%+i,*3Q\$K\0=x2נ԰P7#ȳ0VXSB@l.%\rܥHҧu޼Z7p޲@2=]jnϴYQZCƎQAg8d^1<\\ gQ[~PRyH_ZVۆHƾ2U\rAQwK:\r\rtqgB.%G*c+Fb&-Gqb\0\n)1\n( r0Vx\0(MZ6X-'f2P^ōE,&bu°C8@ͧl8ڐ\rD-;kENӶ\r{-Wa]lz&vՊ{HZQmM{c&@[4tc!y0:|䶡EOtTr6e\"x|}ee>cdn\"2CvR`:k>X֠V&\"Jعs7qOY\"&ŞD:VL[޺Y؝Bm =y[\rcv]SZ&X3vQg{=`k-\nEpJ٭Do~;9\\S'p4kG|Z[v/Ë`Ujh(W\\@9;\\)xXC\0_\rCO~ʹDpK<2hv8&@ൔqL<UuFn*\\#B\\`*=\rV=Be`8\":X83|h=Nr|iW9\n3b0JL3B	)\\s*a?r3\nrH,uzV@4=#|aȔ}7\0i&%Ql!S>L׆[X!>=m_v\0D@xE\0۾A 3jDFnkw渣\0WZ~L&L+D#\0>@>v;p6\$+?CQ<RC!ɀM0y\$!r/d覫1Wz{:B5ctq۶蟾ju7N\rݢiN2Ȯw]J8A@tu44@}.+&/G[#\\FV'zQ5{c]I%{uyo^)lIfoPGI_9V}[)h@Oqx\0.żyݐw{|asTE.wO޾6-p8^v#V\r7N+>K̾k@WX\\d{Y\\Oevh?m7tm80lON}c>|ZVNꅷέcìv@WRIkt}:@dV :W]h[ח͹cr\n)!tiI+&̑\"|Cox(pfuNVR\n\0x槎9873ǣʀV!ȇB2l\rG6Y+(u5AE?wv9\\llwXxDM>㼂FH?3)Έ	}+[or:w?Ȯ)\0'DNH鸘/Sþ@<3x# yND.?2m,p\0O&?h>\r\\	w,=hG'E#H_߷ʤܡjz\\%pKέ&i|Zk}]5!5T{](7Or/>.&0c>>Z.9\0>+@)T _O5!t4pk\"忞x]Zt\0<@c?/}N4ApC<NWZ\05ь)^HN}oP\\p6O.#o!T!\$K*nPqr'\0VNEhF#xM}~GsPE*#A̄(F/!gMogɩ(yb~|3a@'ޤƟk3y'z<,,\${jvļ)\nq\0zA=	[٠=)sMm\0X?\"\"\0=VpJqkދ뽶ox.c6.cmö<d!7B\\ޓh2瓨\r<BHE&+.P	,)0==2-#'=3x1Xf󺌤3°@\$菩wJ3@_<\092!,9r3 ]R̫A%#\\2'?vbB\nL/!@s%DA&\$WE	zH`+CPP%_,3\0s@ ۛ!>`s64)3BքX@Bha{8 	gA\r=}P\"lA@TAAz?\0@͆/v[hys@	@ۃ2 @A(?\05bxxn&ƍ7Jky\$	4L#B@yEc\\Z7X9p<#9t!OtJ0M+YkLX:y.[@ئZ;#>o8H`MP#3\n8=݅`z{\nRwLe2(!	'	\0L)䜘'mokB c`jaҞ}P,-|Pf-(5I&|0C%~)F3,̡ԉJ8⁐\r\rX⳦*Lݛ@.D\$\$6/fمv\n*`s\\|>H1D-ggjyRp\n/Bt1&4;}1ݐ'..CGjCd0C2<>\"14C 	ɏ2C0(\r*0(RJ\n\0d(0;`;>ub\r)TǨIap(3\rB1CDC('aIJ@Rq|EDaB2Do2()Xjpyha%QA1CTJ'<APx-2@\$|JDNM)视JħTFc5c\rD<.C#G*3ć\r.#CN<[q83\rIpD\$QD}@3V0Bn'EP\0Q\rUQBnU%RQ0H0D;\$4O>gQC)RqS`0S5<B|OHŏ\r E_YMEDӨ%0`\0F#[\rp>hAxx59p=`7+Z,xB\")0x(bn?+],?&Sa@3^,	A%ACz'a&\\!`*c\$a8C1Zӌ`@\"dцn	F\0:~!a \0x(q˰r(iFLR\0lf	\rtlF5\0Cq.{,\0Olnm?ѽ|iFm1+X8|qn=!jF!15	4w&[QրODaeGotu04gB+F8\nQWl7)SQG\$qƱ[\0/ƻl}qѺG!k 7ƷAGGjQGL}q\"~QG\$nG{Hk	́qH tkQ ~G܃RI\rwB\$N4c0-\r7b{xȡ	\0Z	RF50\r2!FN\niaMGdqCf4{#y!TF#_:Ӑ25>C\\cWD\"FD(x7qÊ\rkx7#_Dfjp&Ɩ1]`)\0۲DH\n!\0`	*p\$8RI6	 (\0?x\n*Db4D,!Qᅜ:d`+2K a\0Md%><5&\"@\n\0H0%Ɋ3AR\$| <f> +PL5Ɲ&@\00ƻ'Kmok>H\"lj8K}#_ 2?|cB~X\ni6I\n܏= \"ɽ(ir&3OI R>,\0(vJ@LO҇z\rl)A2p+a )LmZL,(,B\$A\0!2D0Ir+zl8pAR&8̅ȼX?]^re%Z+Mc\$Ɋ|J+(һT[Q £_lE^ \01\0,+\n\0&00\nLƣ1hɒ;k\"n-\0;T::Z;cKa[R\r CI1u%ȕ%{)\r<K <%hrDK %\0(h譀4Ҫƨ[Q(?BW8, K,2@&\0R>rm>Hw#^2I\"mV1Cr(`\\̌:FeTHhT=@64/K,q\"&X+1ҝe[٠>q0(C\$1\\m:%j\0.\0002\00>.1@++\"2j@܅I23ٓ 1NL\r`\nȼj\$0H7jlҲ/U\"@;[; K2`&3`U҂׌T!{(c.`>>ˢ[%9+m!)H%\0J4Pɒ2dʯR33tHɇMJ&>ۈ\r*P`.H\0@ I+4hI5Xe6ԓ`Y5T@6MZAɤli: fϗx`('Nv^g 63;.e0d'`TԿ3/\nK7x#(),!7!7M\"4݈1\$y6%x7>N%8߀),lX6I8z@!,&\\HQBL\"\$+8\$+A8sNlӜvQܓ6\nA\n7f<c&̰n@7PhzNh2Hn5:o;:ĿS~0H6l%x9s>A%,t>\0005BQ%oND3'n3\$Pzm.m8 9DAA;8\rƀ<\09g.kd^ƂB	PdF`@ڬ?+TkF0Ճke02Ck)S/aU68Fkjm`'h[-=E˘Ȥֻ)2Xd.+փn\n¼\r65ۀ(ZR[/|2/c*̠Sa(d8(9m`*0a(&>ܹ@MtoF<_Fc4KDR4\r)09,R!BK&:0#\$+#ah\\H,9\0[30#\0O2j2'Ψʐ D+Bt-l	+9+ӑD3\0A3{[҆]:X82Ă%R-FSyX8	&-	`KZk5by͟&rqD저Ʉ6OMx 3C;;يX'U/>,<A>,g\$Rro\0Y c:T\0TcI5\$iM=gAW%G\09(\nM	MpW<Bfz%|٨?4Q?M6QC!v:5^79\"\0\r}G_4hTܭM	P2-m	^f )\nLn\0+Ь:*|AR\0'\rdj\0@t)d\nJ|@@pdPc4(!\$`f5ASMc%|ԞO-IٳMI١M*:tfҨ\"9R0+Ȯ`ɜ#ɯL	5P5tK O Y;SN\0@\\kL~D3oJDt3Lu\r\\!FTdeDF]I`4@0Htp2'HEk,D!ֆMBnM\$D\n4MA=bW.la,K88MQj݄/H\0a7TIM~e84OS?8NBÔSN0?TӜ)->:SN=!O0	H<8TO\"!T\0>T!O`u+-@4t<T\rP̑P=Du\0PK8SQD7ɹ'cX\rFK9Gl\nQTR9R\$Ԉ4 `\r.R`\\'0	RRO/D	P\nB6+310TT\nA0%Hɕ7g24 D[r5R%: 2jhGS\$gmQ\0AR TFYArB@wH@^\$jy/R\0'`l[	VI:7),Z''BŠ`#BX\\KLFBH.\rq?0`QIm\rx^tMkDvavTEѰpʔOLHaP4 Q̙ѫ ~I_Of46\n\0\0 XEBCfTPDC\0@bX	b0dD6k,40(oUbqY6di\nU<P(<]T\$?h\n`Ïz8HY\n:DD\0(b*\n`\\\$ \n` X	՟\08=\0`x <>\r7ʪEA1I+`:mchRPgYDCYdCQg'\r&hE:KD*\0vȑ\0M?H(¬bO(}Uc=YdUVJ=\rqJGY~6y#U[qBչ[i1oucY%pQ!Ex_]rQx]AH5,bpD]uc ^Uen\ncuWX#4lu@_q5}\\_5~_R%_\0006XrkdamX,w\r#`x(\"i<	!Ѷ:0\r<9\"`'aUT\$eDX_a,\0<XiagYa`3R\rvXB+\rTmXhiYanXOb(fV*axnXh0\0c@\0;شhP7bx=XaPڃc~	c56:X:3hedOX^<VLNUdIT0\0ODX\0\0mv7 iQbXiD\rvD!>ZCZXhy(RGTUYzbR4\$ՆjܻZ>dՔ6,K  )5YG/e,Z]ٮP%C\"6oG~-\r<+s·jYe@1YdM!E@r\0Z\\\0<Yg͟v{!&e1Yӈ:lYcAV5f՛rԸpY6GAhvEWYhZ5i0[VmGiIU7Hl\0[qٳi=9ZUf;ӥ\0Ŏ֐qfŤu٨kc Z,,VZSfhvjKC ~+-MZ[gLvV\$]j֮g=67.n7<r+t*X}bmZPvc}Zk5+q8D[j!Z8aiZm`Gs@m	ٵkaY&3+;aa#G0\nE[Oa|A!a[`VTA[r\nՎK{m9N\$ݸv߀6\0n冖۔iv٧g\r֔Z&}Y%dڃlYrM;.vZ=g[@!\rKQݽ6̍V\$o(j>paT\roXV]v[mmp6RFZ٭p\0\r\\)\0P\nȬր\\AqY6h`\\1q\r@C!\r0o\080P;@B\\:mVpxb+yq%W\\xm͏r\nL@:\\irpkMG\$l2m`Zk>iW!\\?%ʀܭjT}RܿqlvW(eBq&m)[h7r?K[Wxw\\Wq]\0XoI1p-8hMMYEP\\%o`	!m{ _v_YX%U\r>\r͛Vw[X䣄 v2UqxDH*uu@,m\$\\I`,6Edt0搏\\[vطl.vM]#Џ1mEWdX/v\n!ޖ`S\0[dbs݅v%w]vsftrG\0003#ڃ]g]^&xxW;hdCv 63v4x9M\"Ә7c䷘;yՕw\0y7فy5w	%imޔ閩ݤ=HB^z:a=ez,׮z90	x%ר^EzXxCW٩x-WZuj!jEX{e{tضV_{	\\|u^7oUi'{*HXy9!\0;Xu >Ur\${1dh>v#`/~U}{J-\rQ_!5-9cHhX@l21X܏>O\0\0,Pf\n`\\\"*G>\nW\0VbVj	]\ne\$d%\r_3r:Pjm\00	#*#8퀚\0ڎ\r`m)_\nZxH,71MP\0	g:\\?C@\"쥘+&>I\09i**DJe(x@xVd@zG`ʦf\r_̀@6كQ.\r`ۃ*΅\$G2X1\r`7ڵ`F\0\$L?v`*QWZ*MCZF\0,a5\0Q,x:`уVxC`2`#A0G\\A?!`@\n``h)`Հ7h?M4.TE\nx@0xr\n)\\`}X\"6	\0?=I_-\rO@na`Hj\rw\0M*x	(.\nvW໅6!0 \nN\n)*w\n؏CDx˅0@Zb:EZk^VZMU<CV?W`jF	I#\0ؕXⷁXT%*b\0x\"Ub\r࿉.Xe\0Vj\rV/xJJbػo,b8b}^(?J	2x\rbv@\0Ώ?Rj`>j*cAXjD_>6xkC\"=#j>kCˋT/K??Ң8Х%Y; %?pꀧ:a.-\nHSc]\0*Цf3\0)coxxyV>\0V *?щ?0\nI&4& 7]&AN'*ܙ?6Kd*Mx-c׍=dA?`ŏ@\n\r.?Aġ,)8X#\0 	\np#j>\0&еa>*6*Ʒ\"@ \0X=	y\0d\r\$dǎ> 3L\$c\n:cY8H>Ad]gx`œNdk]#L菻:6uG}t\nePdtzܨj *dZ5i\nߋ>XɅˈ99F?Ux,7GTH^9偪YUJye_[&W6\$!9AmW4=	WgbFXarᅂ*O+峇4y<eFAe^,XI>TeZ=ko6Q9]jX\ne?=eߒJyzd6J(A6쭑>y|e/c?9f#~ac9|7\0`	ʃe?~\0X%ޔZ9Gf%^Fc?v)%~9Nd0ՏkIW>e?9+Ǝ&%GMX/\n[aÅ6XYE&@jJ̈́7%⟘Fҏ	n~y*0jRe\ny%h*>SFWb\n ⍃J*e\n.->kHVhgJ8XdCh\n X	\0Ar7eV\rYd^2BPV{N1d\n\"'?Umny)g\0h>rی*¥Ys kY\$	>n➩JBJ?v|%g0V?WA\ngz-X``ȑk@\"f	R9xXL@*\00d'78h<%X/\$?n7CF6Zi\$nbhO(0Fj\0Ҡld6z`?*\nVR#2>IjcdHmesxH>DU倶*جfYa#Ù8Yh樒z7~v?8\0ރT%?&Auō.-\0\$i	ZCΎGL\0\0^J`yx\$chL-LW/9\$ ?FYg[/p#\\Pi&\neE \n>s##mG'GGA诏Ɗ\"S같>8+\0I5঩n)i.LNzLݧƞpR-^JJVh`Ҥ}FK)*if4bzf\n+\$F*&i-ÜZa2xh*[/`ۣᔤLi|\"#kb9JhN\n~8	?g˝F'ؖ7\nY*6K\n֭(6_rb*	IZYZꚪfvy1j#H!fbNCF*LnCc2AUdAXb_]b]h`	\06Rԍ2Kraz'<rkKvqz9Z\r^MB`ZAy,QrRksQ8ej(69ey.8CK/\0?kk?U8l?詉ʈ8/䫓\n\rsM-EZJe?fhXL7楘e\$\"*g]thXhZ\0r-VH8Ǡh,çv)dh`A>P>\$1	\n\$o7, Si9p:1 eb<ܡ8L j\\gT-fkPa@xT+eKұLIkR;0Ϙ\rSLȷK\rɀɬ]x*6ճM!%Q>[>l~nI7ϳ!ClE\0Ttd!UG{R\0ڷp*VV}҇\$Ʌ<2&څaA\0\nZsTl\0< ?d\n`+8ɮD㇀Zg*jf\"`]VhkUfrja>:{og;m1^\\#Ŋ+ V`mZmӷ){{m۩.6|{v_mY0S:98U)y& v,s,@\04-ɛ\"^Mn+-{59ʓK;&@ҳJt\rD>oV+\0Nn[*HD\\CP\"Q(%۪	)&	 /նfO\$ځW,Q, OP!ەb1̘φHAF*t\nMHsbAj)kMR1FDK:\r^ʔl12fItlYIc+)U%:S]%1g\$5%|_>#S#\$2Lk&4A&A	 !&LI`*ɣ+`,VM!}C\\xGe˾\$;0k(cHlۀٿtԺJ;36Q܉;v 3l1IE\r\$%	_@.PB\\8=u<P#ﵻ(?U\"6=D\"Ny]0\rQɎ=HD`c0,\0ݟ2T[0k}W3oӳ\r?v̐_T	%{=Ap/__pJ|*%\"?3o\r\0002/\0`>p9*}ǔ		ZHk[ˆ\\+Cp6\ri0|sJe-zN)-Y=9h68nQZ)^<T\0F8q\\GY\rJ@\r#bᅊLK7)6sqn6(Ht gAG(cgA`\nTu_\\˼u+#e`=.~⻭L8;sv^R\rɅ!XfN䪻=h6\0ȈO]-bB?S Tܲ!߅%anIr`%]ӹĘI@:gQʊ'186R]ؖ6Ox\$j.Qx|6/X=rtkRz;MplW*یE |AqO\n5<	#8pF30Pgm+]%,UUq8&,g,;o*h7gQ@47H1QGvMZ.;qqh3R̶@9(bB0帨C@%㞡Tp)IJa!*mU7t4GfLJ\rHMI9)hHO9^}H`ɳn9SgkW*WFW* \\2sǳ(sϱ7|Ʌ/=>i\$n=s	_<79st)yWG@Jt]!'A=_A/>@1Brз@t9Ѕ!W̨dP}aEm=ERO&51qT= `_Һ	WTU\"׽~(jN\"E#uVBMn>;ҶB]o|/cZq[tһZ҇2=3rƄ4,m!=_g3*5AO DQ,r#8*lfER7SAI!AJ<f2.NJ@BgU{A\$ԯT R)0s_v@\r|\0xJ`9\02[ٔu'PA&M{ 	<R]+wՖE?q}=`1ك\" 7^#]1F5sHmאF-9׿Ptg\\{m__}c1:\\׷XG^U!DaXv}= Nؒr׿aoOW0tCy'^k%-]=1\\!~!J:OOyWd5Ӹ\"U\n7R=Lu'WW&;t~S\0b0凁JY\0006m22G X@U(Zom .l-xnFU_\nmv\"lcp+x=5feR뢰vme)^-9BUbI6lq/Mj1K=Y[pp@o70iSVTva`8lh\nl<,+M}U7sWI_\$V\\;nܙyMqEq&q^=ՄKP=eܙ\n`	||{	kHv#2Zٞ7~8`=?luhaV	5z&U^nYX\$qRqMjw\rv!U#'Uva?q]ǀ\"1TeTGz\\f#1;ufNA6F7Wt-ce1Ogs|Q]+N}sޣZ]U^)7qo84c}Uxޢ6jOWoUT|mBǎ\r|Ex6'VxU\$t<} \r/I,l~,z><Kw^LsU(>a.d\rmhePyn>d\0003^<9)wmwIX7\\{&\0\r2C\0T<D'q2IMNo%)\"y&466-1U8,5B)mQhyS[K9'`xGrZ!MWm8yT\\ejqy,9=]NO3_qM\nrk{tw&y*f3qT57Ɵ3IUm/Eg)݂I64a@62K(߯{NMQG1=1]^;8h޲uۿTZ\"z4þ(y(y|&\n5:˫uObw?97R|,kk~[\r/K.7ecMFiu`U9?Mqotx]Kyw?}u'\0,	CBp=ϘM@d|Zqǹ<}P+|	\$w4Ġ43L\$bw_*KIz?~IzO+qkx{\n\rGw{LKU~IٱO`E%wR !_ʂu/KS,k}@u}1	x}M8\ruS|o4e(b%n\rZ|94t([R\n\0|dHMU|=nY2=|_W?q6W˗\"pG_\"Aӷx%4_q3GE4絪o^gH~L_6v2ݗ\0К6}>u ơFS٥䉀ϴv}1Kiv8LɤkK!X|E|{ΟlѲ 5U^WE;&xlúD\nvR\ry]9ϲ=Ǝ}!K_ڍwb<v~|Du}~oпt J>ٿcv14TПq#>x\"z\r=]Y|Wmx5l}+ͥ}\rwiqi7 0|{vwߓ~Aּa&XƂJ}%x_0twL4JS fCug\"}KO wxrt?J\0P+t!.;F'}%f?X]b>ʱ6Q[P3Hpg/߼a 53Ƀޠ{oh;t'ɟK{?=pGLҽ12e|`;bLIВ?wGl4M=}#4I7Dwݿv8\n!,X%6_\\PՔcu/߿Ytg(H Z/g{m(%+ӷh&ͦ#P%w	qôweFS2i`ڈ-`;L»WEt?\nJ,/1'uS<Jvz;g 	k`a7Yk5^;_\0005bX/^j<ΨL;VhgTI.\n6(hP]ruHɼhU	r \"|@>(@\"!0!`% Ra*Ϭ\0iECErEnHPɔ:VDhI2x\n'܊n@կc&u\rem(i+DX\$TH\n0P_#(#s/#!]bOID'Pty\n4m*D^DU@`\r\$}DQ}@&\r%}bxT@:7W,1R@w]@ P13D\$0GL\rSkl#\0_l'e(ìXz>&T<c|\"p?/YN `+EłO-jbyD6[)Qxj0]qs\"S@ĠA]>FŲ0J@ݬ%hg\$ o.xUͯo\0A0\\X	 H,Z	(+4W]olqd%i3A>[4\nK\"KH[\$c4@遭\\\rӠn@\0\0eQj\0k7Y8\$th\0Pԑbg\0;č?,>HpY\"EaFrxPo)\r-2ub0apSIX.\0OP&S}ঠy9*Jҋg/z**CV_~6vm,-Ȁ?`\rl17deX0,bWk+ٸfZ8 m^[m4ـ1j&QZ:euc8<lmX̶iHH)Mq+W\$hce`GѪ/\0Є۹*CR`!&5`U>2M\"XBLBcBR:P~3Gi[DCCBch Q8EL?dV#fdn!08WEHLڴedxј\\RM052?eѽC!8JZ7PhX[:=`@#lv\\%Mz1eI2܌.2c	aD!M\n\nɄǺ!Np 6Z+[V!gz{CB0)3'Nlg'&B(>21&f'6Pp0jՐ,X-fc	f\$%!04&T+hM!W2	_A\"N1dAu'DPXbLّs?<P\0\0R\nKZfDadTbS01dU\nHLn\rhJ%~2PZg*!dɒkG/r4jVH[U6RڝÃ(Ƴ즙l7&SE41fTMތ5a\\`{Bbh΅Z3AZ0ɘc2RFp[ 7݆xE>CCz?v @-l`Oo3-\$<zlTh̠Jn67h\\4ۈ*n.΀(gU@{&!6+n]%`\\If[(Az\na\0j5ov&\nx *Lު8:fI?j2\$(=&oD+}F-]Oē\$M\n\0;9IwAy&`G[ܙCv4'ђsuhvD\$bo(y\0g K`jIƙ|\r\\*ĩ*ۿoMcR!Uc<`\r=sct7. @TN'Ҵbl@f\")=a8PpqaO3[bHW8[c:\$	HǏx9*p/1Oh'#ܱ)h~BfpC)i`(A}\0A	u5IFM\0'J\nvT[(!\0J\\@*q8O:s5<ܤل\$sl}RFn\$GTE\09<<q\"g9:l-K8iFB\$kU\$\\#\nS݄BHmEe.<a. &\\r6}\$z8)(XK.\\OIrl%˔4OF\ri\0b`pr6T11\\Ih1_Uqx'2\"l}IѴNO\"p\rp!TDK.QIm9NSaqo\0Xe%!\\l-uv^S:9IehN<[/e~ΥҿJnkA>\r'X	ʇmECKyޗ*|	(@N\$ilRo)lSH6^,R~\\SئqPኅ(.DIsyx!SYH^UWXv;PtUc\0⮆c*UZEe\0p-6 #T\"mT_;\rqܰ+WGB7;\$BBz(b8X,WK7=D%Yo8;rIVΣ	(iXX-\$Z?\0A8TTJRQhp6P\\⤓f\r@,=mNoy\". αÆku|=g1t{]KJ]HP;Ňiճ`s1Rb:MHH{Ob:\\ؼQ\$\\\$\nvÿx]~*4_D0^knELT	1THH0achCG(߲0!	FYIx®?	{0bH!>0\\*Lt,	 G+Ș*G^1oFA{aˌXȐ_/sȠ]_V/P/.24dʏ_\r9Ō2%h-Ϡ>21EU>ZBh2d`+1Flu|I\rg*e|N#5|3ѧ(ς0F6)4ʲE>TTPc,K\$nY/<qR5'Qqk_=,gWh;[\0'I'x*&I5T{r̛qMS?M6p#:wdC\0Zʮ\"\"IDrĸѸ\nIK/{DMX\0( Na(i\0lipО?~#}^`Wp>tcM\r/2Lj.\07*X7>7Z^vdh D÷Jx[ïa\$v~l:4gX(¨CGsH0W/n1=3`rԔtPNn:(p[PƱB=Lq``ãYq=W3c@\nu60/@ہ4  gИut!oFɎ%60>^|*##iKcǏ.`N'k\0ӠρcGR̚.=+Pi~%ws;xQ5/u|<'ybq &1 &x'=ߏx:H3K@_n8	\"l|nTLJπepf%.q\\Z;D80\\=	\0Q.0HBUGMup_ Өd:\$.*vGow WhAfu:Nu\rV{'7+Ρ%GF\0ָJy9]8/pu dgoM	1 M;QRH7~	<HnnЏsvuU>َ2J^/E``\rzk^0HPwܲRB+x]F+f+8Pn 1uh\0qY]>yKD8'}/ۆ y\n(S1C1P\$\n>uLȋw(!HG<Jc\0005n<\0hSg\"(V>?\0\"E}ĎUHEd7\n^_8et:To#CCI#,j,|bw)ۏo#J;WKj/#eM\0Z\0`+C@upa2o9A)z\$ukQmH6Qpx&\"7.?\nTl?jx]ɲҐL%Q%!3dHr1g	bd5	jƣ'n\$2E5`Ed?m	'\0Sn|\nx>T}&db^4\\hڤFآMi)\0C\\nPW|ZK@\rYͪ7g#c`HP]Lhp>@#%:xS}Iw`]]\02t(2Gv~sγH*tk-#ݒLyI,.ܑIYP2+	ݷBUorBsif]nItz{i7H\$ڽMQܳҨdt&GRQ'!Hj 8+#v-U\"p&[oP/\"W	/P\0		+t&;nB1Von	=0'IPNԞRw@0WQ:)p{yUūE\nu#XO}2T(RtdCђFp}@(QJ#%(},K+\"t\"R'FR\0d4w\$MbFD0,)0XҏXГtX9J20,Erd)EKKWA^RQ	]d\$RBJ/G\n9LP?Jq~E)B5# \\Q\nQ)F1d%:Jx~PO d\n~cuB6e0[}[VD_ᄬ*Saci\rT#[!y<d͑FUжkdV4K90q%<VHKLJDc\ri1IJw+aљ+	 l*eg1	hP݈Q&!,ؓc+X?DlB؆ƅ:rVWJ` RKr4G8U-V*Ef^.:	!{#24vi\nYA;[XhlCfB¬iM#.\\v4dзY&X29k,JleWiuM]!)Ӝ4ƟI܇h\$[ACJ9mC-*8}KMEY]j*Z+%VmHBTK=zd`K-1[6ŸڸjnI>}abR֎e5b@?OYcөSK:jYa+VR:l&YJhZͰqL&-Tc5LTUr.ǥ7nB	d\\r+JԤ|\$dHDnW˯S`+K%	/7R66>wn@=7F[,#.y3ϱϣCopjŲd2@o6\ry\"R\$} wݘč*E2l)Ħo]&8J*Fj\\uʩ%I'fO>ciyh'iKGJs@FTv8S\n7,M&qgh3\n\$@NFσDNc0 =Qq▂rT?}PJcuDzUܴ#xNXš_?neqPaS3&\n4M!J:r9]T#qHnۥY^cknVFI,]WMD'Wr#d/v&2vװiRI}V!)}D&\0*N`:F<-`,C\n4@'(2.r2^Ҕ8f&@w@W\\˔O2J)(S\$|>.qW\0@9%8<`M0M\0b\0p\$}\09\0p\097\0003\0nC}lS \r@\0006\0π:3gH:\00034IS=~	3hٞS;f|L8r\0 xL\0q3ٜ\r6\0a3h =4gҙIf\0ϙI\0o4*ggsMf34i =t9]4g B&MD39:@L4p9=&L35|iA`5Jk<i?fM75zky3\\\0001\0m5hUvM5G\00055i`	7'&5 I;\0\0005	4~h4YNfLs3kID&M6q3kI \r	\0c\0i,ׄmM{)5Fm IL4~hilM\0b\0k	F&r6fgɜ3?&8c3jɧg|\0n\\S=\00065k9s`\0\0	\$s`M\07fa=4=4jjTЂSuf\00044 	\r976g<{\0004\0m6nlIAfw\r7iؙt&P6n٥SF&M##76iɤEwN28s8Fqn'	}5nIPfM)5o4։t5lL≤\rfqM\0a3hI3f@M=4j)WgNle4ts\"3sĳf&N\04Rp y3vf\0c8Fpމʓ@&tO95*rT٦SRgL8tT	SK@NNG4pYC)MӜ3jܩfΉ\r6t	='Lq7liγgfM3s4)3~&NP8:k,}'ON)4tsyfr)S&|M?K96r	sg40u6rD	M'}6pVٝ9lY NS9kD	󖦓\00003sىf·y4xfM!7bsTiZf8~ml93Mn<kӫ&[;VkL˓E!:L:yyS]NMԚv\nw|ٴSj7oʓ'!7p93A<fp٩ӯgbNnpk)ӿ6&wgd&Ε9jgtsFND35.{ѹMF6\"ptӭg\0-/:|<9fN>h	N&[=w<魳gwOC=kySR&My=&z9S@=^lDӀ?Nh?>qy3b&͢9h,ysϒ!9~viÙsCd9u9sfc=vO=q6syS&;^u&䚣9lL'M\$6fp4깱ӝ'|γ6iӉ3LpW3vls?g΂9gM}:Miͦϰ_4n~e_4o9Ӷ'Ί7l|sγ4Zjt홢&΃9k	\0003	MCK<6ifϠ?nBnL?p,Yˏ(PIU7ZidsͧmNܛ=mtω5Ls3㙳O7=n=N6jٹ:TDçJ]7i<	ǳ&N~<?\ng	No?iS^gNw=gYϳfO<>h䩰~P@wi&|M3y߉T&M\$@BvTՓw&NӛB\"x4SgP75o\r3:'ڠA\\I3CB	5'PA\0>j}m3Mڙ4\04{yh\$MH590fٚ;h,ZSh}M+6fi\rT=&WC<{9T'g\$L:\$IۓfNBz9!0SM#;~x։shQ\nC.sUK(3L훪7jn@M8pTmK]4	\$41h7g16Ruy3fv^_<*5\$4N9jgS͒eCn\\\"c=9sSPa3i\$ӳF>пDڹtP!E@&i	T`fх5**HN˚?=2s׹3O>JniM5>rj4zx3Mi'Mb:h=\0I44/;d	,+NF%t-о5|=Te(No3\n=62!h؏ܿ}	m!3ʃϸ+68,W5Ug,+vXз\nGSa2~1\045CBͷ#CfԆArG`+\"A&Lh!eJp\0:_+ݣ\$:FpZT\ndl7{@!fH0CdTCH\$\0`X9\$I	)FԖz\r)Ie\n`a(˅m{Li33j:Q[92r`\nE#x94;0#jIؑqn/ղ(p#D\n~1UN\\emI0F0ci?\nЙ\$vr#G3k4W8D?]*SA1j[!CejHZof|@!x9I*X;ayR	e7v^`֡z*\"bH`0jܐPph0 gΕoC2ϩrOJJ+\$6xll[vZ\rh́=%gHsK\$Ƒh<\0~\"-/،<bK-Ji38\0W-,0FuU\0L\\:CTY1e&~\06` cEt3f1Kl͛lNy+^b(VZK/I*RLJS*b(8/VrDs]cndL0XSkhtRҚ5Tۊp`jʐ7MHh?vxtX cH36*WtٺA\0Vʆ;ٷ?`*g\"HAbPs6<x]DU\0J{1?p5RM\0^<p0)\r=3D\n+]Z)uzxҮr3f>!9OXC4},dݜT)2-wS,\\yYX]M	̍BMai0&\n*`	iSMdL7*}m0BxӸ?KiH@6Z	IaMO-XTxP\r%Mj	B\rPbeBf?M)8WD5\"\nWbLB?KRڨ\$JCV)Sgy+\nGfBPe<[B\0B(ӌK=9(YfE'a\nZugQC6boo6TNQ꟤\"ЖO(:,\$)n֕\"b)my*PjMo7\n\"\"Ou`UJm*;\\5GK#C]O%':)S{Bd=Tf#ꖰZTlQ/D*6)a;	KBZJ2T!jӆe\nZ09FڥB)\"ӅchӵN[U)Ҟޠjo\naTI8U\0D&%P(U\n}BiRhZj22 UP>A]U<h<iKTUAn\n5AWJGMZ5K&BjQQtUE6f&Xr%SӳTJT,:P5,j}ToU<2 Vxe}L )uUJȂ9:UV\nMVzAU#	TمEI:PjJ %RRRVW[,2(YRX*F*WU`Z]!³)VK;6TȞ&LJ*bʩJUU3j+VRt*օ˒XڈU~/j4%\$cCSB\n2Pʮcѩ&e\05]*CPWE]zDjV1[j>Y\r^:t!@fW\n0{k\0Bt}KSʽU^+R]`jO{`mXF!@SaP5b\\,hjv`\rQⰍVܕk*Ƣ!YiUuY:j]oU֤\nA\nYQYI?0*B(=XF`ZljTPWW¥}_:5{TXꐥ j!ԻT6`ZY| z,ӴVڬ56?n \r8D&gqC\0i.Β!Jؿ/#f}@\$֒WYSb\\.WVd%XhIV3#1%`	lvxL	s&kV7OORU%[MaZRUc\\%NZbfH!Hx/*HS4dZo\0\nm]QhUmӌcs[Zޔ	E3\0G8*Nս[ҏ\\/ \0FI\r̶h5[2뉴Y,R>cMe0g%Z+S>?\\=mQ5bcDzSqsu*πB@F5n6@!қBej*vj,]:u*\r,b+Y+Е]]5v2>pT#P%duI1dNEVr[O]uݪW]Mxeh^4gĔm UvłyLv ʱVڛ1Mi^2\"5RhǮ=-iU+ײ#kZB\r{hKkؖfƽ=LlkRf_4&.<ykTYT\$m`OVi_r3]iMzM`Na]VXirέ`D˘b6ũSS2LlJWmmDJ^Zv\0[e|mVbUh?,Q9ڻ\"h> 0V51ȰZSD4fK24ڛ1R9\nu)gN}2_JAxVliMH=X(Ip)\$D5p}2u0隀AbL֪I*\0	;bZ\n\n@Z8QAIYOãj.h6ٷKlE9^ň̞	X\$_rrXJUكVYo4\0N}*zk\0\n8\0]&ăJaknn4i}mMU6bUȤmʼD%D)]\r](pٱ^% 5DĊ+ƛIґXQ:(0jFU\0*TۙBQH&p3bv@SWh4b7X*QW](?/iU k2YkAdm2)As.l͒CQ?c))wThId]%-9DԧXaUOI\0VhתRSR+|劽CؕeL-9*,H+G*vݫYV',\\KS46becCk,4)2Vc[ΓYcc_ejzvTXXQiײ5z,	Sh\\V6ZB; 荪52ٔS*	p˅O\0*Jc9N\0I:e=5@ld\0d80 ,݁Ev=kMco29;+\n&N(-\"(\nACrc@ʪ\0\\MH\$3g|y]<aA+Fm1͞ \0c\0\0@\r\nB\0	  CP\0a(hɐ(||-ՠɡ6Hh\rhH@>\0mhjBUV-Z\0qhU@mZ.	%t@yhVM{@ǃkZ8]hmCvm Zh5F@\$͒h.0{ImZ'h5J-\$1hd֐0PWiNdKi}٬S4;5ӨN-di]IZyhfeNDiJmNAZ%ijԭ-<hlO\$Nj,PmjfQ-P#Xp]KU'ژwjkV=(µ;=\n[S&OGimVm#ZӴ<}MmYڵjBֵථhZKj-+X6f˴4=;^tj\ri6&ZyiY-&Zl]_hm;Ymi[#?]Psml\0?-ZkE{\\f^lnmY'lt=)Ֆέ)M5%)έt[>`yBٕi6ĭ\$Mmm6~Ecѭ_{li6-;l>;igO͵Iv_m^D;h6ڀ\\lem[1l}MVm[ime{_pۄn2-y=i,p6m\\3m[Z-	Mnfۅ[s6-KlIi\rU۳Z/i*Im[umrչv6-Lium\r[÷\roe;j[˷o.i-Joh{VͭTovލzvݷov0\r3JAMYoߍ9S_,co5=iw\0MQlw]rp4+q.	F+ofݼ;s\rʸ3otvn3o4Ыw-z'3}v:.\$[pmc,47Mao>tܫ7.:3\r8	-q,Ӌ-͙q2s?n*R77.Lqr4{7.3b4~Mk	Nq\\ԫ.qk3`>z6-JIpj`K(\\r>PK}&g\\oͬk'-x[<\nkg7*:(¸mr+37S\\WnRva[hi]crFg3Th\\s6~-KHrn;(n\\&rF͋:@\\șs''\\CpU6&\\asU[?.ys9pK0>~P蹅t -Чi`ql<.ܣ-7qAndM]Cr;.l\\Vktg\rOH^kri%ۣ''A\\u+S7Ls4\n˛8uN]kw.nF]Shǔ.PTyBm	{3n.C(yB{uE~\\ںr\nYnYܮu]婔?.EP{w`Mv5fG.̻%u}٣']avjhŠ=2=Yʕ+bY\$lm*Vh\$I\0YXF!9j0*aR=|	A@\$MdYƱL32`Ʋ,3JІ0Se]bڬ<cXdXnbڜ<\0	_w`J\\XVj*ZP5V(Yg	M+I%aRڬKZyLk*g[px7Ubjc2GΣcGzYc3kQmZtT%hB.?A6LN\"ZUi\rByaxمMN`%gIGU0+wqo#0ewBe*Wukp.FrOv΅ZlSOj7X8^\nFT	KYҨa{7/\ncV%oR~XeTɻS)tLT?+\r)T-[]{\$GPZuMWݩ1zv]>jWjT4mx{5ko]]zZWmMKx\"ǅ0j^?#TUKɗqHՂwm,A\\zEBVW[^-{ SlnX*iټ\n,-QjUVԪrLB;]ZH]*ѫY=zteԆR\"uGo^gpz`i_LûM*^k/Nu8[ÉSy9sT1ej]\\=t2SOJˉ+.\rtHo(K?&D.%u_dGP&dׁpCz%j`x̠Z%ΰ/=1D7הonΡɸ|4_xs\r\"HnSlxWJ9\"QC!~'Wz҅s	C@7d:S	\\\n_D[\$ybRHMJX``1]Fg j=I}\\1P0C=߾0QOn+3&TwUե:L6w[uvN#d\rֆ=5w1s<1P}\n-cxJO+DxR3\0!8k#[@UHߠS<@(|7z/7crֲwoVc	\\ۀ&2;p\"\$:&\\^=Cbh+A'l`Tр\0Pn\0`cm1%nـ*|_lx6Rn85x_b=#5ׄciv|0=<w68%ӏև>G&K[V646k@֧r3{QWܝ`ӂ~@3:\nE6q|:\0aE\rwT4T20b`*0`2~\\GP<eH`ډL|l=0&5oEP6o	\0L\0o\"v10`L6(FnW=9\$X7Tq (0.;\\I<Q<d~ru(ndo8(d%ƿ\\6+	 !JG\n4м\0XN;	IL9i(HLs\0G09:^\rXbvxky/bF	8YaXX%eScdbaqG`ZTN\n}X\\pN`f|D'0l갰qɛuIR@faau\0?3a1;	\r!>3jNnkWCDp~c\rNo\"ƹ2]Iv;%*VN̿Z\r`/5\$ào\\99A\n`{:ˀv@\\:X`ְFϲK,=J	\0L~TuRSRxTEO/V(0f!\n0)6oDWŉ{)P8ˇd8V4t 9a|XYсPP:LEg\"@L?]hg=lW/L0\$h@܈W찼\0s;zF CM\0SLmI%%B@2I8H'oQL\nhi#8@ZUG~%DR|!)P*CA@\rj]w+n*@ÐkIa(ap܉/U8");}elseif($_GET["file"]=="logo.png"){header("Content-Type: image/png");echo"PNG\r\n\n\0\0\0\rIHDR\0\0\09\0\0\09\0\0\0~6\0\0\0000PLTE\0\0\0+NvYtssuIJ/.C\0\0\0tRNS\0@f\0\0\0	pHYs\0\0\0\0\0\0\0IDAT8ՔN@El϶p6G.\$=>	w5r}z7>P#\$Kj7ݶ?4mt&~3!00^Af0\",*4oEX(*Y	6	PcOW܊mr0~/L\rXj#mjC]Gm\0}ߑuA9X\n8VY+D#iqnKQ8J1Q6Y0`PbQ\\h~>:pSɀGEQ=I{*327\neLB~/R(\$) HQni6J	<-.wɪjVmm?SHvƩ\0^q)]U92,;Ǎ'p!X˃LD.tæ/wR	wdr2Ƥ4[=E5S+c\0\0\0\0IENDB`";}exit;}if($_GET["script"]=="version"){$p=get_temp_dir()."/adminer.version";@unlink($p);$r=file_open_lock($p);if($r)file_write_unlock($r,serialize(array("signature"=>$_POST["signature"],"version"=>$_POST["version"])));exit;}if(!$_SERVER["REQUEST_URI"])$_SERVER["REQUEST_URI"]=$_SERVER["ORIG_PATH_INFO"];if(!strpos($_SERVER["REQUEST_URI"],'?')&&$_SERVER["QUERY_STRING"]!="")$_SERVER["REQUEST_URI"].="?$_SERVER[QUERY_STRING]";if($_SERVER["HTTP_X_FORWARDED_PREFIX"])$_SERVER["REQUEST_URI"]=$_SERVER["HTTP_X_FORWARDED_PREFIX"].$_SERVER["REQUEST_URI"];define('Adminer\HTTPS',($_SERVER["HTTPS"]&&strcasecmp($_SERVER["HTTPS"],"off"))||ini_bool("session.cookie_secure"));@ini_set("session.use_trans_sid",'0');if(!defined("SID")){session_cache_limiter("");session_name("adminer_sid");session_set_cookie_params(0,preg_replace('~\?.*~','',$_SERVER["REQUEST_URI"]),"",HTTPS,true);session_start();}remove_slashes(array(&$_GET,&$_POST,&$_COOKIE),$Yc);if(function_exists("get_magic_quotes_runtime")&&get_magic_quotes_runtime())set_magic_quotes_runtime(false);@set_time_limit(0);@ini_set("precision",'15');function
lang($v,$wf=null){if(is_string($v)){$xg=array_search($v,get_translations("en"));if($xg!==false)$v=$xg;}$wa=func_get_args();$wa[0]=Lang::$Li[$v]?:$v;return
call_user_func_array('Adminer\lang_format',$wa);}function
lang_format($Ki,$wf=null){if(is_array($Ki)){$xg=($wf==1?0:(LANG=='cs'||LANG=='sk'?($wf&&$wf<5?1:2):(LANG=='fr'?(!$wf?0:1):(LANG=='pl'?($wf%10>1&&$wf%10<5&&$wf/10%10!=1?1:2):(LANG=='sl'?($wf%100==1?0:($wf%100==2?1:($wf%100==3||$wf%100==4?2:3))):(LANG=='lt'?($wf%10==1&&$wf%100!=11?0:($wf%10>1&&$wf/10%10!=1?1:2)):(LANG=='lv'?($wf%10==1&&$wf%100!=11?0:($wf?1:2)):(in_array(LANG,array('bs','ru','sr','uk'))?($wf%10==1&&$wf%100!=11?0:($wf%10>1&&$wf%10<5&&$wf/10%10!=1?1:2)):1))))))));$Ki=$Ki[$xg];}$Ki=str_replace("'",'’',$Ki);$wa=func_get_args();array_shift($wa);$kd=str_replace("%d","%s",$Ki);if($kd!=$Ki)$wa[0]=format_number($wf);return
vsprintf($kd,$wa);}function
langs(){return
array('en'=>'English','ar'=>'العربية','bg'=>'Български','bn'=>'বাংলা','bs'=>'Bosanski','ca'=>'Català','cs'=>'Čeština','da'=>'Dansk','de'=>'Deutsch','el'=>'Ελληνικά','es'=>'Español','et'=>'Eesti','fa'=>'فارسی','fi'=>'Suomi','fr'=>'Français','gl'=>'Galego','he'=>'עברית','hu'=>'Magyar','id'=>'Bahasa Indonesia','it'=>'Italiano','ja'=>'日本語','ka'=>'ქართული','ko'=>'한국어','lt'=>'Lietuvių','lv'=>'Latviešu','ms'=>'Bahasa Melayu','nl'=>'Nederlands','no'=>'Norsk','pl'=>'Polski','pt'=>'Português','pt-br'=>'Português (Brazil)','ro'=>'Limba Română','ru'=>'Русский','sk'=>'Slovenčina','sl'=>'Slovenski','sr'=>'Српски','sv'=>'Svenska','ta'=>'த‌மிழ்','th'=>'ภาษาไทย','tr'=>'Türkçe','uk'=>'Українська','uz'=>'Oʻzbekcha','vi'=>'Tiếng Việt','zh'=>'简体中文','zh-tw'=>'繁體中文',);}function
switch_lang(){echo"<form action='' method='post'>\n<div id='lang'>","<label>".lang(19).": ".html_select("lang",langs(),LANG,"this.form.submit();")."</label>"," <input type='submit' value='".lang(20)."' class='hidden'>\n",input_token(),"</div>\n</form>\n";}if(isset($_POST["lang"])&&verify_token()){cookie("adminer_lang",$_POST["lang"]);$_SESSION["lang"]=$_POST["lang"];redirect(remove_from_uri());}$ba="en";if(idx(langs(),$_COOKIE["adminer_lang"])){cookie("adminer_lang",$_COOKIE["adminer_lang"]);$ba=$_COOKIE["adminer_lang"];}elseif(idx(langs(),$_SESSION["lang"]))$ba=$_SESSION["lang"];else{$ja=array();preg_match_all('~([-a-z]+)(;q=([0-9.]+))?~',str_replace("_","-",strtolower($_SERVER["HTTP_ACCEPT_LANGUAGE"])),$Pe,PREG_SET_ORDER);foreach($Pe
as$B)$ja[$B[1]]=(isset($B[3])?$B[3]:1);arsort($ja);foreach($ja
as$y=>$Lg){if(idx(langs(),$y)){$ba=$y;break;}$y=preg_replace('~-.*~','',$y);if(!isset($ja[$y])&&idx(langs(),$y)){$ba=$y;break;}}}define('Adminer\LANG',$ba);class
Lang{static$Li;}Lang::$Li=$_SESSION["translations"];if($_SESSION["translations_version"]!=LANG.
3098912992){Lang::$Li=array();$_SESSION["translations_version"]=LANG.
3098912992;}if(!Lang::$Li){Lang::$Li=get_translations(LANG);$_SESSION["translations"]=Lang::$Li;}function
get_translations($ze){switch($ze){case"en":$f="%(n0Q :\r	@a0p(a<MSl\\;bѨ\\zNb)̅#FCyfn7Y	h5\rQ<ΰC\\~\n2NC(r40`(:Bag8i:&㙔yFY\r2 8Zӣ<'Ha2܌Ҟ0\nb豌n:ZΰUQŭwDmfpQqacqw7PX3to	ZB9Nzs;̑҄/:|<4j'J:0rH1/+7(jDӊc栢0K(25B87\$B/h8'@,-BƎQEP#O7Ct\r`j[z0c|9h\$>\0\r\n҄=Û\0x\r\nC@:t\"~8_)9xDjΘ2(-xx!H㌣.-D;W+863@Ɍ^F+u\0ᠡ*,1,i8cxؒI¤fۣlZ*/cs.00~0YWB07U\":3xuc@#пC`2'3XIl*83ʮ߷ 553#\r9{5Uwxj0B͡.'(ǧh\$FJŋļC.!n(hڂ߉@N*㢺칈05=RtP5&ĻɓEĄ:ew%8beUz+q3dɓ*\r|7([Ӱzʲcw<]0|]G]MvXl̳?wG핷W:*1ngQW 2<1_OlT@PT%PwQG\"p/'!RD[	9Ufi*<&xޫx{ApEh*P*\rBukI)G2zSj/i\rYuLOjPJF\nzS	m!&hbd]IF\",C3DwIBܜlcgAlW\r!+Oz=G\0\n@QXj\n[16\":9\\5reH_qIy9s	Kn4lL|L@FLQH7J12h匳uDX!0O)8kxDI\rF'F8d&e3[#-k^Y+e܋r	9ɠ*ٷ`+QD4ʾwbKL	L*4\0*Vv10K1?R4s	50G]#4o\$DTHSfDe20fFhH)vbz7F\$p \n@\"@Up\"]J\\0PbJ1H&26J <Q樞LT2ЋSd_Nl/Ś !L2r_j#KB%I((+\"	r*3g6yӐ3:p#sP\\#OѻƋkl\ruȋ&Aɶ\$`lYJ꛰JN%ͩj˚}/\\`E\n`޵,XxF\r2BZIHϋX%u3րYBan[@T-|9Y01ٕGB)ꎭy]W~37gӒ[ ƛ\$xN6\"@BHPaBf_\r~XSNdE`EwZPlDU\$Vy\"BAB\r\r3aF]MձҗK]+A]uSchg\nNImL\"`%<.cXM<A\\2-Ie IFʆYˑ;%+#	f>YGگL%1dם0r%,&(F`fZdaAovM~lY4!S^.㌷[aA8Oe,Զqa^j[dJ605l^t^,BDˊH){qJ(q#Kk!g5\niЙ<|KeƭKR!{{\r|{Qm-ߝԓrJ|O޸|}l\\M`ӻAu%y'%Z`nxv\nYD~O49Fz1sbYi\0=/~+E0q\n.f\n7d!Bi=FWX.a,QHmۉDs߂Yxl(fI&X/(0Vf2nPll\"Lj./#;#8WciK/,5D*9.2\"|GcNo*c>#g)a2_Pd*Vlgv`d(2 LW+>D̏0UpԘpu\rka\0Ρ\nBNuX0,:\\f%Z\rp\n+P0Lh^\$c1(|HWgE103d\n/e\nyp6G31u		bd	c~E*]\nbމL\rb6!c,O5'eqb.\"	qeP:.O\\4\rVmMNh3d`j/%\nZ&59L/\$LmϮ	a#\"qmk蚏!Pʓ j/1(b(L!\"g X<L	c:):`N\"Z*W,.rF!.V\0G+BK+/53,,/,r6\$U+\n+lLF\$@0a\r̠0L\$2.*\"a܃QG\nFrr#Wx:`6\0о@hl(Bʤ,E";break;case"ar":$f="%)l*C(Xl\"qd+aN.6d^\"(<elV&,lS\nA#RNd|X\nFC1l7`ӄ\$F`!2\rl'E<>!!%9J*\rrSUTe#}J*d*V́il(nTIdu'c(oFe3Nbp2NSӳ:LZ&\\b\\uZuJ+ωBHdNl#d2ޯR\n)&<:\\%7%aSpl|0~(7\rm87(9\r@\"7N9 4x6x;#\"~2ѰW,\nNlERv9j\nV:Οh\\pO*Xs')ir*&V3J;l1B+l>j\\z1,t*4܅NA/ډH%-=lLHBPG)\n\$R2Et,]4R25 k(3\r1C351A(4.00@9`@Y@2D49Ax^;܁pVT3(ã?x\rKJH\r#x|1mNR*))U8I\"TL\"8I[R3Qӌ>,j\$WB9\r\n0!VPH9CMyRSDBY({*QT:0E\$D)*0)0kZJJI16HRY.\nGKk\$#kch5 05+\$&-k[96]MTlZT=&gNĈX[1r/tّQ!oݏ#ۦRJBǕ{!LP!N}sYth9ki\\C`ā0|f\r!X =h(i_	@4(x7a_0\$x΃RPA:g343`ث)TJm\"ĘE`\n\n/A\0u]\0l\r5H!08&0RaI1cSrHΌ}-CD\rQ%_@pn@H1`4+]l\n\\@`\\jBPp:0`^9aF&#\nHx|2ȋ:S0*U>Hj7qx5Cp\r+]-5#[ˁq.@D]Av.t%\$kj>ΕM!}\rS.ʑFR.d#\r*,p=NrC4C5yD%XPgH s2u	ѩ\nF⼈bDBhOA'`jC@p\0ZI#N A9;5Vra7Ue?a|N&hБٳY\$\r\r1w74Fη˿0Oa@!07\",GE*(qhĭIj %\$ʚ8Rb:F:޼`L6>g,AK-MZ3yI2K(I&}XzAt7k\0fA?͕a`P cHB4:lmhFT\"řj`.\"5>sZA3\"\$({Rd917\\YpD4W. (gn@).uX s2@kV`F\nA39Ƚ7#HqG%VrJXj_yLQpp \n@\"ra&\\ΞKe\$aK6{)¾\\NI\0T̶yjX\$~Ih.T LQ>ԼK[ʹ,#lTDi` r,=ؾzdu-3]O{0lcBցF/+-|c~\0D]Li'g{nD'>v	uom^q,m裊8S\r!SUCH\n	sRi	t2Ѕx6W;K0\r߂3ZC(-́c|;H2;\\F:1K<=JeI.%F)\$PG<f\nt 1\nֿ)]p5w\0ѾcGtH^hU'-AFЄ]\\]y\"3 O?W_>-4κrP 0/7*B`X\r\"LR~<2^3Jl((\0\nneZ!>NzD*wNigD9.UɗFFrQņ{i'lHp	z5imF٦/d#}wd|A\0 \$T(n8OV-,C(-OP\n#g%IdO*\"R0lMV\$\"`0k%dh)AV\"'c\$LwJ&Gt3\"\$!\\xM6DTB6fT!vNSRq@d`-	c\n0(dO\n.{]wĕg\rS\rFb湥48-lKA\n'~\"dOltwzM\0:JE\rdpPMD,\rHNTޮ0XpTj-pv\rPG!*Q.%Bux\n/thت\rDc;qyyN!\nQ|7L符Dq\n+)F1y\r\"eEgQhHya\rD} ERR1<1v'!\"H#PPDՂ/P+&/e0p6ÎgMe(]&	d12fnK?T.lRT:U%-A2Pю[%2'%R% Nlo)ЌTm튘b#vprM\nR\rў/#ciSr.~F\"1[2ws<s\$KCc-,n8øcSO5#\rS\r1Fn13s2?67s2-\"qb{#%0%Ŀ03A96qL\"h&3c8K\rr/:3.<\ndi<7S:==A>S	HhO<4Ms/m@b-@N4\$.:@\n&NBCf%W&5B#EC*N\"@4FkC?jFu=ǕF8Sx):t>NpPb12siEEs\rRJO#@QPN(BhSzSA&v>Bm9hlC*Oi-	5ƷMEodg0VhOMFeobn;H\rV@CYkxȐY@|~KвH&\nZ6D=ǰO/\"/kktg!֌Pd; T5F&~v1CO.'r\0E>b2M[B-V͒\$&Z8.\$j=\"-,/n;LJGq2,0P1TI(Fa(f4CIBB\r\\{u.F)Nhm):lB\$bC2'rcfG҇Hy-M^W\nt\rB\$q81B\$gtI/``14Q\$\$6Hu`5cvNJ3+L&n&Dt?f\0	\0t	@\n`";break;case"bg":$f="%)h-Z(6Q\rA| P\rAtX4P)	EVLh.du\r4eܞ/-O!AH#8:ʥ4lcZ2͠.(\nY(\$\$1`(`1ƃQp9(g+8]*OqJ_\rGiTh~McN\\4P򂞴[1UkINq呺6}rZ״)\"Qr#Y]7O㬸2]f,D5(7'1|F'7QLs*ns0,{ ī(H4ʴ\0\np7\r7I00c(@2\r(D:Q;\">P!\$p9r낏02Pb&٩;BҫC2izꤨRF-\"؅-KAOłJ<\$i؃,ߚJ)(fl ĚhQ̴-r:Hz-;RƵ*4l\nԍK\$6h=?TavW)\n7(OƁ\"OLf\$hii̝;P;l# 4,gw\01qpTgEфd;#7H#\"Ɂ4C(C@:t,6@p_cJ|63ElX4px!\\&Nze7iCT.)>6N8:bztjJh4Sbʰ((B9\rׂ\nO4N%*M)뎕THhpңH1 )<SHd6t,m?\"h&I%.gх\"⊿	qYKo<\"Ups봷4IrA,4K-htz֋ s;j)Ϋ;z%v|kչ(İh925=mdƢZwBgTuZk@T\nsV`Ԅw\$b\n9BA'4T<A;'	<(~ BVP6z!8\n+`6P掘3*a!:Ԉxr!図gC>l3C,mɔ.ʊHsEEPtCŰ!]3*O#\r98RPcy%ɭBޡpaE;;@taHq(sRLD#ihʤSe}1}Ju*p\\U}]ʕ	g-K<TlɘJc{2ynI,J5ʘ'-܉Xr]\"|L h(y\0\"uo\r!q0`@SaA1F,t91BѤё }LYn\$9QXI432>.B)HIIRdZ=>2\"A\\( al5&Xq2E#ntՕ &iQJ>=;'L*=LIU\\TA̰KT8#-]Nw!-DX\"Q@hFKP@`lKChen3Iê]:۠<~_/e  l&fCd 2A'(\$+Vi[)hdJP	B3ХSlzg[\"9: L	#o Qo_#S=d\rTT@\rOYr7_ ?\$\$ɭh\r!4Eí2!0ˉ6)Ti%[WkhEY}T*dMTJ!tQYlHq9;\0j.ohG{8bkhI%cH+eyǥ\r(TL0NuΑJz'J,)S)iPNE9Մ'WFi+崲)CaqB֕-CVKER1t(eFÝ(o^3YW\$M\njڛgVyI)nJi*V\0/3>[h,X q	m2}E;Rno/`QlL ŕ+sk88BP_2.u?ˁ)B!<FO7|G	7t&B[=iAJ:ʩBשFYA#q ﭛŊcZ;JuVfי\r_F>\$Xe6tU]>]?^dĠų	Vb@A~㨿\"\n40&bҍ+dw<B/rx)Bt^p7B!O*ы!078`u5;dG<Uh C@-^UzhB\rz*y(`jhP 3W鲃(X\0を䀆@\rb\nfEdɀ'A.b0PZ3B\"VxHho[\\{\"(Lq+j4h~8\nȌ\nOhHƎ	tR(~ \n`\0J\r\$l]F\$tI\"H2(jgɆ-TFA8n*O<u\0C\"w'֕`I\"(	C1Q8cl(ETڙë(BK9f#1<Oj91 q		oq\0qcqf0d 6'.#'A<\$p*\\P@q5H0JpEJ;'V-+Vrǈ΂L>GGA.#О(ubƇ\$\"\"\"n<Jr\0003eC|`{LhiGT`x\$n<B)mDK\0͸@BBI)\n)bόQg*2qiz6Bb.novю2Κ-p*Z*).lr-*w/2pbhFƉDbg>t+&!huc#N15_ĕ#\nK34XYP؄G<)(3͍1,'20+rpfDo\rؾR﬇e:hdO).gSr/Cǈ3u<=\$+0;3s/28kԽSh-*UzP)T0h\$@ZM>.q𔂘%Bk#\0NviF\$k)9ye0TN@;E3EB+QuO\0s	Yc\$C.4>JNN?@[J4'!T+0qOb<PtZcD^'\$pĘi79P,g Ī\r|Bh.3JK/18KRp9(pЄMsRODԻ/V;ԧ.QUWPY49L6ILP((j	|A3CS*Z#ZJZՊN4YS\$kI]]1]w^%\"D|o#pxcxD5|\"naO3EԟBTt.tAE#H6'Xm/u1 5LXiBkp'fݣ&9eG7dY?~Q^vYHgcVIHP(Ф̃+'Xe9fwb}bՁA17|'03eM0!Υj,al\rwjVCc0D.fOk\n0hnֺ628-[M/X%ukdXeh5eTvgsPhk >r\rj>Fd\$g3}WE7JFyuMt0atvDo)6\\PqOqc+.\"CJ-7#jA@ux\0wWl,L7-pЌ76\0~!>^u}WҗZyko}3l`47[=w~,\\wqWMrK/394gIis)1gJNOcK-BQ'fXp8F,Kp'r맔'f,饇)8U,EFBbK>d'mFޗd,&NbN\0@\nZ,ugqo.\"YxFNlV: \ryҜJ\n\"g؈g]`o6hO('sp6@2o\0Ğ)o	If\nÌ6:><>.S\$_c>Rz%d}pNxr\"բ,V\n/c7\nԁ1/m\rH!/qTMzӁ,nh>yݛyv1ٓ2)msrӟ3REWgV6g>e\\=e`SOjQ=+90+7+(4VCG'8QUZw浘\"6䁠q:kmFoL%'Rk4Df>O 5QD\n6J,7no3Yon_BXu%avʽIl;WQl";break;case"bn":$f="%)Ut<d sNb\nda\n 6#k:jKMŐD)RA%4}O&S+&e<Jаy#Fj4IjhjV\0B`ULcqؽ2`S4C- dOTSTLZ(JyBHW΢Jhj_\rmyioCZNr,N%Dn৮еU8O2nŭr`(:NS7]|􆇵82ɼ 4NQ 8'cIg2Oy2#:\rK:#:E3nm ;KB+M	Ь#G.S9h6ԫmTd\nQD\rIlj'@Ep{LDЦ\r#pΝ2*b+\nDNtɨÄ+H*[;\09Cx0o`7/h: AR9C7KOêx߫N%4譖}4k[Ư#mq8	CP{]G:\rQ-R(1T47AMc4	ҚDa*;6Bj(c֍etZ-QElLt}CEX'J]6\nY4]f'1OQa\nB*9z,ilKL6JvP;B6˳AEѯu 9T@0c9ˣ>LRK#4C(C@:t9sAC8^2},9^,A=A\r7^0SeCIxɵ|EY@ BYQM^\$Lp^2be쳕 EcxRCݥm4C.4ˌ'4B9\rJ\nMr>Ǵ-.ϊWk*/zN9]c_u/asIN*k/PDlA: lq/p-S*:r|E\0:*HNL'e喺d؄.\"mUK!C\\@>S2CCB|/&e,FAa\r()QG+Ck6!ABC2eb\\	%;g?]\$XDt.\\Q1\$Y0ˉcʔxPFy*\"A@q'xF'BC<FT.1	iU:5 לa44Ða.9 ɠCq4yf>,.εU	?:U<  `srK-l0rG30f\r2r\"AyoAP7 :V( \r3r!3;^8\r\n\\<+(مF谦3tf\"A,2c8*~8rM!/mN\\t4Ft׏Calm[{q\r97f\\- }^\\R^53Ad̿bf8v\$-[LIQu*Afjᡃrj@Uiִp\r-MֿZ#fm\r6nO๺v?'\0\$}kx|\\O q!©TGUbPYH`M;,prqB'\"Ɖ^` j!*#Y/d0kFi3|RP!\r9A(h<MTU7:.@\$,H<-^%_d=ؖ;VGr'nAۢ|O>0'agD\$zX񃽭 fԳF̩8P)Woet\nEҜ_l{\"Hi)\0C\naH#]IiL\\-H>Fbfp8\\6)˕#BɎPHJ1z\"VZLRZY퀶%Z(ΫHy<~.?M82\rzܳڟC+Q8+3)c:%%JŐ@xS\no~FN8\$qѩ@MV,G5>++řw/.?#smŔ[qiar7FJѫ`\r75-Ѻ\"=j}gAQ%aQ3K>5]yFĬF b*0\\dO#Ɛ4JYtvRg`˃Ruf)<JGq+Gn˾Lea,\r'´=c2yg\$v|q!LIds>°+ȭR\n*{G/4Ӝگ۾s`L黎ظ]bNJ6vÄOM}b[\\Ub\\\"+ZN(*^8\0`Of󪒌!	<̔BLxdHK\n`>̈ɄʤLR@\rɃL  o\0\r'M\n2m;4blO(pL{#'GXuBZ%6C.|{H2VIwxNT \",L:84OoJ~l` l0\rpT얍ヿD*Q\r<uOŘ~-4p1J@}+iJv>bDfhbPF#/[Ne`	xfj\n 	\0@ܰQ\"@E7͊Dx)|B{ ^Ee4{\$5c\rCvkNCÚtT\n^)@TŅoXaH(Sqg ~9_ \"R,1EvJ\"W1#ŘFʳ\"QJ>D<*0\$hFCQ_<Ejo&RJr-m(Y(*e1s)%I,Ңbs2,n#䮗f	\nWG+,34#.WcB*J4\"]'&Ԫ2,rt\$)/G!02WY&YP./%,bC.zxDԂ/iE5*0bGPGVp2Bd8S0)#.9(#.^'TS8}e6O-ӹ-rE(RV<o/|D_1[ \"^皐=0Ea\n\\\$2^8s̳fbsA|)j05P3\"sX43t8/#B2IC4NG9qd%uN/IDSu(P cY;.Jnh)E6cp^(-J4.+\rFsF}3a{;\r9&sD4/E}D(Iā@ڟt( ~4E&\"KpiB%&tJ4N\rCMTZT3Q;E1YDtS:v0A5D5SI5IPPM=ai6.2OEt-_V)rL1XC2'EoJuX8{E^&RHAG`ȃLm%\r,c\"TSR1ձAU]TJuG\\Y/*Տ/N./V'k[UI&1\0}CW`[?vM\\1[vR//ţUJM~Lz+6IZ!cPNB6F/|N沯e\\-5%6dDs_MZRŴd./k]qYLFSgbt3ct1&hr68p\r02]8YZ!Lu/V*kTv3&pKBSLωcMS9XVrw.7cwl2Gqq4tMtcHY-uuuDrAvw3v3ul8&UF3e7YFwW?A<VY\"rhA_k72+w]LZLZBVԐsV)V%w8CTs'UV\r1~uϭG7`DWAA|.OVG}oEWo1p4)w= xu\\G</o/';g'Dv\$t\"σr	5srE[xu42X]xw`F[55؋4 wcxםҹ2y≅wP|C4RQX8W則Ӎ	buXDEww;\0CQ\$=#ʋF9y\$(gL%eaUw[9c7%arYg74a&b}3+4UDxpQ\$<ia3ӎq\\xK.ŀ?_X\\9TCa@7I0)oی|Zr{U+s'^NY,5#?1V_^Y]/26'z;K{Ts178\r/͛qTA!5zAWszOic<%cg%_#`jb\rV ӑjDBjDt\nZ	zK\$\\ee_㸕Zr\\::}anGbk~='o(oR|F:2 N]yM|iKi}CiR(c*a_U d|%YɉYdpl@[%1M<:tC̱G#р\r)y84O2㍰zmC[B((\\P[Ѳ4B;IUc:]\rWKOR\n?C=y#\ngr\\4LTg[ 40|Yg+\rhDIvJsP/qR32LՓE\"ƥ5gf+ \nƈ\rl3Iv;::3޽<EH'Bc|b!rфUN,sek-'?(Ϳ`\r@\\h1|VSz+%\"]W 	\0@	t\n`";break;case"bs":$f="%(l0FQt7aNg).&0M磱7JdKia20%9IH)7C@iCf4* A\"PCIrGn7+,lbdѶ.e)zCy\n,΢AJ -e3Nw|d\r]ŧ3cXݣw1@ay2Go7X搳\$eiMpVtbM Uk{Cn59.jc(4:\nX:4N@;c\"@&H\ro4n\r#8@@H;*\0ߨ\rò腱P.\"k\$b#{:Gshl5ϪҠϠ6J9>0Fî,&%iJ3*5'-I)#U.AЀ1mPS<P(@;C5IB#'\n\0xC@:tt4:p˘x	BJ\0|6hbp3.cj4px!=/;=ʃC ɋ8?C;N2^w|6'2LQ9\nL ,MNC!>ãdvCH4r4# kkҿG(0d c	pP:\rpb^p58ɤ&!\"V:5;#'֜M5T5HChӱfӠJHJnz]_^:=3w\"9|kwjĆF)A1<zsખO*X#\n/<]GkCMg\0@6PWg2WKhm۩93,gEmZqm1%|g#(\rԽ9dfC2fQ\r3BH{SP7լ~J)`K\0o9CM|o(TA@s\$*zI%PfXC:~\rZQDiLo4V\nZ+epW%`%L1>ef貵\$Yu\nj)#	5RQcn.rXdgʩVDbժW*^\0bnX?i\$^InƝGRDA㧕r :!rC,ĝ.4JKEF\rCARql*\0J?\"`̂=*/;4w^K*O	'r*2&`H\nԒPPI0䨦Hn)!3Xh4)jj;\"BLL;05lcS\r\r*UNsue2fldjB/aL)g\0\0;SGC*kf`u\$\r)k9FkRX6f*S% 4r&lޝ48I a؊Tqfՙ MR\r~dz9ͳhMM[2D`TNC\$)'XRvb\$1NS\\\0n{%\n4?0oWiP@ {Ғ'ۂMDث/Cg7)Ph	 =aLbiA	8PT2hQ s\$1B\n@U\"~=Jl\r	z4ҒpvB%)Ҽمv!V!2u%s#]8 GeŎLdmtѹ3.slͼ#υ+;xU4v^ɩ'9\0ql\rW4.{aq/d#j>P`IfP\"~AWD3;\$0P0N^eQ\n7xvȿyAI^3DǦs2UDQc.et.}P2i	\$bqKΆ_cp(!c~WXKۓ1-d݇'M^{H%\\F|Hx\n\nL_4nڹOƤ9+yQ^aP*\\H\"\0KB=%Tfb ^LP\0'0LTB`H\rkGyT\\FS!\0ЁDP.n騛 5	cth_zI,#&z\$΂\\Ɨ|Y71d3~q{^SeB3^=yNg	S0A\0r\nA:EM',4\$`{`O\n96BNh1^Γn'ߔe(\\e@W2(Ckf	=pvXi,g2Y_4@&.\nbTxxX260/ ͛G\0g؆/hl@f<\r\r~)|hG&+\0-PP0`.0n!fL\n\\`=mʣ\n`FdMH{L:~PP|Nxd@uBJ`Gɐ\00003	@tMto0PAP	ba\0%n.ƢY\$^*.P\$',1\"'\"1&4bYQBc(22bmC&1-wNΑn?N.b:%c>!O6i8BdQ,\r'1SJN:RoqΕ麞l	g\$\"!Q\rrMQ٧Ja^ODMщ!p)_qGj)m\"i8\"F%QurD26\"@\r%R^kE#l+rcOE#\$dc<`h\".q+rY*r&0A&\"+E+U&m-_2b!*-F\$\0\$Is/Wc&n,v2r1fCKҵļ+d'\0=\$dM3#!f#Vm4V0R.]46PMRffSp-S&800󈈣2Rjߓ&:P0%x76-73K*\r;=C:@	0B*Tuj=`)`).#V脹!ZT'T*@\0004@lڠ]4&1F7(`AQ:¤t`hJh>.pa)P\ngMǒ\nZ\rȆ0\$\"/jATn|d蔷>x43kPxFxLgs0&=p	>z/c6r!H3j;\0 =,N`PL)ed f;E,׮(ِ!T\n LnkKSEF?Q4]Uhӎ\r>\r?YN:\"iK]lC7GL\rZLR'\"p#DCKĜvu|x@\0g&\"hR2<n-2L|C35@,̺r01b]bL.\$\$'9`)O~p\\H\"";break;case"ca":$f="%(m8g3IeLa9t<NBQ0 6Lsk\r@x4d	s#q2T\0Bc@n7Ʀ3xCf4(TPfS9?Qi3M`(Q4D9pEΦ\r\$0ֳX~`6#+yedya;D*i+p4(8\$\"M<kXXēYNT^y=E\n)joM|*u4r9]֡횠: 9@9Ȓ\nl`6=:*z2\n&4욊9*Zz\rI<H4H*̈;I!/HȈ+2\"*\r#&!<&:Oh\"D׌06r0.Pʯ<\".(r\"\n\$H4bfQM&P2%434C|	7<0c7>44Y8ʌD49Ax^;r%LAr3_!uJ0|6Ȃ3.ɓxBR j:`Nʣ:-̍ǣ5ꓵ7\nLc0]I+\rP @1*x9ڽRĴx/8+\"0З=22ш}\"2+A((3%Ei\$6-cގ\r`ߝ	0ܝ9aV474#KK]Pl,H 0l#*\nbZ%81Oj\"WxWӀзHϲo=+?Y`x2sr06dh!.C7vK7G,J2Q	ʹ߃I\"/<ܷ:Ia7#k+[(ir/|'Q\$LCi\$	qPؕ@Q4`81&Ҹo*\$7*-zdU3+S(h2\n`sIO\"*CPBgx)u;!茫XKc,zY=h^KFwd\$嬅3NTiGetT\n#\0ISOU#+Q *Y]ȲVX%e\"G;P5]*}E`ƃ!o \"ȱ\$Hdq^DT%\$t #P U1hI6cA3HH\\#l\\n8&pʶ_&bC1`х0'JP	A%AF%\roQ2Xpldw	<D[oF]Nӵ Ĺ/3]h)SC	\\rZA*GsA(/\nngkZ`FT@#'FAב4R	IH@_Œ^LS!3f	; <ZƐmfꎙWHUM:ONu(lݭ	L*E}\$AIW@\$ZW^a?^\".UZ\rqE/~5^UH>ٱ%TÌq@RLh#5PԒ4䅢BARd\nXm	8PT\"@-MsµL\\#(9ZeI)PŰîvNriI<&dy/TPR+T1]-bQfSCS5DSHŜPHHE`rW%qآP*Q-=قY[K>DI=4F[N\"fhT2ŉO+sHi\nXNAaѕjJ 1e-\$4%35;k\nb5E\n	.;-9S\"pY3;xa:sPXkoӶ	\"FTCsa#S(8%M%pb ԑdy8eu(e7C	\0sg(@cӱLȲ\0^yƄ24,iP.4DA26H\0Λ:2\$!8]rvJ5}[Lr\$̼2'y/<\" t9Vp.kzBu3\"	i?!ݧ2*E)<)Ȓ0yD)@	%adJPFEe7#]֯H٫f\$|^FZPu?;\\0ŒVؐps-VJ7^Gc|C){]Y\$YW0|-^4sؼK:K\nL3=blO_VAmyK&_f1.\06lg*\0Pi\n1 \"PPL ´0#mhl\0N֢t2Hn>\nGƬ|ȧhOθJb8i]\ncsДg	\n hV~ygJ6McOd\n&do/nZ@氯\rpv  n`(PI\nأL%%O\nqB͎b2\$fJd0/\"0G4_QO(BPӫT=VCNv=(DeP8V(K3l&2ܐJFi~<J1YHjIm]D#\nGb`\n1@A\$\r褭0ޮi\n1ϗ Q5!\r{\r` LbMs2dΫ\"Pe  PO%7+hq<t\neL1\\1rl2rx,J9TKg/\r#aQ&_h+S&+*&m|v2,(-r,	\$x\"w'!/.RrRerre\rcN(I'\rB᠇0\"/2\$0B.#-r,p\"C 4P˽/,g5N\".7-e'JXb\".K5(M\r3b.H	\n\\@*漖?@A'E\"SуT!ItlFPd\"\"./Sګd0A\ns((Md\rVUMh/T@ZlBHG\r`\nZU~|.]E@q_EFyn\$N!Bpǅګx6jP!)~=c1M	@# °/VHd[V\"C#eV(e%<DjRGn(puHt0.CfawO/BWOP3ԂPyQ1@1D(C53(>=R501lU\nNF'+Z)P\r^BKF쟋XsUfnHyD0F\r\"h<H̠L@C@RC2+N\",;\"uP/BȐ\$x&P.*+Pd	N %fR	\0t	@\n`";break;case"cs":$f="%(e8̆*dl7qraNCyo9D	m\r5hv7e6MflTLJs!Ht	PeONY0cAn8d:VH+TتX\nbc7eHa1M̈dNA^/J{HLlPDܮZe2bclu:Do\rbʻP.7Dn[6j1F7761T7r{āE3iǓ^0b穦p@c4{2\"&\0cr!*\r(\$B%k:CP艨z=	1c((R99*^F!Ac~()LH=c(!\r)<iaRB874BB`5k<<񌣒n99ZBDFo\0B4B9*MCI l4HhL\rx[f!\02ÐLb~0z\r8a^\\04Bx9r9\0J8|;%A\"1^00n=EC{P#57CkH77L^w޶l:[\\d+0}P(S0bc*:.o :(\n\0%	F P\"\"L>9Ŋz^d\rzW@:\\HWQCX&#H4!#A*CFMBbNȈ@WZt.z' LB&%̹[@V23:-{4;#Ӝ(^?6<\rЕ/-C;O0@6X<w/wJvbWr=\n8@6WZC x@o\\	9pH:пDBƆпڧ#`6~xvPQĵ '\"1?\"D\"OE=)ZNNh˘ )?(L'~CVRA`Id &SaL+!ja4\"F'́!B 	'.%C\0{цdF)XtM1\"}\"!s(,0ߐ(nZi:\\²V\\+xXabp^yP\0|Hs=6g5%	6LF«%B}!tGd +PmA:4Rz%%UKtY%UH5jʻW_&*\\7Kܴɝ\"+z=!E\0It!E2e-x<Г{&RHvTխbn	]JHv1LX\"XRQ>KqTH{\0\n\04u\raRSH\n\0\0h((3hH5C=UgԨ74\$i/Ci\\ç\r\n1PʃcBA'DCBJNdM(~L5ĿfS\nA0N2~d9=Z&aE!8c8Jz&V:&wmO,?b1Гs\r\"_tF1\0\"%*O%92)aK|4'ͦÇ\0et3xS\n&t_LHH[1C|KMK8^\rz?\0N	<Sl`؊r3Dho #Jo;8n0Y\$a\"a=Vp]TF:W4=CˑkP > :xN˄#m-ĘzufeHa#x0H:ɰT\$Ő|QxUT]=F943Ӫ4L1(n9(/rx_pt\nj/JQiGFFpQo'+u2Q4a *<3c	:',)K	1\"Ŗ*b]N*/RDISPb%L\"jk#&lps^ dA8\\OyRZwaerwĸCP8gM9ÑulP\"c>l(#-^PzA-ʀmhy7\$fяX !P*\nu#I*/O9yVc8ec~Ć@b<<	rO`j7b5-,E<<y7e\0<g>_/69DXǷeΠ3*iDo-dXHHs1c>.P彏_\n<z^u*Iimdo\"-̲#N^G\0\rhLL((R\rDB&PL^B\0g >ZZ`EDG-b_,?e]g4`X#bJf#\"0zq^f7:7운9`75J\"&'\"aG	\"l7f\r6\n(T^cK\rp	|:H03L`#LJH7fzgHƆ,P]07-@^4r`0h>LL!Q0hLN*\n\0dJFRS,*DdlHNfq8\rмv@<\0gP'`PynupPxD\r#Ky1쯑u:\",b=\rXL+\rO*|/t#Q<	0\rjG2h, & ql:Ȍ!R8#;\"4IP\$xg.4\r|>	Ez%P|B`g`DKU*orzZdTd҆T|:bHZv̮BjRhBw%;&㲦<0##*Jd8jA 0RS\$neh\r1d\nͷ0.\"	,Cfg*#j94y2N3ed~Ed<ܦ<K10ޱe!	s@9A;˯9F\rB7iÝ=_3}	g5/T &?3q&ee?/>P\$EAS6T!@d>9[\$1T3%3R/S\rA=\\eSt婭9R泳%TfwFC;Ztj&&PR99%oH\$Q%3	HsHQG!<tvMT\$ZrS`M KqCTvMĳ0qL;q\r5_!^g2'K2=z8a- AHO#QcGPf5BD	b Gol@g#PC#OT:#\0Q\r)Tr4Oi\"\"\"5ubvY#@]c'Fŉ\n&2<'eX^Ҫ{'AD1-bZKf%\np*,5WVZ5Zq]- 5WMW4 ,!\"	yfxP`t B? d2 ZqT/ĺhBd*~C\$15Sn;\nіL<%AcPI\0'*lOUނEg\0̨hh2'`%ɱYj6\$3 ֡h3F<s\nkY&j?Ñ.2?\0a55\r'vR=>'6*B\nb'/03\nv~\$=EW.\"*6=edhM(.OL#Vj.6M,iCuHG\n@@";break;case"da":$f="%(u7I:\r	f4is4N2l\"ц9Ü,r	Nd(2e7Lo7C\0(`1ƃQp9gC9GCyo9Lq\n\$	)36Me#)76遹NXZQ6DL7+dtD 0\\AΗk6G2ٶCy@f0as܁[1Z7bm8rGS8(n5z߯47cNo2-\"p܈ә2#nӸ\0ص%0h&i'#z(!BrFOKB7L2B.C+02b5,h.ۀ:#<0-܃\r5c	2\n	\$\r&6@>O#1)4\\H4\rD0O9`@PBd3t4\"B-8^xDjЅ\$x|(X+(\$V:cd3JH;Vmx<M\n&(J227=uXމ P אL7\0 Q\"1W\"0:uzSWPY#Ml7ځu;-ͦraCcPBbC?^Z64>h\$2c\$b\"k,5ڤ*'v24+V懲@PF&0ʏbk;`+	#k9%Ql>x!E;]I@A4eXp\\#q]#|u03c/6B<*ǨԭW\\ݏ2	PܐVlD8lB,-L760\n|I/!Ns͆9Q_0\n]2R-/ʔ:#bɣbSLxCI'\n0(TtR]L:U\0rTJ5jP>r:r6;L<x.@܁)Kd0đ:Q\\K.Qj5G(q3\\U wBV6%tѤB+#@h9/k!+3'!:uI88[\"1!a͞\nVgɛ4w?DYЃo{*PS\$(9a\r%\"\"JȳBȖ0g\0P	@dJ@('@R3E2-1К	*\$:R	X0_HU\"I\"9>J9\rA(UN@w\r1Z5R):a4A) K!(0OSPD5pDI3ᘙXoI-6fa8A\$荄^)~]	Iqb(\$3rI\0ģ.|sԶ`ɫ8|+Мzj\rk֓/I24X˄l7̛\"DR\\BZBN9J@PD12CIƱf%XT2MO	*\0BEl\"Pn\nP^𠸥3}I<&Wv\$[Ș3Jl[20j&>NՀ4^P):d,5}{5l͠WoN\0]:&e.cNP:u+EBL)1LB438u<YPmDRfx)(TgF20k\$\r!:`\\8<*_Ol;~ʂi7eZǋh70\$X(dBD@0)o{KQ<zfAOT-8PٝyEe\0b-fhXhV()((0Ay>_P*R-\0b5\npEZ8j1b.Ѵi-ˡxKQ[Hr!,6;kR.u	'xG'F۱y]	ہxA5fr\nO\"dU]Ee&l\r{jH%D!\\2\$\$lŁ.9r2K p~b|Y6T`CW/,ȿ<rVCi\n[B#KF/Y7Qa!N߮pDq7w܊F2֞^Ɂ:L*ȈQSA\\R\02\",W='R\$|yO7\nbj!i\"㚯]4sG4_Oƃ^d݀^\\N~O]Vw*\\KH__{3{uq-ǱNBkO}:߫Yw3-I\\F3zi]RL(Zb`\r@`Ϯ돾φK\$c@͠ʆcj+)Ɛ@c#B_H3lL.gOq\r QCb,za\"&C3n(Bxp'kd/\"9\$&f\rl[Zo+/0o\0EaŤZRPBXmPPp濬!`͚pfٯoRC	XlC.D/M0/;	\0P?F4Ƕ<?L:/JXcoED+/obH@wpʛb1W\rB7nc/kQ_N^qcT1HmڢBkHMqc.na2()P̈́2'\n^8\rҋYO2/#1Z&фCrBD 1lIr;\$DY&RohFRM#n~nX	\r.m(v`̐!)* )Ȧ@2[݅-q-OmE``@/Hh'Nn@0tVx\n\n@J%#mڍ)Bp.&12M\"+堿T\"\\/PB7ΪG5À/(0\"B/hCXON\nlB9&b	*BK&4&S+34FK;.<Ӭπ4N\$\$@\$S2Fˮ<deBph	| #fԌ\\\0>úl-0\0Dp\"ڼL/&DC,0<r4 (,lf[=\0ҼI9b\$i\0@-jpP!@";break;case"de":$f="%(o1\r! ;C	i9	MQ4x4L&:Xg904@i9S\nI5eLn4NA\0(`1ƃQp9& >9M(e)V\n%⡄e6[`rbQfa\$Wn9ԇCіIg/* )jFQ`M94x 0·Y]rgxLSڸ@wŎBx(6nBh:KC%-|iz9#A:W7/X7=p@##kx䣩*P@ȳL9Cx䩰Rfʡk1Cˆ:)J\0ߨHЉ\$6(R[74ã!,l	+8CX#x-.+	ƣ3,q=#(,6)p츰th@;Co&\r:PQF;O[ j9.^C-sH-3 cꁴ\$\rBhx0.\0CD8a^H\\SKz	5LcC\$4DGh|\r\":Ct:p:;K`%&K(2*=B?\r̘JC,a: BV`r1Losƃx[p\rn[C\nփG.(H҂lA}H\$kt4ԸΜ:+/n8ⱘ:1&ժK~,>76\n2ف#,/5N/33N-&^Y~ô\"4\\	QSXNϭ}\n\\-*T5-X\$\n߽(D}:- VF#k9ݶ:ȌcZ:EԒzC}\\)2ASJX,lb7M\r'9Kotzb,(4ުb\$1&0CLb\"4七`g\r؂p-\nΝ\\ȑ1>oὮHh?F&4hOq\rL\"~\0Q\na>CC\rҢRA@P!łBb`nn\04W8v%Xk'afbD|]ʯ\nXduTKEiȒ BLke8>bHgaU bGI\rƵF(L^ѡQGIrEk\$tnURF+Ž#c,\$.ZH2bL[OFLtiH0JB65Ht22Č@PLN1A{GqMIƃ\$s!4}b\\V\r=0x~*K\rU2:y\$/*l@HtI,ee*#S	D(F:0!@PQI?(-9&`\"\rf v2\r/ݠ&+Й@Bb`L;20E~S\n\rTWq9/OAc&j5\nkeЀ@*jPZk'H@FP7c`B|u!ivfP	*6ڐPBNJI]~UDAKgb\$p_#\\	k0a\\l.f>,&C\$tذ9h\$4C\0m(kBO!3F;'7p)ܞr)4bM|X^OP@al\nY^r`\rJ!rHђEX;wFf6x+06,H A\n2@.k;,Ɩ3(x&5<ۂf	r\0Xͱ2a:+#S1hݹ  w_4yjLuA\r%X0EOθtQAR @u[!-ر_{r7fB+6z\nl\rw	3\n|udLSS2Y'@6*ZhC7dϯEn*#k;\\Z;2us*҇6l\$CB:64hVdLC-otT=P4	:|մss}e!BƗ#*O*z4SzN=~ltOtAa!+Z*\\ԡU4-BV\$ <`Aݸ^UYbl4Ovd#PMoQH#%	~mwn~\\hȪC!86#Y+4 3+w	[P-^ʃqUKW̑}ӏ3~Կs:ꉶUvzvCȉr[#9)6,b\$pBCDC	@(lGDD-\0ZR:oF&9F'p'D|GDMPP:)؝&F0^!Dr*I}+F0PM\r^xh\"\$Lg\nmLH9I҈`Lrfv)|gj'z\rJ-Gm\nR=Jj+<㈂#fmZ\nTdn0'7	u\rpE_	|=j	\nq10O	1\nDty	S3NqUqOEV=\0\$vVp`(oeJ/NF1QsDh'ќ\\˂@Cb%EcDnbc/PH\n&0 ZI @HH!H\"\$C4.\\ 5y@B0\r\$fG\"e|9䍲)lnR0\r~\$]f_F2-,r*Fw.rR++]	R(D&+*F=@шo^ -bIq0)TDhiM\nF\n\rg/#-2͉.\rd\r:4QDz\0{n\$d&m0U\$6R2?6sk7ҿw8s0a)7m5'+0S9'\"sDǻOHȠ;'8vD7=NvsvwR)}>d\r=`:s'=??=s,1 M3IA6B:Ӏ >-`0sA=\0\r\$T^tFC3SH( \rEhcFbfd*P\r;Bzv4YPF^`36Đ0SVZdG0z\0\np4G(UpH%,GinGjI/2A+\$nZcRk#\r(V4K5\":HK<\$#dV]1!bKJLb@:N(u4	\")@\rASN!(xFЌpN!TW#Ws=~ZCY`ЂSZu EJ|C=0ن2Sn'\r'D~dH|-N3/dvSM3C#E4%dݣRZ\"=\0X5\"RɄEC,ue^|keY.jqդ˽e8t:)@d\$#BA /b";break;case"el":$f="%)g-Vrg/x\"ZАzgcLK=[QeDXŢJr͜F1z#@Cf+Y.SD,ZO.DS\nlΜ/*	D+9YXfad3\rFqck[)>Hj!uq*?#BWe<\$]b^2n>z< TM5'Q+^rJU)qs+4,er5-3J7g?g+1]_CFx|-UtLꢻ)9n?O+;)IjtP#0\nQ!s'\n|W+IHsH<?5RP9~%3ٞG(-4COT\np7\r7I00c(@2\r(K:9@;\"P#K[Dr())JNO1~+LR0=8*ªqt.:Mcδizbm\n:ĺQnIr\"MUqљĤ E>FH	>!dhӷkAFv%PQwKjOzިOT:gE[4L]DӃhTAr,֍	z]jh2N)uw.Jb6#t5ͳ|9γ@0c9#>g5̓45H4\r0=ϡ`@i@2D49Ax^;pÓ2]0x7V9xDl5e#46̃H7x6+]|\"ᇬ1A^œEz/{&DTFͼ|/t^'<	C[j3W(1;r|PH+#ݜ(C2>7Mإ\$^d=b\$}Vv5ʍæ)v6ޥ۔F̊\"\$ap\n'|he]y(AM):E\"32vfE'/hL0GM*2.\n78!\\,\\=J\$Ԓu`i[!°1(fP{L(\r~Kd@QuGϠgBȳ	YՕXUGĆIA{RL#af5ZH%҅q(\"FqHr9#~Dx BzQwW9d:4S34Ca.i`Co4yhe>TTCf\rU&MZUPs8ob8lɄsg:&+\\Ϝňsu5:6PL%}*ȕ8c@)qr5*zӜїcI]jOQ1L.Q	r.\" bhڋzȧ\$u}ƞzDE!VRJE-#bY!RJtWSo\"Cɂ&P4rLPriqڀ jMQ5`퉲WKklF>7yYĺ!؄,O)i\"I\0I\"W0zb!Ijq	IiEVZ]k텱׆SlӂqY\$(jQǡ|1Q*=Lv5ET=\n5?fɓ^xν<a65Z2bB4&ie h!6<q\rs՛`C`o50@T`1:a\rg, D	nkQR|*BWsY=e\0\0(,RQM^%P(.-ɴ\r̨1k;{IA;cINh'\0\"YŎ5\$b )H*]zN޺3Éu&6o k0њJzODcc;#)4P̹S<03\nd&,\$\$%km8.@TI	vSp,1-gAp;l(Zr=ԚҬBAp8<kS0\0\\ƥV|))3z*\"GUC*sZ\0¦څJD!me!G3xb|FF).d>!gcVwБ䘨,0RxDG[=?U0&)LI\0F\n#=D'6P:^{ȍcTwߕ{+\0U|črZ9'\nNbF_p\$}Pδ1Lth(}<!\$<o_'rN2cp/|)ʑ^se5-t9}ݛ~Nt+	\$)<~bAXEؑ<>h*ܧ̐ML\$.Wg}qJKE	22B|P85	RˎCp9\"Dn\",\"6OLbx2utϠAzD*zL,q\$W	Nh~OF\0܇'fPhbxdD9+0.=Vn^ w8`\r \ri@Ƞm`h耨Ԏ|mEʎ0Jrn8aHu;(a:ދheF\n\$p\\bq:)]P&\\HuG\$O>pYbD::ªl:` jdMMb8\\iÒQ5./f8f>,b\r&YNw8\"#ggea%9<0@&E,_О\$ \n`\0\r\$ffFbGOǤH-0X47g@Gb)!Xy'u\"&d&,Sé%5-4\nx%.,?(%D(|Q&B]()(ۇ?)*.&0s+.c'̾b+3,2,HT,&\0_g3\r--R+q)3)1\n&3*+)쪵\n]E\0H(,0^pb#>|-!krrQX=~*\"d6F\$\$OCb+ԥo@Cy4rY/o\$.X3X:@\\'o,\0\"Q*\"\"QD%Ǩ 2RNZC2ɤK\0i\rB6l*M\"INW,wdӼE2|wADT#WbE©E^~4bHҥeF9#&sn)>o#F0%2b1H:8<(G#Jeb8S!8DGBe擔jT9L\n2~ϠCKT~|-󜪔1LܯP\"HqRr^G'\"N*?ԱzXU,`\r\0\rseU\\/wөIYK%rU`+_B%.5hHƩSDX	J{8cSE1PPReuzU!QR C5LAH2Q7Luz1̫(>'</)@#()y)w+r쫊c^H^^җ35uҫ_`#)/1ReD&Z!_E'x50\$1;NO<\"uSD\rYdէe&Y?fXmEvkXAϏ)1_D>UU96(BR>r\"f=]ʵv>αN|&A\nc?Vk	9m\"kvp6ua.ta5/e1Dcg]dEMT6H!Å*)on/tHt(<iXեWANs4dt\\YuXV\"4AvMu-26E5gf*Gt>s]t}tԯwvoy?\\Vu1U]Uz@p;\\\$)|>ui?B8nT/nQ<so;2GD?`^cvh\r\"a7Y׫vNZ{{Pq\\d:w}K;gZbHCqK{s},],!	%!XmE8`ł1C\$#-\$uAovwB\$)ud\$*..h83Wzm\"Vc|W\\uJ[Pxы!8gX8\"H^8!WSXs׌|7K~=dǅ)9>QְDMtY1QՙWyF_,V&jqyGWO!]Xےk{E!h%zy)%Pq쵛ӜQvx׵REJ%Ӑd-y_8fy9\"{xhXBXt\\ \0.*5r8J4\ncрAY-*Tx8T>?\nb'BpMa'S\":R5YDF8JvN/A%I\r-ؓ*`MyGG,,_).y}br:\$1``\rcRNδ(:=3jδ|A8I@\nZlbP4LjabbH\"O4r9((LT!L,2'\rWH8xJ]XqnJC^yCP9%85RVQ2j/u}*9;߮:Ә3Ίd\nD\"_.\"q~h6f/&)3d50\0v-H&^ 'WN6\ri=VM/%vZ2UX\rJ֋:A9س|dzS,)ͼԸ1OH\n)tU\"<ՇfAb%n#\"\\_hT%\"aMC;ƅ\\mɜ{p^C{(\"-535Bvzuvrkn6^(\r?n3UUbDB*3u~p`]<m´O \rKgWU[NǨ3Ώxt/6v%]L4\$` ";break;case"es":$f="%(oNbi1gBMi;,la6XkA<M\$N;abS\nFE9͎Q 2NgC,@\nFC1l7AL%\0/LS~\n7M:8(r4FdJx#&̆1*rL+Z	oX˕.ifS {4gCcpt:\r'*O{0dd}ɎE!(o7-[NNn2\\AjH}C2f5Hl\\S9㈧+/js1\r3OFF&5~:5L7Z8/Ø3ȷ\0s[ B'@+Z,F'e2P2k4-!)DOP\nL2(9el*\r(jK<9x'D,<QLnDr0  `޹\rΛzH@202\rTx!\\ی#ƅ##DN%\rD R),:5C3:xaM27Gr3_p(I|+SiN6\"Cx!F+F81:L,ڲë^H°Lެ#+J*s(K.\$/PJΌCʘuF,Hx:\\ےMBH14B\\PO\"6ht3 S)\$Γ\r&gF.&{|1ϽGJ`&=;-;Zgi3r >.)\"`ܮB1׵|sW:qW8xr|r*SB\$C΂JӬRz\n\$<uG.2;\"\$:Dsik1lDT\r}p~8i*I^}!l^#>\nPC҅\nIC1_.y<l>mz= 00a!IFYj/*F*dM1Hq#\nd)lR ab	T\r7-A)u!+@@ʹWj_*SAeu{UPjr[ބPDHaC\rBa5WETg)!BE	@JMe243񕪷J_,4S1g?3\$bz8&\\^X :GD#Jk7@m1RPd\n?#BK 3ҡCp`|ó|N n\$XB}ѩ)!l0]&gKt;TȌ0HXP	@ I(P25!A!HHAri-Zʠ\$=2Ayj;bBQyN3!HAHZFƹ d?MBo\ro!0nļHpCcFH\$#p3LO£0pDc/&.}W[Esi?!sPadu ҧ*JTzj!bE:|Z+?\"/V)P	L* e=': BjQ=TII+!Ş\n*@}H#-3E0*a/N\0&[E&ե0`?&AV{\$Fw->܏?(70wBC\nVB' mF1_@>(b^Sc9ɵ\0;1&,Ƙ^qp@M%=/-&:'YYo1БVe@r1&rFt	̂<rlnCK(Ve\rݎrDkS[3Ry/	]7il3 8Pc(*;b\n͙oIB<u>K1AEcGIt˻5HF\\Nuuю1A^\0%q2RȥڿiX:XC\rδ0vf('9	;@\r#~y)m/52SEV'%:Jґ >1!*L,0KF\\;jGv\$gAyOc.0gycc~CQjE8SL%rTg39iCS7hhm)a	:*rrº؀ kLeld	B7>x	[;yn]h9z.A/ [`F>Y;y@\$茄5p	|DVY.=	r@CjEf& b)`2} R@+sgȩ4(ѥd]뿹9#J7=N;mۦC\n\"A,Rf#\$Pj/t	O\0Hgz\\6\r-Kh\"m\$c.LFm 1zq̲5O.oL5C(40V\"1,oqpps4PsZwP'\$@DRvN殎~nxa).萮0nU\$2H	`Jc[\ni\0pDd\$L@B8:;%\n#e2bf4Cj w\nD(X(-JԚ\$8)VxƘP@F8(Z\rͮdONClͅMōd\\MϢP_nLN_	`r-O/-&GHp\"6):J2oG,=1B3Ѥm 0_ h(;#\$!\$Cdp:g\"t\0Ljl`V	'I'\"<#\"&zHQ(xb%rR\"19Gi8H``\rے\$R+'I#\"=,m֐1!O.É(ma/Ri#\"30	O0LVic1\r1sII*%S3-`\rf\"j 9!c2@\n/+k!aPV3AR7b4s\r\$N_8f]\r#0d\rVc`C9v#o!xgR@ZF鐼SCT&G]B'K6!,,*\rxr m2\"O#8\rޕGA!5iPs\rn]\"P0QJ&l6DI(w\0^\rzFx&D!Pp/q*f|b\nFN4xɾ0qTAd/FңIO[Rh|D9E2C9Ii8Ѽb CszƂFĐNnLLmp=@w*y2>,T dL6mF\"@MDT2s1|hSiOCQ\rҲ)&\$0J-P*	\0t	@\n`";break;case"et":$f="%(a4\r\"e9&!i7D|<@vabQ\\\n&Mg92 3B!G3u92	apIdCf4(aLA0d2ࣤ4iF<b&l&+\r\nBQ(ԉDa'89\rfupNI9du'hѸ&S<@@tϝNhgP9NI9;|)@jjC,@m\"ٳq|F=ZqF̶`*y㹸@e9Rr!eX\rl#8+/H:Zh,\$4k§C|7[־Hēè1-i5N;:*-\"#HKp9BB9\ra\0P<B87走\n0)xQ >\"xHH.1>H2:\n&\rjP¹*+2;@?[8@/1hX\rX\04p|4C(C@:t㽄\"-C8_\n#Wv\rR4P\r#x|țR'8j+|ܦZ-j2h\"죷͒䚭`P5P!΂>8A@ˊ\n*41\rhB\"V뜣^*%L\0^IdՌzHBxL}jDk#,r\nH90ycH5J;nX64<9lc(h@Pvf-h(7-b\r3z\$^xm\08Zm=<5chabq#lB*Wݭ8@+\"LGH&'n;X6jOsP#p\\I=eivV\0}2b\r5O3}2\rhӟ'aeC#A3bF`!dRÀ\\SQ1fhe	?`a >Dv8eC\$R\$0Z2nI'\nN *@`,,jʻW`5V:Ya2VљnmT[9΃\n:@BBi^u0!BRNJMʒYY[UZ+epX;HFc	֌k-X\0V=G\rpA`P[delGIXt(	rolCU+3بM!M6BUL\r<riT5jXi\$iޔ2^BމI#DPQ\\\n (O(IID,ω28FiL{`'&BxwNԭZi[sD3@u^q@jFrA-jN4]\rm`@R8L4j@9Jb%j\nC\r!4s;V6?9Hy2MRU,al養8*\$mR}IS)TpTXS#\nMWjG[k`H<uL\"Vj,7Ʉ3\0	#`CWCwM\\\"A'H#jr(3Rem\0\0U\n @oD0\"\"!^\nNɺUIJ;bx!@5;{8ʶa.(1HLfLXVQ\$?TPI]O:Lnqh>M^8[[<#̊3')-tUNsի,g'fBQ\n\n2Bp.Z1 _+3^\"PSVTFU1sv0yjN+2tk.\$ƣ_G V3辰L4\$,5J貵>?gp=npa\0iCPf8mIPT\nA\$#pdCV4 ise\$a'52}BE	P)w6a'th/BAa XJiUgHR)YdB&2`/@eM\$4b 5`I\$s`뜋K)\$t<I' i-ʏUEwU.Nr\nOQdDVDAwh/qa9'FAHzӖ&Ma0z4&l){M1hiW9	^;Gww	'sڒnab	VmlQgeղs,,\n?u>[|Y&M~%N+%cޛ5{rNĲ\nCQxD>A4dHp\0̦(/ւDCZ϶hjMl4VZ|\r0nn/hZOa#!VRLbsBOMD^'J!p6vz6tP}\nPai&кh,O-ʎ&.~/|t/pȐ\niض.ІzO#Zj%t3(鄘DIDFm)7jKX\r%aH8mHc%@4D|c'Y[q\r0Et\0b>e\\IE`\0S!\r_`1Q\"L5F0.R'N\nq952L5 xࢳ	 nxLr4' P\nZ	Bt	(VaV8\$*N!\n\n!pdȮ'A2{(ȩ(I&\0&G8\rɮ&C*ż)2\r徭n{DP(7ҡ 	R/s)N#(3/TKE`/*,/1-!, ٪2I/X*Rom30^.2Jo3?2D5~g%\$*JI20ʹ/!j7Sk.ҥ#3k7#8sf\0PMLdu\"\$<8\roNN-{/b)bO<D \"Ο\0P	k`2as,\\o)u'>\\,.@@*`eR(>5bF(Gΐf@R6d\rV\rbJan,\"|R?觫\np~Ƞ\"\$TA!fDJhl\n%	f\r )\r\0P0N1BrE9#ޠ҂)ZjRt4ɂ(q ;f+1/`4!A/o	cx\r(\$	}\"LQ1Qp+ޚKQR53;4430=:d.HTs_3XjS>9T*uJn0R <DU­^C&\nPYƪ\\e	eJ:!D\$Bk],LNNcN(Rsz.e<aN\0-c[-ۃShLc1gLNv	\0@	t\n`";break;case"fa":$f="%)l)\n@T6PD&چ,\"0@@c\$}\rl,\nB\\\n	Nd(z	m*[\nl=NCMK(~B%	2ID6MB\0Sm`ێ,k6Ѷmkvᶹ![vM@2ka>\nl+2H#0\n]SPU!uxd)cZ\"%zB1C2o\r*u\\o1g{-PsW㤵>--#JK<֋TsFT/\nS0&>l`Q\r{US!\\8(7\rcp;\09Cx䗈0C2 2a: 8AP	c2)d\"rԢŒ>_%,r6N\"|%mT\$͊S%楨J>BM[&%ES<HPW;'ﲲZ%nS,+>'.r%!R@ȩbҥҡ',2Ϣ8N\$#F0ҒЪ@XO,P2\r\\\n7@0c09c=o\nЄ%\nH4\r80`@Y@2D49Ax^;܁pVU\\3(ր2d\rT(P\r#x})ǒCHIAhHS,sH3\$̻8~Ƒ	#\0Q%<^\n7W(J2<nTSB?9+2KʨLZ)3TD%D2嶘HQ,O/,kJ,/EM\r/,.j\n+bMyjV.2E˭<8ڟy2oA*(p(*Ll3#u-'NXdK--'⭦0Н߇S1sa%3wY̐P!x7ǸZ &A\0:p{.dy`p3\0F# ЀlB ``2軕H\$B@PrDC \$4T`0q&4WQ&8@r(J5&yHEel&TTB{cɵ:g5* 2X yjDl8AVhW{ab1׺4;)!ѐc(\n\n02C ~*Z:p4E^[in- w\\ˢP.p/B|:0`37Ib~KeУ%QQ&^2\"!3Vp|Z!IDHTXGRU-V\\ksZ]S/׻Y%5#;{LbtVB0x%HOaFELVόQdK	.A\n+z\r\$(<\r	s]`O`oQbp@Ф`1yLa\r'fdcjG\"*N+tQ\n (L>J@Fd\nd9QIYX S/!P9z{*oY44\"D(f޲MJ6଍eDK_hef4F8,2!40bܧR0-\naH#YֻQ<.βW;Y%!PPR\"u(IEԲ]F)&6828U5\r3!I adYKi\rcUCC;-}X@:s#\$6\rb=G%0ldR`=wfnE:t.Ck_ɢFhr\"M&HуA>)\$JfB\$li|NRަCKwѥBO^hE6!)[*I,qQ\0PO	*\0BE:L\"Ptֆ|Q,VgWLUMɅ2\\E\"Ձ➥ɌdRSL7iţ{|5`DNi뫅%\rPSqG\$-#?GWWG/n;d1oTT l㘁QL< :*tyG;H>3iDf=::]dG~ռvQH3oMgokxvLִy_YXRvq:yI*Mk \rk)s/yKFEQےp!?jkP!ƶq\rIuB_^l0\\_Vkf\n!A8iC\nkh!rJM1\rg6>z\"36K;^xWOs飤SLF>8D\"paMLsO#\$#\08>%O6O?D#lJ!<hϰ0Ox .f:pLSDxN'/{.Iem-90xePD2IL\0Ϭ~2Rԏ|<P1fH~c87w0ꭎ݋\njs.#\$EI|pǐkbBkA H~Le2CMi mFeb+0\r x\"tCe+\"颢qH^dMޏj7\r3pj\rSX?p\n%<:gt}CnT5Qu\nq,j(B>g~ަ,O+	C&qg1)j.5.f&/&z-\\c\\wN'	r|NoK.B*2jsG'FP#jBLРlF_!1Q/J)ƚH\\hN\r0\nq'ğ򄱒Hȑ)%=qq)(wGs*{<ݯ>ejdF1x>RdN+j?A\nN)[#Q8r})**'2xn뒢\n8!0+rIyO`:n32r.59+sO26&*e65Csthҭ818\0֕\$\$kQ88(C*|\nĩt9lVO9\reo75=G}s}\n6P>cD>DْJO34e@/3\nQ \$LKdy6z-JnTCtgؾ6&,zR1+(³E\r򊰆ԃcϖQT􂐲A&Ou+\rVŋ8ࣰGp3#\nZ	,#QMG*\\Gf\$%M#@eXꇺ\"\r5@(iP&hQξJP?\"IC,Sl*!AT\$գBYL\"7S\n0NChQBc\nȉD(2MWNLװngYWkQJeYF)Xu#\$7XC_GWç'Pe5da\"LD*0quqQ3u\"dr5l+3E[mJ6MMVG sKROcD:a\"Y4ʍ=_i!?cY\n]bR0j8a5o<KODg	Czc6";break;case"fi":$f="%(i2\r3 2Dcy6bHyl;MlegSnGgC@tB\\ 72	aR,#!j6 |=NFt<\rL5 *>k:+dnbQéj0IYa\r';eHmjIIN_}\"F=\0k2f۩4Ʃ&ånap0i݈*mMqza͸C^m6>㞄;n7F,px(Ea\\\"F\n%:iPn:lنhA7*bn%#\rCz8\nZ#Sl:c٨&0p*R'(BJm@0@L7E^ԥ+G	#zJ:%#`#N	K`!\nBKJI ҕ#\$;<`2PI<c\\53D C93I\rM'&Hز&,	!`@~M\0G4C(CBh8a^\\Q˘\\7C8^J; ^(aض\r`x!R+#;#l@'λ@݌S!r52^ر\r&\\[O:x:8fMU*2II++-æ`\nH	p7hiX =j3LY=ݬ3?B#P\nN9+Mb*q?`Ұvidd5XT(j{!s#cm%2Nl=ݼ6İ;?s1{>Sܠ\"	* [ÁNfqV#\rZ`c<vSYZ3\r#:Z2#\nRu=[!r׳w5[d<,<˻E;\03L(Z@3B/[4=\nZ7h:E7(EMNB%šELOM@D7`ĔsyBCdI!\0\$\r S_,<5\0{ <\"&vX<Pl!4PcfCa\$AH`u\r(!{z(ŊKb\"Ԃhº_,rX%e^B6kP\rq-DTj\$x\$\$œOn?H/_6ػ\$H|C-TIDD\"mq\"hպWj_lyk)fP|Cr(+MjDhHx`%DSjŵV\0v^hjJIb#L![!CRsaFk3	T2<Ɇ@]!Q`eO( &/Oa&qb9)/@\n=fxqHţH\nM!z+IAC*FW\r2% (,\\&T'B LЦ%DLɩ[iU\":E'\$*e3g2!mM@rZE;j#\rճNc&) ZyEH\0[죌?IHnAݒIw\$ůdk3|aƄHvW-!ρ,½G,ぇH/e)Z\rhGM=bP4%H(jJPͱ\\=`l}!<x3S(x #(8Ԗ+R`cﬤ`00T2.A,Ix\"HH[.l.l8@BD!P\"P@(LfA9sqjEdf@e-\\rm \"va\ry8 Q<Tܚ`ۊhk37ZΪ%SmptL̠tM+ǆ+%[49CrʴÈq#4phy34H5C\r3\n.4\"];\$YSJtdf+{\0)6a7&\n_\$<탪dMkrCݷI!]^hgx+S\ro4D\${!RgAL\r()D^WH@K	6M;@CnIF^IZP<Mg~?Fāx al4Ȇ#.hiνxbGb_\n_L=:,N]ꀃsۀo7dwǰ\r)bKӞk?<憺+=9jH7Nvgcn=a*~LXXle`78I|f-̤K]<e'EZO}2ddGދf\n\nquWNwˠaWK\n	'Gw8479j9/YI͟0 ES'iR&(WhXo*cb\"A\0F,v!\\XB(aL,,B\$J+aP6g`D0\$E\"ڭNc cgt/ڙ Jjk@LODpSpKVƾ	f\0ͯЏ,\0>n\04IN,O\r)F\$4.+\$.S.pMähP\0',jN]`dID!d'@ԃ&JbQ\"3\$\n,q\$.zBj\$@۰lFKTׯ%8T=f3g!D\"bbbϖ1)\0f5P^1d\nq64/q q`1+Џp_842,(`\n&\n	D%Bhc#\"1p R\0^\0@hfÔe(s\"&2'b'ǂ2P6\nf\$)`Pg*\0*L&0+CNet:r-,ҾMf0cB%P\nr\"PoR1ҋptH \0Epr!\"R sF3.s\0\r\rrS\"IP\r1mM04\n%<Kq&R#a5c/\0F=cU.P\r- 2LĠ2ׂ\$]'\$~Ry+h\" <\$4#J;A(&dhG)13Nf\$od2?/d\rV6xK#o#hJd\np'G.RD1\ndR(&&f^T|#0:]Go\$&	G\$0(/cX4 |+6ѸcE8%KO.\$LԅVD/,H['\"-Clp4LCLMTM^|`7ҫ5EʩJ'\n Q}@@KljM' N<#\"pmRX ̆@#(qP*68\06UDl\$7uF5B0;-<H8iir-@F6O,-\n>d\" ";break;case"fr":$f="%(m8g3IeAt2c4c\"Q0 :M&xcC);fSF %9ȄzA\"Oqo:0,X\nFC1l7AL4T`-;T&8̦(2DQ4E&zdA:Φ脦\$&̆fn9',vnG3RtBpv262S'I\$6N\r@ 5T#VMKxrrB@c7iXȃ%:{=_SL\n|Tns\r<36΄3P\"Ln7;N15h#s\$88!(V֣p7FP2Z\$\r;C(2 (\n)`Ep6L\n\"(ê(c@a\"\n!/L\nL0PI쒜B8CVʲ).qT7326l9ϴKdXPT2C0\n˴J\r@-Z20hʿj \"ҵ\$A`B9}42OH\"N420z\r\r9Ax^;܁pXn,3(C,2`\"cp̋%@|/pŔTa;^ılj51Hؓx'*#(#c\$Pv6h @7h 6C5|<K~hKbL9A6}B8\"e-Dh?Q!:3;4Ϭ)M*)y\\ΣlH!vnj&\"^&;02D|/)vlUƨN8~eT)\"bN>vI#p-dS8A2h' E]]a׌\nR>\"8ֹM^!V6ۚ\0ھ^Q#0\n	!0bI\0>iK!6)dC6~7,\0n}wPϙfFx%w\rX	L0BTBGDvT&0<oqP5	lU#\0`J'u\\U5FEC\$^H0-)ꗃpk&\nnQhF [m-żI5ֻWzoKTxO\$N)\$2Z!Eb\rdv:EZ3EiNX:fMպ\\ksLb]%C2k+._rh]<f2حVgaFBhDV1!	JS<<DjXxukA2Ml4JMk7&r!ɜTj28\\H\n\n\\u\n\nr4(Ň2i\$*jɵ|D6i9JWmpZ&Ѷ(1HYxyk`SX[\"C%-HՌuJkX\r4ՃoD͝}պUBo\rk02*HD^IdVe*TE:(y\$Nq2KHYhh(uTae64++i)JQC|63x9-Be꫊Ihii6\n<)BQwY?*\\5NZ}Kz*\rn\\KIۛ'=XӲG`HBhͱF7wf\n&@A\0F\nBb˃W't]H\"KT2uDRShgPic4A<'\0 A\n%ЈB`El'n\\qR*\r%s'qDu6՞ԼS\0T+nk^mY>BN?)GM&EաǶl4&d*FaSRͶ7'R!D5SD\"E\$4\njEʟv\$SC1`ʣS;(JJm;d=`(ANuԸLlmlS66\n)OPI>_7?al;fY7\r`&Ii:̋T-Xb)u?\"ؗ*1S幫9Q3z]o)&k1ԲmPEuK9*tn]U*(!AFwucƺ(t|P7h*@B qG	Ί	sx4N(/\0)Pa#>ɉ4[bRc8\"v:Pd4xyE؅\$o\n輗x,mU^:z#Eޱ%y9I}ѓyohoy?9Eeo|TFNO~[!r#VlrEn\$`s%\0@\nONB\$3J_2AC1+;3kF \"l^ϣ\$jON:f&fR!R(prF\$}ͫbKv)fAҚJu~bW\$а#p~ЖfPu\ng2ORL%^YlBPqm0.#ց'Cf\"N5p`Mw1;	Oz/i,_HiE\r lOĜ\r-2{9p\rYqXijQ`xJQTX0&%fkxyGzP~O1D\\\nk\06-B0)q֏qM/gj.q p̄_ꨝR  0b6:Ő'e0x^̊RCr%bVCCN\rz.FGl>iB	VJO8k\0⎞YrV5\rd:d\"\n2p..Z>@0dR5	1\$d-\"-p#S\rb\r_.2Nѥ\0K07-{/S031\r	0S>72fjB\\PfUeKƢ2t#Fj@!	pa.[0\r3ts.pVr/3'V_;4ղ+O9E3=:DDT\n800{-;8-S&* %<O;S?AS?.0k81X21Δjz4\"\$)4D	BC\"mCk(&MA5NwDCTa<;KX鮊50yA,莞{1&4uHfA;An~tqwH,I.O,n1L	t0ArєLdQHHODM#s	?qUjoҲoC1}	(3Gd\"!hnx;#hkRP-QPaMOQƊmE5). )l\r0\\5C9/AclGO-F\$8␥X2\\1J\np/sӎJM7YR[Q'!B\$.='m~N?'KdU:Mh#\nO^NqA㮡!WK|4rY1{5V3k'q2pM63>8~UӲvHmd\\q 6F_d،\"emU𦓔eug©d\$C1	(<%d3fí-B\noo5M?lŎՇ1lW~A>c\$֑ Ҍ*D\\X/&E1R;ІN?渵eb4lqciIp1Ȃv\ns=\"@\"T,a\0NkJ4qp#";break;case"gl":$f="%(o7js4Q9'!@f4SI.iXjZ<dH\$RI44r6N\$z 2U:c@59\0(`1ƃQp9k38!uF#N\n73Sue7[ƃfb7eS%\n6\n\$s-]BNFS z;bsX|670·[VpL>&PG1\n9llhE]PӒq^k0&uQT*uC&&9JӐ: @9c2%#&:¸M22CIYJP#\n*4*\r?hҬ\r!)!:C*p(V҇4@7(j6#ç#B`%*~ԨJ0\\6<Z(Co9+dǊ	[@i@1@#\"@M:64L0ȠG8As\n43c0z\r8a^] i\\{\0UlJX|6.3/)jx%ʉcүn ڏz8J#d=hƧMRW\rB=<,\"q?B7.0((J28+T6jJv='#7O\rU'j\nˬ&)(G<ws!x\r\\\$#;631lzqjRzp9.~R2BdbxDN\\8\"y`lNOC☢&U\"7j\r78!OYu \$܎#4l۪9صto-Rn(5\rT_(6ǈ#.޽ u/c'b\r	YZLf9!/\rB9<ͻoP	aL*[T	먒)~\\>\"DOXgqnF(jҐ0h4p鈃Q4uғQ{JVQnE\n0))6fHD	>@A`\$zM I\"\r`S'Q#z!\$-vHa[q*\"C@dW*^:d,)}[qS%	\0002/(KlH\rd*JC7dQS/ӝûU0:b\nWJ_,#Y-o~>R:Z~m-t(S>(\ri;tD1B5n b5F9H	\\S)3fSFP0bqגaμUlj8ap6?\nxD4aOe`\r\0PRI`E!^DH{!\n VG\"a%7ԸoSx7tɀ\\QdĜJ/@\"FNv&a.Oα)D赃U5Њ`i劑@6D50F}(PB(nB=H#ӈ'IoM#ipM	jPlBDrC!b8YcDˆFj	7DLzإW%Y|Hu̾q`BO\naQ\"qky\$nGŔDZ8fvq)/F_P\nBM}(BJ<#&9ki	-%zP(veZGrM=@_7x>y(ɽ@)i 0BL	!h *,p \n@\"pA%A' q>)&\\_<oY<_A\0P#d(fuIa<8]^Z;G*z.{^ELǹC<:f,uə&;\n*Xbjy\rɹTй@#sjM)\ryXjQ\$L9<(T@qIDzH[\$c6pX=|%\r`7a(T\$1*nhJ+֑SsjH4Y:<G<MKK+?ט6	?H\0P<4Sߊy\n<{^N]0Hk x(05LGj;fmP9t)]AIU\$R\np;F?T[L\nS@K#r14Fii{Lų<FSNX }>6.\n	U\$¬j6A(P]wxIPZSuKƾB6J^^WhxV3Յgx*娪\nOFwe^ 'ogU2eg-zJ1sFT\n~-	.J8S`ĉwλKUx<n#*lΈ7rWiR\"KuƖ%cP2,Jo\0\0O'\0`F	\0Er\"C|\$vxDe.pEOg\$\nRI@ʜ(\nLL.OB\rMŪ 3~'\"ZCSɬJ\nd@dB\nL\0ml0XI\"F9\rM\rwbѧ\0pE\ruN8}3LM.08-5NΎ1*Z4ʤn/\$\"/QbC\r.<Bdqvi\r//.Gf>+y8ZW`LCBȆD\$^Gk\0\0@V\rw{\nc\r)dp<qM\rwL1ȥ\"u#C!3rx_MP\nB\$2<\$r@\n\$p@7 KO\r͜ހ#\"7qK	P\$ҊfI\")e)Rנ@hLq(&8+R4'+dr˵zB>P&\nty..|=sҳ/%S/Z;R0n\"(b/1	2/92L\rdx)`+,B3>Ϡʄb335*ʄf\\wµ4ҐQBv2q1Rl	+qm)NPD2S~C93s`9W3383/&HsM%#SW*9R9<@AbFw](I\$,5+#p(cB5*&=cHFO4OU(\0Q@\$t*`J `ƩƢ@3io-v1E'\0t47+ހT\np:b*t~\",!(xy+?2v\\cb:EfTM묩)4VTy*\"QG{\rN\$KxHC>&Ԯ%)fa'oP4@DACQȋR\r!PJ% (b+\n,SQDw\"B\njmqKiU,VWQ&A@&:\r>~RiDʕD6xobL.)'YTM\n\$^ʐN[~d&j;1jw	9\n#!\nB\r";break;case"he":$f="%)kƺAAvUkb*m(]'mu]2וC!ɘ2\nAB)̅E\"ш6\\׎%b1I|:\nh5\r;*bJu<UBk0i]?F'1eTk&G~_&0EAd4U¤MBi~ŕ\"U hn2\\+][vGbҥE(ŷMƳqnNG#y\\\n\"Ne\rStN/c2<\$\rC6\"iJ\$\"k'*V*Z9гw3rk(@s5K%L-LRk{0ͬ<Z\$\$3iH/4v-ry0b>%zZHiR[!1S3i|ľ# 4\01o<=s;#7?\0yK3:xW<<As3(42z\r+<(\r#x}z6\"ݡRT#Ap+\$4ɲ#J9\rB\nr!MrO!B&hBHJ9f9/s4(%z	|dkw!S#\$),\$ˋ5E\nH0P,ȢZL]JJdlN]6ͧ7R,H(L7mJ{\"#\rs[c78R!\$2Kf\"z^2_8q9CjI[t\rI@6Ou:{ChZO?@93\r#?H22O\"\r#6><gp+,:\rk\$f#ۿT飏,|*\"9Z8\$e:Q%(d\"'.		0hBp!\$4Ȋ	GI\$dradTjSVUxwV*`/>O\$:,v!,F0NX%F\$2M3@PZ3mNSʁQ*ELRUC̭ʻyD7=8~i1)7rDI}\$ԉ3rXMKkkcQ:d).VlGQ%@|=YHd WaF00f6T\nH<)^LqvTk3`E|(A=2%`ryp7(r\r!4@,>-)@̛_\$<x9RWxx&%\nUL  h\r!49jA!0ʁ_(@8_N,t\$E4CN8 x fZ48 2(@tLqbAT7zb-N='nIy\"hNLC\\%ҎIam-	?\\\$\n<)JDf12\"`|DJfi2`38d\"}	\"a8:\$8KHCnoq|%t95HfHQ!MJ395ceI+6	P7TZ0NB&3N jHRa1#Br!o)۲A]˛xL\"240DQ!7UԔm35n\"`QJrXA3|g2}QỀd3nf꛳~Ғ_,CE̆	\rvfO]d(\\b9.!]&e>l:2C+Raќ6)/9t\nlH +Il˩I.6מYF82^hS	\$	\\\n{_\rxC5PQ𤁗J[H\"rH\nan,'`CDNhW}f&q9u15E0l;) BT!\$0羂*#I-e<E (NR3	,c\"D2L)ݿ-\$LվJa\"'LTipkbm/Y.H*WKX4+jPQp(V:a%\n!q\rT;h:PxFxP􁄛H!dVi3LĮ^>6:2)vN6?UybѤI3,fLV۟GXg8/)\$%</cFmi\\D<[pn.ni\"Z=D\nK8]8m˹k־)Lp|⫮`;{N/ek%uy&\nnk_ss;];c#S}7	:U~~蜙V~+\"OobC6УhƔLd%D~B %x/~'ĨLԹHBWN4PK.!+,Df@%bO\r dn\$+eHBBnOMt\$	\"+\"ж0c0/Hfq\rH#~ Θ-K@M1nlopg0g]m\rcefFKH\$\"ào\$DepoЎlqc\"1wGz\"MXQf5DÁ`օ#ܥ%t>/d	9 iSM)C\r3 \rh.\\7H\"T\\1\nFA!@mK1K\"Kn:QJ /wR# 1Olzjxg2\$*,n%6<NAZ7\"%fB-:`VK8А|7*\04N_}r@Rq'o4 q\rr-8x\"j&.m\"-3D%i21FT+(&Z,1/-կ4ĳb0^\$~f*\rP'NCϫ3D!F0N<4]	FA4ʷ(5L#p\nRd[\"0[jj:P1M-~GF+ow.\0(hqHc}jp%liR*oOJs%65b\r<@GgXc9!L~!.\n!";break;case"hu":$f="%k\rBs7SN2DC3MF6e7DjD!iMNlNFSK5!Je@n\r5Iz4B\0Pb2ar\n!OGC| L5\nLL<n1c*))`k56Lԁ:'Td2ɼ 4NZ9@p9NƓfKNC\r:&hD7, *msw&kLxtl<7cVAgb=U\n*GNTT<;16B5x73Ð7IP޸oX6*z9C;\"TʑR&XҧLlR*\nh\" Ȣ\$\r##9EV/BحCacz*.6.51*e,\$HZ8x-\nձ2RYBR4{{93\"=A\0 mk\rI1l(\$t 1BA\0\r5L\02\0x\r	C@:t㽜4ґ8^!xDl.46H7x%BR#b/5c')zh˯n/&	aaCR'@Py#pη#ΓNC.OD\rC'װsk28>]6V- 3#6ר2B[dì12֕:v3>9V\0V@zl %pbP5+ktr80&W0LEL󛃇\njeЂK1GH_#-juD:=(6-3#ű#mHkx<zxZGJjw ܕ7@g\$ڞvPG0CvWC]a4pN>EMh0\"kl}<ܪXs%A0Fi4H%MYF(r4@!P3N)AAzC#NK?9\0T[` E/RɪPU@W8BXd,ZD0-Uy	u} K'dJA=6*Uze\rRjT1t?\\-tȠp\r\$+*Y+-fc~[rB	\0HH̉!&Hd:96H	e@hEETr+\$ðS\\Z#HL|#r+0؎dQȲ \$>U+n ȉU7@a\r+yFMhE̔I#E1:^K,\0(0gTVȉ*AO5XY\r{6ّ=2jpU^ܹ\"C&IFz>\nhjIU01bW(Y\0\$XǜVjiNJTRČ=.ZŘ.,ȏ#Ɵ0+%3 S+2tSk\0p886:(\$0iI5]NËSd3 %c 1jqoţhP	L*UszA\0C`پ?<zYEssRݹ0tP76IjP`#J`0zs<eB.s)	g5g8\\Rhݹp&4ct1[/f!8pj:b1pPze6&щ3%Je>(&4L]TJe}שᨒhPNzsCȵ&N̹=PF:Gڲ,(Y1 g\r-?W(i0p5zy%LQ+:D0bj	E\$~egrX1e@޴K\r\"D) j՗evkwRQ2f`܇ |^	!m7\$v熸js]N\$kW~#fh1ٽ52Sl[)rF=	޸\0Ie9?.\"ӃB^\\Le?%2{!P*!vP4Ww6#x:̲p^U9LuPfTCvMZUYNU\r}D%Va;JoNOs']Ԟ#^}v\rOo=>s|i*=yMInu^\r}Q]*|ǅʄd[17\$k哔\n_&YM/3 8eGJQ\\Ln6L.v\$x\rX4]]&H\\iŶ0C0@049*b\\#5dm4¬Na\$G1#H#MyX/ffi3D{zl##\"QN#C\"`Bz0Ƣ~-@^flm\"j)@Tȭ0Ll%*.ʛD}\"dcGܦ.fM\r>t*HrV,x8\$Н̌8,eB\0wQ@v'wdv'q&1@vgXCRf\r.?.RhDtQ\\1bipnc%not61x-6:߱:8߀آSL5Ѽ#lM9iFd(,K\n@2`t\")\rez\$\$s1̃jgRWf<eLNԞUѾ\rQƎnp%n`Q1PZhS&I'Rm;(1Fw&e*._0M)n\\(1W*Pa.Z\"2,;һ)\"|	bT	s-@##(o,V8BER'\r'm/(Pf&kr&ؒ;o,'#1Nm,x3!2Q+2\nNKCR\$P)`A<{C5M4GhsFAsk17^R,>0/934PA92;ӠhNʮ!dDN᳴?~>u;#Q<mSH ⳕsS'%90h\ns44D%**dOB愯1w*Ct/326H3R%c o-4U\n&d;\r\n@ʾ0/Fh1G0~tsHoGfO\nB;\0oABT҆EQOKO?KL3_ k+]eZj-r! ȒET\0\np%QrCcHU&U!\$Tb \"B(\"\$},g0\$BI%;NPaC@0HO`:8*øAV/0, ~m~dEī;Y#C7\0g`\0p:P^`f~;ntbD#B.Hp4b!#]m]]c9.T5AhhH{u<Rj&-\"u]B\re`s n	eEk\0gT\$V8F\nNv^?찓2F \"4`	CTad\re|^C_\"e`-ah^ޢˆ\rb)q78)Fb,3-afF@\r";break;case"id":$f="%(i2MbItL9(g0#)a9D#)rc1M'I>na&ȀJs!H\0Na2)b2ar\n 2T~\n5f*@l4цa\$E8S4'	ldu'c(oFe3htƝ\ry/s4aUU/l'Q!7nS>S/W95&n/x\n\$NX)\n3 Щx(6ǝӑ\"\"CiߚyӇ!9c\$9:A*7;#I0X\r|iR(ڑ+#:>%:068!\0AmhɬjBS;87QZ%\"m N}kZ(H)\"8m	\05Rڗj6>1`3XƎKDâs?`@-@2D49Ax^;ru4\r\\z&o2~\r34ƣ^0\r(	Er%\n5+Ldtt+sx\"7?9X6Gzį%	)w\$H@'B%0b ;@%׃@#\":Z1q,MXJ(Q\n:}i#.#ㄖ4)\"`1Knb׵4J\rr+!mni%~(2l/=BKTZs%jh6_C'苨Q]c\rO\05po|!0Ҋ|0}		&/+/<'1; ,3]V%0BNƍ0̴SP7r\"Ϝ:AtCEcrrܵaJKID*1IYXx3<9PRMTCEѴ}\"ԪS*mU@7*}rE̒cʆ|H%^i\"Kƀ*SvQgCRYLu4T\nWNK\"Um8u䜢9\rq/0\\#CЖiOhH1XHf|Ɔ1DpȑDau'CYoy>\" a\"@1¸P::bRdHE{\0\n0JA,\0POL/@8ܧc;Hc0Wk&C8yFIDc#/B84J73H\"Dƌ1ԁ)41{Q') (L%&^!7\\êya+P@ c1S?JD̚y\n\r!v@ɇ&+7'\",C<MS,5О,!d@xS\n9JI1睌dNRL\$r9,!9E6utr@	W*[0T	EʶpD&G\$)Ȱc^ԲxxNT(@(\n \"Pl@\n	Wd\$2D\rRe*H%]\r9vH02X:gUzʏ/I(V+5Q\"R1V]0OQ#jAky<lc\\*!R\$OӔ\02%?Kh/\r\nf`_%n=0wjG2Xw`o'RȾXACL9İ͸IZ/2;l^7NMqa.ڂV&\$7WrC5CCK145iq=G5m62O#jbL&x\n\nFؚCkJWK\rta Aa R6xf\r8Vt:XdAD&1%!e1ق_Im,TLYI7C#ni\$U-TwV\nh\";S%l00t+&*ΉkrI(T͢Q4BhAc(HT5l9eTGBiD2tZϽ=֪3H\0ԵxG\r-DpޫIЧfw% 겟=X4BHnm('k\$Dt\"P'{2;Gat>)ZeO%\0CjnGo*?[#YCۚ6ZǗEn䡧cK}[Y.fc.̮#V>\\ZdBM8txǵ xV>o+}c廥\\Ϟ4MD%crqNH5`Ժ	)uv[\$&fN1DZ+\"Kܖ^D	7g,v6~y_BO b Y\n5\"ow&G=`+ZBKk(gj:@ƬfJ-/4rw\0BEbpp,L.ox#G\"i\$,I`d0=JkP\$|H0B牆~0l__*io=\rk:]N/\nY/{`@_1\"#(|G̕Pg`I0'%0(L P\0ovʐÌ\r1EЅ	B[FڊL[dP[PL	d)\$pt|I캌Px.ͨ#Ѱpmf_\$n\rbzOL<V\rVT!bȫ|Bx('ODJ,\nZ<Ǳ\"D~<D\$FOWJ `,fCb;D\$#gZN7*'& X\\EZQk{&t9'HH!CFIK|=,.Fb,fqe*NTbLwRkR`L`NT0oЉ`XdheL9e\"`[/ @\$R@I\$°@8pT0J&-%*<;w**2e.`#-@\r&4\rdNnN+dN E#";break;case"it":$f="%(a9Lfit7S`i6DyA	:fL0č0qL'9t%F#L5@Js!I1Xf7e3M&FC1l7AE8QoS|@o&dN&(fLM7\r1xX(-2dF}(uG&s4M\"vZgZ-(J.WCa[;fʒ 1Ņƭg<	 gJerKDSd׳&ZQT\"H&9:oS!W3G#sѩ8Lg{AL%,BRP%&J\"tjh@e:H\"=@7c4PBʦB87f*\r#&rI`Nb(?\rã2#^7D`޵#Ll2\r[: #1Ȍ*\"=%/i(`@%#CH3:xK7Ar3 _A?o^'laL3-	x\$³޺\0=%tíM|:+͚/K0Y.5Kى 숢,7/ġ(CʚWeܥ x؎Th^jXK(\\1+-B4֒\\Y\"30@1J!+ޱ4J'N\$Hr'5;3lX&1<IcME ^Z9%-]~#pȈb,ﶶl={YĒ0Yl,I̻2	#k9.NˢMkf\"J#8(٧\0ڐ8T`i,05nQHIWt0.hH35=#\\LJLȀS9HL	ޓ7l\\3YTȗ%A2P{K-=xͣs\"g(}-~ŗZ	cɾbl!k'˭|wL3\"MH0<`dCpkt9\\8 *m0%yq (&TzRjUKu3\nJ[\rT#P	3&T0aKF셇'^yd@fHn\$g1SC\$W:pRaM>؂t<\$:n!4!)\".0&͘АJq'#G)n8֝W(IAc\$!(Pe;nr߁F괸30eM&i0α^bDw80È)4@D	A\0P	A86{('क7t˱'3r4OmdNGtL׷^,AntfoPUf)EU5'Y!5P7S\nAL@*-f`كIoɐ	o0_KH(ș:vOqqxPVhȍB	Cd|:*OS%CѬ:y8BxS\n曕\r3=I8^ՀЬf\0PPF%rC;DiDh+\$h#ILG{+*&u~4)o'@BD!P\"z E	a3[>V4VsY(f052e1XL9[椵PZ0qSZs>\$ՃX_mw魷!4S!27tHww'b-nHnlhй3f_MC>uOH#lY_)MZS!\$F=ad@CELlk\rq~iD(5բ#+j~P\\ggJkYh\n\$,RA cD!&Ӡy+XRJ;0I|9˫ (#+6|LM\$͋a01zh@@ d\$PGhro&E4?^\0R-!x.҉eaYI9 	-ClJZ&&t\0TħlmS6}MaN(M˙vi	2ݥ*]Z=y[l=%ކ+[\na;@nqr40uE?)jeV¥ G&+d@8'&sY+\"3\"rY#2YAr`JE2Yy7[#V\\n\$S՗XcBRs&}hS^\\\$Fo+tJ	9B''E=\\&~|s=f2F⻉7pyךXC3[tjT랫iF%[3zײ\rGwVz>Q\r_F;gV6S2ex6Zޛ\0nwn?;N03=O/k	^-ni@6&)ڠʕc\$Mn5OJ6>\"d.#N!IFK{*\n(&n0x%ܡG\0fR\rR\\\rf6mafʮ\nc_Ȗ<\rJ`Ohb#\0%=@\r.k2\\mob\r8Mˍ\02\"ҽBH5M@,be%+&R0&@:YEb##8HMc^bQbW)OQ\0OD_EfGF=ZGW/& |iШwh&aGͭS#\r\rhj&e^ad12'N.^L?Qq#İ9c:#@3'(K\rLLr'!KQE#QK#xP\0\"=RSr,8\$&dHJq\$I<R[^'B-|]r0ʬI]h\"-hb1M2B'`(rҼ\n,%,d2J`9`:0逡oac;%^Nj Z%mvKS2iBbL}[0B@&\0QR5˿0 *:)0\n<L)\"K*kVU r>eR%cg*\"#-\r7<.F,b׉E9RZ\$Ӽ4B;>rFӱ9:3:W<S<<\$?	X	#EE@FL	=Ng\\FqdC&:E/Ն\r1>	X˸s+&Df07Ӭnmr|kt^\r^Mnƈl tΩ)HZb\0#";break;case"ja":$f="%:\$\nqҮ4(b*JqTl}!Mn4N I*ADq\$]HU)̄ )dt'*0N*\$1)AJ堡`(`1ƃQp99UB[Hi[x9+AFCw@~UM^_PPU! F^!UМR<I'2mhK,/P[PtRW^XEvu:kL[&|	W~G*)Am4TO;%~sC\\10G\$%ReK8myCd~\\#%{A	Vr_L(Ce\$\$i	\\se	^1Re&r@I	Fd		\n@ư'HFĺ-:´@򘱜ĩ`y.R\\DNK,U1	)dDK)<EpAF%U%J!1<AMSOG\rp<A'9PW%\0'H1f[Du_5l3XVPNAiy`\\<g95Hk'VȂ2\rH2QMD-KM]Y@@GC1R1l_͒x2\n@4C(C@:tL7Evx3(9pJ(|t%Z^0MW9tze,2I&dKzZ1\rnܧI7QP97{ҁ8sV)\"EA(ȤW'JhM7ѻ1\0Q2U9@?GN\0sPKSa3.sQ;%vs}+'WF[hd\"^KOi/?*[KJOHMeH)\0P(gO!<E2w9\"zηJNO}[,IW=n;\nPn+nspX!>􍻚re5Y53%FiBL Na2fU7J\$HEÒn\0sgVxT!J,a:7cB\$aLO 2HII0^HtB	{bIJa-#,K\r9)U2BЌ([a\nJT5ZkED\\uAbD1B5oICQ|dX\0ShlO3j#^+uҺÒB\$\"Q?t1Mf(@cWlMA.Bb]:#dX˙27Lg @p\"b;J!싐ǈ ɫ`BpOw%Iڅ:;Y(y\"tR(%\"T g4Sm18Ǚ\"d;U0k/f,2̃fl!]EA\"0)8UD	CG.mΧ\"'1znb\n~(Bh	&+Ղeu_%b	 '(D9jSaHů@DRF\\uI\"tBM3%@PHQF;2/K(Ϲ+ů+@%Ut\rq.\$\\d%!!`)\r0j:@=QJæbEI,%\nD)Oi)B40Bs*b\$<#ʮФ^\$0#q5 #\$o:HX!TR%G*5IhM@@B`UW*Ur}ABC\"HM-]~T(Ђ\\%b**+%/U;4y\"xs!(	 R͢}cLQBτϓx@Y< e2H_9~ 	%bIw\"\"Wӝ3KșXrfRzd	`P(qj# Ƴ25aVdIH.v4K5QJw \"\r!E;v]:\0U\n @x &].\"<A9励Kx1SS{OyoJf%eWuFLϛX}̹;{\"؟PVoIAb5zԟL)ˋcsBHe(QTR5\" BF+0c4ZآBEdS}ٰ5*O&0\"߈sØØ\\7?´ty0BWiraɷp.Z\"'P1-LclbPugNĩD^%\\ZvmJf,)ls{=߾1AR1BO]'C>!6^FHJ>{ׯ	qq}RCU/j@D?CF#5Lwx<GaB~f\0^ocLRf.jU\0\\NT7*lIc {i(E6Gjꎲ\$c14Cdvr1*FZ*=oɄՅMbLo\0^cn9p޲j\nExD>,^}0+\0&ˊmZu\0!~.PH0\$lb;43<lmg Pd,q mCf7f8,G\01%@:Ǆ,k*7FR.614qcol|QrQX7\"Ғ,{JrG(0*/b/DDh%Wѷ1L`qrc:q<O6pglԉX\ns|\nq+1BB4DrX\$n\$,u-!3 6I~n1!#lQ!Q\n'!B}L%U&QnkrlnxMcnk\"JqdǰsMM])j/]*G\$u+.~\"k%u'\rZ>P\n nS_2>c!G.EEQKcPkg̾ML\$2\$3	r,E|bSqlT}hJhjA0]j#,N6N6-6#2RjRto s-R)g9fZ|rw6Df0!jAC<^@LP;G҇t҄!2R:???T9?;2VnfTs>m| BBnFQ%AfOqR\"!Tn8A/F!FrJmTSr`C4x6T/TJU%VRr[9s-tTeJ6OI5F9JԘԟ<4e!''8N_%_N/kNt*p4@ANNUN4EQO62OKtµ[G8\ruSu/\00045;G6sJQRM%IOsV-VO?5Of(\$O(9\n6I>ApՊ-NAtXoS<Q(Hq[`@rl\n7}lh\rV\0'(I~Hk	d\np)3;(Ҍ@A\"((6V-4z	C`GB㨷Q36/?`(!`mNe0(N\$0ֈ4T#>4\$%b˼ <)\\jc־\$ vSVAǴ!(Q\0005n[UQLi\\Ň,UamBxtOfюf[2CM4+rc0bINLl!6~Y7\0o\rk:>UW3'8\0jw2SZ%`mO3xp#Cz`%HeHNQ8e|c>OKT\\";break;case"ka":$f="%)RAt5BPt2'K¢:R>5-%A(:<PSsE,I5AdNi=	  2i?cXM\")v@\nFC1l7fIɥ	'\"1UdJ	.eiJ\"|:\r]GR1tYg0<SWµK{!feMs'Im&K=e\"r'Q+˿}-<^}nnZ,:K<թ;SV\"zq=o۳*#\0LDζS:-JsL\"4Mi(N\".@9Z7BŴϻ&Vl7RRrF\nKt-Y(˰KpDLΣ*x#	Sj2S!RL,*ʐiDO/ۊj\r1ЧK(N#VJsR(TOTS)HHE:1	%iRՎM%jtfG,>C*^͵LYP\\t6\$\$5;b6#p9J:'TtYRoe\\]J[@4C(C@:tD7{x3(9PJ|(W||MQjxTӧ dwmN	=kRzM;cڮ@CMHh<McJrө*m\"+q(!1lmNQ/O.U/]03a\$?VͭsDj6j7ZNC-]%:o;먿yoGں(Ḩt=I,	Bh!f ĥiEJV{5fоꚋtzܥBb-<u:ގ!?<+\$L\$j(6TUs샇jfnYVS^!+q5|I2#%	^7&	[Z-,̦!8mFX0eD 7\nQ4dBT\0m:1\0Θt7\0CrA<LX:a7`e1ꘒI4Q<%mi+L>CX]¢+EeV`tNбh}d(](G1 !4xfH&D^1>R8\"N+K%gܕe T\n6|CWƄ*fW *N	Dā+\nro)an}\n8i)vJ{Q^K{/3l?ӭ`JNDM\n>LEV.Xc셑YS,e2G@Ltg· mm6=c%b-Q4MSiz،vB+pޥ!4,%zSz4h\$\"F(Lގ\061F,ćvHɧ)elPps,:HީC=b&Rby-ԙZ鳒SYgfI@IũBCT4˧g&E&dN#xYqX,-)xPxv=\$LIM\$3H	4Gt㐶F`2O\0L_bmۻCN뙪V\"+M׼uwj.\ninzs\0L'[H?`[VOv܉QI>&jiAC\naH#/T {#6H܋'A7W^%iڒx)U15ymE\"K?v2X7P[PGB@%{R-Yp\$0^xʽ&l{	Ph\$ַs? ¢4(\0ɭjUt,bKtSWdJ_MQ@e%Oe+sձTS`a^mD9:\\?JD3M<&B5oM7MA(`ޫֹ\\Sa%lIKcc+zI4nQkQw ʽ뮮2oHS>E	2Y\"p'%\$x2.~DJК)>t<0KְiU#XZE|P6@>0SH'2Xu;^઄w5Qqߖ0uBHo;nV]B+j]|ql^a+|Zb	#E:t<`od\0C: 1Zxt<C	Y\n^si^QLrR1[ƪQJOt)nꍋsˣd5nzNpGf'/!4P(Cb|2\0y2}xFL*\nBɶ򋌄M\rZbeGvg-GZU\0`)P*Z,m0x*݊hn \n`_(l+M5gJF1fۃmk.\\\r\0|Fp @X~micDţ#(:Bxth%7	p~Ov#tgֻ!\rоV³E0DPE'ƚv\"-¿<\$.Hm%aOxGSMoIl+R8FևK\"hۉ\"yne,NƨF\"kBk@VK\ni,~2kl\\dK\"qݏx!Dюl04'	mk4(-C \rr8F0Ϗjr<Nr\"8ʗ\"\"T,JXVveXϠ1Rj(i'R(HLC\nrz+F0Bi(#,'Q\0'I!#CM4ϔ.ش\$\rN\r G\$nWnF#!CN. nr\r,h-7@top2f&}0(nDj1\"ݓ\nN:-Ma-pPE+΀B 3A!\r	\"\r\r/x1	Z%j8\$O1;\"87w9/m'fFT/v#uG۲R\"3(nfZ'&Br\$,ҿ\"+<XҬAQf+nY,\"ED?mj^&k&V`W:K9/9P+?<37O!\"O1QP:hDʰq/ɟ906rfk.\"`Md{+::W?8tv񔌳麗2<ZFvi.4eK*S\rKEK)LESI#/Tr'ԦI^&TJLaNIEZ.,6;r|%DqA'D\$b|DI61SSKAS6\$556]4Jt+I-OϨ|U52^l!V5fwft%;UUD=XүPZ0ЇS4np%/\0L3Nv4k6tYmWu*tCN~%qS\\U-[S\\r6T0UQ`O:&\rf&f@@@e@\rH&68>vCdhГ%e`e<\rAdVH& f\rp\0\n&s޼uL=ijR7FUI1i1!7uJUSr)tM+nWrrjSX,5a9JVW6uU_lLFX/8UF]5Z)K=\\Sl/rC(4ǷmEX^	r&Najpo&7q`ک<Qa@qklzb.qy5<?;E@B*mqĀ\n\rse4Oll\"\"U\$0Rp,M]?isn+kDpZs]dei=uI4%3[4W.Wx=wJX&zxCAl%m&T1X1]ZTaKGR&:܈3Ӥº3Kz2F鐶~{tY##G+aA3zd, -E{\\wx!QO4GVG-韍ذ?ImF?N]V:RM}I4}Y)%2F8]+fX,qǥ\\8(l6/5H7藵s)Z2QɜBLRwnYI\r^@үĶ`/*R#2<L4`";break;case"ko":$f="%b\nv%Ю\nq֓NU)ЈT2;db4V:\0BapbZ;aا;O)Cf4)؋R;RȘVN:J\n\\ZKRSȈb2̛H:kBuY\r֯h!a/\"]dێri؆&XQ]n:[##i.-(Y\nRO)igC#cYNw	NL-\0S0&>yZP',l<VR\np7\r7IX00c(@2\r(A@9DC09Ƞ\$aHHAGE)xPv	RX3bW#gaUD̸=\"V3d bSYa6'0JI`SA\0<7D!`uj*FRO+9:e/T-M4[Di0t#ZvBk*u:I	Zv(d# ;1KQ1p\0\r1\rH4\r㭤ECY\0ym3:x\rdB0p_tcI|63Bl(4px!WR5=S !@vdE\$:aB/i;<\0kh:eeiU/!NF\"\$:n@#X6ewZ-E:BQG(!LNpy#:WQ+1NHpdJUY@V,ĻD?OÈJ\\Lb@VS*δ`P\r,6CC0x&<R&P<\\年KU4MXEQVgiRe97{UCOVo:.;!Z^̓RjM\0-/]qʙb'6P戗{^A:\$!史WC>lt3C,%4hHsvj	4L2VlEÑfI#JAQ5G%`_؃AP7( -E \r30Cr!3m\r>k2\nYV02E.hw X7 Pi%wת_+~X`Ƀ^\"\0tc(Ϥ2%p<͈Rk`mPH/%J%Gu\"/f/ܕ1E9W/]y/E_JD3aQ#ɆI\r!4ˌ7kbȥJ4ܘ͢@HB*m1nL46;PĆr9:tn]Q8\nO᥿DNi5dDRiSX(jʁ*iP°)C>3\0Oᕯ-\0 \rJ2:Bu	\\b%red>Ú*Z6,]uHc\r3pAOwpX2ً5g, aL)b4!X7\"xp]7\$h&@Aԑf9HȘ>>\"#\$Țb7Gqf/\$|dR:@HS axRI+	\$<T7*\"C![>3 (ɵ,143T*d(\"yAJa\"]vHɹ9'x\nBkGPP@(/!XN<B. \nnذM0T\n2ia\"dTĈ%LREK5#y`3bc861f\"ukssxo 0<	: u)ڰ\"	i!aER=:Q:#u,r+R#]W(ͮݝXT>V:73\">i#/h[8@|̛clګf(L\nzN 1QP|k=iRB7uzWTNoDJ8cZBDlLXPsWN9\n	XxsNyD5Dǵ\nӢݞ\0ޢ'Yf-҄=zzBhb5@=Z!`'\0PC^HRw`B\r':,O;=vURb,(sgQQ\"vIRmiZY0C	\0҇\nY\".Y\$\0d/\rp22Z>hْZ>լ`O#ޓDZ9|ዚ~[]_L~k}' *FϏE~ͬj)N cOvoR-ˤ%JVidn҈{NB4gIL49`?'&r\"=;pjFM#Fi0#\"epVpRR@>Ӄ%V6lhO\noIP2¥'k090i4R.2dN1cHAF(O>7)IqAbӍPθ0\rFNl\r\r[<ٍǟEʹωol7ی4%pܱb̏|\"P1hڑcɗQ<!FCO<	TC644:zqЭP\0פ 1JQJ1Ap:~bj\"\"lm2%Æ1Pa:QC*J`ǭg+u, \"5%)B]&*d 0glb|1rNͣp\"gҵ0\$an'#2,!\"r6/Flnt&D:D\"iH\"b#A66:/92C1	+:'/3-2PGAb6p)Ķ8/'4BA-/Y-d4X0b@RY4?/7s{ Ony7-.AHӈbA8edQk.;/53=45PRTs7:sd\\C~CqP\$^.>d>o>I5?Ď&Y+u>.\n84B!p9Co*<sD-	C/E4G=.!`RD=B+Dn@F*DzSs,F.q@C\nl#38K<\$oh֣sd?\"	0)JB{I#b MD~tʽt0t+p\"\n1h\rVīr\r`@EoCJ.*\r ̍%%`\r'p,DK\npP/Qu\0~ 22r(#aF\\J4Ʀ#0Nhhc!/pGXL)4{R5ՒA'mHT{!!FԨ*BF=҇rFr&7dƋ)cd<R LbV#j\\.BaPaN4o)\nvC45@\rEbc־,['}drM5#Zf}qvxko,d>nkTm1-aj}v)\$`)f%,\0M\r#bnmm&Ɠ]9SCt!*dM\$";break;case"lt":$f="%(e8NǓY@W̦á@f0Mp(a5&	scb!iDS\n:Fe)zQ: #!j6 rT&*4AFi7IgPf\"^ 6MHC	1Պ\0NE\r:Y7DQ@n,h(:C@t4L4:I'S9P춛hb&NqQ}H؈PVuof,k49`\$gYnfQ.JbfM(n5rGHt=. 9c2#P;\r389aPCbڊ˱fir'5*?o4ߍ`*B 2C+&\n5((2lP0MB5.8҄2!,,\")#bz_ r.\nH5\0('MTkX2\rC\r1p4#ϤN@?#AxXD49Ax^;pJRÐ\\zu2h\r#,\"Hpx!: \$S]bc/x2_>.+&͚1c\nB(=t239&?\rKX(O갂#B	#pOC\"`(2We(1c~x3F*#*:9B4\"I:-RF(BbGG#K<2ÚH`յ1#s(\0:Id?J9:T6罸ϸ8h4Lا}d1k\"uS?Gg2,T.+8խ9l,b*Cq.Ly%	@6Msmr507=Ҏ|(f,2|&!-.6Ct\rĉrSraDQ\$o6)e	\0*Ipyrl:%HYp\r\ruAh\$͏Pσ((`J1PhCLhC(|	B7䜴p@qV.LWa,EYg-y-+D }\"߀ȸϵP!iDR\$ǊAp yQhWL#yDuCIkaUV\\qh81[a%BR5	r@K2PHbHJ9*ÚwrE8B\$\0cV@ejJL|0bo>Aő=q)^a\rxd\"7,e#\r%J]\n (!>(&P@\0O'm5^R%Mü F,fmԳs1[`GB\r+4,w5.e=Qr2TN:) 5HiD!9Z\\r\"v\$]q5S,:H\"HIAqsаԺىuKa	B	y/L,s\rN&>j\rQ-<sc|R26Q!4._\r	L*Xcm%k#\rdAglo)!uVND3ma5~N5r\\%d-i)qLוȒ\$	N\$Q:\"\\i]|6`̤ʳ`4:Yi!Ü3<F;wY9+r+*\"(Ed.ID1xZxYt'~xe˜dP>,jnb5Y2~|\n70i,ش* Bȱ>C:jQR]u&GEJ_Zvb\\`f'ȅ&=2ASzjE\\g{yJ@]@дWqsUK9\$#~ ӰYXu927DYލ(	* I%TnsԽ\ra{\n;a\r2CMN1\\T5}\n+3\\E\nCv.!q*d@V;F얊!!P*\n[\nJ	s9g0I9DjJXseGNh=}+\"!ωi\\׮u4:\$*BO݅x0Qwos׍\"]&v\$co)4yxLySegy(ݯz`:ὠA*!Bx[IK0oh9&8Mo}:#idHr(%̹!V}pJ7\n\rBPl0HBld<I0#,P\$}E:Ч.2Vm.bo-|-fk#:a.@4PH,LxȦ*Z *ºwǊVi0*2nG|9?\0DE|8ebJ;@D(E	ЬD#2!LD,`m\$,B!0P\"^bBnj \0\$ڃgDQvd,xfLɵqhu[-\rnOMv`\ng\$@l16VQ z]0OFt.p/k0!QNJ1ZEF>A1^)cpB%\"b0ĸ,FQ/:1EޯQG\$p~\"\nIfd	\"~!\"*@B*@pδH\$&M-6J7\0ON 'm1fiSQɢge B ݍj<J[&FM,`Z;nz!&*R;'\rr|5QP`opnQ'*VP%?,C KQF6c\$wK(--Y-t-#^(/jƾ;reީ/o>985/K;`_\nLa.l?/</0vD}1r|K9AsA(0](=0X{n82jBz>	FdB\nk8#(N(-8S.J\"9@\".|,M(@,)qP'ss5#O=N{S>n?>GB)\$Mnbn,g\0M'.݄Kru/1^{L0Tb}&?2mH]gqndHB-DD1EaE0`e&J̣gcCI=qt01qQl@]k\r3\\O\0fe%̇C&}8\nZ\$d;JM&b\"gNBFqI:l\"pJ%d?\"C\n	Bm +B8 ,/*8`cBw3!(498[X,[P?k\nNN\$Am\nDԁic{0V@줴rҬYfUZK!hPq@2\romUF&cl&`r\"GQ~juCP !a&# Z\"PBC,\"bJ\r	R=<-([deU\"`t Z@PP,*C5ZvkO^\n=M\0,3ǡ2*H.\\0\$M\nB=\0";break;case"lv":$f="%(e4SsLq:I :SHaa@m0fl:ZiBf3AĀJ2WYCf4(#Y9\"F3It9GCF\"67C8'ab:ǥ%#)DdHobٸuN21	i@ S0Mө_ni2|9q#{o5Mat5_6̆Q32b)V,HC%À9\rRR\$I7Lsu		jCj\$6C\"\nbf*\r40mZ 	d\r#֥ Pbc\\7(轶O5Lh׷r.7\"LL(	²l:& H̢H`7Gb)CAЂL#Nb\\4C(C@:t\\4Zڒp_	cxDò89!Z\"7j@ x!.=!(PNP+(#/p于(U/\n	ݲ%.RrK!YPa(A؂8:\r8!\n%ʞ@c]C,07C̡9)\\x[0%NPhsPv|)C(5˻-!P3A	CV*FLp@3qx90(#UȶaJ~(8Mvn3_qGxCW4LC@I4 <ѐ#h`*e睥~B ϢК\"=bT+ď6c|!`3/E\\[}5AsA>猣IEİTv@H1\\fkm?7B=9Crihܸ)Z4rڇ8e	p	46C|/A(HD'\"FJ^1lV/Dў\rND'!^\$!4T,pDEcm^\n Is&Dj;(A\"a\0Әl2ltz\n)FE8K:\";\nTTZՌJ9+ur	caePb}d)@Ҵ	&DEG)`%sS!\r%̧JW\$\$Sh[	n\0ND2UJWu`l\0U|NVa5PZ}d7dZ	>sLDI9#dϙiy/\nlH!k|3ځPuAa)IPR\\J>7ٙ!\"Q3rk\n%(0 \n (uF4\"DL*+\0c&a<R!J!wKQ}yUUc\0`&8xBѴKP#`h4(܋oҧ\rY`/\n\ru23\0F77yÜ7C49B4\r}P/\rm5MͣhG@ޥ(&rHC%,Z*18tXݰ8a,6 #C{谡<)J	E]eq,RX*Eu&@OC3k+B_ۤWP@b1H \nn>HI%\$jlɍ\rbCG]#%bF\\DM9%{2c.9ܬ1KN&efk\0PGn9'L6\$L3wEFp6M(p:zD!2ha.XGzQ}0PB9,BH*/(V\$\"tc5KZՄx\n\"w. uP(5*ӰN7R!@7JIza>XRGaaP\0ѳH>3*J!&fb\n_\$de׎#%&lñ\$]drp ۖ/r\r\$tA4PƐ0h\$1^Ng\$['ym6l8\"ׅb\re[Ӗ2\0ѳ>c}n	_C	p]doh5nא>n8VX/*LTҟ64i8a;[ݯ.!NHDnc-/.73X!e0<ʏwCJ!u4d\$ȢkZX=\\%:CC}ᰛQ=/E_,|ކ\ry^()p>ZQ!:31!e_Ĳ*/<(\r}\n:}9N^jB2#b:t@F@fnE&\nEr,@0-\"zĚffza#42,LN;JvB,BR\"ِZO`\r' ObF6b\\%0hA) \"0U,fn#zgdZ.C>b(rFxJz캸L\nиvF,pFB]\n\n|<\rF]l0'2A\nXʃ*GA0pbzc\"uQӱ3m^-\ng-8𖣧HgN<ͱ@K{uQx!1|1/?pRmD\raVˑqшxbg#H%!-Ǭउq	LIE<2*Ee8T 2*\0Bg\"Z.s &VYp-_(orͮjNDmxP_%;gn tP<2dR|h]4''&'G.DNFʝ*(B7n@l0e+g΋\":Q?(#q]?(1r2lTs4	~tR_g.q]p6\rƏ/&,P\"@#0H)RcR*Hs-3[+c2*5dS2fBU224ЪtS2n\\Y@o,W%B*%.H}8{\$SA7!8#݄% 9峔m`4r'fSJ#='-Bc(LM\rSMθ2\"S@Ac `.Ord!/ChJΔWNo5.bgD>|0Ԏ	c-0ֆN0CET)^kAb.gb7@K`\0V,&u\$*9 *B\nZ.R<D.#\\H4䚣O\0004gOyOL<aOx%pM/\"mZ@T0F3oQJ#Q*(20sO&3IB@4k'!!o6,>\r\nMr4Շ-UX`0ECYzG&:	'2(8tB>3nVℒa*\$>Ob&&̵tn`0O-U8jۓ&J@ͬ>@\$BI>VX3U:,4\$'\$feĤq!Ʉk\"";break;case"ms":$f="%(u0	 3CM9*lpB\$ 6Mg3ImL&8i1a#\\@a2M@Js!FHs;MGS\$dX\nFC1l7ADt@p0Qs7VaT4\"TLS5ki9k-@e6Q@k2()6ɝ/fBk4S%A4Jr[gNMC	œofs6!e9NyCdy`#h(<H>Tk7r!&.7Np|+8zc*v<vhH7lH\"p=xÍit<(íBSV3#ÁBRd+3*BʝLޮc\"!P	؄;QjiꉃzZT3{1/c Ժ?ì&\$bn>o;#7T@X90z\r8a^(\\Ncs=8^%\"9xDk#3ސHx!2(\r+lL#\n&5CtF'@P0\nT (C˞ׅJ|R\n%L!`FPdt6HI\$H0lI|P)L\rë		Ĭ2X9K|rZ9<\rئ(S~I#p/Vka\rB!{K<ǙI+:ϰY9P{\\[m\"HJŪݦ<v*3aLLr|=>c=1u]A(\"ģX&\rZot0̶HhE*:&|9n,Cɩj*i\$xp')PwSD1-w]IQzrރHo!FrRolͽn	RK6TTj;x UBBCIiVCH]	?FXka6>7iJ鍇?0,=[l@\\SJqO*D2*9*`ú̞2`] kmA*_0'P\$9%\\\\ViC7j 62c!r30c uO\0003R&3Q\n((LrS7RtrB@{/\n (fA?2GZcI Ce1cy~٘+ی(Dg#܂F9tx?w+U[(IHc'3+dtr'H2(L\0C\naH#N;bAa9@|>|FQr`&=*(bbfZ.9]hVBNbG88BRɱPN_U=Q0M=\n>Q0(%k'O\\\"894'Ot9=1WL*\r\nGM;iA#(2*LTNm呭fY)\$Wq&3ƾܒA<'\0 A\nЈB`El)(uIJHq5Fkqd,%ޛO#HM=1[4f{3!%Jv`P2h0oKj-ohD蹰!ڏ7;tctT(V:efٖ\0L9OSMb\0SVP5[@S%iIX4t*ʻÂ[}娆50LnQkO:ځV13#XeԪ	ugfI]\$OhlΙA:ǭƸ=\rv@rpcgA\rL@.@%h-)G㤳Ti6MFwFW\$%jXz, jU\n!nVr2J+Z /!wc\0vHY\"%jMz'Pe.TVRv]?D9mMHn\r;|mvj0 bb1!D3K*>( BGaI5SY9;##Z`j|Rbbku%iļ:Wԇ`j\rQ!RG!-oFF{:ߐ2+E\\9{T0wIXyn7⠇2vۢ&|\r\n?6j\$}>Џi|f.Tw^:;_|/[ֵsCOgpYWuVl7#_NBCY:S!ڻ\rsӽwa;>OQ@KϖrVy{WܡRh'Bc82#&2rdRcRo\0#,@Pˉ:\")-N\"p,Bg,;eg/,.TLOl*PE#:ڜ0pIMT(oV{p:_\nТ L:bB\nIl\rZ~CuBF\":`B\$l|rM/Ptx\",-Ъ,eý	J]15_\nM,C\n\\//(:&:Pq,ͥJc{g\n%\r!8?bb\0=\03M| 'I?b1x,'A x\$\rѭ:P	Y,<hQ B-S\n0%\nN1Jd qf,LGLlp^,P(ҕ^fzKcm&BNwE``-B\rҖG\0p\$2#8	ƄD\np#-OP蚤vB&CYㄛ\0QBr4JU\"5N'(%f'[D*ݲ@z2F[JLkLn\nxd\"y1[23\06\$1N6[>N~#zoD5鎬r%fl%4mZ@\n 	3?t1\r;-Ӎ1\"j '/VzN;Rz86y\r:\00190nY~>~n";break;case"nl":$f="%(n6Sak3do0p(a<MSlde1tF'#yNb)̅%!MуqtBK%FC1l7AEs->8 4YFSY?,pQi3MS`(ebF˔I;ۍ`0߰\n*͍\nmm0K`-Z&.O8Qh6w5m9[Mֿ5!uYqoEkqȕ5u4.T@f7NR\$Y8C)6,ûBю)ϛ\$=b6h9ØtjBȣ^K(HȾX8- 21b(ïC,7 r1kN,+rt2C24e[Qkc2P8cs_2Ѥ1?\0P\rbDHhԁ=jԜ?ʂ:,3ʀO\0@=Q4Np0´D0z4crx[\rAr3^ٶ,J(}>ы94\r |FːƍD[ o+)û\\X!xx\"r:J585_Ӱ8B#˂Xޏ̢%m<37rY>r)YZD	p#?dLK0p2\"̏h2nLj5\n3Sm.f#V1.H \nbF 9.K\"7tN?mUP2;\r{;80BR2\"H8hks\"\"^mkEͻ4\0Pי(VTKIaͩk\$Hc#t3VC\nj¶Ш.ް/#zүI(?Xs3ט3hZKOdw)􌜂\$u@\"TfgW/EᑅvO	\nXⴟOك?@{8}\0PȘs:&3(gIB\rBgN\0AQ*,9*UU*4*^UV\\õxXA0U@>2gfL`#[AV\0q6.?rNrN3(I\"XºB)傅W%۸<	-|JCh\rӠM*dm^	)Hc{\rF\"SU-rhq\"_2d18M\n!S~qԚ	;/`f=-\$B@[MI_~o(\$@zI\0((ȼ&|Ci.E䲠sdA(fvURE)&!uĘ[f>[d\"dDLсfi<)LTʡmMN&^D\n\0F%(	EI-%AgÄp\$ZsTg}G\"S|qnD)>pPìח]U\\:Wj0%\$r&/čd_SfeO\naP+D;'^h1𴆒1e[֏LIx]QX2S2́D6g)#xL0TW\rwV54Je/Զ \$V*'\0 A\n\0B`ElzB+2_p	TIFiPКX1Xk0m7e7j!rucH}'\nC[m?7r<\n	fW^}\"Tܟ,ӶȇҗV2,f#Y5RY[L*wܑ	(Ap_`hm AEpޭ2^ik#\$2srA\$N	nfK{^y3;v!\0PCD7mNcg!lXg̈P-ҦL1-FoސPáKɮokzAa 84QFVׁop/VHq\n;|9&1U8ʯjm N~KNj2r8/.93.÷n <·C .w~&.G	,Zc8\n[䚑&JJ\"Dt#YOnfង/;f\$X(bꩥ\"y|3F`jXfzJzFPBӡ2\$jYP+L^̏6<F4?W,pfW!\0R	e8tf\n)p.]I,6C+4J[.<y7ibĀ\\pU	ɿ7|'6p^~ ƃb_[pv?A_?6\n\ncdJzhBzl-pmT\n2y\0J͊P004)A-/\rdM*`m0\rk\r6p\"^ 6\n-`؛K\n>ϔKe>!UB2bFش\"ֻk	0s\0ĮË.#@!-+b:\"]/sl^\n90O3P+\"M8rqFzetnD@KMÄbn\r`͐Gđ^P\0GkpPVAFh\rjm\"7;1Oqo1gudݱ'\"6m-ja&nĕb-)#o1ԧ\"&lJK N-h&\"{\$!!&jmV#NlխL1`-oo/\$lQr2Q%}XRdq\\Rb88<\"TIQ 3mʣnu('g!\"FL1\$nх-za0z\"؁2s,n\r(P-\"\0i2_Ta\r%\\k<=&ȥ\"jiH5	n1C.	DA	H*\0\nq(~8pN.9\$!\$#a^.̲6ShO. bke([M&qBd&iҙ1C \r`NQ 5SKV\$V/Bd}m4+G\"Dc;f&.L42&D3^\"&\$?-=>K83LGhT1@0tA,Th61?Ѐ w+.l@LļjOIM	Ʀjb\n*q.x`]\$>!m.Gr\\&MLT2\rL\0;	@ff5,XIT7m!\rD2~L\$iP\0.Cz##B\$`";break;case"no":$f="%(u7I6NgHYp&p(a5&ө@tNHn&\\FSae92t2Y	'8C!X0cAn8!	\r࣡\n7&sIlMzb'ґkfY\\2qNF%DL7;g+0Y'qH16:]40gۈHr:Mqt醡B傽JG\n!n7S:D0LQ(Ye93^;#\":+(#pصa\0\rmH@0j&i#M|:	((@\$H-L܉ ;'2\"B	<<;9Gp7B7Nc|p!Cs69h jڤ@ c\$K&ϚlH4\r㫞0`@RBf3ЕtL19H!}%JC ^'aڴkh̴I@7x@|2KP :52հ6Cb'.+\n7-:\np7 X65P\$2WS z5x ǌ0:x췎6P\$#U%#n	b&;-,&x5R0Xc&\"'h\$2c\$\\Ah1l&^SN8!@R\"[[B̂\rcPBz.˿{n0˯9ۀ[K#l0\"*Ci!gvgI/jL&#͋cv43ڣ/NC48˺ڴtqZs(7\$VF&(ȣy`Z4&r,ѽ*3Z0\rxA4\\C?P6(MgKF7+n0쪔peЪ7qT\rѫrT	N\n)`qIS\0M1:âTjSr\r>v2:0k986\0sh z)&t\r\$j@SpP*%HN0V%^^+y0\\P^q8vhISoݬ4Ơ3`kj\0LLXt&ӈo2/iODBHrȝxRo6?DPJ\$9R4\r%\"Pr1Հb\riBJG-0f!PNL\\Eq]5ጔ(\$TwKOFoMܿ@`CaPI*ȓ\"\r҄FOEr@HZCh}fd痉w/ؙ6Fz`TPoX0B!MV(3bӃ14e(P&>/BsZˉ/tZ8i&p ƛ=b4ht1JD*6,O .bR̜r^LI݊&\\Z֭	yE)`Ly^\rntVEЕx'!M5-VҐP(\"Ĉ.PB3\rPgAjea<'\0 A\nЈB`El	~&WTyY,_Vqoc4~\rRӇ}R/͹u?	kP7\\'!PvHUck-f܅zlY\n˪aĔlVD9Рtm fm̵N!t9鐂l_<\"´c+.Hz`.@xD=]0C`u~2cvGHΘh/)/r[S'H\\J0b6тi.\r3|H/\\c\$ (!3/G-O{kFi9&\n@/uRQм=AP BH-k*zgR6C\rěr1az`B\\\n83HsZF2ɭC	-;vnA7O](Mi5q71|kI	`r+-xlHbbn8E,c!RK%'*zW%]Kף׍I#yџ3YԋHym`IwVB^=dAMtu#;g<:G'RdUύA\"ټ}wպZ^o \nWd\"Q/-ƖFE%\"@J1k#:<\":B⯴,N/Jh:6PRZݢ?S~!ثϧ\\6ONWX0ǁh7pS.\\<4 dnB	\0@&޸fZ!\nN\$(9'hb:	mzkl}m˺)),5& JD>&\0RPn&-pzƵ`RXOlfCb\"&cFj(b(f';0#>G\$цXfYsDP pMN|\0\";I/qpRF5.qiÀ;aJ%h\r0%/.:M)qXqa\"!g<RKR#&{Fq#&A+0H0Bz5mp0qBmo!1_P_QnN04\$5l82ʙ*)\rr.>ڀ!r2\0MT)c_M\$QMRԃ&\$f\n\\hC&Jb'eĈؐ	@\r1\"pc\n:B'>f^њ\r+PB\0_^ʨ2#p\";/+@db\rV\rd!А.5*	8*c?*\npz<ޥ;.\$gsBf8\\(1s+Jc8(#755^ob#lANb:0HB` ֌Q)o\\Ol,QEƴq6\$7;ϖ#+B]O<<\"e<fCp5=&=\",%\$.ɳbB\n\njM:\r:7CCB<-F9a,\0-IF!-Т@#M?&2qXOF_@BJ -KQ*\\\"\"L-(E^!@";break;case"pl":$f="%(g9MƓ(l4΢劂7!fSi̢Q4k9Ma ;\rmD\"BdJs!I\n0@i9#f(@\nFC1l7AD35/8Nxp:L =M0Q\nkm!y:M@!aݤhr20gy&*u8Blp*@do3Qxe5^of!hp[73qiy7pB\rHL>\ry\r+ry;¡\\b@t0.\"D)*a=KS拎;A*7N@@n) 2Mt'5B:p6n3޵藴򂊌r7KҗP)#|h:K*#\n0	65 P?-H6FN?.Ȉ[\$AH޺\rP7H4¹92cU\n 69?;+CMpAcXxƌD49Ax^;ׁpH\\7C8^P;؃ ^'bmB7\"V\r!^00#)ʃ-Pʈ6J,#n\n-^L6Pt1x	LH\\\0:8\$⸌ωC%dfJ?)a#z̫z#zb@6[0B07\rm\" çIcC8=!ؘ]iX>&\r+@yrɹ2V3)\rètH9#_K;Hh(P:V/]38	?s 9;4}Va%Q@0̌,sx/NX\$.tB*Qlo2YW\n!9>~\rKMV#92CGc 1}|)0ҁ~2aI W\"	ȃ0>bވC#.2X\"@Sl)&6%C£<R37CP\$B\\gС#aҪC2d2HiUH~,h(^Ŕ.9\0pO<Tg#r^\$D\n1EF(;r2E:˜b4;.	ő-!\"5ÐDc@\nǂ#UZՂV\\+xeK\rbp.3|h0&Køyp\nUdpiE>N0r.\\!3X\nV\\{*VXdPCrAC)K~yq|D\$OYzKe%޾0CIqGd\\ByL)*Y7^a@\$HWB#0M!)4ZJt;DM%1?Cr)2A4j\r\nYA	>HK4|l5YP(A?*VE6/C@ЧރBtp*5u?2ΌHc&!;%CjIs3JDD`ad4BKݩ/T/OQ>[\$l\$q@R8jf\nBd9>PK|w:9%d!AAe\"\$2H-\"\nV`ɻE!SuPIR3&'LE?!5ROT\r\rqFM\\v|;\nY8L[pWи/&@\$1yAІ\"iL|zb B\n49&fxF\nq1=`!EY,l#iI;\n~N͚{ ٱ,&ZZ\\5}Ʉ'#6r\$n	TÃT0Ԓ8u\rPp|y.'yi\",ȹԂF\\v{'q[e\"/<*yIo9'^\$[%!`޵Cs5sAB#8!}'/k >	d2fKfz]1ߐiG(:X Yb[v&50m3Wʕbفf\nX\n_쀠^fJpk#^d)!N!5!/Y9Ac=Bop#\090+Bzt0=w%|^ǔ)	]`F[NMlE-a#0)t(a7AC	O2M9HuLX,Vk19fU5cUd=6#sKL/aΗja%3\rB`᥯}='7XSV5?υo|om=VF*o\"'DOOnh:\nb0fmV`\$ \"'KI) ֓N\\(pBD#JJOD5Ĩ+V'`>a2\\x'b&䁐v6مJ&yl`7@).\"ߏZ&;Q/LP.\"]`%\$`ͽa9J\$/b^*&JAgIϠ%^eŘ=O%]\$\ri4	,gt&9>.'\nrf+qG\"N8Ќu\nO	.n1,Z|;Nd@:ѰDpw\r\nqϿlOCqBg0XѠMq\ngjѩ@v1L\n2 `˾N..OO!\"1r\"##p#R'\$d\$Q&ˮ,\r׬K!nLk !k'R'2NL4O1BtkжC2hp~-Vhb#`EIp礄++dZҼ?,*ق6B!`DfƬn)6]ҸEՍ&:.`1Y%N^S@ґҁ.]3%*@uά!`\nO\0h3-|~CJ󎉳6NvӠ96z:\$|><@#`<z8f-\0AC;k\nf͊De\$OE%!4Q8A%W&?ZsnDuit33e;\rABpz%@_gjd\0Ic\$@4QQ1D 3EEU@2ӧoF45;'aFRĆJ?H3{-nz<nEsY]JΧKJgIB<7;.6R}IPҟ)TMbYNA2GBsObAN=6M*xi/NH\nx#NK)Q-R|49EP;=@øRJ_03UVL-DMb\0<#2&5uV{V\nxf:0'Gb<;!v&+m&K&[[22r+d\rV\"a\"*C\n8z;\"nˣL{YSPb(Bp-\$v&+/\0\np\$Y,m̊2{L\rb5Kb\n9cv\$kx(ȴNTfB0ȶ&^y6Hv8^#&BCf.:ZRؠ,;eAI2<ЃP+;s&l+ވl({6JmV h6m.imv1'ooQ}@7\r69^R#7F=\nVTfjd/_DĂg1sFB\rGb-fG\\o<Иgpkǘ4te_\r'ϫ%vlVb6C@Z6LBط36d`y\\;DHN,!w+HG;b6";break;case"pt":$f="%(Q5Ho9jӱ 2Ɠ	A\n3Lf)oihXj\n2H\$RI4* R4K',t2D\0d3\rFqTe6\"P=Gࣱi7#In0 Ը:a:LQc	RM7\r2tI7k&i#-ڟMQHٳ:e9al])#cs+Î,qX̸q9W|=:IE==\n\"&|q'o<qTk7N9%\"#p0(@\rH6z·0H3O@:;\nZ*\n'\0ԙRCj̈P&cȒ錮0\n8\r({c!#pҜ#,9RҜCfHa\03o.<k272 ҄#Lƹ)|6M3|p\"ʰ.sӒS j@|ccƲ/20#;#`:Ӱ#	C XD49Ax^;؁tI\r0\\z2`2&@˚Z9^0HMp)21xՃ|1Sj||i<7'\r%͘+3(Cʠ4Hx:l1pe-@ Տfk2CsS#ӥ(w8CfJ\r{	2Hy{`h	RX&dZH؋ԭrƍB\\&L_hP7r`Ha\"過|~\"#<7rV4b	#l(۱8T\$r!=/N3lpl;ֶ8:^\\?q\\O9(\r,}y1oߊ=nuVֿ+?80f=K\$B̲I\"'\\*bK2!O\0 kȫ3Cg/Ր((`sAT6,@A*4ح<UYY\"Ԣ4]+|H4\0pn.d7X&ehp\$04PۚP԰aa®BHP#8U^*ǋ,9,՞byZ]ڇ\\_;yD1vdKCZU\$:2	HA60H5EKQg8ШIcT70rً a?^P>زHy^Gc X4#	0DN#!:G9a\n ( xm͈(( yD`bKDT6LTLջ\0k9!q0X:dMQwxIѼQDPn\nA-9n.c͒PQ%ATFԌPRP!9\$o3:\\#,(#&DЛ:c]TSK)K!r<QDmMKh(Ln͉ke=r?ToB<)EIYk]3ܐKԴzKIy\n5gPI,7>FH+ڵԄup\rT\0F\n҃Xf9T\0\r16,QAY{g0P*[{ E	YK\$G\"`GFFǄ`L/hpj\r44eCdԛ>,]!0i	)D]ꓺ}DjVR꒻K`C\rZ*98ʧ}:GVנ8\n\\S0L	9AXNPAԢ7t%z>]m9&^TQ|A0`\ni&'mE*\$o`o,^OXHACfD:<WER9phF.F(wfa䉐9GTQڎX!w.:4,rB@א^eWHk x2Ik%Z\"ۅJՒsawGvqjy@3ENj8@Yt-\n!@ˢ	MoFA!E)~/*lu䙃f3LqdvSWJώ<BrQ]~M9NYFX72duxQ\rU;\$_tr2ӧV|`eS/:sL[=V֤Y'NÒc	>c,{GIKHQNi?ܼUn#2,mt4XLl@N/Ri?=9S[ލȋy%߀9{;O\0tڿ>|50t}<\rD3\\IIoNIk圑n&qd*#f3\n-tA\"n4L',*ЦDD\"Nn^\$Dozod3b2J(NsȐXϋ'HBHLD&^rxCpf\rm.n6X範,%k	N퐖nZyCc\n,͔(SPن'Pd_o͖^-\rP{)d9fF/r#z##?)n3CnDlbn6D\rfHp/LCMh#,N-τW#%ԴqqopL=¯&J\n<,p\r%1p_ywpߠ@_=\rsb)^!Q-#DZ\"fo\"lHuNEd:bm-mvjg0f#ƒ)P \"\r FiR\"R -h\$0M'\0ȀN&aTe9DI\$T\\G\$G\ro%Qg%Ѿwu%h#\n\n%#3O\"Ý)\rcJDcB262z2\r+Ҹ2#-.(\n\n#/2s/܍h=0@ۢ1@sQ Lm/21)@	\n\r\r\rG-ȓ8:~!Oґ\"*61kF;f0\"ccR3PN@[l< k(\r& D\0[B#<#Efy0j\\\0Z(g#bn	^\nPԺB'j0FL!Lo)o3s-;K\\r/c<J0:%-\"uDs<&hHGF~&XQaDf\ne\0QGc*hQcG(.bXd5c9hx-C43&}4\rJ RS+9Q0t]w44'[NbN\$,Z#!F83ƪDL\\˂r%/1ė<C/IBPaT@.&R%;+OE\0004Mq(SI\0";break;case"pt-br":$f="%(Q5Ho9jӱ 2Ɠ	A\nN\\\n*MqmaOl( 9Hm4\r3x\\4Js!I3@nB3'h5\rQXcach>#Qz4Fi7MjblLQc	NE2PcI>41e!',΢A+O_cfkNC\rZhbL[I9OvqŸnD,\\(ǵGM7k]3c/_4Iț`&U7094ÒN\"7S`: 9A9ȓ@35˄V72k(RRbγ:]\r @j\\9. \0Ф2(#ھ\"҇h(h7#\$/.<H\"|12KPĐ@+ 3B`޿~#* \0ܟD|Ʒ/@@0Đ(<\n\\:(t'\nC X\0D49Ax^;tG'r3_	\"5`J8|N3/Z燁x8`Ƽ(y>Bj :T6*\0@HMzݭ-y	z%\"+t @1*lcx:)Dc1ˡ2/LdC bkt\\n{&#cOb`ӡh(w&0I 6,'ը'&IbhJV<eT^}hb.n1!B&LS>[& މ;mCtq<jO*rc+ sd=]ZH4b#m0Ɉ^r=1Ps	q\\\rXMxe?\0#ͻo@c6x|xl=L|h&L5r|ƁW4Եh0f\r\0c2Jy/%`Ͱs5Ey䁁3U0RqC	7< dM'\nuGQ9*beV&Z+epXa(:\r>=DL)Se=^#Y@~˳)4ƯUTPfeUWj_0rY)єҎC.a̩wJ\n_P<St_\r2kq5\"oASQ\\*V%7G,80h옠d^>%K&Mv%GuӠGc p4#9yNP\"S@\$0((ऌTfdC*Pw'PmXr6J)a'>\n\$4QQ.VHHiR<sC/`IP\nOFZlPL:*a3VHl#DuwI2&伡BO:\$zG'Dy5HFd6扩T6il;D6\$BA\0¢:䕿4B:@\r4r#%>QRSJsgib[qjJ߂b܎\0'q;ywDU1ZEQ1%22Vbܢ	8PT^@- IP6X\n9O31E&+f%+TYg1fLɪ`JAMU%u\r!%&f\\zQJP .;`T<=\";v-<b.A_qAvG\$T;vB>_\$(oR)ePM;'qGJ\nFbMrb/,)hk蔘nĬvh\nLQx@s\"\\2sx[zf3hzl2rg(1Na6TqDx}R=K#N!sW`n^\0A\\e\\0JgȂlu'((΢`\$MJ\rER*t]&H T!\$_PSYLQxQ	z\$(4L169?Y2DeUH@m%ܺ97SJ/)OqR@0Ďv)q\$_d\01˕~8Ns]3tmʚmB[4܂)Pu		Md0GIܮ>RR7I6qD<pǸtIv]ƶyWU#)6>Bg2i֡'l/O&әfLF2}\rlcf4A{`EKgCz|ܕ(OG	ܓVTfCT4F	@OQ:f\rvA2,bԾ\0/O/.	nԭ\\AHn%OqNvcmZLcDD2:J/OQlTǬr`,dLpqD?drpQ,ZN#aPe.H\n<zs@\\T4P{	sР/|עT2`c\0g毂SPWnH#n/z|^4p^Q\r~M|	x@0)\\}Mb?F*jO\"*-drbj-f>U䚖DD!a[b0Ou1Dփ9nh'2\\k/ú*d3)q^OC\"Mv8H/\n@30qP	̧0}\r踌	ޓ}Ї\n1	P:Q&@s (fz@&0!LΒnR#̈6p=r;\r2E\rB<bmT^̈,&\\1!fR/Dg.g/D\$B\rх2LaU)ˊЦR)\$1rX*'gm,R*ĂP̱f?%O|(B,ͰcY#\$HBzB6y͋1[1@0F\r.͘~\nr33ҽC3!+.4M3Ms\\bP4 N\"3\$k7d8LJ5P|1RPcRj3F)'QT&#bӻ02f\\areC0pxFl	P;(l,\$-<k\r& E!RCO\0ˣ ZjO!x1jL\nZbf#\"NL^o<x`]?떞N3b!\"\$.2jglH2:\0&>#:%#4x Fs#}APKxZ:J= &%H!E&:>R,m6F3F8oJ)Tm&1d|9HCOBODnoQ&?(\r509\0C\"OPJLVL:s\$hBl@4TBS@DFT,2l/6c3DB#532e\"'l.f2/-M7Y<<H(9<";break;case"ro":$f="%(uM0r1DcK!2i2a	!;HE4v?!\ra2M'1\0@%9dtˤ!eұ`(`1ƃQp9Φ㡕4\r&sQFsyo9Z&\rن7Fh&2lAH:LFSaVE2lH(n9Lf;̄+,o^NƜ :nN,h2YYYN)Xy3XAK׬eNZ>A#\ry۳qLYN[Q2lBz2B5x#𕈌S\$0!\07J;\"V#.x掭/qp6JҠDR`*	0P.B,Դ?JD229#\nH/q),#x2h2J`¸+#j\$-4.ύ/\0P!03@ΉxÂB*Έ)y\r <9)\n9oBL*;CCe\\H9`@#CC3:xouTAr3P_זXJ\0|6	23/	퇁x91:d#*:E1-7(*c=UOɇ#N&2cbF/XKҊܽ(J2~:9k,H!#H럼hƍ(t3 3j#b;/)X##,c{#;Qy,T?[ƴ3cѳ-	\r#\"1G-^\"`@8Ðo#n\r8cuVP	Ixu*=t&|\$ǝ`O&J|4vSBO@&Cg7ƇLS\0~]yhr8<|O1H	@L:/RڪEgl9Q#Z@(ؐHC0fOʤGhT\rT\\hcWa3بzN04c\0!0RP \$`3O1+\nS30\nqv)@-&V[kuou«\"?k7._u@;`V&&4|ʀpKF)g Av:сfL*%a5\nQ*:zIhVh[in-z\\tyyʧ22Nײ T	\nu`u/'BSi;`b9IWNl0i<cC9ECI}AE-(,o/eA{5wa\0уr*c1`n4yYrPTQL	F K!5B3jhwxQ<#AX`N:\r5,BC&Eky%a) p|0)Y%2lNiԒQ\$DRȓ&5蝡_[1_?	M'Qx1&M\r,Z1NA<<nrB䱫1t*qJ!7lLBO\naR,቙PZIi!TNzE)^`l5+4x	)Gݗp8W>G72RQɻ#A*gSC(kNIÑ)\\\"P!ڧE,c}a~mj8UK>IҞ]dYLpn\0ƔP	X&i.cZ\\rGD0ùxŗ%E4)B,YHiĆ `ˮSPf[K)Hi3beVi&I4\\< (PI/i^lA1VF\r&I(60ўlCPC~I	T\$E=+zIc8{;WI8^Kզ2tm,*ig8x-رsgʆ,%k]nÆ8bkUZqv@:c\rdĽCZP`t7 w>3:38akBu23ҥmEIQC&JdmrsE%,_f-6O\rC	mΒ\nR,C#2hf5V>6hN56	3i`[KgEۀtY2sDLj\0HzxGj2\\[c&n+g]33|_]ٗ^!PWBd}ð!bdcN M@m!:0%\n>EMTKsc(vko ZF3GQg崋s:f+e8.*EEYhLHn*`PMD|)\$.֊M&0\0C6noN\$&`çzDdF|JKbjL.M\"l\\ÉHfgg&L<\r/\$rj0|NOb/m\r/c@FD>\nRDR%4о @<c{Sj>00	&=\0v\rF&p1\r	NT*: O* a0נͮAn5̯QS~Bhc1Q	E\r@I--!*:`@>JPC;1g^Q5F:ð\"JU*|q~\r\r4d*;Mڬn-\0hC:Mi=0%\r\$b(pxG# F4j1~wb4fETp#2W&Be'&Xc2ipmF7'.ZzGRN(, aDHfn#<Ҟ ^t\$#-W-r,.7.RO!IaҔ=1U.m%C҆(a2	\"H}bBgcBnV,Aw-J233a73?̙4s0`sM5Ap/4\\UOs=1sk5576\"vL!4&x86),&d90D6}\r䌤(TBVTL\rs'';bLs:6kYd@I<vNइ8lk-l3(q\">'3@ޯA6Lz,\nOP4-\n072). U`B-C:\nN<@M\\mgSJuFhULhnU#d2\"HfdHY'.:2ԃJGH\\#^g\rV=<O~7!T\$E~|H\$r\r)&@\nZ;I0f&hp\r5U,!\"0dv'>M0G<4n0IMɴ9DPh<4\$8\"\0A28Av%X&`RHzM \$d&d\$u1FG |O4ѥ[\"O)5(d5S˲\n2x6m<SZsrY\$f2F~j*6ǐ<LfJ)aa	r#D0tJQ&KH`	_f0:'N/f\$F1rGkGV̰gh|@@/,2e47rmB3\"I[f2@	\0t	@\n`";break;case"ru":$f="%)h-D\rAhX4mEFxAf@C#mE#i{a2fAZH^GWqh.ahhh)-IhyL%0q )̅9h(HRDLD)Cf4%Gf\nb֬{R\r%m5!s,kPtv_hn]#Pօ'[\$!&chK'FAIE\$e6jllѬ2\"\\횩mKV7ťs6PhNCh@zP<l:\n,c;jA0p9m#)Đ~ZĎc(1^Ӕ07Ϛ8ŪGHE *8C`*c	..80	9\"\\ҫZH8M\"?>jRʴvȚkKLd ģEQc*\$|z2qR*JC<h|5J~͑o\"ء(SςZ9Ԫ#A	 Y*Wzi8(vI>6\r.רOOJ/=N9w#П4# 4(B5'k֢D_ERs/C\rS,[ӅG\0x0@2D49Ax^;pÇb\\7C8^2x0cxDMF*+~%H2~\\x-|%H&RũD	pv,Q׊zֳ9@7&IK.QiP/U(ɑ	0v\nKb=՟-OzhKb?IxNp&RӋ3yRRFrhq̷\$J+d)#;R\$Iz{>uYfj[9漱J(nd<JK\\J\$P+l\rR6`Q[01#Yd+]\"pv؋AL(Zu\\I\"zHDZK')9U[A/J8pLDhMstrm4jSiLK-7g\r3Yv 0I\0IE.^l\$@)yYedUmBdZ&Lrɒlm9BBAN(U-#@Xd?7'zKpsϤQ'aUT0OQ	`tIҐțe!6U\$Fe+bJpQ2)q1%)h)ҥɔ4;-鸦X\n AgdŁnO3CgYK0\$Y9M.ET>D#VY*ҔQtFgptOZ@qtk~z\0,)Tv8Lg顋z\nuD3%u;?aYEfǕ08<e̅0C1ID\\G`68psH3fݜzChӚ/7m#ZkKGj]d?B:gNrQ!Dr\nf5>J^!C@Z	ܱ]d S}43fpΙ>h\r	v,Ki=Ps\rE6oL/':k<CX-VYrE&A4ED|s)_AMC˖M\nm;53 \"ɿEʌ)du-Yv!˙*ntbdƫ|59|%DKA<v\rDi\"@,xz|-{*(31N=Dl#UJ\0CoǚAd2d1Mm1H\"?(D%^zaK@;S8M4՝\"2%`%E|hAl#ZW-b9bf\0!0m%KGƨȂsvA]lռf\$T9m]m	⬚9&}d.[B}˴-cF?Uy4>rZn2\\Y>m~~i6A.jdo%sH (!5E3UFPQT|r_%2M Hck#83&l5cLnSƤ[]QM_!%E0@PU'Uh}; zq;,fAnɢP<zlU1qzNՊq1<aV}~Εc=	^TdoPcׅ,	ub)vFt#HMZQzQdǋr\rS?XNQ\"\\y9Χ,G>ē&G鿙;d&dƮ)o\"FԷdwUg(W(D:_c(h	nȀ	\0)ʬGi,V|@tkfFӯ<LqFŔ?g20j+HinGG\$D{\"\"DR̞|n j\$(`f\r\02.E썦кGDЮz7OoSJUprϢ-P\\B^uhK\"pzq\n\$ձG\"qŪ Q\$Tϒfo2\$jc~\\[zpbyBp3DwD^k>g@@@,\"g>ǰ\$\"iNJ:*Pp,8En~)'|PTȰɐ&-8MhkFsF\n 	~\$9hшdͅbNivʦo)r, GhvV\" wFI\$:[b\r\nc:zp\$t.j ~,Q\"VRZ*^.w2lq'2w o|*R&>LV)-cjdhdH*'2j#y,I,N*-,)G2lpl#.2-=].b-}֋9BV2N#!8nRCS'\n2 -+C\"\"SRf?8R.RiI\"dG^r4v_qhQR\"xzī\"\$Y&\0車PlL.Cq:\"#3D9fJB'rnfqķ<Ұ\"(,+<q+_:4.E(,bu@=Rb31@i\0Or}#ExHGAMǼ;\r>|bWJO(D0%3!74rF\$t,D.DZ]\\o-Q) &LK@L1'N`\r\r Z(\\IgIOoDdó@qBeKNt0=RUoGG==OT@ȗCuV)rBaB6)&.o?CΌC3\rB\$uBpI.@#AVE%4Cg\"c.S>'N-KH]'5gR*m7-gy*(,1C	U\"VYjYZaW:;U\"u*r10L|N_%(G2uXr(1QuB(eB.P/|F\$cDg䎋`V\"g25(HRlt+R&!4Ⓦ6Y15TC`lrq,fV\$Ed3dD+AOҷ1꓈<U]\0q^m0l3>Owl\rCV]Amhtn/mџ0n!|ª\\\rYjqqbåv5aOr(s1CWpvQQwBr	`SL ǊbfX#Uѐc'JATml+YO\\UҦ>T;xsYx!]xUwBisNuC30~cW\$\\ttp~T}W+T3@7}pQ/0/-\"UMcExAjPhQ:O+cE'Sq7\nfsU=eoŠXszƌ<8\rԳBU|v%.x3\rO@#~6	EP\rxoDynVTr?#Wz1}Ucxe\"X!z6Ԍ\"VUQ_wWZxaEQ5t-)_ώrXw67\$k1~G-y\\}Wphуxa728M]A7+Q9B<`=x5C9	R2XC)]ZW̕rq7u*!Kj/5ՙf@-]DPF9Sv-(u)^ulZR=x,*yќW|;s	!@@a1:WZlbEz8͍ i8ׂeC[L@.\n\n0&8c<\n.\\ZdH\"[bI':x\$ؘܔ\\3;Gf8PIDqȤ@E7\rө3H.Bw*FlMvHFz\$./Yd/a2Fm*tvu2B\$fU}@v(d6OAvE7+;VN4>;BYϠ[J)@[T'+K{cHCx{O@;tO7u2j@aepWVn|	DP8x80.b\rR/«f\$@F-X#%]:S4c;-Ynx{&ꅴqV%Nk;+~P]Z&nPp­gg	O}\"eXDxgxc=4zZ\0TET0|A";break;case"sk":$f="%(](!@n2\rC	l7&P\rl25q\$\"r:\rFQ\0B0y%990cAn8yj)AB&sLR\nbM&}a1f̄k01QZ0_bԷ  _0qN:Q\rA n4%b	a6OR5#7\n\n*8	!\"Fo;GA#v8.D8ܞ1*͗ə\n-L6la+y5O&(3:=.ϐ@1xȂ\$2\"J\r(\$\"<jhBz=	1\rH֢jJ|)J	F<\"%\n<9\n\n)1P),`2h:3. -\nn9fR<ʣ3\r4B@P7[0\$Be\n;\"@ؔnC\nEXEQR# ں*lRVR\"(C,Q\n`@!3:xc>Ar3 ^8HØxDP1̅|TzU-\r<!\n-5	\$4&M'Nȫ0xJ2:8;997.:2t	rb:J4LV93ٽɂ\n\"cp޿Cè5h3;hX!|:@P2n7Ԍ='J	0:Pyk!\n{t;S\rfB'40[\n\"eLc:%ȳ::uk\0᳸Q\$ݼ}QR6ᢟetC6	!BSOx6;<x]:xS\r۽Tl*0A*5nh\n\r`䎏7EԐ72:P}\\?*MjPd6ɺ#Cavj\n\$&Jjl\rq \$!<2)BLb<DKxk20sSA[&BTK@\\b[;¡[.`C@\r2Qp.hM(RȢJi:(E&!5&-è!#g2hДtp:õM*#1]a5:#\$/5 NBUB^+倰\"Y)P,՞CX/ඁl܆WF5,_-gm##=ʙ\n=:v=aѥI2.\n(=`J5vUXkcujK@10^߉\rin<0LR-PJ20M.FIZ\\Rac:!{p̽;FLĄ \"4޲*bfҐS\$VC0t	Ze~,i:>HK̎2.tBrT#e\"(Td-!z)<Xp@\n\n0)C\$X8 Ա&*rBL*Lth\$f.j]MG&63Jq9PDBih2*:q&dZaIΙ8AUfA\0FQrvlMB|9 Fz!&%#3Eաy_%T=Sk/d܂Go\r1l&NYr|,ɝ\\z!BZf.(S\0P	L*/@\rǖbk B7PQS0wZOtR\ndP\0Sr\$<0(KfRCz,(!*I+'DfCvMnB.jɤQ5يjTEJt͌r[aQe1\$a44tؤ6f(xOl9\"^ghThwBKm^;LCA)Ѩj(BҳwJr5NAD!L̬ĘB)FO&\"2uTu^\\nq';L\0#nNo2;̤iui/0'K80dx_-7Wb(ovM CBp\$Й_n{`;'76@0.D6PC5\$݃'cfΞ0.s4~	pZNB*遱\"=`PD'kDܩJeȐTFID6R(F\npH]u\nQ%bk\ry8Aa ɰB 2ys\nǎ/2 ^Uaa=/'.'9Y\\0l:4J;r]91,6@?-r#2}:3,M'ț#><(:!0\"<EU*_\\rPi.??a~4|eȿ_&D/o\0n>L3FT,b8z)e;(Hjkȥ+2E\$Fb{CV=D\r`Q\\>/`B,@o.I^͠'?d	lgfKڵ89\0<'.JbB	>B.2%oL6J0\rc*\r7V\"D֐\$.SP%('1C,PjypM;\rG.`- ,ȅ\n&q\$\$'Oidgh,\rl\n.\\aq#eDlP PZf\rVU=qs1E\rqQv2vqGQzhCN\" V`P0 11\r!1}!ϣ D t#+!Q!P#Mj#0rjQ%bBK;&lm!qw&N'&҈>l\ra!ƪ&򤽬IFQ>Bx݊ZaM VVcȨe'~HΫb9.>jL򶤤j*,\$c'Da&e-^f\$N=&tG!r2^<8ޣ\rsKa67N'Ҙ%\r\"xsv5A9SsZ7Cf f #} XX',b\$\$q63\$RI\rr8\$2)8q>b'jGa\$7?F׭?\0006	\"t #N@&VmMCCk3V\ntB&4G77LuaE47AT3EClfEU!s4Go?a{9/5ǘMg;==7I77CJQ?SE.Jn4=TT24%!M\"5S52MӛI&BDvHe9hROOG4AD&HnKQUҕN4MR\r<3>Фh#SES!8\"^E<k[@-\0RSV`UpVԮ#1DI'\$\nU:U8\"2:\n'	'd\rV=@\rcPDcVVrt-@Dt#eR.P:if:*x\0\np/d\0\"/VDSa/ƃ5`#x_%9aOyTB&\".Fs`2`J#d%CnRĦM(;/QfB;3,cEM\$)70fh\nrs2\$\"ޘNrq/66Cswְqӆw>73&NUG!n1+##Gc40F3<^;GM'yi.')uE>Bt@\nv߀pCa\râΥJsSV\rfwml2,=<'gYҗ1knl/neDi֋(*&0:\rH\n\0";break;case"sl":$f="%(eM#)@n0\rUi'Cyk2QF\"	1k7Αv?5B25fA2dB\0Pb2ar\n)Ǆep(0#Upz7PI6AC	laCH(H;_Iуdi1ȋ&aCl2̧1p@u8FGCA9t1f\$E3A}kB|<6?&Ʒ_7K08ʱDы*PIFSԼU8Bҩi;L#.}Np!7c2\$B9#hXϿ2:V7(@	T<ˌ R~:sj Kx9,@P\"Ȏ2h:IDr<C\rk86\r2<+1|\rn%\r2c'T~9QJT\rH)52H2\r{>Ki1l7V>/@;CA+p9Xx(C@:tT6ʈ9X{90^'a926cH7x\$NʫpBޡ\"3 ĵ\nj#!6mB	|5qO+ĒM_R_\0ӄ`#`2`P'B\\.,ɼ)2P2\nsS6&yH:6s־ë1S2CnPi%4+n\r8&A(R\"\re9(*FXy630k7&-c\"n4spb1Wr B\nSho<;|:+;\rF|HŮk\\}\r.n'hHzEpdid93-8ÑSM'LBz}h<#tcm[O Va1lln2\\\$Bx5,7v <0fe缂#(Hڼ*S*[bg` c1XAϨuqAaC	َ!}P5JJUX+%hy\"]c}*yrJl)@Y-!ش\"	ȏBEnT	@b!TJS*Tbx9+5j߈\n!#H\$B4ޒ\"a DkՃE8rTg`!(Faє?\n hHC;+aH@18HF0SDH1FBa\nCHhB]yIب 0\r+Nf\\̆Y^YO)?%G*HXXECND!8A*1\$S1:kdpFX,B%/F pt\$v8i\"HZx8	'І2('T@^,\"N#XY<3m\rTQBYǴByFHc\"J:f0%hD4XP	L*FQح5P7\"+BD澚XrM6T1@܂` x'IaB\$2-nmDX1cvFYVʓ	^Z!K*:<^	B	]\r̳kqEMuDҹ1\"̍RM\rI9Nǐ3<`LT1ȦrD=2v@tU,!#vFP7nj_Y݉=uc&%vBsΒv`G\$L{xs\$djlXTtF`:<L!LB<BѐH&o?39ʄ L''#f=gCՔˠs92C[sd,:S}\\v.%u=3Hf,T}kղՒ兎@BޖNBQB2#z*|8dZkLJ\rIK	*@@ ~š\"X]I&[)m3vy7#h?^h2ľRAaJbW	1(n[lPOƵ1Ժ!+L@iܔ7~\"⼷\\ؖr%7')ōRÎj,UL\$9r'>guB	n,K}O,\"/wFvVם̚ա{	ݻx\"dw>YhLhwF>]lD<Gׁwc`V;윴#}8W%l'BC(;#^cr>i3ޓ]aF6ԾeEH\$2dCzhR>H;2Cu^'}nR90̶Àb.IUM\0JsnŚe˅X2\n+C\n=yBZ\\FB%ŢPW,\$ږd\nk	-\$'.,H<I	ӦELF;L̈\r.L\\Db,1\n-\n%Xr!}Xu(PpB\\%9(8b`.q!q#f\$t1+1\rBn#QUcbH<Ra\rт7%g0G06x71>b&&b<ChѲ0(ID\"\"5В9l>bFxCj(%Q 2hf=d HH۱aӱ%p2E,`oH7\\#%;/#7Ot#Ek#A\0D'LBa#%]&_gB,&1%,LB^K,dc/bbg&i'!\rc\r2{\0&mrp%ڲo\$%&pgdpNK'=%R\rfy rZS5]0̀\$mcLS1\$ }#2K\"q?2\"Đ~=1bbO%M-+R6\0փ>IffF&@Xb^18.ɶ\"(sg7k8,-bD&`OjK7B%` F~K'3+<'].{</2K!xKM;BKs33?,-F\"`/d-R,\"~@ЧcN.ڗwCj4:3q(XCt8ţ7tACI)DEe@\nr?x_C\"I(1yFC(dr=DtgIIPETIJGInfQ}H^IHk;	ǌdK\$@B\rCj\nZ4QsH\$Nh%qB/Pq\\UKBu!:Ŋm-L+/ \nBPdmM\"?\\M&LÒbV#:!B|F!c>~6bdʣn8DRbV٭HL?ZQb`\0U;ZU381#8CB.O-7ƣ%ц&O9T#08\nr&`atMC,X\"\nZ@u4tK/.Hj%,+!CHlXNaVlG&5\\@*#2/MCB4`@FH";break;case"sr":$f="%)h.i4	|Ez\\4S֊\rh/PHPnv0G h\r\n)EȄ:%9>/M}H`(`1ƃQp9WhtuO`J\re;ьF\rgKB`X42]nG<^PdeCRFtɼ 4NQ 8'cIg2N9d08CAt0ոD1%Co-'3Do8eAZA)@{b0*;p&\0\r#p΃4\rY] s(>X7\rn07(9\r\\\";/9 踣x:Äk!;ƣ\"N\"\\:C*	zE<E-¶-н\"#JҐ+d*{^@51DK0jF9AhuPڬXD**L@2^@-8R6U45z'QƎT8ЧVG3RD=Oi1 l+Hc#1#*3ݷ,r1Gn 40T9`@`@2D49Ax^;ppqj3(#&\r\nѨ#x|2\rGYA,¯*77ҰeýM:	+YJ\"oVˡMƦۢZS:'Oږx0Cu悄\"\"ѽHiѻM=5(T2_Mz01 *jSO1a=b&0d;#`26fH#IKCDj?3N%Ѱib\"ˢpOI2k+Cf\$L4#L[/_bE-Fu2٣פ6D*zk0Z&JS/k*n\nTFyY9j))I\$/L*/#O ПhM`k!pt^ck&jǶvԂ B ЉB-S]:E`el,:VڻQlA<tKs\r`eD+C7;ǄG\0@Qn&GC\rɛG~\0\nsfq<D\n0A\0uawA\0l\r\n6!0nh0RV(%F&O.\n&b\nBpKd\r!r0kb,Mv2L}5d`NhY[ycE5HlKeW\$Brji?kJ\$vv%dXZN`&p0 Ęcݍ1܌sd,@H)	<XI\rD#\\vHC[/IOSVidSiDblZ\niuh!(4E<Y _a6\0q2F\$dҞʩX:u|!emZC.jz_FL,	@\$dR\0e99in̒xc3NsNxenI9Cw\n;\"L\n2gRs!\rZdFL0\0W q.&`m;\"lgb@#WI F)bkb!\0\$xFE _*Н#M	\n6M=k#u@(4!*J\$(uW\$& ӤË\03#@5)r伈1ʤy`BI:UJTGP	L*Yc1JJ;5y,q&-(&DԂn/	cE\"Q#\r2`,p%t`uS^3\0e1`innA2vCG\r*q&]<(^H܄P*[WB^4M\nm0*Lg! +c\0B`Eٻ>Tdmn\nXdba4\r!N-Ւ5aY\n`k-w:TBc/f]nxflFJAjLfsMǋrmNo,=7<OgO˄\r-Mΰ^Gubn W4OΑhO\n\rIp2ZlOV-CJ!:\"a=a;>~()#%;n)Sn3E!09PbC+\"a!D<.^\\>JrSwEŌ=օTBxB)xyA,^{m41H0j8I\rDL!PC5PĽwO\nJWށ0wF̼Y\$0PH2) '|!-O:|nn1(Vـ 	\0@\$d\r\$m];Dzdn&@fj60fʂ0tJ*LBh.Whb`j(?Z%Dc\r\n	20\n/QcK0)P,RF01	)P+2.XD-ïh*؟]+i	\r	\rW=	neqI\nqM\nU1>mQa\nA}qi5:@Ս^F )ʢX.ez'J&U%?MXhVqZ*M#b#AbV5C|N.\"Hv[c*xe\rxN@x0QGL<C'o\0x̀>f16<M?^PMN΢'N( ֳ#vZz4Y&Uϋ(*&qO*F3AA)X4%`xwޢmK\0h1rhrj/\$c^Βx%./g)R~pyo\rD\r hXeP))(Q)4.NU%BܮE-LYO6g){7ci7`U&#A&rY5]8:I'ѧ+S825&2Ģ]Ƣ\$R>q&fп./=S=43p/#7s=2)=>>LNly>	r`wJ^ד(>K.c9' 6lC8Co*);H\0Q/\n(\rm,\0Nfx\rd0UB`N4}>,T~r-4X/tOAG,J1y4<4qIEt2Mx ϲ\$4t{(O5\$d=Gpg.kCE/	>tMCҏDt`keEP6;P(?Fn2>>5BT;)&#U*'u=Ǚ+cCS\nMWEL6D@\$\r 4ȳʳHh\"i[US:':=9tOUuZ8Tc+5hX|N#10jJi0j/s\"U@[Ig_.847lN/\$q\r%V%%`uf/%c!*RmWP9WedUV'[NqRc+]5HRO`ХJpq8vD\\0gh/ht*0v86,d%so	.eGRbvAU)ofv	RVlV5\0VnD kU'XMRVQYqrq<vJcan#Zս4.=BtƏUby< ¾bOfgv\rv\rl\\@K_vBiw1Cvl7B=ni\rF{u4m3ӝ7BwP>&,>@.`\rV4VA\",TOP\"\\D̖F\0\np)-Qd07wvMBB\".0fY(	\0/C#r4>p\nq/g	(O~f~SV&2̠b0##5q+#u6}\"-h~4+*h|\$H8Ĭx~|s&28\"80:vӍRt1ރSA9()Sd<ՈzUrZ6ƴM,@Sd'45J.݄ރFhqKp ]u4#q.H >9/y\$/hzy%UDApiJ5.rR\rh;V9(w5y`";break;case"sv":$f="%(e:5)@i7	 6ELp&)\\\n\$0s8t!CtrZo9I\rb%9iC7,X\nFC1l7AL4\$8uOMfSt7ASI a6&<b2\$)9Hd7#qu]D(ND0(r4\$U0!1n%(Ɖ:]xId3O\r3Dpt9tQN!ݾr#-+/5&d~hI':4Td5gb(ī7'\"N+<c7\"#̋죦E#μj(\n\$Crů\nL	è63C7M@=9<˫!\"\rh8C*҄3	#c<H<*)C&p&?,5ñH(,lD(4\r̫2\r:/I8LD9]!>JU\r?\0\0x\r0CCD8a^(\\#szJ;!xDlSr`7^0z6\rMK\nHFc:¸򭐖.\"p/-7`Aw\"H(7в&WO8]B\r6rvF :R\\c\$95Ve5B07ZcM#8.)O\nU+.dv)3X2o0<d(腧F4E6c\\E9BkL,mn[Tʂ\0 M4m%9t3I#8	#hᘹ\"(Yz!9[,Z6m,05A(6`\$C=20\"f:FQMv}ϐDKre '3@RN&M\r\0چ.Y\rǩ5J\\gXÓ['p;t6Rp	υWr}O\$C}ւKCX\rh uvC~P)=AA4\$,lVgM		RLU6TTj;xhUEVZ(bl*c d-?ޚPB\$ :`#:b\"\"5#a\"q#Tʢ褫)1[+	\"()1ؼRAo@>G\rQ	I7fi\r+ 93;R77/RviA\re(aJƝE ȫȉ~T9B9'.mzȌIAƤ\0l-82}d)@kH.0sơ3<Q\r0˙6LqBD0\"AГˋl\rѽM?7	u҃#!*ca#,d% nQ\$QFL)C\naH#OX0 qahzP!^9Xšdʍ!x&)t'+51*TBPՒOK\\&l+RT9aD3U&tPAOMI`>HL(eDa@'0Tb3 <*HQX-s1}G Rd=?`I\nmX \rIP(\"Ӝ%=\"Y\$3	N@2v1dő;`\0U\n@\"BI	f^p@xR\nP p|_(x0PD[R,.vL?cGL1hp˾\"FF#|9dB񕦖おRƭ'g[= @9h2w\$1+<X/gtXdH4gmʹt&8ZW#70Ӵs'@)`8l=\$cHq(s\r⪐B[tMĜ&\\ul+-㋙\r2!# (&)hne6(C8X6x3fL2ϭJS@&+HKB<!T:+¾AICCPQn)B!\$\\S?``g'BP5¢%Ex ,.c!~j^\\Cĭ|NqY81:^qgMkL`JSh/|x\0W;;Ntg\$!13Io*H:ɴ>sv_%J)*KLɩ{YPa/7qvj瞫>ÍV}ha6kcKTm|(\\o>i=\$ya?qg%ļta8A19\n1	((2a39j+Kccb\$ME<HW+B|qq{`M\\~tkHy랢޷H?_r-\$S<#~6g\$ /HN`	o܂`jK(4ZG0(viN6n:\\j\"mt}nƐc0\\b,oRϢ.-w~p\"@ZibA	p?\$lBIؼ\$L.9@=Ì	J*Xp'Ս\\5l5Eӯ3h\nŘ\\oT[M\"\"NN1o0#MPv\\?,\r\"5Ji4\"mܰ,l1w2/31{q@[bf8dH5.¾;#cf:XJnQbZhĪAjJIlDJ\"P	-oLє5g\n\n~\$<BE׭~^`Ql#\$|T2O#\$.O#)\$-\$bm\"HN&\\3<  cr\0с&jRw'-\"r2R(Mҝ'M\n=8D̚OyKR!Ҿ3B2bHi)R@ԯ>c\$=;\"b&dHq8X.ld0 Nf-\\%r0eY--W-1A,FU#f\rV\rdl\"kH/jꧏ\nb&L p4\"O.ƀҺ9Ӡ4	hx\0rq/(\08fR<A=,%(r8o!\$P+Ŗ̫{0ij%Q<@\\vP^sBP@k\$1C\nƇďAƲ\n!4:+8ލ30OYB;ŴIS\nk|ՏbzCL\$B`GľаnVaz#cE0lc.fB:B#~0`֤LFD\rfnI\$yCYA`ET\r@";break;case"ta":$f="%)J::u>8@#\"\0p6&ALQ\\!_ FKh3Xҽ.B!Pt9_`\$RTmq?5MN%urι@WDS\n4;(pP0cAn8U_\\dj?&JGFMSIXrJ΢_'JuC^ʽp i4=xS/Q*Adu'c(oFe3NbNd0;CAt0l,WKɨNCR,H\0k7S*RޢjMY`,#esrʢ\rBB4;2)(|\nD@\0P7\rn7(9\r㒐\">/9 ;x\$9X;̣#wI@k6G\"I uW(R0,d\rØ7j*+]!1%n,Lk\n.uHY3V7drڱĪ\\)Kz0\\W+q1ezwv櫖J)ӮdBH=Ͷ\nZ̫kF87-8l2=u@)uLWbDh:a	;@@<orR\nh)R_9dMtFa@6f\nMilƪl\"֫\n@ۓa۷J*4I+qj8Jښ#A5kEy# \"LA8;:\01oU=\"t1Mn4039`@q@2D49Ax^;rW]2x7=ϡxDlȃ464}?MV=*bZv±SXUU+c0_Y䀫F@2x2y.lP*V-	VdҐW!7\$@AA(dE͍v#޸zi4W[U5\"jW`=sͅKDav!:WƵ\"8/8WunaT4̉` p;TAAe+`:i-qlRH'oƵ\r]t]R}KU\$x{l9b\0a<1ܐBL%z3YHFF\"HsP2ƞB*GP+\"N~ZCꗏ_FygF:c\0rq	GdL+Y03|.cCW)xuHt+402VP(	&;Hi3!ѡtAO-_RMו\\,A!4Ltŝ3V#zHL\\xavL:XݓA<Rj3O-FŬJϴ;e2V d2V\0s7pb\nco66vfD@@xn (6ރ4?3@v5ZAwHO(`',[rn(Тm6ҵi	H\ni.tc{Di\r!ܫs.mιBbfu&yޤZ\$f,3b4ץ\0ٕE@-\$+54UUW!\nyH	\\\\ba44Nn{ra9<mWeӇ'RUfS;JJ\rJh w'bq\"ekqeVy&\n;Bzsva\"A{o!K쌘YCٗ a` 1ldbj3%j[\n+*gDW(bCz:F.Kq,iQ\na8{<X\$ti.þ?5r(2>\rG5961;yo Gpq. }ChU9f3\$7 !0qU9@xf\$k/U).Qʿ,Fh\$p{	WNI&yAq5Kȝˎŧ:Ԫ{Fxi{񲍤+9Z*N\\錒)*_6Z}-QZ<eHy:=nL8Zp m\r)M8n<F!UH%O\naQV8ՇAJJ4lgg~ȋe~k	hRhE\r6<;Few:Diru0rRJb)ASdq*i=M;q9\0Asr(*ŧz%ţSUWO	*\0BE_@/HB=a<nRا(vpbabꀍ\nFLM\"f摥p_/ҧ|knxGD*X/^[C>!Za.)jRjnJ^0:ㄘhj	fȮpx潃y̢biHtc	%o4<wԌlG\0iқ\n<hd)\nb(Z+K޵/g m\0?CdVj\$\ny<?\nz`鍖 t#L2*wʨ`fɹ%bÎ9NV(\"J\nG(r`\rHp'p ,	 \r ʖ4k@Ίmm)@%K舲:@ϠʬNJL\0jV\ny,J\rȄ\$\nm4@´l\n(\$<)qP7i5gL-\$\r˘[#.Щ\"mrBdI')\"i%Z)0Z#j70J^`ˀ\rb\ng&># 2b1 7'@Dj\nRf`3bc7+g\nD)!AFm\r%frv>&HQ9*1(b	r+Q`P,am\0PDj:F#2nO\n`L@N\n\rp>Dh:O1\"B2Õ\$xa\$%01	0\0i11\$nе/IL'RG|жz- \\-Ӻ_9:E;;sd<92НӯS̅:0URB\\2>r2(Sn,3-6H\r-oBs?43D3lI#PT @OEsDzQ#	p@L\$ViJ('M\$cJRE\nOz}`\$%`Ro%-S*\\bߴ\$7\r)k\$S.U+7k`3dZ1UNHn\\bv҈`\\Nu&-LSD\nS>eL.fU0|Sb<)H\"`Pc΁fH&B\$y\$6EG\0\$+jrKH	KA\$IP4Z.RKSN5C57s2RXFDԨiVTHxȣtu<uE5cE~W_̧`a`nw;\rYu>AwV	9ҨOPVrЉ&(x|XuG\nFLઃ0AR+Uu6q18D*vBl\r,n_J]@P\0,3i䰩%JSbǽ\\v;Ҿij.5y#B\0,4ꖈu3tIq0\n^c5pls-Uwp3.	a6:w`3r*Yo)bP3v+^v/^W*6AYav1tq4uuuwiwwu\\鶤u?ulw}03luHUwucd(	0#bl+!{yNqN??{zN6Pta=S/|JZ7k,QZPq,FtӚVCtvs@NPxW&O2y%ҽ9s`KaK8,#~]sC7Ә3IRo;?Cw&TЪ]586&aO\$[lDYnt:\\4ockr3h|ͪMl-\"+I֤	^T'b_*o.HC>u~vP2]O=U?5mT8tp~5@jc4 \"EJ3aӳc#PN:8jؑ,,PG^O'\"D\r\"M9m'z7OɅY	Nvq}~QW9W7Cr8UpFMdP\r950K0NhLe%MǟYGݠ\nY79^XKym:'OAԵIƉWEYG0zCQDF՝]md-I㏧5NIiМEmWGxPV^.a)3\n3/Zs	'b:3`HOO\\0)5<Ɋ-\\Ty+YTw%1wȯh8Vn	kǯ7o߆y3yѱ7szXwYw/]wg[mz)ImR4z_*BUy˥'Շ;xۅ%'I'I;\$Vmx_;C̛ֈlMU)\0׽.)\\)\0*\0*U_d}+t镘q˚{c|'(EחQxö?\\A[oQ:٦9֕mZ<\$sؔFI&2Zĺkd*FV#>Z<u׺[O^MlY:ѫJ%j\\PshfȜXeJurYgG۩58|\$7Йpt\$#vUWAB<M(/bs}\r0\\8TCz[kEWyGֳt8cu}F\\ n\r;ϰGt\r\r ̱g)\0֌t̍L\0\np˓\$)eL{\\mp>,^׻ј!; ѝY<ZGHjAY]Zŕ\na\rnϳC	@[7g1|\rSwPR픚[ʷlq|B\${fAVsT䱋I)lrf?\0H=LZlp^cg!x\$);5	\"zPU1ȓElץR2U4R(GH'z5^\$6Z;J=c;L\04!WTk.aJS7acǑҌ)(dߑH،?]+Z7fX䬸G(vM @&RDq`[8V\nBM	Dmqf;f)\0e\\XOk[( fI\$׮\0'%8d5myȐ޻d01۽^G0{`\$ΰ(D`ox&夙k!\\KNw.9C>mNqj\\|}4	:";break;case"th":$f="%OZAS0U/Z\$CDAUPȴqp*\n*\nW	lM1\"T!R4\\K3umpPUq\\-c8UR\n%bh9\\EY*uq2[S\ny8\\E1BH#'\0Pb2as=UW	8{#+&\\K#[[=-O5,%&ݶ\\&TJ}'[AC\\k%'TLWȽg+!'MbC ɼ 4NQ 8'cI3@:>2#:\rL:#-ڀ EM˘a9~NsL^\\.-R\\\"CCEÚΩMR:()E<)CH3srR7!pbLB5ø7I#|@9ÄC;\$(θ(34#mSAJsت,pA\0b)>֪m/:\$JR\n;~&uU*9l\\S,?#NDN\\MGR\\Ə6\nH#\nj&4ŵ̝{8R!*L1	pNY52-SR<+/օ\\f)i_H.!؜ϊ8؅P'VŶeJ)7z)zx4/cWzF7ȢR2\rP4CQ9P1#3>S;0cݶu 9`@n@2D49Ax^;pðlS3(ѣH\r-#x|:RJ3+|ΩɃX\\铎TKS{a2I7=nzfLÑnW쳺\\;`P0Cv9A(A\r!씂#ȗF1H%	#ʜ#.IGgu/4∅*d!hO	݄ GClP0W]>[iLd&h4bh#2IN9ZdAҬ0WEᄣv|(MJ~D׼P(gtJX')2@\nI(#C؀ЉP0 A`ND0ߍmDGoedd[k__;f^S\"Q\"@evd.%aJ\\5`x-	<YxBB\"tQS;Ch}*\$^hBsa1tt:5[Ta.Cv4yh >X@-,\$II:3D(oGdan,cbBUSC*py֓VC417t0tU(0pEhih:PM;t)BP~/\$ŚR)'PCKnIl5t4Fq=ȹ7*˛9B\rт }h][\$)H FtW>+pRr?MjѪI)s7it:\\Zp&8 䜣s9烓tN:*Oi]XI\rD(IC[Q֤_u]Ya0<̩䭮v\\Phݰ oC#0ksptFCJ@xT9پҒv)Cm*jȱ#\\+<eTvd@@P\0`V%N2yeQ(Pb0s@g+ma po\nL~l;\$HƠlzuu	5(sA7\n]3J܀ H]n8=cJ\0C\naH#@\rj[@3џKrZ.0\\LNINF [я@[,[\nBKBd69#; -ja\$MDEA\$d,nPÌ73'pao3ci1D@<DeD;\$f=\nE-\r4\n2\$K(\0ުdAkPrDtsq'恪nY/3 ?#L#_ij.(nzG<a2E~{ ŉU&p \n@\"|?&_YA<@/Qu</xތ#6hYl\"W~ɓxdd'vlCYg-?047ZZl#j^)mZ<lO'ߗfRz̏Fh&6/|e5)jEjiTD@MGa2NawD\"~(XI4h*ȴc'7~4MƜ͞\0FD/\n`HpK欨pKx@\r6#^ ʽP\ni͞JMGM*+A\$Ǌs?POtȾ\"\")`|IF^dCOW-%JIHDΊM&HgGeir`qpB\rbz+3V&2,@c\0dT\"JHog,xh3qb:ͺiQZHeeEE4 	\0@0Pg>QmΔڎ7mDHpf;eDd&QgV.gĠ:()\0>9OFN\"/4a2dDeaJ';#H#lZd)%F	o@NC~/`Fr%1JdY&ѧe|gd(:F>A&J\nNPV(<bA-RZOZ4G2G*/oúֆ@:JxG-yBpS#!{V:&IDY2DR9Wp-bddc`H҂}H3t{b'p'GԶIa6+\"S6s8S8J5\$&B~sc2:;3s (dFs91'OU8p{3	)T2~yH,+):<BAaAfpb\"5Q\"{iOf^D=%>.`\"\rl\rL@= SBs>}DCD=R&w1)TXB{QHQ=T'>}KE9rq:Tֵܘ0Ѵ<tNiEIPJ\0ɪXElh@D:J6LQnc\$R,; *ɮz)\n&\"Z:JI2Y/]#P{Lc++n&hQOUD]&PlDnn2F	;VS_eJPEMCyUb{:d_3EEIoZ]E]xpծ\\Y1CZaETuVUUkO].GL;[;Qg?`JǴ@TAV!PvFKӽ6{ASWXdUO'WcKceeʊp\0002X[f+g<8)D6Jqe%:({9%mi6]fhqLVMW֫*2	?dF:p^Mbgp^e(/BS\nFlT,4PSdiOPUL\"kqkW5j3rWV@'mL6WT? n\0ȡ<WV\\KNmwxab\naZ|J/;	+[Z>]hu\rzhoz@JE\"77Mz1r/vOOwtWUq]|-u1WXJ{wfe^aבzY6Fi7UJ3REwcw82a%,Zf1@D>PN`@,@RL8H@L<tFM%CcNLAXX8h4@\no78|*|ֻv4M}u\rk3W'~UpN, AQr^Ҋ\\h֭iH5+,Y7MDw}VQ!YF)Ư4wˎx;8?J4	\raȴͺ\"`ļTySf*{נJ7WrH\\j 7g 	F%x_yRs\"3:)Ջ'C>YJ~X\r'-r@n*\r8F%DQ;5yb')mV\np&R.Z59SS\$-J\$Y9]J{lV2d`	\04t#ú)<:QZ8#b7:{|4Dv*_uCT/7w8⃚Yby	nuhA!	PĸWLh}ȗI`:oy|H ̶Wy|-'\na=I=J>홪[+O`\$>#d\rf\rַ^&5gGDWe]Z\\3v<{	0[ŕ@\$VP3Y@mbT^Waɦ{(a=im<gZy4%-/C:caa}|LڳHdd<yp-Yb\rAW|[BlĽ{U#T3<4B\0	\0t	@\n`";break;case"tr":$f="%(o9L\";\rln2NFai<BS`z4hP\"2B!Bu:`Ehr2r	LcAb'\0(`1ƃQp9b(Bi=R*|4&`(a1\rɮ|^ZɮK0fK\n!Lx7̦ȭ 4k|\"tit3-z7eLlDa63ڜI7FӺAE=FqH7PuMn7Q#j|aŘ'=sx03=g3hȎ'a\0=;Ch6)j2;I`҉\0A	j%H\\:\$&0@A#H :#\04B\n(ޡS\n;IƜB9Ãk:ê!0XB7\0P{GxҲ	;4=	 \$σ>#\$9p!pc:\rzT#9`@!c@2D49Ax^;Ձp:(\\zNүI|6MjB3#Qx4!^0Ɖ+4#Dym(\"Q92ڼ(*5<O31,U7BL!PTL\"XM-@08+tj#C'4PH{DmnvN֯#-L,b43%8Ô)fd &\r(P&&:X,Pܽ+@Ÿqx9b	Gh0c[Y=B-xQO\"x];纄\0x>ӫ)b,.#cn z,Jsrbp8!n[^=660b9\$Pl6USH|>vIc[\0Myꌣ87+h\ra&6>qp}	|;a \"y^.YbpNWr#ɡ#A3PPy]hGvzM,M3Fq8Q\"\$L)@TT*XrmZ+`KX^\rŉea^*B8nCJ=Tl/3!9IMQ-t.^)AObEE⟁Q;@`bF')jg\"4HT*RuRjJ9+Un^݊9Vs|wJ	\$F)\"+qs>g\$l&8Eсm6s.`g\$NN'бD,7)k1r>f<\"S\$Py\n7 g]H1V Ƞ&>A;1u)]-P//+?1hJc),pOR.Ffj=rAȯ)5tٛa@DDn\\u٠cEd\\3BXkj 2u<i`) DQ8!K2P ԀzdM	-zO@}#Qt@#}\$HJPLAA11\nP *9zCH|C(G<<Ìh2ca~/1^P	L*&W5#s9@&@D8<2DIČhLpG0T5@z/-)P,U9&l3~}EAӈЭ6>\"	_m9X:I	8PT@\$A90`\".fQ +\r.\"Ę3b.\"NF\\f˓v>2\\J:ȉ<[\$ Yrʳadrce}s!#̱ZMp\"Jc+˩dn@8w@\\ΤX#uWoᬽЉ0W^t'-OԞq6oM'! b%2ysZƻ'<Y/5avG&^si:Ƨ8sR&*{\"	:ߍIKtm8(.!6̞uм+ؔm#ۈDh0BGl5?+QhQʓi\n\"\"O 	\"q\"J\$mD\"|BC	V0'@\"9fLّ#`{<urb\0C+/^1'Ϡ't^8!Oet{جw!Q|WpL!u@i8g f0yc`[5~U1޼W~YzxrӎG~JFtHem{i\r*%nw>`Zˋ elfPH\\첸6QI\"558Rj']6q.PT\\Q*o;~{#!2C(OԬFO֍\"sϸ磰.e^kb'cF8B\"GG,Lj\\!ӢPX\\GmsdŢ \rp\"J\"IB\r@liŠТ:\np؇>\" o)-	6ʇCptohMPD^SpN).&\0π7.'E#Mnᦱ,FNPa?]HK8+7\$LQ\0mI)\"2\"d^5ADΠ9%J'#~J0(ɒZr	ސtN%\rԍq\r\0Ӱ*vlhnf01O!!1o('0\"1\0j&dħE`-^p!o i:K-0fQp&- qpdL!%JZ,s#J;Q2>2J2zŠg8F#&\${ \"0f2-#2h R-9(*\"&#@C<99/rN0'j|?*R:ܓ 3z/6-A#pnA.~ㅎHn3TbRZ;r(Kr|S[s7ac7QרZrn^i9C@c]*8S\"#	:*VR\r!Db-%鳮'\0BW`g+)M\$]C,C6\$C^Zd\rVct\nZ&,JB&q\$;3;A;v+Dg%&^9\r@in,Do7QFd_⒤rr&NK/J:\$NDgu-e,|A11l,Lg<мNSs\$:\"*!7ؐ#~ŻNNK@pl60Pà\n01\0ތF_`8L ZPŨ}Pd#pgaT2|AGT&ME`gΦ\"d9+-ƊFRP˦fc";break;case"uk":$f="%)h-ZƂh. h-mhĆ& h#˘.(.<h#v_Ps94R\\h%p	NmcL4PҒ\0(`1ƃQp9\$&;dH5}Q\$C˩ZB	D8(iyA~Gt(ygY1~Қ(BdׯKmJI\r.(VV1>#\$:-r%CǴ)/tp^\r>[73'6SP5dZ{h>/Ѡz0)28?v(P|\"oKB\"i{* 5ϲ:㹉вH8ޣ\"JBZ薉(F)ZY(\$&Y6,X\\Nz#DZ9)ĵ+;DLh1(3 (1@ݷlhQɠMH>K X Ě!аqQ&1d3WH\\C%PnTxH\$D-hU͋^5OR\"\"9#:hƁGQ8mn#NO*# 4(&Ԥ!rްX_ܥ0\\kUsɐ;(~\r3:x\r`Ap9x79cv2Fn=,@Mn;GB^0jXƐ/Q Ѭ+\rbe^V8<\nvxZnz	\nO[D_qNliRI!7`PJ2biZBʫ\rs5hZ~H(5h|\$`K ąDUDΐ':)Y:%<N3u^j\"Se#Yj/pf<Ǒr\rAS\0Zޖ|)zP8FFVTz\$,bdÛV.5'EJ,4V@PS\n!11hA>&IF_:НnB\\1%!DBIUġ35b<NX+x[*S]HaM2[\n׍*o\$+\$-hj\"((k0fҰ dM-%JZP&=5] ÛL!q1M׊20II0Eb!RQ{\$NĤqi%&A@)Y1'F[T0uG\$eB렟9LDTEaI2V\\2ȭC4&T'5M	NQ6&\$6C@\npDj\r9zqCӨN#;DCY>w5	mЩ7\r!ӕwiқcsD9Gf4PO4bu]&WI&E4DI<MILذQ\n_9&yK<8Ӎ2&HəC*e3&hͫ9glpa4Elh,Ea)<FDIT2#+4L	J+aU%DJ/RlO+Nha:b?|İ;6ԊAe8+s%d쥕^Ywf޲3xϚ\0eџ;TICPU5jڪ麟Yil0Ksх.jBi_'Qx%UnDxPim󾩇'v'fPOsRٻsڴQIC<<;y,̲BF,@*PP	@ㆡ,ݡ9\0O\nU 1)\n \0_L^A\\E;@')|<]1,JhyƆ9a70ue[r\04ɦTI\068-CDGg#h2JS!0Kgv6Iϼ4.JmWGUP1d>ykL&moF,\\R1X	\$#uu̥PWƋԚrBFĆV&qYlZGRDɚS=}2:BsyxO\naQuCaIW%bF ܯFImӣ`\$ML D9-\$uiON\$Rf`BIڄF\nBhb4pUB-u!TxeQT[LL\"7&wBn3#mت5uep)EW#E[F)?y~	EY~DM3\$>%!1bIzu}\ny^qLAǗLG\$Q&7jǵBZDf#6;fFz>_u-BșKDⴘ)R\nBdEMyNViNCRa\"Fl(PFÆFm0OzhlA\0I(rmc|~6fL\r6P脩ĄEcÀ#D&g;\"zS=ԋ'lOn*nGD\$1\\\n@0/NC/&2[OXBDr14:D:qЂ!DGT6\$^̦&*((Mޅc]\rwZ\0DDB\nCF59(Ⱥ0Yϵ/jWI.\"U\0\n 	GnJd\\,vk*Nm-t,s\0^-4m'tt#u5aEQ z(bh&;J\0Cy7>1GW1GC	2 	 Y1!!pc#	!%;\no#R²:ϑ&K&&ī!Mn;&2P6T҃'6!&ʀbm\$<r\0QޤV\"F΢wvx,/LZ<!j=\nT{bPRĖ͞f&Z (*>&d¡n0R[.}md\\iRDq1HZH*d&p滏|A)0%	v!#bBQr66nk]u86?90po59)<0\n9g8o4MZ=m>A甝zJ!@zpx4+Cp2~/c\rV<LqAB>\$\\wh2>7A7(vbC&`\r\r \"BFn4d\\HrsӞ3l\\\$rc4:GZ84-GHY6sZ~YЊ	Gr;3舵toDKd\n<sKUL=KApM,\$\\4:/\rhLqEMԶlAD o0xNPӣQHNOd(gPE(:ԴC?*풆M[PGԺa5dkUsST@:vVp	JfJv@B<n@ez' ٤SD򵤬o0H4BH\\sªNq5ѨxZse\n-4(cX}3P==G7CR^\"4\nF'mX1N1-d!iVzpouM4W1wMHo_\n3)eDSW@lydv-JHu]&f!if>_Q3uE;&cP1\$>o0l,q.>g]R1felh6TfhZυo-OTS'io֝s\n{}'\nv]ĵ7\r[	qeq	f\$=\\Vd^%̕vanerlAvgppaGk`IL6I7֛r:ysyׅz^wetEUvuf71iykkz2pI\"sih[~QU#q1~Mw}77g]šg)LwÁqXW1a.*Tt}3%.wpCQDVGR [1ϟ_ydy+DnZx7fUW!J?\$	d?o'nUIFQ\$'U2cL?Q3vOrRrf80\$'E/БxpӍHU+~vPPZ6bC\r\",'ؿTQByy,RP8ߑU3d/P3pQr(+ᑘ_2Ji~\rV\nq3BD!PVl-VhӮVm?\$,\nZa\"2FlI	\nLSrEU/N!m),%+GMn~Lb ǵ3	:d^cx#QBDU5T6)ΉB'*_XRM	0\"=,[	4nFF*+DH\r^U;&|5l0>X-9SZ	h_VvT,Du=:Y:o{7Kz<n!61ZUZНe>O؎V4],J0:O\\zD64x&(1ZD#5DHi38tyMTG`Fg*snMj=	<yF|PR2rGWs3A=Ng/;S[V";break;case"uz":$f="%(a<\rƑk6LBNl6Lp(a51`u<'Ai6&%4MF`B\"u2Kc'80cAn8'3Ac4MsI@k7#**''3`(;M6,q&ƙ}ģ+77:B:\rW.3b\r4q/|\0(a8ۍ :`*{VvN-o)dgxiw7MX('b%Iyawu:D50K82cz(\n2#ؗCX:\$VL[<&{♺\nn*2M47csX߯#%ct\$n5L P2)s\n</s&c\$+*F6ј1Lr4BCc7+@S ޑ#;Ȟ\rhAPsS@t\rAID3Њ.P\"07c2D49cx_)6̈ġ|9c\"2|-8L4x@/O2l%:2=&KZTȳ\n,=&Cw;˸ȼ~눲!(2,'xa8&L<N:D\09=9+C,#79;Wи:CF`3C*d:\$R(('#j2FRn9L\r!(:!* 7@]m;f	\$	\r67H&J(<8O<\rJ:?9%!;'!`=F/S	)s6%##}.K.u<!uHsQcii\0004۶I@Ea9Øݴ|а:*D́reYcG(`S,3Y#R\rb1M\\jM39¸_#5l8fAc{BL}0NnD+,CRa}Ƣk\r\$DzxRJ ='R:},¢bϑ2%bhC@V\nɦUnUڽW`2ı2\r2VJ4zW{t\$3PNHS2KҐjze&J@;8*T{TS* \nEϏ\\40é3lW`,)(rX\$2IZOY,~RQXBʰsL#g\"mI?dm9L!Т\$#sv)bȉ#-(kjhIT*/	\r4( (i.r|\nMhe,\$£tR]L+NF\n(Ю*\"NJIYM\":}Y'qH\0a>2Ql#2J9-\$@vu_PZFDwLNH{\$4:Y@(^g*E\\W_Ep43) 	(|bm,ɸq'ہ~7-@kKa]!\r\$P-b!%r((k{@:dd?z@n3n%Ie]5ēb\0F\nXCx9q#^FR)b0'Erch,HL@y8C	\$)bXp\nd줚'bxLKO;ݏ\n\nhHuTZ0^di!\"ǥP\\yA<3M`|VUT\n\\5ӷKe\"Ip	Pg#ˉwlUt2	\rOӒtXR\0HAĭ`H֛*MN|A:/N')t~#],	it@PH]1I0Y[bhdѠ(96:\nGU6;7FuQqp\$]/LI\r\$T1tabʧx*ng\r\$<<u(g qg\n,%E(NNAA:GܔPS-@2Kۦui97\0OtY2d;!Kg遨;\$0^S5faɑdRW^Bj)\n\n3f<cٌ}sR ںdE#w{wL:8Ntc&x]ӿ2?:\rw2ayF?.RXq(Oo\r[3ܛQ^Jrfy*&S}PX2eA?O/-xoh\$4W10\"\"gw\$3l&l/ FMxp/b;\"_0(Ȍ~`l\nfts.&H`̸A@'FF\"eP\\`Hj?jHXM趰\";BBLd?  IL>~l/Ф l|>L\nкvN0PPtG\rvQ^Cup6'&|ˮfllNMu.dP\nJ,8^>0n\r\rE<X&d7X#-#CHe{JbJ1	L%Dj:Dqhnǂ}\"pHCZG-66I:\"\\J(=\r߱oq2tv4zʎFܱO^lг΀ɕ qB6%P\rQQ\"2 ;\"Ir2/=`i0h\$r2rip&#2t%#h!(\rҍhh'm*f{%%2NIjHR%(R,?&+,\n?.R-2@,q\n-S(0=nR.\$	'2.)+!1I0=n22>R(C<E-0G0u3O4;̖H̓#ĺL-.~pCpNN33~L7s0@f42KrBm\"dn!8,.;m6O83C\r@d4'\0\n=J%11Ɓ.(CJ5h`0V\"l(`\npft+M.zw9?q6L%DD&x]\nBB2#n3	N%G248T\n4t0\r6\$H΀F<kP(->D<n,\"l@o0Ǉ夻\r]ǌ6L;MjN`?NC@D4RO6C%H}1|SXgƬy@:ay'\"vv	5@kR7>O] PGP2\\0c\$=c'Tr^EgU+sEBU12>OҊfwG,-e)4#@䊵 ";break;case"vi":$f="%(ha\rq]Ҍ]c\rTnAjhc,\"	b5H؉q	Nd)	R!/5!PäA&n&0cAn8QE\r Y\$Eyt9D0Q(Vh<&b-[no\n(U`+~daH8iD\\Pnpu<4k{C3	2Rum]/tUږ[]7;qqwN(a;m{\rB\n'ٻ_2[aTk7)o9HH0c+767 88@@ \\j L+@ƻl7)vOIvL:I枧fakjc]/P!\0d! K P k<M\0\r@h4AN!c3(7\$Xb,(R-2j]2<!iJ NA1[(Rf1B\"\rAZ8B<&u=SI#qtI>(0P2\r<9ph#n\0@C҇\r㭘B%\n\0x3:x{\ra?/p_pcI|63?k4^02T.́BED\",9e9):&Y^\";\n7ZH(J2/C2S)cs2R̩JVJ\"!7\"]q:V6qJćeJZ7k,2 JGV\n5Hƈ3Q7tWcéVI~;U6Ê4J4YfBΓF\n#TĮ@-џR|[46'h(PCcn\r)+uߢ\$\n)C4{au!FTz~ص%WhUH*]RTs/5ux %JaK:V~>91C>h3,t~J6A@	8nZ(C)\r\$\0`\r3*Ih;\\F BnEP.)],\\ Qz^Qfi.Hn2T	3ŕx3@ @WK1@u޼W^|4\0`A4N\rL¢B&~KQAC:G4ċY3oČEғKuK\$t.ػ^|/2}er_D	&BIfmOd9SCNa\"[ȹ{Hq1B@X-IfhMd, \r'C:FԘ.@fԡ*.]Sצ8u['p&i	wD	%|D\"xw8 vag hb>TycHMCY\\E	j:(뾐Ӓč	!KitA5zaH#X)f1&4Ыec6i\0(;(v(Msrsj-DȚ6BI>腦mRu\$\$0\$74B]Q@\$3s&9+\0դ+2| M/\n<)Hws\$LpjĘ\\XK݀:M+C3\$<R3~Gr\"RH(!p*ζ3dҜE2ti-b^f,+N ^EGB\$yQ+ jgF\$X\rE)w8I)>12Y;'zzdqv\"m(YhDӱ^h?#taL_(#/L\00*:G04Uzm(bz\rPLܓsٟwY\n^#\$7Z--\\Ãg95=N\np%ވ#6PكHzgd2s\r1W<%B \"jQefBqV}(*CH^ok-|ԟ c	Mupy\ntj<k|&l|4+xi,	֙Mݭ(#JFUDʪkvjWP*#gXPu|w%#Ì\"xG^\0T\r2I1ܵp,In5F.VpIA*E4|ՄPYxeeCJ^0jRRv䘯87!`+'{Ǜs?p]Ψ(FoKFOKS1DF\"//\nLO\$7\$`)'\n~*DI\n6	.dv6)QF#zԢfFł3\rLSo~8922N-N\0>6'@~BBt^\"b-qbMp5\n˦UЌFA!v\\8KoE0j\r FlڈNY	2GKDpJ/8;>H0\\Lӱdq&![	P(H-T|go%皚\"|JUK/,>XEP{B.\"CcNQq~汅q0h8\\\$\"¡f\"9|pqN\\/Q鶶Ed:j.Nŋ4GF<\$m0(nHѣ	0cn\\qrz.БB	fBQeJbfqQ\"2;\"Nx|*\"D\";G32cRT9e'\$fy'nvkrvN78\$JR!w\0֛n:T\\~_hri!b/,e'HF.-2{'CzW8P(m\r7Qb*9T<?	P%C pZ-I.\"I/3l1р-G4w'\\=(Ds\riF@\nB`#\n\nFBhSn@tlVD67\"福7le{?N+(䓰s%-s3sc<yWNf:ѤE;fZDQe?FméQ645c݈Bez6:w\"{\$:UtAwDO\"hԩ-KHCJ)\0-\n@GI\"S*G;.TcHJ,)\0\nqp8\0JO(ʊG#cFW\$x/K`2nS+1/kHq.003bn6cГ^dJWd+X\"m*K vp.*0a1mP#FA/`\$53\"NFLv`Z5D\$& @6^/F_\$ep4TPJl7j<ElJLOPYZ\"V%NEEU35ĎoRLnm\\roVvMKL\00\njPa^0ʙ*:JU0pzE<u4I\$:N \r>Ə1\$-N\"Aj3q?vfkCD(`";break;case"zh":$f="%:\$\nr.r/dȻ[8 S8rNT*Ю\\9HHZ1!SVJ@%9Ql]m	FU*qQ;Cf4usUUt w:t\nrU:.:PǑ.\r7d^%u)cxU`Fjrs'PnA̛ZEf]EvitUλSծ{Pg5	EPN1	V\nW]\n!zsΟRRVI:(s#.UzΠ@:w'_T\$pVLD')bJ\$pŢ[MZ\n.>sKAZKaLHAtF3D!zHC*re^K#sXg)<v׬hE')2Anrj\n:1'+ֲ2izJsͲ h7]	9HN_esK?	RY4=DF@4C(C@:tT3>x3(9I|1B:LΝ\$=0!tIE'5(RMy&s#SE͒CH]K:KC%um0KV)\"EA(CGAFpܗ&fTYCG)\0DGSW)\0^cTewa D#8s*.]\"h^9zW#s\0]c9a Dj<V]2gC\$CCm8)\"entI4}|=3Q''1Q,g^nKsSL̋&eȜ:ϿC34;.Ml`#@6S6::=9CZ\\u|!p4Z)M=?pA\$_Kz<O66ҙt_No-6MHX:+3.~ɻFbt\"\$r!bJՄP~T]'@Gr[\0 @\$\$C1v+ʛS}P5JJUX+%hxdx:2°_:X%PQ'Ea/1ir\"&B\rBoM ~pOrTJS*Tb*YUnCtV'+uABV2>,E\$\$W1,\"r,E4H=I>ŊH9kdvd\$?M#9# 9t,Ǩ4zZ) @@Pz\"MQ-DV':HIAØG\nTf,8o&Hs_;0hDM#bʹ{mR NAr@a(3WT&(8LZ((-I\0PP\n\"\0C\naH#.)(#g8/I\$V&.FR:E=9)%hhs\nj;?ca@+\\p ZлНW*RdȱQ4G4\\р\0£RAOXcHUt*!Y?l 	EL#@CȈ&	8E@OIy\"9+1dϣR	c(YP*[s E	a/WE`LSA/DMBsFQB.QwEߢ)0t7gʅ2Ş\rna#/-/)&dF@&g@DCOA^|\n|JIas4GEʹnٓ3+n<ArV\n907Àl=\r:1;>t/vJֻNx]&h(jp4\\|GEА,mE\nIpa(h5b`eIiLDxKGo\n5[-l]4:D\nÀ&k4pHÜ=').oI@@<@Q+Ö<Be0^6 Dwk)6QK-(DdXY7'm#Q66wHDX1زhLWfyD'oVә1btR1UoRƣA\\2.QoE	vh[Q[k6b)h˰G.%/5 &9g6]93]wB`qe}d?uh{6{^öQ{47<TdLלR&[O+\\Z0FZr]9^T9-ݏb4AEK=Oj_wE|}ws+|X3jzcX{ߓmo_'Q%44%#yf\$|Q VDI.(-a\"&pQ6;j#v!!()\0d7D.Сso-6OO|G4L/Pat2^\r~'t^Ж#	%	u\nmJv\\a:J^o\\H.L\"4Nbl6O^&	ZׯФ'*eN)j׍qemJq3:a=\"\rhO00'-KqHÛQ\0ϑ)%\"`Set\0l\0@\0m)M1v'OQvl2~1M6ӠPp]11R4FUNTFDRoW 	t@i	#\$-t>F-x^.F,w#\"J8M>,g\rv~p 3F) \$P(C\nZhOC!dH.!6ì6\rdfdgʳT3\n.䊪#\\JN16-L3o2\"p-4*2fL/nҽ+,2fAt,FE&% \r!@,#G1%L\$\$19{2%A\nJs<K;9L>7:qLCo6>(+D\\";break;case"zh-tw":$f="%:\$\ns.eUȸE9PK72(Ph)ʅ@:i	aJe R)ܫ{	Nd(vQDCѮUjaʜTOABPb2ar\nr/TuʮM9Rz?Tא9>SNeI̜Dhw2Y2PcмW*=s7B9J\"XQ2M/J2@\"WrTD{utspS\\=\0Vp\"R )ЪOHΔT\\ӊ:}JF+JV*rEZs!ZyV꽯yPA.yZ6YI)\ns	Z̢[2̒KdJ12A\$&Y+;ZY+\$j[GAn%Jst)P)<?\0Uw*x].2ft+<Kd(A2]*X!rB\n# 4(tE\rl	Tr{:OpbJBO:F@4C(C@:t㽄4)Kx3(9PI|t(B1֯B|\$	q/9H]D̸et\\K6?஋LQ\\1H@PJ2:@ea	&s2So1Qd0ם3Mewd:<C)xGdrBHreBi^1I@\"ZP@fg1pM	j^B<JLf*83(ڰ:s (&^)Dr\n淘1(\\մ	_ܾ7&]>Tt734ҥr</hCHHs,o7|u+wxbØ@6XU:Cp@09#uW97H}U1	~1KTNFQ8)HTKPs3cM#& )FGpXa*%)FG4B',a\na\$\n0Cո)Ȉ%)(pfD N*R:a\0(&D	`\$UV\\z\nXId,xd|:ζV\"@XCt	e/0ʴE#Ȫ髃dpO­WJ_,\"Ɗk%e՞nrEl-b(f\0CG@e}!]>]w/U\$fEhC51QB'!!&Ѱ9sa\"CQ>-0d\$TD2(2xDv\0 \r\$BGu\"#䄑Fօ*DM?!PD*\$G@&d͘tl!E*U)\r\$8lG9i^*hЃL\nf#@A\n/8F[(4ZjI\0C\naH#\0Z')E\$&ra\\E^0\nG0\\Ck=&ȵ4tXEP,S!'BbS*r?QXʼW~9KĂ\"G4N\"xS\nVEFLIfdΜ;&/Uiਪ\r@50T\n;&8L%DޜG*sp,96ԹBLpO	*\0BEX@.	d,^1 #G9##=V0sn黳ba:XVAEX/OD堔qhTػޛE\0*0H P\"`\$ӣR\"\0\0R]aeP\0ֈYEhD4nAj՘q]	9ӑbL!\"J%܆E<07PlJ0Y4B+-gU\r:EH,b*`d\n9ŠhIa͹s6ؗs Br\$.X\\0)/70Ck\rZ@'S|SL6[w5T]&_'^#h?RBhg,NʻJ\"}Jy,C	-|`~Qb,(	@Zt!qz,GHdq\"ؤxG˙xf⍏5<|uQr/TD/.%%9'!蛃@ɿ}Eӽq9\r%\0þo\"3L戴uV\"<ע#N LNL!1|TOaI)x'OF;F(O{f:|0ثSmpk۰fhT\nsO\"*煣Fɓ~?k#I/h8-K'@ڗEn#ϺGVopϒσql>uotnOg<!Wp&Nx6PNP@s\rXuXh.FlC.N`2zorAkrK.\n0\$9\r^Bʛ0>\$\0NU\rpJ\0M8\"LUkPЬ1Jp^`&6HQ4Q9v6w<6א\$Njm	͍\nQb0p_NAxrB.GB^h+B^~(7pKN\rE(!.溓!hڅ0%Qzhq#yL\"'\r\$-\nРQR0DM!\refZF2\0@\0#M#R@{(RPۭ##]\$-B2bM&V2\$ G0ޒ(_*R9)C\$HqyLrK,\r,##,\n)@ZM.aLwAD<^Hi	+N*?H^!Fb:!k1,d:h.3!z\0:R:è^6&rIjY-\0\np9'PO6vB!gJ0bڅ涡R9dÔ1\ru7C\n\\^SȨ\r Ht:q/Bl-/!#Nl3\"O2aTa`bGQAuai#͔./ETNĔJ*, &ʨ\n`ڑS++BmnNB>튟Rw3?nD0J,j2#&rrBN#+ąL";break;}$Li=array();foreach(explode("\n",lzw_decompress($f))as$X)$Li[]=(strpos($X,"\t")?explode("\t",$X):$X);return$Li;}abstract
class
SqlDb{static$ge;var$extension;var$flavor='';var$server_info;var$affected_rows=0;var$info='';var$errno=0;var$error='';protected$multi;abstract
function
attach($N,$V,$F);abstract
function
quote($Q);abstract
function
select_db($Mb);abstract
function
query($H,$Vi=false);function
multi_query($H){return$this->multi=$this->query($H);}function
store_result(){return$this->multi;}function
next_result(){return
false;}}if(extension_loaded('pdo')){abstract
class
PdoDb
extends
SqlDb{protected$pdo;function
dsn($lc,$V,$F,array$Nf=array()){$Nf[\PDO::ATTR_ERRMODE]=\PDO::ERRMODE_SILENT;$Nf[\PDO::ATTR_STATEMENT_CLASS]=array('Adminer\PdoResult');try{$this->pdo=new
\PDO($lc,$V,$F,$Nf);}catch(\Exception$Gc){return$Gc->getMessage();}$this->server_info=@$this->pdo->getAttribute(\PDO::ATTR_SERVER_VERSION);return'';}function
quote($Q){return$this->pdo->quote($Q);}function
query($H,$Vi=false){$I=$this->pdo->query($H);$this->error="";if(!$I){list(,$this->errno,$this->error)=$this->pdo->errorInfo();if(!$this->error)$this->error=lang(21);return
false;}$this->store_result($I);return$I;}function
store_result($I=null){if(!$I){$I=$this->multi;if(!$I)return
false;}if($I->columnCount()){$I->num_rows=$I->rowCount();return$I;}$this->affected_rows=$I->rowCount();return
true;}function
next_result(){$I=$this->multi;if(!is_object($I))return
false;$I->_offset=0;return@$I->nextRowset();}}class
PdoResult
extends
\PDOStatement{var$_offset=0,$num_rows;function
fetch_assoc(){return$this->fetch(\PDO::FETCH_ASSOC);}function
fetch_row(){return$this->fetch(\PDO::FETCH_NUM);}function
fetch_field(){$K=(object)$this->getColumnMeta($this->_offset++);$U=$K->pdo_type;$K->type=($U==\PDO::PARAM_INT?0:15);$K->charsetnr=($U==\PDO::PARAM_LOB||(isset($K->flags)&&in_array("blob",(array)$K->flags))?63:0);return$K;}function
seek($D){for($t=0;$t<$D;$t++)$this->fetch();}}}function
add_driver($u,$C){SqlDriver::$fc[$u]=$C;}function
get_driver($u){return
SqlDriver::$fc[$u];}abstract
class
SqlDriver{static$ge;static$fc=array();static$Oc=array();static$qe;protected$conn;protected$types=array();var$insertFunctions=array();var$editFunctions=array();var$unsigned=array();var$operators=array();var$functions=array();var$grouping=array();var$onActions="RESTRICT|NO ACTION|CASCADE|SET NULL|SET DEFAULT";var$inout="IN|OUT|INOUT";var$enumLength="'(?:''|[^'\\\\]|\\\\.)*'";var$generated=array();static
function
connect($N,$V,$F){$g=new
Db;return($g->attach($N,$V,$F)?:$g);}function
__construct(Db$g){$this->conn=$g;}function
types(){return
call_user_func_array('array_merge',array_values($this->types));}function
structuredTypes(){return
array_map('array_keys',$this->types);}function
enumLength(array$n){}function
unconvertFunction(array$n){}function
select($R,array$M,array$Z,array$ud,array$Pf=array(),$_=1,$E=0,$Eg=false){$le=(count($ud)<count($M));$H=adminer()->selectQueryBuild($M,$Z,$ud,$Pf,$_,$E);if(!$H)$H="SELECT".limit(($_GET["page"]!="last"&&$_&&$ud&&$le&&JUSH=="sql"?"SQL_CALC_FOUND_ROWS ":"").implode(", ",$M)."\nFROM ".table($R),($Z?"\nWHERE ".implode(" AND ",$Z):"").($ud&&$le?"\nGROUP BY ".implode(", ",$ud):"").($Pf?"\nORDER BY ".implode(", ",$Pf):""),$_,($E?$_*$E:0),"\n");$Vh=microtime(true);$J=$this->conn->query($H);if($Eg)echo
adminer()->selectQuery($H,$Vh,!$J);return$J;}function
delete($R,$Ng,$_=0){$H="FROM ".table($R);return
queries("DELETE".($_?limit1($R,$H,$Ng):" $H$Ng"));}function
update($R,array$O,$Ng,$_=0,$zh="\n"){$oj=array();foreach($O
as$y=>$X)$oj[]="$y = $X";$H=table($R)." SET$zh".implode(",$zh",$oj);return
queries("UPDATE".($_?limit1($R,$H,$Ng,$zh):" $H$Ng"));}function
insert($R,array$O){return
queries("INSERT INTO ".table($R).($O?" (".implode(", ",array_keys($O)).")\nVALUES (".implode(", ",$O).")":" DEFAULT VALUES").$this->insertReturning($R));}function
insertReturning($R){return"";}function
insertUpdate($R,array$L,array$G){return
false;}function
begin(){return
queries("BEGIN");}function
commit(){return
queries("COMMIT");}function
rollback(){return
queries("ROLLBACK");}function
slowQuery($H,$yi){}function
convertSearch($v,array$X,array$n){return$v;}function
convertOperator($Jf){return$Jf;}function
value($X,array$n){return(method_exists($this->conn,'value')?$this->conn->value($X,$n):(is_resource($X)?stream_get_contents($X):$X));}function
quoteBinary($mh){return
q($mh);}function
warnings(){}function
tableHelp($C,$oe=false){}function
hasCStyleEscapes(){return
false;}function
engines(){return
array();}function
supportsIndex(array$S){return!is_view($S);}function
checkConstraints($R){return
get_key_vals("SELECT c.CONSTRAINT_NAME, CHECK_CLAUSE
FROM INFORMATION_SCHEMA.CHECK_CONSTRAINTS c
JOIN INFORMATION_SCHEMA.TABLE_CONSTRAINTS t ON c.CONSTRAINT_SCHEMA = t.CONSTRAINT_SCHEMA AND c.CONSTRAINT_NAME = t.CONSTRAINT_NAME
WHERE c.CONSTRAINT_SCHEMA = ".q($_GET["ns"]!=""?$_GET["ns"]:DB)."
AND t.TABLE_NAME = ".q($R)."
AND CHECK_CLAUSE NOT LIKE '% IS NOT NULL'",$this->conn);}function
allFields(){$J=array();foreach(get_rows("SELECT TABLE_NAME AS tab, COLUMN_NAME AS field, IS_NULLABLE AS nullable, DATA_TYPE AS type, CHARACTER_MAXIMUM_LENGTH AS length".(JUSH=='sql'?", COLUMN_KEY = 'PRI' AS `primary`":"")."
FROM INFORMATION_SCHEMA.COLUMNS
WHERE TABLE_SCHEMA = ".q($_GET["ns"]!=""?$_GET["ns"]:DB)."
ORDER BY TABLE_NAME, ORDINAL_POSITION",$this->conn)as$K){$K["null"]=($K["nullable"]=="YES");$J[$K["tab"]][]=$K;}return$J;}}add_driver("sqlite","SQLite");if(isset($_GET["sqlite"])){define('Adminer\DRIVER',"sqlite");if(class_exists("SQLite3")&&$_GET["ext"]!="pdo"){abstract
class
SqliteDb
extends
SqlDb{var$extension="SQLite3";private$link;function
attach($p,$V,$F){$this->link=new
\SQLite3($p);$rj=$this->link->version();$this->server_info=$rj["versionString"];return'';}function
query($H,$Vi=false){$I=@$this->link->query($H);$this->error="";if(!$I){$this->errno=$this->link->lastErrorCode();$this->error=$this->link->lastErrorMsg();return
false;}elseif($I->numColumns())return
new
Result($I);$this->affected_rows=$this->link->changes();return
true;}function
quote($Q){return(is_utf8($Q)?"'".$this->link->escapeString($Q)."'":"x'".first(unpack('H*',$Q))."'");}}class
Result{var$num_rows;private$result,$offset=0;function
__construct($I){$this->result=$I;}function
fetch_assoc(){return$this->result->fetchArray(SQLITE3_ASSOC);}function
fetch_row(){return$this->result->fetchArray(SQLITE3_NUM);}function
fetch_field(){$d=$this->offset++;$U=$this->result->columnType($d);return(object)array("name"=>$this->result->columnName($d),"type"=>($U==SQLITE3_TEXT?15:0),"charsetnr"=>($U==SQLITE3_BLOB?63:0),);}function
__destruct(){$this->result->finalize();}}}elseif(extension_loaded("pdo_sqlite")){abstract
class
SqliteDb
extends
PdoDb{var$extension="PDO_SQLite";function
attach($p,$V,$F){$this->dsn(DRIVER.":$p","","");$this->query("PRAGMA foreign_keys = 1");$this->query("PRAGMA busy_timeout = 500");return'';}}}if(class_exists('Adminer\SqliteDb')){class
Db
extends
SqliteDb{function
attach($p,$V,$F){parent::attach($p,$V,$F);$this->query("PRAGMA foreign_keys = 1");$this->query("PRAGMA busy_timeout = 500");return'';}function
select_db($p){if(is_readable($p)&&$this->query("ATTACH ".$this->quote(preg_match("~(^[/\\\\]|:)~",$p)?$p:dirname($_SERVER["SCRIPT_FILENAME"])."/$p")." AS a"))return!self::attach($p,'','');return
false;}}}class
Driver
extends
SqlDriver{static$Oc=array("SQLite3","PDO_SQLite");static$qe="sqlite";protected$types=array(array("integer"=>0,"real"=>0,"numeric"=>0,"text"=>0,"blob"=>0));var$insertFunctions=array();var$editFunctions=array("integer|real|numeric"=>"+/-","text"=>"||",);var$operators=array("=","<",">","<=",">=","!=","LIKE","LIKE %%","IN","IS NULL","NOT LIKE","NOT IN","IS NOT NULL","SQL");var$functions=array("hex","length","lower","round","unixepoch","upper");var$grouping=array("avg","count","count distinct","group_concat","max","min","sum");static
function
connect($N,$V,$F){if($F!="")return
lang(22);return
parent::connect(":memory:","","");}function
__construct(Db$g){parent::__construct($g);if(min_version(3.31,0,$g))$this->generated=array("STORED","VIRTUAL");}function
structuredTypes(){return
array_keys($this->types[0]);}function
insertUpdate($R,array$L,array$G){$oj=array();foreach($L
as$O)$oj[]="(".implode(", ",$O).")";return
queries("REPLACE INTO ".table($R)." (".implode(", ",array_keys(reset($L))).") VALUES\n".implode(",\n",$oj));}function
tableHelp($C,$oe=false){if($C=="sqlite_sequence")return"fileformat2.html#seqtab";if($C=="sqlite_master")return"fileformat2.html#$C";}function
checkConstraints($R){preg_match_all('~ CHECK *(\( *(((?>[^()]*[^() ])|(?1))*) *\))~',get_val("SELECT sql FROM sqlite_master WHERE type = 'table' AND name = ".q($R),0,$this->conn),$Pe);return
array_combine($Pe[2],$Pe[2]);}function
allFields(){$J=array();foreach(tables_list()as$R=>$U){foreach(fields($R)as$n)$J[$R][]=$n;}return$J;}}function
idf_escape($v){return'"'.str_replace('"','""',$v).'"';}function
table($v){return
idf_escape($v);}function
get_databases($fd){return
array();}function
limit($H,$Z,$_,$D=0,$zh=" "){return" $H$Z".($_?$zh."LIMIT $_".($D?" OFFSET $D":""):"");}function
limit1($R,$H,$Z,$zh="\n"){return(preg_match('~^INTO~',$H)||get_val("SELECT sqlite_compileoption_used('ENABLE_UPDATE_DELETE_LIMIT')")?limit($H,$Z,1,0,$zh):" $H WHERE rowid = (SELECT rowid FROM ".table($R).$Z.$zh."LIMIT 1)");}function
db_collation($k,$jb){return
get_val("PRAGMA encoding");}function
logged_user(){return
get_current_user();}function
tables_list(){return
get_key_vals("SELECT name, type FROM sqlite_master WHERE type IN ('table', 'view') ORDER BY (name = 'sqlite_sequence'), name");}function
count_tables($j){return
array();}function
table_status($C=""){$J=array();foreach(get_rows("SELECT name AS Name, type AS Engine, 'rowid' AS Oid, '' AS Auto_increment FROM sqlite_master WHERE type IN ('table', 'view') ".($C!=""?"AND name = ".q($C):"ORDER BY name"))as$K){$K["Rows"]=get_val("SELECT COUNT(*) FROM ".idf_escape($K["Name"]));$J[$K["Name"]]=$K;}foreach(get_rows("SELECT * FROM sqlite_sequence".($C!=""?" WHERE name = ".q($C):""),null,"")as$K)$J[$K["name"]]["Auto_increment"]=$K["seq"];return$J;}function
is_view($S){return$S["Engine"]=="view";}function
fk_support($S){return!get_val("SELECT sqlite_compileoption_used('OMIT_FOREIGN_KEY')");}function
fields($R){$J=array();$G="";foreach(get_rows("PRAGMA table_".(min_version(3.31)?"x":"")."info(".table($R).")")as$K){$C=$K["name"];$U=strtolower($K["type"]);$l=$K["dflt_value"];$J[$C]=array("field"=>$C,"type"=>(preg_match('~int~i',$U)?"integer":(preg_match('~char|clob|text~i',$U)?"text":(preg_match('~blob~i',$U)?"blob":(preg_match('~real|floa|doub~i',$U)?"real":"numeric")))),"full_type"=>$U,"default"=>(preg_match("~^'(.*)'$~",$l,$B)?str_replace("''","'",$B[1]):($l=="NULL"?null:$l)),"null"=>!$K["notnull"],"privileges"=>array("select"=>1,"insert"=>1,"update"=>1,"where"=>1,"order"=>1),"primary"=>$K["pk"],);if($K["pk"]){if($G!="")$J[$G]["auto_increment"]=false;elseif(preg_match('~^integer$~i',$U))$J[$C]["auto_increment"]=true;$G=$C;}}$Ph=get_val("SELECT sql FROM sqlite_master WHERE type = 'table' AND name = ".q($R));$v='(("[^"]*+")+|[a-z0-9_]+)';preg_match_all('~'.$v.'\s+text\s+COLLATE\s+(\'[^\']+\'|\S+)~i',$Ph,$Pe,PREG_SET_ORDER);foreach($Pe
as$B){$C=str_replace('""','"',preg_replace('~^"|"$~','',$B[1]));if($J[$C])$J[$C]["collation"]=trim($B[3],"'");}preg_match_all('~'.$v.'\s.*GENERATED ALWAYS AS \((.+)\) (STORED|VIRTUAL)~i',$Ph,$Pe,PREG_SET_ORDER);foreach($Pe
as$B){$C=str_replace('""','"',preg_replace('~^"|"$~','',$B[1]));$J[$C]["default"]=$B[3];$J[$C]["generated"]=strtoupper($B[4]);}return$J;}function
indexes($R,$h=null){$h=connection($h);$J=array();$Ph=get_val("SELECT sql FROM sqlite_master WHERE type = 'table' AND name = ".q($R),0,$h);if(preg_match('~\bPRIMARY\s+KEY\s*\((([^)"]+|"[^"]*"|`[^`]*`)++)~i',$Ph,$B)){$J[""]=array("type"=>"PRIMARY","columns"=>array(),"lengths"=>array(),"descs"=>array());preg_match_all('~((("[^"]*+")+|(?:`[^`]*+`)+)|(\S+))(\s+(ASC|DESC))?(,\s*|$)~i',$B[1],$Pe,PREG_SET_ORDER);foreach($Pe
as$B){$J[""]["columns"][]=idf_unescape($B[2]).$B[4];$J[""]["descs"][]=(preg_match('~DESC~i',$B[5])?'1':null);}}if(!$J){foreach(fields($R)as$C=>$n){if($n["primary"])$J[""]=array("type"=>"PRIMARY","columns"=>array($C),"lengths"=>array(),"descs"=>array(null));}}$Th=get_key_vals("SELECT name, sql FROM sqlite_master WHERE type = 'index' AND tbl_name = ".q($R),$h);foreach(get_rows("PRAGMA index_list(".table($R).")",$h)as$K){$C=$K["name"];$w=array("type"=>($K["unique"]?"UNIQUE":"INDEX"));$w["lengths"]=array();$w["descs"]=array();foreach(get_rows("PRAGMA index_info(".idf_escape($C).")",$h)as$lh){$w["columns"][]=$lh["name"];$w["descs"][]=null;}if(preg_match('~^CREATE( UNIQUE)? INDEX '.preg_quote(idf_escape($C).' ON '.idf_escape($R),'~').' \((.*)\)$~i',$Th[$C],$Yg)){preg_match_all('/("[^"]*+")+( DESC)?/',$Yg[2],$Pe);foreach($Pe[2]as$y=>$X){if($X)$w["descs"][$y]='1';}}if(!$J[""]||$w["type"]!="UNIQUE"||$w["columns"]!=$J[""]["columns"]||$w["descs"]!=$J[""]["descs"]||!preg_match("~^sqlite_~",$C))$J[$C]=$w;}return$J;}function
foreign_keys($R){$J=array();foreach(get_rows("PRAGMA foreign_key_list(".table($R).")")as$K){$q=&$J[$K["id"]];if(!$q)$q=$K;$q["source"][]=$K["from"];$q["target"][]=$K["to"];}return$J;}function
view($C){return
array("select"=>preg_replace('~^(?:[^`"[]+|`[^`]*`|"[^"]*")* AS\s+~iU','',get_val("SELECT sql FROM sqlite_master WHERE type = 'view' AND name = ".q($C))));}function
collations(){return(isset($_GET["create"])?get_vals("PRAGMA collation_list",1):array());}function
information_schema($k){return
false;}function
error(){return
h(connection()->error);}function
check_sqlite_name($C){$Oc="db|sdb|sqlite";if(!preg_match("~^[^\\0]*\\.($Oc)\$~",$C)){connection()->error=lang(23,str_replace("|",", ",$Oc));return
false;}return
true;}function
create_database($k,$c){if(file_exists($k)){connection()->error=lang(24);return
false;}if(!check_sqlite_name($k))return
false;try{$A=new
Db();$A->attach($k,'','');}catch(\Exception$Gc){connection()->error=$Gc->getMessage();return
false;}$A->query('PRAGMA encoding = "UTF-8"');$A->query('CREATE TABLE adminer (i)');$A->query('DROP TABLE adminer');return
true;}function
drop_databases($j){connection()->attach(":memory:",'','');foreach($j
as$k){if(!@unlink($k)){connection()->error=lang(24);return
false;}}return
true;}function
rename_database($C,$c){if(!check_sqlite_name($C))return
false;connection()->attach(":memory:",'','');connection()->error=lang(24);return@rename(DB,$C);}function
auto_increment(){return" PRIMARY KEY AUTOINCREMENT";}function
alter_table($R,$C,$o,$hd,$ob,$wc,$c,$Ba,$mg){$hj=($R==""||$hd);foreach($o
as$n){if($n[0]!=""||!$n[1]||$n[2]){$hj=true;break;}}$b=array();$ag=array();foreach($o
as$n){if($n[1]){$b[]=($hj?$n[1]:"ADD ".implode($n[1]));if($n[0]!="")$ag[$n[0]]=$n[1][0];}}if(!$hj){foreach($b
as$X){if(!queries("ALTER TABLE ".table($R)." $X"))return
false;}if($R!=$C&&!queries("ALTER TABLE ".table($R)." RENAME TO ".table($C)))return
false;}elseif(!recreate_table($R,$C,$b,$ag,$hd,$Ba))return
false;if($Ba){queries("BEGIN");queries("UPDATE sqlite_sequence SET seq = $Ba WHERE name = ".q($C));if(!connection()->affected_rows)queries("INSERT INTO sqlite_sequence (name, seq) VALUES (".q($C).", $Ba)");queries("COMMIT");}return
true;}function
recreate_table($R,$C,array$o,array$ag,array$hd,$Ba="",$x=array(),$hc="",$la=""){if($R!=""){if(!$o){foreach(fields($R)as$y=>$n){if($x)$n["auto_increment"]=0;$o[]=process_field($n,$n);$ag[$y]=idf_escape($y);}}$Dg=false;foreach($o
as$n){if($n[6])$Dg=true;}$jc=array();foreach($x
as$y=>$X){if($X[2]=="DROP"){$jc[$X[1]]=true;unset($x[$y]);}}foreach(indexes($R)as$se=>$w){$e=array();foreach($w["columns"]as$y=>$d){if(!$ag[$d])continue
2;$e[]=$ag[$d].($w["descs"][$y]?" DESC":"");}if(!$jc[$se]){if($w["type"]!="PRIMARY"||!$Dg)$x[]=array($w["type"],$se,$e);}}foreach($x
as$y=>$X){if($X[0]=="PRIMARY"){unset($x[$y]);$hd[]="  PRIMARY KEY (".implode(", ",$X[2]).")";}}foreach(foreign_keys($R)as$se=>$q){foreach($q["source"]as$y=>$d){if(!$ag[$d])continue
2;$q["source"][$y]=idf_unescape($ag[$d]);}if(!isset($hd[" $se"]))$hd[]=" ".format_foreign_key($q);}queries("BEGIN");}$Va=array();foreach($o
as$n){if(preg_match('~GENERATED~',$n[3]))unset($ag[array_search($n[0],$ag)]);$Va[]="  ".implode($n);}$Va=array_merge($Va,array_filter($hd));foreach(driver()->checkConstraints($R)as$Xa){if($Xa!=$hc)$Va[]="  CHECK ($Xa)";}if($la)$Va[]="  CHECK ($la)";$si=($R==$C?"adminer_$C":$C);if(!queries("CREATE TABLE ".table($si)." (\n".implode(",\n",$Va)."\n)"))return
false;if($R!=""){if($ag&&!queries("INSERT INTO ".table($si)." (".implode(", ",$ag).") SELECT ".implode(", ",array_map('Adminer\idf_escape',array_keys($ag)))." FROM ".table($R)))return
false;$Ri=array();foreach(triggers($R)as$Pi=>$zi){$Oi=trigger($Pi,$R);$Ri[]="CREATE TRIGGER ".idf_escape($Pi)." ".implode(" ",$zi)." ON ".table($C)."\n$Oi[Statement]";}$Ba=$Ba?"":get_val("SELECT seq FROM sqlite_sequence WHERE name = ".q($R));if(!queries("DROP TABLE ".table($R))||($R==$C&&!queries("ALTER TABLE ".table($si)." RENAME TO ".table($C)))||!alter_indexes($C,$x))return
false;if($Ba)queries("UPDATE sqlite_sequence SET seq = $Ba WHERE name = ".q($C));foreach($Ri
as$Oi){if(!queries($Oi))return
false;}queries("COMMIT");}return
true;}function
index_sql($R,$U,$C,$e){return"CREATE $U ".($U!="INDEX"?"INDEX ":"").idf_escape($C!=""?$C:uniqid($R."_"))." ON ".table($R)." $e";}function
alter_indexes($R,$b){foreach($b
as$G){if($G[0]=="PRIMARY")return
recreate_table($R,$R,array(),array(),array(),"",$b);}foreach(array_reverse($b)as$X){if(!queries($X[2]=="DROP"?"DROP INDEX ".idf_escape($X[1]):index_sql($R,$X[0],$X[1],"(".implode(", ",$X[2]).")")))return
false;}return
true;}function
truncate_tables($T){return
apply_queries("DELETE FROM",$T);}function
drop_views($tj){return
apply_queries("DROP VIEW",$tj);}function
drop_tables($T){return
apply_queries("DROP TABLE",$T);}function
move_tables($T,$tj,$qi){return
false;}function
trigger($C,$R){if($C=="")return
array("Statement"=>"BEGIN\n\t;\nEND");$v='(?:[^`"\s]+|`[^`]*`|"[^"]*")+';$Qi=trigger_options();preg_match("~^CREATE\\s+TRIGGER\\s*$v\\s*(".implode("|",$Qi["Timing"]).")\\s+([a-z]+)(?:\\s+OF\\s+($v))?\\s+ON\\s*$v\\s*(?:FOR\\s+EACH\\s+ROW\\s)?(.*)~is",get_val("SELECT sql FROM sqlite_master WHERE type = 'trigger' AND name = ".q($C)),$B);$yf=$B[3];return
array("Timing"=>strtoupper($B[1]),"Event"=>strtoupper($B[2]).($yf?" OF":""),"Of"=>idf_unescape($yf),"Trigger"=>$C,"Statement"=>$B[4],);}function
triggers($R){$J=array();$Qi=trigger_options();foreach(get_rows("SELECT * FROM sqlite_master WHERE type = 'trigger' AND tbl_name = ".q($R))as$K){preg_match('~^CREATE\s+TRIGGER\s*(?:[^`"\s]+|`[^`]*`|"[^"]*")+\s*('.implode("|",$Qi["Timing"]).')\s*(.*?)\s+ON\b~i',$K["sql"],$B);$J[$K["name"]]=array($B[1],$B[2]);}return$J;}function
trigger_options(){return
array("Timing"=>array("BEFORE","AFTER","INSTEAD OF"),"Event"=>array("INSERT","UPDATE","UPDATE OF","DELETE"),"Type"=>array("FOR EACH ROW"),);}function
begin(){return
queries("BEGIN");}function
last_id($I){return
get_val("SELECT LAST_INSERT_ROWID()");}function
explain($g,$H){return$g->query("EXPLAIN QUERY PLAN $H");}function
found_rows($S,$Z){}function
types(){return
array();}function
create_sql($R,$Ba,$Zh){$J=get_val("SELECT sql FROM sqlite_master WHERE type IN ('table', 'view') AND name = ".q($R));foreach(indexes($R)as$C=>$w){if($C=='')continue;$J
.=";\n\n".index_sql($R,$w['type'],$C,"(".implode(", ",array_map('Adminer\idf_escape',$w['columns'])).")");}return$J;}function
truncate_sql($R){return"DELETE FROM ".table($R);}function
use_sql($Mb){}function
trigger_sql($R){return
implode(get_vals("SELECT sql || ';;\n' FROM sqlite_master WHERE type = 'trigger' AND tbl_name = ".q($R)));}function
show_variables(){$J=array();foreach(get_rows("PRAGMA pragma_list")as$K){$C=$K["name"];if($C!="pragma_list"&&$C!="compile_options"){$J[$C]=array($C,'');foreach(get_rows("PRAGMA $C")as$K)$J[$C][1].=implode(", ",$K)."\n";}}return$J;}function
show_status(){$J=array();foreach(get_vals("PRAGMA compile_options")as$Mf)$J[]=explode("=",$Mf,2)+array('','');return$J;}function
convert_field($n){}function
unconvert_field($n,$J){return$J;}function
support($Tc){return
preg_match('~^(check|columns|database|drop_col|dump|indexes|descidx|move_col|sql|status|table|trigger|variables|view|view_trigger)$~',$Tc);}}add_driver("pgsql","PostgreSQL");if(isset($_GET["pgsql"])){define('Adminer\DRIVER',"pgsql");if(extension_loaded("pgsql")&&$_GET["ext"]!="pdo"){class
PgsqlDb
extends
SqlDb{var$extension="PgSQL";var$timeout=0;private$link,$string,$database=true;function
_error($Bc,$m){if(ini_bool("html_errors"))$m=html_entity_decode(strip_tags($m));$m=preg_replace('~^[^:]*: ~','',$m);$this->error=$m;}function
attach($N,$V,$F){$k=adminer()->database();set_error_handler(array($this,'_error'));$this->string="host='".str_replace(":","' port='",addcslashes($N,"'\\"))."' user='".addcslashes($V,"'\\")."' password='".addcslashes($F,"'\\")."'";$Uh=adminer()->connectSsl();if(isset($Uh["mode"]))$this->string
.=" sslmode='".$Uh["mode"]."'";$this->link=@pg_connect("$this->string dbname='".($k!=""?addcslashes($k,"'\\"):"postgres")."'",PGSQL_CONNECT_FORCE_NEW);if(!$this->link&&$k!=""){$this->database=false;$this->link=@pg_connect("$this->string dbname='postgres'",PGSQL_CONNECT_FORCE_NEW);}restore_error_handler();if($this->link)pg_set_client_encoding($this->link,"UTF8");return($this->link?'':$this->error);}function
quote($Q){return(function_exists('pg_escape_literal')?pg_escape_literal($this->link,$Q):"'".pg_escape_string($this->link,$Q)."'");}function
value($X,array$n){return($n["type"]=="bytea"&&$X!==null?pg_unescape_bytea($X):$X);}function
select_db($Mb){if($Mb==adminer()->database())return$this->database;$J=@pg_connect("$this->string dbname='".addcslashes($Mb,"'\\")."'",PGSQL_CONNECT_FORCE_NEW);if($J)$this->link=$J;return$J;}function
close(){$this->link=@pg_connect("$this->string dbname='postgres'");}function
query($H,$Vi=false){$I=@pg_query($this->link,$H);$this->error="";if(!$I){$this->error=pg_last_error($this->link);$J=false;}elseif(!pg_num_fields($I)){$this->affected_rows=pg_affected_rows($I);$J=true;}else$J=new
Result($I);if($this->timeout){$this->timeout=0;$this->query("RESET statement_timeout");}return$J;}function
warnings(){return
h(pg_last_notice($this->link));}function
copyFrom($R,array$L){$this->error='';set_error_handler(function($Bc,$m){$this->error=(ini_bool('html_errors')?html_entity_decode($m):$m);});$J=pg_copy_from($this->link,$R,$L);restore_error_handler();return$J;}}class
Result{var$num_rows;private$result,$offset=0;function
__construct($I){$this->result=$I;$this->num_rows=pg_num_rows($I);}function
fetch_assoc(){return
pg_fetch_assoc($this->result);}function
fetch_row(){return
pg_fetch_row($this->result);}function
fetch_field(){$d=$this->offset++;$J=new
\stdClass;$J->orgtable=pg_field_table($this->result,$d);$J->name=pg_field_name($this->result,$d);$J->type=pg_field_type($this->result,$d);$J->charsetnr=($J->type=="bytea"?63:0);return$J;}function
__destruct(){pg_free_result($this->result);}}}elseif(extension_loaded("pdo_pgsql")){class
PgsqlDb
extends
PdoDb{var$extension="PDO_PgSQL";var$timeout=0;function
attach($N,$V,$F){$k=adminer()->database();$lc="pgsql:host='".str_replace(":","' port='",addcslashes($N,"'\\"))."' client_encoding=utf8 dbname='".($k!=""?addcslashes($k,"'\\"):"postgres")."'";$Uh=adminer()->connectSsl();if(isset($Uh["mode"]))$lc
.=" sslmode='".$Uh["mode"]."'";return$this->dsn($lc,$V,$F);}function
select_db($Mb){return(adminer()->database()==$Mb);}function
query($H,$Vi=false){$J=parent::query($H,$Vi);if($this->timeout){$this->timeout=0;parent::query("RESET statement_timeout");}return$J;}function
warnings(){}function
copyFrom($R,array$L){$J=$this->pdo->pgsqlCopyFromArray($R,$L);$this->error=idx($this->pdo->errorInfo(),2)?:'';return$J;}function
close(){}}}if(class_exists('Adminer\PgsqlDb')){class
Db
extends
PgsqlDb{function
multi_query($H){if(preg_match('~\bCOPY\s+(.+?)\s+FROM\s+stdin;\n?(.*)\n\\\\\.$~is',str_replace("\r\n","\n",$H),$B)){$L=explode("\n",$B[2]);$this->affected_rows=count($L);return$this->copyFrom($B[1],$L);}return
parent::multi_query($H);}}}class
Driver
extends
SqlDriver{static$Oc=array("PgSQL","PDO_PgSQL");static$qe="pgsql";var$operators=array("=","<",">","<=",">=","!=","~","!~","LIKE","LIKE %%","ILIKE","ILIKE %%","IN","IS NULL","NOT LIKE","NOT IN","IS NOT NULL");var$functions=array("char_length","lower","round","to_hex","to_timestamp","upper");var$grouping=array("avg","count","count distinct","max","min","sum");static
function
connect($N,$V,$F){$g=parent::connect($N,$V,$F);if(is_string($g))return$g;$rj=get_val("SELECT version()",0,$g);$g->flavor=(preg_match('~CockroachDB~',$rj)?'cockroach':'');$g->server_info=preg_replace('~^\D*([\d.]+[-\w]*).*~','\1',$rj);if(min_version(9,0,$g))$g->query("SET application_name = 'Adminer'");if($g->flavor=='cockroach')add_driver(DRIVER,"CockroachDB");return$g;}function
__construct(Db$g){parent::__construct($g);$this->types=array(lang(25)=>array("smallint"=>5,"integer"=>10,"bigint"=>19,"boolean"=>1,"numeric"=>0,"real"=>7,"double precision"=>16,"money"=>20),lang(26)=>array("date"=>13,"time"=>17,"timestamp"=>20,"timestamptz"=>21,"interval"=>0),lang(27)=>array("character"=>0,"character varying"=>0,"text"=>0,"tsquery"=>0,"tsvector"=>0,"uuid"=>0,"xml"=>0),lang(28)=>array("bit"=>0,"bit varying"=>0,"bytea"=>0),lang(29)=>array("cidr"=>43,"inet"=>43,"macaddr"=>17,"macaddr8"=>23,"txid_snapshot"=>0),lang(30)=>array("box"=>0,"circle"=>0,"line"=>0,"lseg"=>0,"path"=>0,"point"=>0,"polygon"=>0),);if(min_version(9.2,0,$g)){$this->types[lang(27)]["json"]=4294967295;if(min_version(9.4,0,$g))$this->types[lang(27)]["jsonb"]=4294967295;}$this->insertFunctions=array("char"=>"md5","date|time"=>"now",);$this->editFunctions=array(number_type()=>"+/-","date|time"=>"+ interval/- interval","char|text"=>"||",);if(min_version(12,0,$g))$this->generated=array("STORED");}function
enumLength(array$n){$yc=$this->types[lang(31)][$n["type"]];return($yc?type_values($yc):"");}function
setUserTypes($Ui){$this->types[lang(31)]=array_flip($Ui);}function
insertReturning($R){$Ba=array_filter(fields($R),function($n){return$n['auto_increment'];});return(count($Ba)==1?" RETURNING ".idf_escape(key($Ba)):"");}function
insertUpdate($R,array$L,array$G){foreach($L
as$O){$dj=array();$Z=array();foreach($O
as$y=>$X){$dj[]="$y = $X";if(isset($G[idf_unescape($y)]))$Z[]="$y = $X";}if(!(($Z&&queries("UPDATE ".table($R)." SET ".implode(", ",$dj)." WHERE ".implode(" AND ",$Z))&&connection()->affected_rows)||queries("INSERT INTO ".table($R)." (".implode(", ",array_keys($O)).") VALUES (".implode(", ",$O).")")))return
false;}return
true;}function
slowQuery($H,$yi){$this->conn->query("SET statement_timeout = ".(1000*$yi));$this->conn->timeout=1000*$yi;return$H;}function
convertSearch($v,array$X,array$n){$vi="char|text";if(strpos($X["op"],"LIKE")===false)$vi
.="|date|time(stamp)?|boolean|uuid|inet|cidr|macaddr|".number_type();return(preg_match("~$vi~",$n["type"])?$v:"CAST($v AS text)");}function
quoteBinary($mh){return"'\\x".bin2hex($mh)."'";}function
warnings(){return$this->conn->warnings();}function
tableHelp($C,$oe=false){$He=array("information_schema"=>"infoschema","pg_catalog"=>($oe?"view":"catalog"),);$A=$He[$_GET["ns"]];if($A)return"$A-".str_replace("_","-",$C).".html";}function
supportsIndex(array$S){return$S["Engine"]!="view";}function
hasCStyleEscapes(){static$Ra;if($Ra===null)$Ra=(get_val("SHOW standard_conforming_strings",0,$this->conn)=="off");return$Ra;}}function
idf_escape($v){return'"'.str_replace('"','""',$v).'"';}function
table($v){return
idf_escape($v);}function
get_databases($fd){return
get_vals("SELECT datname FROM pg_database
WHERE datallowconn = TRUE AND has_database_privilege(datname, 'CONNECT')
ORDER BY datname");}function
limit($H,$Z,$_,$D=0,$zh=" "){return" $H$Z".($_?$zh."LIMIT $_".($D?" OFFSET $D":""):"");}function
limit1($R,$H,$Z,$zh="\n"){return(preg_match('~^INTO~',$H)?limit($H,$Z,1,0,$zh):" $H".(is_view(table_status1($R))?$Z:$zh."WHERE ctid = (SELECT ctid FROM ".table($R).$Z.$zh."LIMIT 1)"));}function
db_collation($k,$jb){return
get_val("SELECT datcollate FROM pg_database WHERE datname = ".q($k));}function
logged_user(){return
get_val("SELECT user");}function
tables_list(){$H="SELECT table_name, table_type FROM information_schema.tables WHERE table_schema = current_schema()";if(support("materializedview"))$H
.="
UNION ALL
SELECT matviewname, 'MATERIALIZED VIEW'
FROM pg_matviews
WHERE schemaname = current_schema()";$H
.="
ORDER BY 1";return
get_key_vals($H);}function
count_tables($j){$J=array();foreach($j
as$k){if(connection()->select_db($k))$J[$k]=count(tables_list());}return$J;}function
table_status($C=""){static$Dd;if($Dd===null)$Dd=get_val("SELECT 'pg_table_size'::regproc");$J=array();foreach(get_rows("SELECT
	c.relname AS \"Name\",
	CASE c.relkind WHEN 'r' THEN 'table' WHEN 'm' THEN 'materialized view' ELSE 'view' END AS \"Engine\"".($Dd?",
	pg_table_size(c.oid) AS \"Data_length\",
	pg_indexes_size(c.oid) AS \"Index_length\"":"").",
	obj_description(c.oid, 'pg_class') AS \"Comment\",
	".(min_version(12)?"''":"CASE WHEN c.relhasoids THEN 'oid' ELSE '' END")." AS \"Oid\",
	c.reltuples as \"Rows\",
	n.nspname
FROM pg_class c
JOIN pg_namespace n ON(n.nspname = current_schema() AND n.oid = c.relnamespace)
WHERE relkind IN ('r', 'm', 'v', 'f', 'p')
".($C!=""?"AND relname = ".q($C):"ORDER BY relname"))as$K)$J[$K["Name"]]=$K;return$J;}function
is_view($S){return
in_array($S["Engine"],array("view","materialized view"));}function
fk_support($S){return
true;}function
fields($R){$J=array();$ta=array('timestamp without time zone'=>'timestamp','timestamp with time zone'=>'timestamptz',);foreach(get_rows("SELECT
	a.attname AS field,
	format_type(a.atttypid, a.atttypmod) AS full_type,
	pg_get_expr(d.adbin, d.adrelid) AS default,
	a.attnotnull::int,
	col_description(c.oid, a.attnum) AS comment".(min_version(10)?",
	a.attidentity".(min_version(12)?",
	a.attgenerated":""):"")."
FROM pg_class c
JOIN pg_namespace n ON c.relnamespace = n.oid
JOIN pg_attribute a ON c.oid = a.attrelid
LEFT JOIN pg_attrdef d ON c.oid = d.adrelid AND a.attnum = d.adnum
WHERE c.relname = ".q($R)."
AND n.nspname = current_schema()
AND NOT a.attisdropped
AND a.attnum > 0
ORDER BY a.attnum")as$K){preg_match('~([^([]+)(\((.*)\))?([a-z ]+)?((\[[0-9]*])*)$~',$K["full_type"],$B);list(,$U,$z,$K["length"],$ma,$xa)=$B;$K["length"].=$xa;$Za=$U.$ma;if(isset($ta[$Za])){$K["type"]=$ta[$Za];$K["full_type"]=$K["type"].$z.$xa;}else{$K["type"]=$U;$K["full_type"]=$K["type"].$z.$ma.$xa;}if(in_array($K['attidentity'],array('a','d')))$K['default']='GENERATED '.($K['attidentity']=='d'?'BY DEFAULT':'ALWAYS').' AS IDENTITY';$K["generated"]=($K["attgenerated"]=="s"?"STORED":"");$K["null"]=!$K["attnotnull"];$K["auto_increment"]=$K['attidentity']||preg_match('~^nextval\(~i',$K["default"])||preg_match('~^unique_rowid\(~',$K["default"]);$K["privileges"]=array("insert"=>1,"select"=>1,"update"=>1,"where"=>1,"order"=>1);if(preg_match('~(.+)::[^,)]+(.*)~',$K["default"],$B))$K["default"]=($B[1]=="NULL"?null:idf_unescape($B[1]).$B[2]);$J[$K["field"]]=$K;}return$J;}function
indexes($R,$h=null){$h=connection($h);$J=array();$ii=get_val("SELECT oid FROM pg_class WHERE relnamespace = (SELECT oid FROM pg_namespace WHERE nspname = current_schema()) AND relname = ".q($R),0,$h);$e=get_key_vals("SELECT attnum, attname FROM pg_attribute WHERE attrelid = $ii AND attnum > 0",$h);foreach(get_rows("SELECT relname, indisunique::int, indisprimary::int, indkey, indoption, (indpred IS NOT NULL)::int as indispartial
FROM pg_index i, pg_class ci
WHERE i.indrelid = $ii AND ci.oid = i.indexrelid
ORDER BY indisprimary DESC, indisunique DESC",$h)as$K){$Zg=$K["relname"];$J[$Zg]["type"]=($K["indispartial"]?"INDEX":($K["indisprimary"]?"PRIMARY":($K["indisunique"]?"UNIQUE":"INDEX")));$J[$Zg]["columns"]=array();$J[$Zg]["descs"]=array();if($K["indkey"]){foreach(explode(" ",$K["indkey"])as$Yd)$J[$Zg]["columns"][]=$e[$Yd];foreach(explode(" ",$K["indoption"])as$Zd)$J[$Zg]["descs"][]=(intval($Zd)&1?'1':null);}$J[$Zg]["lengths"]=array();}return$J;}function
foreign_keys($R){$J=array();foreach(get_rows("SELECT conname, condeferrable::int AS deferrable, pg_get_constraintdef(oid) AS definition
FROM pg_constraint
WHERE conrelid = (SELECT pc.oid FROM pg_class AS pc INNER JOIN pg_namespace AS pn ON (pn.oid = pc.relnamespace) WHERE pc.relname = ".q($R)." AND pn.nspname = current_schema())
AND contype = 'f'::char
ORDER BY conkey, conname")as$K){if(preg_match('~FOREIGN KEY\s*\((.+)\)\s*REFERENCES (.+)\((.+)\)(.*)$~iA',$K['definition'],$B)){$K['source']=array_map('Adminer\idf_unescape',array_map('trim',explode(',',$B[1])));if(preg_match('~^(("([^"]|"")+"|[^"]+)\.)?"?("([^"]|"")+"|[^"]+)$~',$B[2],$Ne)){$K['ns']=idf_unescape($Ne[2]);$K['table']=idf_unescape($Ne[4]);}$K['target']=array_map('Adminer\idf_unescape',array_map('trim',explode(',',$B[3])));$K['on_delete']=(preg_match("~ON DELETE (".driver()->onActions.")~",$B[4],$Ne)?$Ne[1]:'NO ACTION');$K['on_update']=(preg_match("~ON UPDATE (".driver()->onActions.")~",$B[4],$Ne)?$Ne[1]:'NO ACTION');$J[$K['conname']]=$K;}}return$J;}function
view($C){return
array("select"=>trim(get_val("SELECT pg_get_viewdef(".get_val("SELECT oid FROM pg_class WHERE relnamespace = (SELECT oid FROM pg_namespace WHERE nspname = current_schema()) AND relname = ".q($C)).")")));}function
collations(){return
array();}function
information_schema($k){return
get_schema()=="information_schema";}function
error(){$J=h(connection()->error);if(preg_match('~^(.*\n)?([^\n]*)\n( *)\^(\n.*)?$~s',$J,$B))$J=$B[1].preg_replace('~((?:[^&]|&[^;]*;){'.strlen($B[3]).'})(.*)~','\1<b>\2</b>',$B[2]).$B[4];return
nl_br($J);}function
create_database($k,$c){return
queries("CREATE DATABASE ".idf_escape($k).($c?" ENCODING ".idf_escape($c):""));}function
drop_databases($j){connection()->close();return
apply_queries("DROP DATABASE",$j,'Adminer\idf_escape');}function
rename_database($C,$c){connection()->close();return
queries("ALTER DATABASE ".idf_escape(DB)." RENAME TO ".idf_escape($C));}function
auto_increment(){return"";}function
alter_table($R,$C,$o,$hd,$ob,$wc,$c,$Ba,$mg){$b=array();$Mg=array();if($R!=""&&$R!=$C)$Mg[]="ALTER TABLE ".table($R)." RENAME TO ".table($C);$_h="";foreach($o
as$n){$d=idf_escape($n[0]);$X=$n[1];if(!$X)$b[]="DROP $d";else{$nj=$X[5];unset($X[5]);if($n[0]==""){if(isset($X[6]))$X[1]=($X[1]==" bigint"?" big":($X[1]==" smallint"?" small":" "))."serial";$b[]=($R!=""?"ADD ":"  ").implode($X);if(isset($X[6]))$b[]=($R!=""?"ADD":" ")." PRIMARY KEY ($X[0])";}else{if($d!=$X[0])$Mg[]="ALTER TABLE ".table($C)." RENAME $d TO $X[0]";$b[]="ALTER $d TYPE$X[1]";$Ah=$R."_".idf_unescape($X[0])."_seq";$b[]="ALTER $d ".($X[3]?"SET".preg_replace('~GENERATED ALWAYS(.*) STORED~','EXPRESSION\1',$X[3]):(isset($X[6])?"SET DEFAULT nextval(".q($Ah).")":"DROP DEFAULT"));if(isset($X[6]))$_h="CREATE SEQUENCE IF NOT EXISTS ".idf_escape($Ah)." OWNED BY ".idf_escape($R).".$X[0]";$b[]="ALTER $d ".($X[2]==" NULL"?"DROP NOT":"SET").$X[2];}if($n[0]!=""||$nj!="")$Mg[]="COMMENT ON COLUMN ".table($C).".$X[0] IS ".($nj!=""?substr($nj,9):"''");}}$b=array_merge($b,$hd);if($R=="")array_unshift($Mg,"CREATE TABLE ".table($C)." (\n".implode(",\n",$b)."\n)");elseif($b)array_unshift($Mg,"ALTER TABLE ".table($R)."\n".implode(",\n",$b));if($_h)array_unshift($Mg,$_h);if($ob!==null)$Mg[]="COMMENT ON TABLE ".table($C)." IS ".q($ob);foreach($Mg
as$H){if(!queries($H))return
false;}return
true;}function
alter_indexes($R,$b){$i=array();$gc=array();$Mg=array();foreach($b
as$X){if($X[0]!="INDEX")$i[]=($X[2]=="DROP"?"\nDROP CONSTRAINT ".idf_escape($X[1]):"\nADD".($X[1]!=""?" CONSTRAINT ".idf_escape($X[1]):"")." $X[0] ".($X[0]=="PRIMARY"?"KEY ":"")."(".implode(", ",$X[2]).")");elseif($X[2]=="DROP")$gc[]=idf_escape($X[1]);else$Mg[]="CREATE INDEX ".idf_escape($X[1]!=""?$X[1]:uniqid($R."_"))." ON ".table($R)." (".implode(", ",$X[2]).")";}if($i)array_unshift($Mg,"ALTER TABLE ".table($R).implode(",",$i));if($gc)array_unshift($Mg,"DROP INDEX ".implode(", ",$gc));foreach($Mg
as$H){if(!queries($H))return
false;}return
true;}function
truncate_tables($T){return
queries("TRUNCATE ".implode(", ",array_map('Adminer\table',$T)));}function
drop_views($tj){return
drop_tables($tj);}function
drop_tables($T){foreach($T
as$R){$P=table_status1($R);if(!queries("DROP ".strtoupper($P["Engine"])." ".table($R)))return
false;}return
true;}function
move_tables($T,$tj,$qi){foreach(array_merge($T,$tj)as$R){$P=table_status1($R);if(!queries("ALTER ".strtoupper($P["Engine"])." ".table($R)." SET SCHEMA ".idf_escape($qi)))return
false;}return
true;}function
trigger($C,$R){if($C=="")return
array("Statement"=>"EXECUTE PROCEDURE ()");$e=array();$Z="WHERE trigger_schema = current_schema() AND event_object_table = ".q($R)." AND trigger_name = ".q($C);foreach(get_rows("SELECT * FROM information_schema.triggered_update_columns $Z")as$K)$e[]=$K["event_object_column"];$J=array();foreach(get_rows('SELECT trigger_name AS "Trigger", action_timing AS "Timing", event_manipulation AS "Event", \'FOR EACH \' || action_orientation AS "Type", action_statement AS "Statement"
FROM information_schema.triggers'."
$Z
ORDER BY event_manipulation DESC")as$K){if($e&&$K["Event"]=="UPDATE")$K["Event"].=" OF";$K["Of"]=implode(", ",$e);if($J)$K["Event"].=" OR $J[Event]";$J=$K;}return$J;}function
triggers($R){$J=array();foreach(get_rows("SELECT * FROM information_schema.triggers WHERE trigger_schema = current_schema() AND event_object_table = ".q($R))as$K){$Oi=trigger($K["trigger_name"],$R);$J[$Oi["Trigger"]]=array($Oi["Timing"],$Oi["Event"]);}return$J;}function
trigger_options(){return
array("Timing"=>array("BEFORE","AFTER"),"Event"=>array("INSERT","UPDATE","UPDATE OF","DELETE","INSERT OR UPDATE","INSERT OR UPDATE OF","DELETE OR INSERT","DELETE OR UPDATE","DELETE OR UPDATE OF","DELETE OR INSERT OR UPDATE","DELETE OR INSERT OR UPDATE OF"),"Type"=>array("FOR EACH ROW","FOR EACH STATEMENT"),);}function
routine($C,$U){$L=get_rows('SELECT routine_definition AS definition, LOWER(external_language) AS language, *
FROM information_schema.routines
WHERE routine_schema = current_schema() AND specific_name = '.q($C));$J=idx($L,0,array());$J["returns"]=array("type"=>$J["type_udt_name"]);$J["fields"]=get_rows('SELECT parameter_name AS field, data_type AS type, character_maximum_length AS length, parameter_mode AS inout
FROM information_schema.parameters
WHERE specific_schema = current_schema() AND specific_name = '.q($C).'
ORDER BY ordinal_position');return$J;}function
routines(){return
get_rows('SELECT specific_name AS "SPECIFIC_NAME", routine_type AS "ROUTINE_TYPE", routine_name AS "ROUTINE_NAME", type_udt_name AS "DTD_IDENTIFIER"
FROM information_schema.routines
WHERE routine_schema = current_schema()
ORDER BY SPECIFIC_NAME');}function
routine_languages(){return
get_vals("SELECT LOWER(lanname) FROM pg_catalog.pg_language");}function
routine_id($C,$K){$J=array();foreach($K["fields"]as$n){$z=$n["length"];$J[]=$n["type"].($z?"($z)":"");}return
idf_escape($C)."(".implode(", ",$J).")";}function
last_id($I){$K=(is_object($I)?$I->fetch_row():array());return($K?$K[0]:0);}function
explain($g,$H){return$g->query("EXPLAIN $H");}function
found_rows($S,$Z){if(preg_match("~ rows=([0-9]+)~",get_val("EXPLAIN SELECT * FROM ".idf_escape($S["Name"]).($Z?" WHERE ".implode(" AND ",$Z):"")),$Yg))return$Yg[1];}function
types(){return
get_key_vals("SELECT oid, typname
FROM pg_type
WHERE typnamespace = (SELECT oid FROM pg_namespace WHERE nspname = current_schema())
AND typtype IN ('b','d','e')
AND typelem = 0");}function
type_values($u){$Ac=get_vals("SELECT enumlabel FROM pg_enum WHERE enumtypid = $u ORDER BY enumsortorder");return($Ac?"'".implode("', '",array_map('addslashes',$Ac))."'":"");}function
schemas(){return
get_vals("SELECT nspname FROM pg_namespace ORDER BY nspname");}function
get_schema(){return
get_val("SELECT current_schema()");}function
set_schema($oh,$h=null){if(!$h)$h=connection();$J=$h->query("SET search_path TO ".idf_escape($oh));driver()->setUserTypes(types());return$J;}function
foreign_keys_sql($R){$J="";$P=table_status1($R);$dd=foreign_keys($R);ksort($dd);foreach($dd
as$cd=>$bd)$J
.="ALTER TABLE ONLY ".idf_escape($P['nspname']).".".idf_escape($P['Name'])." ADD CONSTRAINT ".idf_escape($cd)." $bd[definition] ".($bd['deferrable']?'DEFERRABLE':'NOT DEFERRABLE').";\n";return($J?"$J\n":$J);}function
create_sql($R,$Ba,$Zh){$eh=array();$Bh=array();$P=table_status1($R);if(is_view($P)){$sj=view($R);return
rtrim("CREATE VIEW ".idf_escape($R)." AS $sj[select]",";");}$o=fields($R);if(count($P)<2||empty($o))return
false;$J="CREATE TABLE ".idf_escape($P['nspname']).".".idf_escape($P['Name'])." (\n    ";foreach($o
as$n){$jg=idf_escape($n['field']).' '.$n['full_type'].default_value($n).($n['null']?"":" NOT NULL");$eh[]=$jg;if(preg_match('~nextval\(\'([^\']+)\'\)~',$n['default'],$Pe)){$Ah=$Pe[1];$Oh=first(get_rows((min_version(10)?"SELECT *, cache_size AS cache_value FROM pg_sequences WHERE schemaname = current_schema() AND sequencename = ".q(idf_unescape($Ah)):"SELECT * FROM $Ah"),null,"-- "));$Bh[]=($Zh=="DROP+CREATE"?"DROP SEQUENCE IF EXISTS $Ah;\n":"")."CREATE SEQUENCE $Ah INCREMENT $Oh[increment_by] MINVALUE $Oh[min_value] MAXVALUE $Oh[max_value]".($Ba&&$Oh['last_value']?" START ".($Oh["last_value"]+1):"")." CACHE $Oh[cache_value];";}}if(!empty($Bh))$J=implode("\n\n",$Bh)."\n\n$J";$G="";foreach(indexes($R)as$Wd=>$w){if($w['type']=='PRIMARY'){$G=$Wd;$eh[]="CONSTRAINT ".idf_escape($Wd)." PRIMARY KEY (".implode(', ',array_map('Adminer\idf_escape',$w['columns'])).")";}}foreach(driver()->checkConstraints($R)as$tb=>$vb)$eh[]="CONSTRAINT ".idf_escape($tb)." CHECK $vb";$J
.=implode(",\n    ",$eh)."\n) WITH (oids = ".($P['Oid']?'true':'false').");";if($P['Comment'])$J
.="\n\nCOMMENT ON TABLE ".idf_escape($P['nspname']).".".idf_escape($P['Name'])." IS ".q($P['Comment']).";";foreach($o
as$Vc=>$n){if($n['comment'])$J
.="\n\nCOMMENT ON COLUMN ".idf_escape($P['nspname']).".".idf_escape($P['Name']).".".idf_escape($Vc)." IS ".q($n['comment']).";";}foreach(get_rows("SELECT indexdef FROM pg_catalog.pg_indexes WHERE schemaname = current_schema() AND tablename = ".q($R).($G?" AND indexname != ".q($G):""),null,"-- ")as$K)$J
.="\n\n$K[indexdef];";return
rtrim($J,';');}function
truncate_sql($R){return"TRUNCATE ".table($R);}function
trigger_sql($R){$P=table_status1($R);$J="";foreach(triggers($R)as$Ni=>$Mi){$Oi=trigger($Ni,$P['Name']);$J
.="\nCREATE TRIGGER ".idf_escape($Oi['Trigger'])." $Oi[Timing] $Oi[Event] ON ".idf_escape($P["nspname"]).".".idf_escape($P['Name'])." $Oi[Type] $Oi[Statement];;\n";}return$J;}function
use_sql($Mb){return"\connect ".idf_escape($Mb);}function
show_variables(){return
get_rows("SHOW ALL");}function
process_list(){return
get_rows("SELECT * FROM pg_stat_activity ORDER BY ".(min_version(9.2)?"pid":"procpid"));}function
convert_field($n){}function
unconvert_field($n,$J){return$J;}function
support($Tc){return
preg_match('~^(check|database|table|columns|sql|indexes|descidx|comment|view|'.(min_version(9.3)?'materializedview|':'').'scheme|'.(min_version(11)?'procedure|':'').'routine|sequence|trigger|type|variables|drop_col'.(connection()->flavor=='cockroach'?'':'|processlist').'|kill|dump)$~',$Tc);}function
kill_process($X){return
queries("SELECT pg_terminate_backend(".number($X).")");}function
connection_id(){return"SELECT pg_backend_pid()";}function
max_connections(){return
get_val("SHOW max_connections");}}add_driver("oracle","Oracle (beta)");if(isset($_GET["oracle"])){define('Adminer\DRIVER',"oracle");if(extension_loaded("oci8")&&$_GET["ext"]!="pdo"){class
Db
extends
SqlDb{var$extension="oci8";var$_current_db;private$link;function
_error($Bc,$m){if(ini_bool("html_errors"))$m=html_entity_decode(strip_tags($m));$m=preg_replace('~^[^:]*: ~','',$m);$this->error=$m;}function
attach($N,$V,$F){$this->link=@oci_new_connect($V,$F,$N,"AL32UTF8");if($this->link){$this->server_info=oci_server_version($this->link);return'';}$m=oci_error();return$m["message"];}function
quote($Q){return"'".str_replace("'","''",$Q)."'";}function
select_db($Mb){$this->_current_db=$Mb;return
true;}function
query($H,$Vi=false){$I=oci_parse($this->link,$H);$this->error="";if(!$I){$m=oci_error($this->link);$this->errno=$m["code"];$this->error=$m["message"];return
false;}set_error_handler(array($this,'_error'));$J=@oci_execute($I);restore_error_handler();if($J){if(oci_num_fields($I))return
new
Result($I);$this->affected_rows=oci_num_rows($I);oci_free_statement($I);}return$J;}}class
Result{var$num_rows;private$result,$offset=1;function
__construct($I){$this->result=$I;}private
function
convert($K){foreach((array)$K
as$y=>$X){if(is_a($X,'OCILob')||is_a($X,'OCI-Lob'))$K[$y]=$X->load();}return$K;}function
fetch_assoc(){return$this->convert(oci_fetch_assoc($this->result));}function
fetch_row(){return$this->convert(oci_fetch_row($this->result));}function
fetch_field(){$d=$this->offset++;$J=new
\stdClass;$J->name=oci_field_name($this->result,$d);$J->type=oci_field_type($this->result,$d);$J->charsetnr=(preg_match("~raw|blob|bfile~",$J->type)?63:0);return$J;}function
__destruct(){oci_free_statement($this->result);}}}elseif(extension_loaded("pdo_oci")){class
Db
extends
PdoDb{var$extension="PDO_OCI";var$_current_db;function
attach($N,$V,$F){return$this->dsn("oci:dbname=//$N;charset=AL32UTF8",$V,$F);}function
select_db($Mb){$this->_current_db=$Mb;return
true;}}}class
Driver
extends
SqlDriver{static$Oc=array("OCI8","PDO_OCI");static$qe="oracle";var$insertFunctions=array("date"=>"current_date","timestamp"=>"current_timestamp",);var$editFunctions=array("number|float|double"=>"+/-","date|timestamp"=>"+ interval/- interval","char|clob"=>"||",);var$operators=array("=","<",">","<=",">=","!=","LIKE","LIKE %%","IN","IS NULL","NOT LIKE","NOT IN","IS NOT NULL","SQL");var$functions=array("length","lower","round","upper");var$grouping=array("avg","count","count distinct","max","min","sum");function
__construct(Db$g){parent::__construct($g);$this->types=array(lang(25)=>array("number"=>38,"binary_float"=>12,"binary_double"=>21),lang(26)=>array("date"=>10,"timestamp"=>29,"interval year"=>12,"interval day"=>28),lang(27)=>array("char"=>2000,"varchar2"=>4000,"nchar"=>2000,"nvarchar2"=>4000,"clob"=>4294967295,"nclob"=>4294967295),lang(28)=>array("raw"=>2000,"long raw"=>2147483648,"blob"=>4294967295,"bfile"=>4294967296),);}function
begin(){return
true;}function
insertUpdate($R,array$L,array$G){foreach($L
as$O){$dj=array();$Z=array();foreach($O
as$y=>$X){$dj[]="$y = $X";if(isset($G[idf_unescape($y)]))$Z[]="$y = $X";}if(!(($Z&&queries("UPDATE ".table($R)." SET ".implode(", ",$dj)." WHERE ".implode(" AND ",$Z))&&connection()->affected_rows)||queries("INSERT INTO ".table($R)." (".implode(", ",array_keys($O)).") VALUES (".implode(", ",$O).")")))return
false;}return
true;}function
hasCStyleEscapes(){return
true;}}function
idf_escape($v){return'"'.str_replace('"','""',$v).'"';}function
table($v){return
idf_escape($v);}function
get_databases($fd){return
get_vals("SELECT DISTINCT tablespace_name FROM (
SELECT tablespace_name FROM user_tablespaces
UNION SELECT tablespace_name FROM all_tables WHERE tablespace_name IS NOT NULL
)
ORDER BY 1");}function
limit($H,$Z,$_,$D=0,$zh=" "){return($D?" * FROM (SELECT t.*, rownum AS rnum FROM (SELECT $H$Z) t WHERE rownum <= ".($_+$D).") WHERE rnum > $D":($_?" * FROM (SELECT $H$Z) WHERE rownum <= ".($_+$D):" $H$Z"));}function
limit1($R,$H,$Z,$zh="\n"){return" $H$Z";}function
db_collation($k,$jb){return
get_val("SELECT value FROM nls_database_parameters WHERE parameter = 'NLS_CHARACTERSET'");}function
logged_user(){return
get_val("SELECT USER FROM DUAL");}function
get_current_db(){$k=connection()->_current_db?:DB;unset(connection()->_current_db);return$k;}function
where_owner($Bg,$dg="owner"){if(!$_GET["ns"])return'';return"$Bg$dg = sys_context('USERENV', 'CURRENT_SCHEMA')";}function
views_table($e){$dg=where_owner('');return"(SELECT $e FROM all_views WHERE ".($dg?:"rownum < 0").")";}function
tables_list(){$sj=views_table("view_name");$dg=where_owner(" AND ");return
get_key_vals("SELECT table_name, 'table' FROM all_tables WHERE tablespace_name = ".q(DB)."$dg
UNION SELECT view_name, 'view' FROM $sj
ORDER BY 1");}function
count_tables($j){$J=array();foreach($j
as$k)$J[$k]=get_val("SELECT COUNT(*) FROM all_tables WHERE tablespace_name = ".q($k));return$J;}function
table_status($C=""){$J=array();$sh=q($C);$k=get_current_db();$sj=views_table("view_name");$dg=where_owner(" AND ");foreach(get_rows('SELECT table_name "Name", \'table\' "Engine", avg_row_len * num_rows "Data_length", num_rows "Rows" FROM all_tables WHERE tablespace_name = '.q($k).$dg.($C!=""?" AND table_name = $sh":"")."
UNION SELECT view_name, 'view', 0, 0 FROM $sj".($C!=""?" WHERE view_name = $sh":"")."
ORDER BY 1")as$K)$J[$K["Name"]]=$K;return$J;}function
is_view($S){return$S["Engine"]=="view";}function
fk_support($S){return
true;}function
fields($R){$J=array();$dg=where_owner(" AND ");foreach(get_rows("SELECT * FROM all_tab_columns WHERE table_name = ".q($R)."$dg ORDER BY column_id")as$K){$U=$K["DATA_TYPE"];$z="$K[DATA_PRECISION],$K[DATA_SCALE]";if($z==",")$z=$K["CHAR_COL_DECL_LENGTH"];$J[$K["COLUMN_NAME"]]=array("field"=>$K["COLUMN_NAME"],"full_type"=>$U.($z?"($z)":""),"type"=>strtolower($U),"length"=>$z,"default"=>$K["DATA_DEFAULT"],"null"=>($K["NULLABLE"]=="Y"),"privileges"=>array("insert"=>1,"select"=>1,"update"=>1,"where"=>1,"order"=>1),);}return$J;}function
indexes($R,$h=null){$J=array();$dg=where_owner(" AND ","aic.table_owner");foreach(get_rows("SELECT aic.*, ac.constraint_type, atc.data_default
FROM all_ind_columns aic
LEFT JOIN all_constraints ac ON aic.index_name = ac.constraint_name AND aic.table_name = ac.table_name AND aic.index_owner = ac.owner
LEFT JOIN all_tab_cols atc ON aic.column_name = atc.column_name AND aic.table_name = atc.table_name AND aic.index_owner = atc.owner
WHERE aic.table_name = ".q($R)."$dg
ORDER BY ac.constraint_type, aic.column_position",$h)as$K){$Wd=$K["INDEX_NAME"];$lb=$K["DATA_DEFAULT"];$lb=($lb?trim($lb,'"'):$K["COLUMN_NAME"]);$J[$Wd]["type"]=($K["CONSTRAINT_TYPE"]=="P"?"PRIMARY":($K["CONSTRAINT_TYPE"]=="U"?"UNIQUE":"INDEX"));$J[$Wd]["columns"][]=$lb;$J[$Wd]["lengths"][]=($K["CHAR_LENGTH"]&&$K["CHAR_LENGTH"]!=$K["COLUMN_LENGTH"]?$K["CHAR_LENGTH"]:null);$J[$Wd]["descs"][]=($K["DESCEND"]&&$K["DESCEND"]=="DESC"?'1':null);}return$J;}function
view($C){$sj=views_table("view_name, text");$L=get_rows('SELECT text "select" FROM '.$sj.' WHERE view_name = '.q($C));return
reset($L);}function
collations(){return
array();}function
information_schema($k){return
get_schema()=="INFORMATION_SCHEMA";}function
error(){return
h(connection()->error);}function
explain($g,$H){$g->query("EXPLAIN PLAN FOR $H");return$g->query("SELECT * FROM plan_table");}function
found_rows($S,$Z){}function
auto_increment(){return"";}function
alter_table($R,$C,$o,$hd,$ob,$wc,$c,$Ba,$mg){$b=$gc=array();$Wf=($R?fields($R):array());foreach($o
as$n){$X=$n[1];if($X&&$n[0]!=""&&idf_escape($n[0])!=$X[0])queries("ALTER TABLE ".table($R)." RENAME COLUMN ".idf_escape($n[0])." TO $X[0]");$Vf=$Wf[$n[0]];if($X&&$Vf){$_f=process_field($Vf,$Vf);if($X[2]==$_f[2])$X[2]="";}if($X)$b[]=($R!=""?($n[0]!=""?"MODIFY (":"ADD ("):"  ").implode($X).($R!=""?")":"");else$gc[]=idf_escape($n[0]);}if($R=="")return
queries("CREATE TABLE ".table($C)." (\n".implode(",\n",$b)."\n)");return(!$b||queries("ALTER TABLE ".table($R)."\n".implode("\n",$b)))&&(!$gc||queries("ALTER TABLE ".table($R)." DROP (".implode(", ",$gc).")"))&&($R==$C||queries("ALTER TABLE ".table($R)." RENAME TO ".table($C)));}function
alter_indexes($R,$b){$gc=array();$Mg=array();foreach($b
as$X){if($X[0]!="INDEX"){$X[2]=preg_replace('~ DESC$~','',$X[2]);$i=($X[2]=="DROP"?"\nDROP CONSTRAINT ".idf_escape($X[1]):"\nADD".($X[1]!=""?" CONSTRAINT ".idf_escape($X[1]):"")." $X[0] ".($X[0]=="PRIMARY"?"KEY ":"")."(".implode(", ",$X[2]).")");array_unshift($Mg,"ALTER TABLE ".table($R).$i);}elseif($X[2]=="DROP")$gc[]=idf_escape($X[1]);else$Mg[]="CREATE INDEX ".idf_escape($X[1]!=""?$X[1]:uniqid($R."_"))." ON ".table($R)." (".implode(", ",$X[2]).")";}if($gc)array_unshift($Mg,"DROP INDEX ".implode(", ",$gc));foreach($Mg
as$H){if(!queries($H))return
false;}return
true;}function
foreign_keys($R){$J=array();$H="SELECT c_list.CONSTRAINT_NAME as NAME,
c_src.COLUMN_NAME as SRC_COLUMN,
c_dest.OWNER as DEST_DB,
c_dest.TABLE_NAME as DEST_TABLE,
c_dest.COLUMN_NAME as DEST_COLUMN,
c_list.DELETE_RULE as ON_DELETE
FROM ALL_CONSTRAINTS c_list, ALL_CONS_COLUMNS c_src, ALL_CONS_COLUMNS c_dest
WHERE c_list.CONSTRAINT_NAME = c_src.CONSTRAINT_NAME
AND c_list.R_CONSTRAINT_NAME = c_dest.CONSTRAINT_NAME
AND c_list.CONSTRAINT_TYPE = 'R'
AND c_src.TABLE_NAME = ".q($R);foreach(get_rows($H)as$K)$J[$K['NAME']]=array("db"=>$K['DEST_DB'],"table"=>$K['DEST_TABLE'],"source"=>array($K['SRC_COLUMN']),"target"=>array($K['DEST_COLUMN']),"on_delete"=>$K['ON_DELETE'],"on_update"=>null,);return$J;}function
truncate_tables($T){return
apply_queries("TRUNCATE TABLE",$T);}function
drop_views($tj){return
apply_queries("DROP VIEW",$tj);}function
drop_tables($T){return
apply_queries("DROP TABLE",$T);}function
last_id($I){return
0;}function
schemas(){$J=get_vals("SELECT DISTINCT owner FROM dba_segments WHERE owner IN (SELECT username FROM dba_users WHERE default_tablespace NOT IN ('SYSTEM','SYSAUX')) ORDER BY 1");return($J?:get_vals("SELECT DISTINCT owner FROM all_tables WHERE tablespace_name = ".q(DB)." ORDER BY 1"));}function
get_schema(){return
get_val("SELECT sys_context('USERENV', 'SESSION_USER') FROM dual");}function
set_schema($qh,$h=null){if(!$h)$h=connection();return$h->query("ALTER SESSION SET CURRENT_SCHEMA = ".idf_escape($qh));}function
show_variables(){return
get_rows('SELECT name, display_value FROM v$parameter');}function
show_status(){$J=array();$L=get_rows('SELECT * FROM v$instance');foreach(reset($L)as$y=>$X)$J[]=array($y,$X);return$J;}function
process_list(){return
get_rows('SELECT
	sess.process AS "process",
	sess.username AS "user",
	sess.schemaname AS "schema",
	sess.status AS "status",
	sess.wait_class AS "wait_class",
	sess.seconds_in_wait AS "seconds_in_wait",
	sql.sql_text AS "sql_text",
	sess.machine AS "machine",
	sess.port AS "port"
FROM v$session sess LEFT OUTER JOIN v$sql sql
ON sql.sql_id = sess.sql_id
WHERE sess.type = \'USER\'
ORDER BY PROCESS
');}function
convert_field($n){}function
unconvert_field($n,$J){return$J;}function
support($Tc){return
preg_match('~^(columns|database|drop_col|indexes|descidx|processlist|scheme|sql|status|table|variables|view)$~',$Tc);}}add_driver("mssql","MS SQL");if(isset($_GET["mssql"])){define('Adminer\DRIVER',"mssql");if(extension_loaded("sqlsrv")&&$_GET["ext"]!="pdo"){class
Db
extends
SqlDb{var$extension="sqlsrv";private$link,$result;private
function
get_error(){$this->error="";foreach(sqlsrv_errors()as$m){$this->errno=$m["code"];$this->error
.="$m[message]\n";}$this->error=rtrim($this->error);}function
attach($N,$V,$F){$ub=array("UID"=>$V,"PWD"=>$F,"CharacterSet"=>"UTF-8");$Uh=adminer()->connectSsl();if(isset($Uh["Encrypt"]))$ub["Encrypt"]=$Uh["Encrypt"];if(isset($Uh["TrustServerCertificate"]))$ub["TrustServerCertificate"]=$Uh["TrustServerCertificate"];$k=adminer()->database();if($k!="")$ub["Database"]=$k;$this->link=@sqlsrv_connect(preg_replace('~:~',',',$N),$ub);if($this->link){$ae=sqlsrv_server_info($this->link);$this->server_info=$ae['SQLServerVersion'];}else$this->get_error();return($this->link?'':$this->error);}function
quote($Q){$Wi=strlen($Q)!=strlen(utf8_decode($Q));return($Wi?"N":"")."'".str_replace("'","''",$Q)."'";}function
select_db($Mb){return$this->query(use_sql($Mb));}function
query($H,$Vi=false){$I=sqlsrv_query($this->link,$H);$this->error="";if(!$I){$this->get_error();return
false;}return$this->store_result($I);}function
multi_query($H){$this->result=sqlsrv_query($this->link,$H);$this->error="";if(!$this->result){$this->get_error();return
false;}return
true;}function
store_result($I=null){if(!$I)$I=$this->result;if(!$I)return
false;if(sqlsrv_field_metadata($I))return
new
Result($I);$this->affected_rows=sqlsrv_rows_affected($I);return
true;}function
next_result(){return$this->result?!!sqlsrv_next_result($this->result):false;}}class
Result{var$num_rows;private$result,$offset=0,$fields;function
__construct($I){$this->result=$I;}private
function
convert($K){foreach((array)$K
as$y=>$X){if(is_a($X,'DateTime'))$K[$y]=$X->format("Y-m-d H:i:s");}return$K;}function
fetch_assoc(){return$this->convert(sqlsrv_fetch_array($this->result,SQLSRV_FETCH_ASSOC));}function
fetch_row(){return$this->convert(sqlsrv_fetch_array($this->result,SQLSRV_FETCH_NUMERIC));}function
fetch_field(){if(!$this->fields)$this->fields=sqlsrv_field_metadata($this->result);$n=$this->fields[$this->offset++];$J=new
\stdClass;$J->name=$n["Name"];$J->type=($n["Type"]==1?254:15);$J->charsetnr=0;return$J;}function
seek($D){for($t=0;$t<$D;$t++)sqlsrv_fetch($this->result);}function
__destruct(){sqlsrv_free_stmt($this->result);}}function
last_id($I){return
get_val("SELECT SCOPE_IDENTITY()");}function
explain($g,$H){$g->query("SET SHOWPLAN_ALL ON");$J=$g->query($H);$g->query("SET SHOWPLAN_ALL OFF");return$J;}}else{abstract
class
MssqlDb
extends
PdoDb{function
select_db($Mb){return$this->query(use_sql($Mb));}function
lastInsertId(){return$this->pdo->lastInsertId();}}function
last_id($I){return
connection()->lastInsertId();}function
explain($g,$H){}if(extension_loaded("pdo_sqlsrv")){class
Db
extends
MssqlDb{var$extension="PDO_SQLSRV";function
attach($N,$V,$F){return$this->dsn("sqlsrv:Server=".str_replace(":",",",$N),$V,$F);}}}elseif(extension_loaded("pdo_dblib")){class
Db
extends
MssqlDb{var$extension="PDO_DBLIB";function
attach($N,$V,$F){return$this->dsn("dblib:charset=utf8;host=".str_replace(":",";unix_socket=",preg_replace('~:(\d)~',';port=\1',$N)),$V,$F);}}}}class
Driver
extends
SqlDriver{static$Oc=array("SQLSRV","PDO_SQLSRV","PDO_DBLIB");static$qe="mssql";var$insertFunctions=array("date|time"=>"getdate");var$editFunctions=array("int|decimal|real|float|money|datetime"=>"+/-","char|text"=>"+",);var$operators=array("=","<",">","<=",">=","!=","LIKE","LIKE %%","IN","IS NULL","NOT LIKE","NOT IN","IS NOT NULL");var$functions=array("len","lower","round","upper");var$grouping=array("avg","count","count distinct","max","min","sum");var$generated=array("PERSISTED","VIRTUAL");var$onActions="NO ACTION|CASCADE|SET NULL|SET DEFAULT";static
function
connect($N,$V,$F){if($N=="")$N="localhost:1433";return
parent::connect($N,$V,$F);}function
__construct(Db$g){parent::__construct($g);$this->types=array(lang(25)=>array("tinyint"=>3,"smallint"=>5,"int"=>10,"bigint"=>20,"bit"=>1,"decimal"=>0,"real"=>12,"float"=>53,"smallmoney"=>10,"money"=>20),lang(26)=>array("date"=>10,"smalldatetime"=>19,"datetime"=>19,"datetime2"=>19,"time"=>8,"datetimeoffset"=>10),lang(27)=>array("char"=>8000,"varchar"=>8000,"text"=>2147483647,"nchar"=>4000,"nvarchar"=>4000,"ntext"=>1073741823),lang(28)=>array("binary"=>8000,"varbinary"=>8000,"image"=>2147483647),);}function
insertUpdate($R,array$L,array$G){$o=fields($R);$dj=array();$Z=array();$O=reset($L);$e="c".implode(", c",range(1,count($O)));$Qa=0;$ee=array();foreach($O
as$y=>$X){$Qa++;$C=idf_unescape($y);if(!$o[$C]["auto_increment"])$ee[$y]="c$Qa";if(isset($G[$C]))$Z[]="$y = c$Qa";else$dj[]="$y = c$Qa";}$oj=array();foreach($L
as$O)$oj[]="(".implode(", ",$O).")";if($Z){$Pd=queries("SET IDENTITY_INSERT ".table($R)." ON");$J=queries("MERGE ".table($R)." USING (VALUES\n\t".implode(",\n\t",$oj)."\n) AS source ($e) ON ".implode(" AND ",$Z).($dj?"\nWHEN MATCHED THEN UPDATE SET ".implode(", ",$dj):"")."\nWHEN NOT MATCHED THEN INSERT (".implode(", ",array_keys($Pd?$O:$ee)).") VALUES (".($Pd?$e:implode(", ",$ee)).");");if($Pd)queries("SET IDENTITY_INSERT ".table($R)." OFF");}else$J=queries("INSERT INTO ".table($R)." (".implode(", ",array_keys($O)).") VALUES\n".implode(",\n",$oj));return$J;}function
begin(){return
queries("BEGIN TRANSACTION");}function
tableHelp($C,$oe=false){$He=array("sys"=>"catalog-views/sys-","INFORMATION_SCHEMA"=>"information-schema-views/",);$A=$He[get_schema()];if($A)return"relational-databases/system-$A".preg_replace('~_~','-',strtolower($C))."-transact-sql";}}function
idf_escape($v){return"[".str_replace("]","]]",$v)."]";}function
table($v){return($_GET["ns"]!=""?idf_escape($_GET["ns"]).".":"").idf_escape($v);}function
get_databases($fd){return
get_vals("SELECT name FROM sys.databases WHERE name NOT IN ('master', 'tempdb', 'model', 'msdb')");}function
limit($H,$Z,$_,$D=0,$zh=" "){return($_?" TOP (".($_+$D).")":"")." $H$Z";}function
limit1($R,$H,$Z,$zh="\n"){return
limit($H,$Z,1,0,$zh);}function
db_collation($k,$jb){return
get_val("SELECT collation_name FROM sys.databases WHERE name = ".q($k));}function
logged_user(){return
get_val("SELECT SUSER_NAME()");}function
tables_list(){return
get_key_vals("SELECT name, type_desc FROM sys.all_objects WHERE schema_id = SCHEMA_ID(".q(get_schema()).") AND type IN ('S', 'U', 'V') ORDER BY name");}function
count_tables($j){$J=array();foreach($j
as$k){connection()->select_db($k);$J[$k]=get_val("SELECT COUNT(*) FROM INFORMATION_SCHEMA.TABLES");}return$J;}function
table_status($C=""){$J=array();foreach(get_rows("SELECT ao.name AS Name, ao.type_desc AS Engine, (SELECT value FROM fn_listextendedproperty(default, 'SCHEMA', schema_name(schema_id), 'TABLE', ao.name, null, null)) AS Comment
FROM sys.all_objects AS ao
WHERE schema_id = SCHEMA_ID(".q(get_schema()).") AND type IN ('S', 'U', 'V') ".($C!=""?"AND name = ".q($C):"ORDER BY name"))as$K)$J[$K["Name"]]=$K;return$J;}function
is_view($S){return$S["Engine"]=="VIEW";}function
fk_support($S){return
true;}function
fields($R){$qb=get_key_vals("SELECT objname, cast(value as varchar(max)) FROM fn_listextendedproperty('MS_DESCRIPTION', 'schema', ".q(get_schema()).", 'table', ".q($R).", 'column', NULL)");$J=array();$gi=get_val("SELECT object_id FROM sys.all_objects WHERE schema_id = SCHEMA_ID(".q(get_schema()).") AND type IN ('S', 'U', 'V') AND name = ".q($R));foreach(get_rows("SELECT c.max_length, c.precision, c.scale, c.name, c.is_nullable, c.is_identity, c.collation_name, t.name type, d.definition [default], d.name default_constraint, i.is_primary_key
FROM sys.all_columns c
JOIN sys.types t ON c.user_type_id = t.user_type_id
LEFT JOIN sys.default_constraints d ON c.default_object_id = d.object_id
LEFT JOIN sys.index_columns ic ON c.object_id = ic.object_id AND c.column_id = ic.column_id
LEFT JOIN sys.indexes i ON ic.object_id = i.object_id AND ic.index_id = i.index_id
WHERE c.object_id = ".q($gi))as$K){$U=$K["type"];$z=(preg_match("~char|binary~",$U)?intval($K["max_length"])/($U[0]=='n'?2:1):($U=="decimal"?"$K[precision],$K[scale]":""));$J[$K["name"]]=array("field"=>$K["name"],"full_type"=>$U.($z?"($z)":""),"type"=>$U,"length"=>$z,"default"=>(preg_match("~^\('(.*)'\)$~",$K["default"],$B)?str_replace("''","'",$B[1]):$K["default"]),"default_constraint"=>$K["default_constraint"],"null"=>$K["is_nullable"],"auto_increment"=>$K["is_identity"],"collation"=>$K["collation_name"],"privileges"=>array("insert"=>1,"select"=>1,"update"=>1,"where"=>1,"order"=>1),"primary"=>$K["is_primary_key"],"comment"=>$qb[$K["name"]],);}foreach(get_rows("SELECT * FROM sys.computed_columns WHERE object_id = ".q($gi))as$K){$J[$K["name"]]["generated"]=($K["is_persisted"]?"PERSISTED":"VIRTUAL");$J[$K["name"]]["default"]=$K["definition"];}return$J;}function
indexes($R,$h=null){$J=array();foreach(get_rows("SELECT i.name, key_ordinal, is_unique, is_primary_key, c.name AS column_name, is_descending_key
FROM sys.indexes i
INNER JOIN sys.index_columns ic ON i.object_id = ic.object_id AND i.index_id = ic.index_id
INNER JOIN sys.columns c ON ic.object_id = c.object_id AND ic.column_id = c.column_id
WHERE OBJECT_NAME(i.object_id) = ".q($R),$h)as$K){$C=$K["name"];$J[$C]["type"]=($K["is_primary_key"]?"PRIMARY":($K["is_unique"]?"UNIQUE":"INDEX"));$J[$C]["lengths"]=array();$J[$C]["columns"][$K["key_ordinal"]]=$K["column_name"];$J[$C]["descs"][$K["key_ordinal"]]=($K["is_descending_key"]?'1':null);}return$J;}function
view($C){return
array("select"=>preg_replace('~^(?:[^[]|\[[^]]*])*\s+AS\s+~isU','',get_val("SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_SCHEMA = SCHEMA_NAME() AND TABLE_NAME = ".q($C))));}function
collations(){$J=array();foreach(get_vals("SELECT name FROM fn_helpcollations()")as$c)$J[preg_replace('~_.*~','',$c)][]=$c;return$J;}function
information_schema($k){return
get_schema()=="INFORMATION_SCHEMA";}function
error(){return
nl_br(h(preg_replace('~^(\[[^]]*])+~m','',connection()->error)));}function
create_database($k,$c){return
queries("CREATE DATABASE ".idf_escape($k).(preg_match('~^[a-z0-9_]+$~i',$c)?" COLLATE $c":""));}function
drop_databases($j){return
queries("DROP DATABASE ".implode(", ",array_map('Adminer\idf_escape',$j)));}function
rename_database($C,$c){if(preg_match('~^[a-z0-9_]+$~i',$c))queries("ALTER DATABASE ".idf_escape(DB)." COLLATE $c");queries("ALTER DATABASE ".idf_escape(DB)." MODIFY NAME = ".idf_escape($C));return
true;}function
auto_increment(){return" IDENTITY".($_POST["Auto_increment"]!=""?"(".number($_POST["Auto_increment"]).",1)":"")." PRIMARY KEY";}function
alter_table($R,$C,$o,$hd,$ob,$wc,$c,$Ba,$mg){$b=array();$qb=array();$Wf=fields($R);foreach($o
as$n){$d=idf_escape($n[0]);$X=$n[1];if(!$X)$b["DROP"][]=" COLUMN $d";else{$X[1]=preg_replace("~( COLLATE )'(\\w+)'~",'\1\2',$X[1]);$qb[$n[0]]=$X[5];unset($X[5]);if(preg_match('~ AS ~',$X[3]))unset($X[1],$X[2]);if($n[0]=="")$b["ADD"][]="\n  ".implode("",$X).($R==""?substr($hd[$X[0]],16+strlen($X[0])):"");else{$l=$X[3];unset($X[3]);unset($X[6]);if($d!=$X[0])queries("EXEC sp_rename ".q(table($R).".$d").", ".q(idf_unescape($X[0])).", 'COLUMN'");$b["ALTER COLUMN ".implode("",$X)][]="";$Vf=$Wf[$n[0]];if(default_value($Vf)!=$l){if($Vf["default"]!==null)$b["DROP"][]=" ".idf_escape($Vf["default_constraint"]);if($l)$b["ADD"][]="\n $l FOR $d";}}}}if($R=="")return
queries("CREATE TABLE ".table($C)." (".implode(",",(array)$b["ADD"])."\n)");if($R!=$C)queries("EXEC sp_rename ".q(table($R)).", ".q($C));if($hd)$b[""]=$hd;foreach($b
as$y=>$X){if(!queries("ALTER TABLE ".table($C)." $y".implode(",",$X)))return
false;}foreach($qb
as$y=>$X){$ob=substr($X,9);queries("EXEC sp_dropextendedproperty @name = N'MS_Description', @level0type = N'Schema', @level0name = ".q(get_schema()).", @level1type = N'Table', @level1name = ".q($C).", @level2type = N'Column', @level2name = ".q($y));queries("EXEC sp_addextendedproperty
@name = N'MS_Description',
@value = $ob,
@level0type = N'Schema',
@level0name = ".q(get_schema()).",
@level1type = N'Table',
@level1name = ".q($C).",
@level2type = N'Column',
@level2name = ".q($y));}return
true;}function
alter_indexes($R,$b){$w=array();$gc=array();foreach($b
as$X){if($X[2]=="DROP"){if($X[0]=="PRIMARY")$gc[]=idf_escape($X[1]);else$w[]=idf_escape($X[1])." ON ".table($R);}elseif(!queries(($X[0]!="PRIMARY"?"CREATE $X[0] ".($X[0]!="INDEX"?"INDEX ":"").idf_escape($X[1]!=""?$X[1]:uniqid($R."_"))." ON ".table($R):"ALTER TABLE ".table($R)." ADD PRIMARY KEY")." (".implode(", ",$X[2]).")"))return
false;}return(!$w||queries("DROP INDEX ".implode(", ",$w)))&&(!$gc||queries("ALTER TABLE ".table($R)." DROP ".implode(", ",$gc)));}function
found_rows($S,$Z){}function
foreign_keys($R){$J=array();$Gf=array("CASCADE","NO ACTION","SET NULL","SET DEFAULT");foreach(get_rows("EXEC sp_fkeys @fktable_name = ".q($R).", @fktable_owner = ".q(get_schema()))as$K){$q=&$J[$K["FK_NAME"]];$q["db"]=$K["PKTABLE_QUALIFIER"];$q["ns"]=$K["PKTABLE_OWNER"];$q["table"]=$K["PKTABLE_NAME"];$q["on_update"]=$Gf[$K["UPDATE_RULE"]];$q["on_delete"]=$Gf[$K["DELETE_RULE"]];$q["source"][]=$K["FKCOLUMN_NAME"];$q["target"][]=$K["PKCOLUMN_NAME"];}return$J;}function
truncate_tables($T){return
apply_queries("TRUNCATE TABLE",$T);}function
drop_views($tj){return
queries("DROP VIEW ".implode(", ",array_map('Adminer\table',$tj)));}function
drop_tables($T){return
queries("DROP TABLE ".implode(", ",array_map('Adminer\table',$T)));}function
move_tables($T,$tj,$qi){return
apply_queries("ALTER SCHEMA ".idf_escape($qi)." TRANSFER",array_merge($T,$tj));}function
trigger($C,$R){if($C=="")return
array();$L=get_rows("SELECT s.name [Trigger],
CASE WHEN OBJECTPROPERTY(s.id, 'ExecIsInsertTrigger') = 1 THEN 'INSERT' WHEN OBJECTPROPERTY(s.id, 'ExecIsUpdateTrigger') = 1 THEN 'UPDATE' WHEN OBJECTPROPERTY(s.id, 'ExecIsDeleteTrigger') = 1 THEN 'DELETE' END [Event],
CASE WHEN OBJECTPROPERTY(s.id, 'ExecIsInsteadOfTrigger') = 1 THEN 'INSTEAD OF' ELSE 'AFTER' END [Timing],
c.text
FROM sysobjects s
JOIN syscomments c ON s.id = c.id
WHERE s.xtype = 'TR' AND s.name = ".q($C));$J=reset($L);if($J)$J["Statement"]=preg_replace('~^.+\s+AS\s+~isU','',$J["text"]);return$J;}function
triggers($R){$J=array();foreach(get_rows("SELECT sys1.name,
CASE WHEN OBJECTPROPERTY(sys1.id, 'ExecIsInsertTrigger') = 1 THEN 'INSERT' WHEN OBJECTPROPERTY(sys1.id, 'ExecIsUpdateTrigger') = 1 THEN 'UPDATE' WHEN OBJECTPROPERTY(sys1.id, 'ExecIsDeleteTrigger') = 1 THEN 'DELETE' END [Event],
CASE WHEN OBJECTPROPERTY(sys1.id, 'ExecIsInsteadOfTrigger') = 1 THEN 'INSTEAD OF' ELSE 'AFTER' END [Timing]
FROM sysobjects sys1
JOIN sysobjects sys2 ON sys1.parent_obj = sys2.id
WHERE sys1.xtype = 'TR' AND sys2.name = ".q($R))as$K)$J[$K["name"]]=array($K["Timing"],$K["Event"]);return$J;}function
trigger_options(){return
array("Timing"=>array("AFTER","INSTEAD OF"),"Event"=>array("INSERT","UPDATE","DELETE"),"Type"=>array("AS"),);}function
schemas(){return
get_vals("SELECT name FROM sys.schemas");}function
get_schema(){if($_GET["ns"]!="")return$_GET["ns"];return
get_val("SELECT SCHEMA_NAME()");}function
set_schema($oh){$_GET["ns"]=$oh;return
true;}function
create_sql($R,$Ba,$Zh){if(is_view(table_status1($R))){$sj=view($R);return"CREATE VIEW ".table($R)." AS $sj[select]";}$o=array();$G=false;foreach(fields($R)as$C=>$n){$X=process_field($n,$n);if($X[6])$G=true;$o[]=implode("",$X);}foreach(indexes($R)as$C=>$w){if(!$G||$w["type"]!="PRIMARY"){$e=array();foreach($w["columns"]as$y=>$X)$e[]=idf_escape($X).($w["descs"][$y]?" DESC":"");$C=idf_escape($C);$o[]=($w["type"]=="INDEX"?"INDEX $C":"CONSTRAINT $C ".($w["type"]=="UNIQUE"?"UNIQUE":"PRIMARY KEY"))." (".implode(", ",$e).")";}}foreach(driver()->checkConstraints($R)as$C=>$Xa)$o[]="CONSTRAINT ".idf_escape($C)." CHECK ($Xa)";return"CREATE TABLE ".table($R)." (\n\t".implode(",\n\t",$o)."\n)";}function
foreign_keys_sql($R){$o=array();foreach(foreign_keys($R)as$hd)$o[]=ltrim(format_foreign_key($hd));return($o?"ALTER TABLE ".table($R)." ADD\n\t".implode(",\n\t",$o).";\n\n":"");}function
truncate_sql($R){return"TRUNCATE TABLE ".table($R);}function
use_sql($Mb){return"USE ".idf_escape($Mb);}function
trigger_sql($R){$J="";foreach(triggers($R)as$C=>$Oi)$J
.=create_trigger(" ON ".table($R),trigger($C,$R)).";";return$J;}function
convert_field($n){}function
unconvert_field($n,$J){return$J;}function
support($Tc){return
preg_match('~^(check|comment|columns|database|drop_col|dump|indexes|descidx|scheme|sql|table|trigger|view|view_trigger)$~',$Tc);}}class
Adminer{static$ge;var$error='';function
name(){return"<a href='https://www.adminer.org/'".target_blank()." id='h1'><img src='".h(preg_replace("~\\?.*~","",ME)."?file=logo.png&version=5.2.0")."' width='24' height='24' alt='' id='logo'>Adminer</a>";}function
credentials(){return
array(SERVER,$_GET["username"],get_password());}function
connectSsl(){}function
permanentLogin($i=false){return
password_file($i);}function
bruteForceKey(){return$_SERVER["REMOTE_ADDR"];}function
serverName($N){return
h($N);}function
database(){return
DB;}function
databases($fd=true){return
get_databases($fd);}function
pluginsLinks(){}function
operators(){return
driver()->operators;}function
schemas(){return
schemas();}function
queryTimeout(){return
2;}function
headers(){}function
csp(array$Fb){return$Fb;}function
head($Jb=null){return
true;}function
css(){$J=array();foreach(array("","-dark")as$hf){$p="adminer$hf.css";if(file_exists($p))$J[]="$p?v=".crc32(file_get_contents($p));}return$J;}function
loginForm(){echo"<table class='layout'>\n",adminer()->loginFormField('driver','<tr><th>'.lang(32).'<td>',html_select("auth[driver]",SqlDriver::$fc,DRIVER,"loginDriver(this);")),adminer()->loginFormField('server','<tr><th>'.lang(33).'<td>','<input name="auth[server]" value="'.h(SERVER).'" title="hostname[:port]" placeholder="localhost" autocapitalize="off">'),adminer()->loginFormField('username','<tr><th>'.lang(34).'<td>','<input name="auth[username]" id="username" autofocus value="'.h($_GET["username"]).'" autocomplete="username" autocapitalize="off">'.script("const authDriver = qs('#username').form['auth[driver]']; authDriver && authDriver.onchange();")),adminer()->loginFormField('password','<tr><th>'.lang(35).'<td>','<input type="password" name="auth[password]" autocomplete="current-password">'),adminer()->loginFormField('db','<tr><th>'.lang(36).'<td>','<input name="auth[db]" value="'.h($_GET["db"]).'" autocapitalize="off">'),"</table>\n","<p><input type='submit' value='".lang(37)."'>\n",checkbox("auth[permanent]",1,$_COOKIE["adminer_permanent"],lang(38))."\n";}function
loginFormField($C,$Fd,$Y){return$Fd.$Y."\n";}function
login($Je,$F){if($F=="")return
lang(39,target_blank());return
true;}function
tableName(array$fi){return
h($fi["Name"]);}function
fieldName(array$n,$Pf=0){$U=$n["full_type"];$ob=$n["comment"];return'<span title="'.h($U.($ob!=""?($U?": ":"").$ob:'')).'">'.h($n["field"]).'</span>';}function
selectLinks(array$fi,$O=""){echo'<p class="links">';$He=array("select"=>lang(40));if(support("table")||support("indexes"))$He["table"]=lang(41);$oe=false;if(support("table")){$oe=is_view($fi);if($oe)$He["view"]=lang(42);else$He["create"]=lang(43);}if($O!==null)$He["edit"]=lang(44);$C=$fi["Name"];foreach($He
as$y=>$X)echo" <a href='".h(ME)."$y=".urlencode($C).($y=="edit"?$O:"")."'".bold(isset($_GET[$y])).">$X</a>";echo
doc_link(array(JUSH=>driver()->tableHelp($C,$oe)),"?"),"\n";}function
foreignKeys($R){return
foreign_keys($R);}function
backwardKeys($R,$ei){return
array();}function
backwardKeysPrint(array$Fa,array$K){}function
selectQuery($H,$Vh,$Rc=false){$J="</p>\n";if(!$Rc&&($wj=driver()->warnings())){$u="warnings";$J=", <a href='#$u'>".lang(45)."</a>".script("qsl('a').onclick = partial(toggle, '$u');","")."$J<div id='$u' class='hidden'>\n$wj</div>\n";}return"<p><code class='jush-".JUSH."'>".h(str_replace("\n"," ",$H))."</code> <span class='time'>(".format_time($Vh).")</span>".(support("sql")?" <a href='".h(ME)."sql=".urlencode($H)."'>".lang(10)."</a>":"").$J;}function
sqlCommandQuery($H){return
shorten_utf8(trim($H),1000);}function
sqlPrintAfter(){}function
rowDescription($R){return"";}function
rowDescriptions(array$L,array$id){return$L;}function
selectLink($X,array$n){}function
selectVal($X,$A,array$n,$Zf){$J=($X===null?"<i>NULL</i>":(preg_match("~char|binary|boolean~",$n["type"])&&!preg_match("~var~",$n["type"])?"<code>$X</code>":(preg_match('~json~',$n["type"])?"<code class='jush-js'>$X</code>":$X)));if(preg_match('~blob|bytea|raw|file~',$n["type"])&&!is_utf8($X))$J="<i>".lang(46,strlen($Zf))."</i>";return($A?"<a href='".h($A)."'".(is_url($A)?target_blank():"").">$J</a>":$J);}function
editVal($X,array$n){return$X;}function
config(){return
array();}function
tableStructurePrint(array$o,$fi=null){echo"<div class='scrollable'>\n","<table class='nowrap odds'>\n","<thead><tr><th>".lang(47)."<td>".lang(48).(support("comment")?"<td>".lang(49):"")."</thead>\n";$Yh=driver()->structuredTypes();foreach($o
as$n){echo"<tr><th>".h($n["field"]);$U=h($n["full_type"]);$c=h($n["collation"]);echo"<td><span title='$c'>".(in_array($U,(array)$Yh[lang(31)])?"<a href='".h(ME.'type='.urlencode($U))."'>$U</a>":$U.($c&&isset($fi["Collation"])&&$c!=$fi["Collation"]?" $c":""))."</span>",($n["null"]?" <i>NULL</i>":""),($n["auto_increment"]?" <i>".lang(50)."</i>":"");$l=h($n["default"]);echo(isset($n["default"])?" <span title='".lang(51)."'>[<b>".($n["generated"]?"<code class='jush-".JUSH."'>$l</code>":$l)."</b>]</span>":""),(support("comment")?"<td>".h($n["comment"]):""),"\n";}echo"</table>\n","</div>\n";}function
tableIndexesPrint(array$x){echo"<table>\n";foreach($x
as$C=>$w){ksort($w["columns"]);$Eg=array();foreach($w["columns"]as$y=>$X)$Eg[]="<i>".h($X)."</i>".($w["lengths"][$y]?"(".$w["lengths"][$y].")":"").($w["descs"][$y]?" DESC":"");echo"<tr title='".h($C)."'><th>$w[type]<td>".implode(", ",$Eg)."\n";}echo"</table>\n";}function
selectColumnsPrint(array$M,array$e){print_fieldset("select",lang(52),$M);$t=0;$M[""]=array();foreach($M
as$y=>$X){$X=idx($_GET["columns"],$y,array());$d=select_input(" name='columns[$t][col]'",$e,$X["col"],($y!==""?"selectFieldChange":"selectAddRow"));echo"<div>".(driver()->functions||driver()->grouping?html_select("columns[$t][fun]",array(-1=>"")+array_filter(array(lang(53)=>driver()->functions,lang(54)=>driver()->grouping)),$X["fun"]).on_help("event.target.value && event.target.value.replace(/ |\$/, '(') + ')'",1).script("qsl('select').onchange = function () { helpClose();".($y!==""?"":" qsl('select, input', this.parentNode).onchange();")." };","")."($d)":$d)."</div>\n";$t++;}echo"</div></fieldset>\n";}function
selectSearchPrint(array$Z,array$e,array$x){print_fieldset("search",lang(55),$Z);foreach($x
as$t=>$w){if($w["type"]=="FULLTEXT")echo"<div>(<i>".implode("</i>, <i>",array_map('Adminer\h',$w["columns"]))."</i>) AGAINST"," <input type='search' name='fulltext[$t]' value='".h($_GET["fulltext"][$t])."'>",script("qsl('input').oninput = selectFieldChange;",""),checkbox("boolean[$t]",1,isset($_GET["boolean"][$t]),"BOOL"),"</div>\n";}$Ua="this.parentNode.firstChild.onchange();";foreach(array_merge((array)$_GET["where"],array(array()))as$t=>$X){if(!$X||("$X[col]$X[val]"!=""&&in_array($X["op"],adminer()->operators())))echo"<div>".select_input(" name='where[$t][col]'",$e,$X["col"],($X?"selectFieldChange":"selectAddRow"),"(".lang(56).")"),html_select("where[$t][op]",adminer()->operators(),$X["op"],$Ua),"<input type='search' name='where[$t][val]' value='".h($X["val"])."'>",script("mixin(qsl('input'), {oninput: function () { $Ua }, onkeydown: selectSearchKeydown, onsearch: selectSearchSearch});",""),"</div>\n";}echo"</div></fieldset>\n";}function
selectOrderPrint(array$Pf,array$e,array$x){print_fieldset("sort",lang(57),$Pf);$t=0;foreach((array)$_GET["order"]as$y=>$X){if($X!=""){echo"<div>".select_input(" name='order[$t]'",$e,$X,"selectFieldChange"),checkbox("desc[$t]",1,isset($_GET["desc"][$y]),lang(58))."</div>\n";$t++;}}echo"<div>".select_input(" name='order[$t]'",$e,"","selectAddRow"),checkbox("desc[$t]",1,false,lang(58))."</div>\n","</div></fieldset>\n";}function
selectLimitPrint($_){echo"<fieldset><legend>".lang(59)."</legend><div>","<input type='number' name='limit' class='size' value='".intval($_)."'>",script("qsl('input').oninput = selectFieldChange;",""),"</div></fieldset>\n";}function
selectLengthPrint($wi){if($wi!==null)echo"<fieldset><legend>".lang(60)."</legend><div>","<input type='number' name='text_length' class='size' value='".h($wi)."'>","</div></fieldset>\n";}function
selectActionPrint(array$x){echo"<fieldset><legend>".lang(61)."</legend><div>","<input type='submit' value='".lang(52)."'>"," <span id='noindex' title='".lang(62)."'></span>","<script".nonce().">\n","const indexColumns = ";$e=array();foreach($x
as$w){$Ib=reset($w["columns"]);if($w["type"]!="FULLTEXT"&&$Ib)$e[$Ib]=1;}$e[""]=1;foreach($e
as$y=>$X)json_row($y);echo";\n","selectFieldChange.call(qs('#form')['select']);\n","</script>\n","</div></fieldset>\n";}function
selectCommandPrint(){return!information_schema(DB);}function
selectImportPrint(){return!information_schema(DB);}function
selectEmailPrint(array$tc,array$e){}function
selectColumnsProcess(array$e,array$x){$M=array();$ud=array();foreach((array)$_GET["columns"]as$y=>$X){if($X["fun"]=="count"||($X["col"]!=""&&(!$X["fun"]||in_array($X["fun"],driver()->functions)||in_array($X["fun"],driver()->grouping)))){$M[$y]=apply_sql_function($X["fun"],($X["col"]!=""?idf_escape($X["col"]):"*"));if(!in_array($X["fun"],driver()->grouping))$ud[]=$M[$y];}}return
array($M,$ud);}function
selectSearchProcess(array$o,array$x){$J=array();foreach($x
as$t=>$w){if($w["type"]=="FULLTEXT"&&$_GET["fulltext"][$t]!="")$J[]="MATCH (".implode(", ",array_map('Adminer\idf_escape',$w["columns"])).") AGAINST (".q($_GET["fulltext"][$t]).(isset($_GET["boolean"][$t])?" IN BOOLEAN MODE":"").")";}foreach((array)$_GET["where"]as$y=>$X){if("$X[col]$X[val]"!=""&&in_array($X["op"],adminer()->operators())){$Bg="";$rb=" $X[op]";if(preg_match('~IN$~',$X["op"])){$Td=process_length($X["val"]);$rb
.=" ".($Td!=""?$Td:"(NULL)");}elseif($X["op"]=="SQL")$rb=" $X[val]";elseif($X["op"]=="LIKE %%")$rb=" LIKE ".adminer()->processInput(idx($o,$X["col"],array()),"%$X[val]%");elseif($X["op"]=="ILIKE %%")$rb=" ILIKE ".adminer()->processInput($o[$X["col"]],"%$X[val]%");elseif($X["op"]=="FIND_IN_SET"){$Bg="$X[op](".q($X["val"]).", ";$rb=")";}elseif(!preg_match('~NULL$~',$X["op"]))$rb
.=" ".adminer()->processInput($o[$X["col"]],$X["val"]);if($X["col"]!="")$J[]=$Bg.driver()->convertSearch(idf_escape($X["col"]),$X,$o[$X["col"]]).$rb;else{$kb=array();foreach($o
as$C=>$n){if(isset($n["privileges"]["where"])&&(preg_match('~^[-\d.'.(preg_match('~IN$~',$X["op"])?',':'').']+$~',$X["val"])||!preg_match('~'.number_type().'|bit~',$n["type"]))&&(!preg_match("~[\x80-\xFF]~",$X["val"])||preg_match('~char|text|enum|set~',$n["type"]))&&(!preg_match('~date|timestamp~',$n["type"])||preg_match('~^\d+-\d+-\d+~',$X["val"])))$kb[]=$Bg.driver()->convertSearch(idf_escape($C),$X,$n).$rb;}$J[]=($kb?"(".implode(" OR ",$kb).")":"1 = 0");}}}return$J;}function
selectOrderProcess(array$o,array$x){$J=array();foreach((array)$_GET["order"]as$y=>$X){if($X!="")$J[]=(preg_match('~^((COUNT\(DISTINCT |[A-Z0-9_]+\()(`(?:[^`]|``)+`|"(?:[^"]|"")+")\)|COUNT\(\*\))$~',$X)?$X:idf_escape($X)).(isset($_GET["desc"][$y])?" DESC":"");}return$J;}function
selectLimitProcess(){return(isset($_GET["limit"])?intval($_GET["limit"]):50);}function
selectLengthProcess(){return(isset($_GET["text_length"])?"$_GET[text_length]":"100");}function
selectEmailProcess(array$Z,array$id){return
false;}function
selectQueryBuild(array$M,array$Z,array$ud,array$Pf,$_,$E){return"";}function
messageQuery($H,$xi,$Rc=false){restart_session();$Hd=&get_session("queries");if(!idx($Hd,$_GET["db"]))$Hd[$_GET["db"]]=array();if(strlen($H)>1e6)$H=preg_replace('~[\x80-\xFF]+$~','',substr($H,0,1e6))."\n…";$Hd[$_GET["db"]][]=array($H,time(),$xi);$Rh="sql-".count($Hd[$_GET["db"]]);$J="<a href='#$Rh' class='toggle'>".lang(63)."</a>\n";if(!$Rc&&($wj=driver()->warnings())){$u="warnings-".count($Hd[$_GET["db"]]);$J="<a href='#$u' class='toggle'>".lang(45)."</a>, $J<div id='$u' class='hidden'>\n$wj</div>\n";}return" <span class='time'>".@date("H:i:s")."</span>"." $J<div id='$Rh' class='hidden'><pre><code class='jush-".JUSH."'>".shorten_utf8($H,1000)."</code></pre>".($xi?" <span class='time'>($xi)</span>":'').(support("sql")?'<p><a href="'.h(str_replace("db=".urlencode(DB),"db=".urlencode($_GET["db"]),ME).'sql=&history='.(count($Hd[$_GET["db"]])-1)).'">'.lang(10).'</a>':'').'</div>';}function
editRowPrint($R,array$o,$K,$dj){}function
editFunctions(array$n){$J=($n["null"]?"NULL/":"");$dj=isset($_GET["select"])||where($_GET);foreach(array(driver()->insertFunctions,driver()->editFunctions)as$y=>$pd){if(!$y||(!isset($_GET["call"])&&$dj)){foreach($pd
as$qg=>$X){if(!$qg||preg_match("~$qg~",$n["type"]))$J
.="/$X";}}if($y&&$pd&&!preg_match('~set|blob|bytea|raw|file|bool~',$n["type"]))$J
.="/SQL";}if($n["auto_increment"]&&!$dj)$J=lang(50);return
explode("/",$J);}function
editInput($R,array$n,$_a,$Y){if($n["type"]=="enum")return(isset($_GET["select"])?"<label><input type='radio'$_a value='-1' checked><i>".lang(8)."</i></label> ":"").($n["null"]?"<label><input type='radio'$_a value=''".($Y!==null||isset($_GET["select"])?"":" checked")."><i>NULL</i></label> ":"").enum_input("radio",$_a,$n,$Y,$Y===0?0:null);return"";}function
editHint($R,array$n,$Y){return"";}function
processInput(array$n,$Y,$s=""){if($s=="SQL")return$Y;$C=$n["field"];$J=q($Y);if(preg_match('~^(now|getdate|uuid)$~',$s))$J="$s()";elseif(preg_match('~^current_(date|timestamp)$~',$s))$J=$s;elseif(preg_match('~^([+-]|\|\|)$~',$s))$J=idf_escape($C)." $s $J";elseif(preg_match('~^[+-] interval$~',$s))$J=idf_escape($C)." $s ".(preg_match("~^(\\d+|'[0-9.: -]') [A-Z_]+\$~i",$Y)?$Y:$J);elseif(preg_match('~^(addtime|subtime|concat)$~',$s))$J="$s(".idf_escape($C).", $J)";elseif(preg_match('~^(md5|sha1|password|encrypt)$~',$s))$J="$s($J)";return
unconvert_field($n,$J);}function
dumpOutput(){$J=array('text'=>lang(64),'file'=>lang(65));if(function_exists('gzencode'))$J['gz']='gzip';return$J;}function
dumpFormat(){return(support("dump")?array('sql'=>'SQL'):array())+array('csv'=>'CSV,','csv;'=>'CSV;','tsv'=>'TSV');}function
dumpDatabase($k){}function
dumpTable($R,$Zh,$oe=0){if($_POST["format"]!="sql"){echo"\xef\xbb\xbf";if($Zh)dump_csv(array_keys(fields($R)));}else{if($oe==2){$o=array();foreach(fields($R)as$C=>$n)$o[]=idf_escape($C)." $n[full_type]";$i="CREATE TABLE ".table($R)." (".implode(", ",$o).")";}else$i=create_sql($R,$_POST["auto_increment"],$Zh);set_utf8mb4($i);if($Zh&&$i){if($Zh=="DROP+CREATE"||$oe==1)echo"DROP ".($oe==2?"VIEW":"TABLE")." IF EXISTS ".table($R).";\n";if($oe==1)$i=remove_definer($i);echo"$i;\n\n";}}}function
dumpData($R,$Zh,$H){if($Zh){$Re=(JUSH=="sqlite"?0:1048576);$o=array();$Qd=false;if($_POST["format"]=="sql"){if($Zh=="TRUNCATE+INSERT")echo
truncate_sql($R).";\n";$o=fields($R);if(JUSH=="mssql"){foreach($o
as$n){if($n["auto_increment"]){echo"SET IDENTITY_INSERT ".table($R)." ON;\n";$Qd=true;break;}}}}$I=connection()->query($H,1);if($I){$ee="";$Pa="";$te=array();$qd=array();$bi="";$Uc=($R!=''?'fetch_assoc':'fetch_row');$Bb=0;while($K=$I->$Uc()){if(!$te){$oj=array();foreach($K
as$X){$n=$I->fetch_field();if(idx($o[$n->name],'generated')){$qd[$n->name]=true;continue;}$te[]=$n->name;$y=idf_escape($n->name);$oj[]="$y = VALUES($y)";}$bi=($Zh=="INSERT+UPDATE"?"\nON DUPLICATE KEY UPDATE ".implode(", ",$oj):"").";\n";}if($_POST["format"]!="sql"){if($Zh=="table"){dump_csv($te);$Zh="INSERT";}dump_csv($K);}else{if(!$ee)$ee="INSERT INTO ".table($R)." (".implode(", ",array_map('Adminer\idf_escape',$te)).") VALUES";foreach($K
as$y=>$X){if($qd[$y]){unset($K[$y]);continue;}$n=$o[$y];$K[$y]=($X!==null?unconvert_field($n,preg_match(number_type(),$n["type"])&&!preg_match('~\[~',$n["full_type"])&&is_numeric($X)?$X:q(($X===false?0:$X))):"NULL");}$mh=($Re?"\n":" ")."(".implode(",\t",$K).")";if(!$Pa)$Pa=$ee.$mh;elseif(JUSH=='mssql'?$Bb%1000!=0:strlen($Pa)+4+strlen($mh)+strlen($bi)<$Re)$Pa
.=",$mh";else{echo$Pa.$bi;$Pa=$ee.$mh;}}$Bb++;}if($Pa)echo$Pa.$bi;}elseif($_POST["format"]=="sql")echo"-- ".str_replace("\n"," ",connection()->error)."\n";if($Qd)echo"SET IDENTITY_INSERT ".table($R)." OFF;\n";}}function
dumpFilename($Od){return
friendly_url($Od!=""?$Od:(SERVER!=""?SERVER:"localhost"));}function
dumpHeaders($Od,$jf=false){$cg=$_POST["output"];$Mc=(preg_match('~sql~',$_POST["format"])?"sql":($jf?"tar":"csv"));header("Content-Type: ".($cg=="gz"?"application/x-gzip":($Mc=="tar"?"application/x-tar":($Mc=="sql"||$cg!="file"?"text/plain":"text/csv")."; charset=utf-8")));if($cg=="gz"){ob_start(function($Q){return
gzencode($Q);},1e6);}return$Mc;}function
dumpFooter(){if($_POST["format"]=="sql")echo"-- ".gmdate("Y-m-d H:i:s e")."\n";}function
importServerPath(){return"adminer.sql";}function
homepage(){echo'<p class="links">'.($_GET["ns"]==""&&support("database")?'<a href="'.h(ME).'database=">'.lang(66)."</a>\n":""),(support("scheme")?"<a href='".h(ME)."scheme='>".($_GET["ns"]!=""?lang(67):lang(68))."</a>\n":""),($_GET["ns"]!==""?'<a href="'.h(ME).'schema=">'.lang(69)."</a>\n":""),(support("privileges")?"<a href='".h(ME)."privileges='>".lang(70)."</a>\n":"");return
true;}function
navigation($gf){echo"<h1>".adminer()->name()." <span class='version'>".VERSION;$rf=$_COOKIE["adminer_version"];echo" <a href='https://www.adminer.org/#download'".target_blank()." id='version'>".(version_compare(VERSION,$rf)<0?h($rf):"")."</a>","</span></h1>\n";switch_lang();if($gf=="auth"){$cg="";foreach((array)$_SESSION["pwds"]as$qj=>$Dh){foreach($Dh
as$N=>$lj){$C=h(get_setting("vendor-$qj-$N")?:get_driver($qj));foreach($lj
as$V=>$F){if($F!==null){$Pb=$_SESSION["db"][$qj][$N][$V];foreach(($Pb?array_keys($Pb):array(""))as$k)$cg
.="<li><a href='".h(auth_url($qj,$N,$V,$k))."'>($C) ".h($V.($N!=""?"@".adminer()->serverName($N):"").($k!=""?" - $k":""))."</a>\n";}}}}if($cg)echo"<ul id='logins'>\n$cg</ul>\n".script("mixin(qs('#logins'), {onmouseover: menuOver, onmouseout: menuOut});");}else{$T=array();if($_GET["ns"]!==""&&!$gf&&DB!=""){connection()->select_db(DB);$T=table_status('',true);}adminer()->syntaxHighlighting($T);adminer()->databasesPrint($gf);$ka=array();if(DB==""||!$gf){if(support("sql")){$ka[]="<a href='".h(ME)."sql='".bold(isset($_GET["sql"])&&!isset($_GET["import"])).">".lang(63)."</a>";$ka[]="<a href='".h(ME)."import='".bold(isset($_GET["import"])).">".lang(71)."</a>";}$ka[]="<a href='".h(ME)."dump=".urlencode(isset($_GET["table"])?$_GET["table"]:$_GET["select"])."' id='dump'".bold(isset($_GET["dump"])).">".lang(72)."</a>";}$Ud=$_GET["ns"]!==""&&!$gf&&DB!="";if($Ud)$ka[]='<a href="'.h(ME).'create="'.bold($_GET["create"]==="").">".lang(73)."</a>";echo($ka?"<p class='links'>\n".implode("\n",$ka)."\n":"");if($Ud){if($T)adminer()->tablesPrint($T);else
echo"<p class='message'>".lang(9)."</p>\n";}}}function
syntaxHighlighting(array$T){echo
script_src(preg_replace("~\\?.*~","",ME)."?file=jush.js&version=5.2.0",true);if(support("sql")){echo"<script".nonce().">\n";if($T){$He=array();foreach($T
as$R=>$U)$He[]=preg_quote($R,'/');echo"var jushLinks = { ".JUSH.": [ '".js_escape(ME).(support("table")?"table=":"select=")."\$&', /\\b(".implode("|",$He).")\\b/g ] };\n";foreach(array("bac","bra","sqlite_quo","mssql_bra")as$X)echo"jushLinks.$X = jushLinks.".JUSH.";\n";if(isset($_GET["sql"])||isset($_GET["trigger"])||isset($_GET["check"])){$mi=array_fill_keys(array_keys($T),array());foreach(driver()->allFields()as$R=>$o){foreach($o
as$n)$mi[$R][]=$n["field"];}echo"addEventListener('DOMContentLoaded', () => { autocompleter = jush.autocompleteSql('".idf_escape("")."', ".json_encode($mi)."); });\n";}}echo"</script>\n";}echo
script("syntaxHighlighting('".preg_replace('~^(\d\.?\d).*~s','\1',connection()->server_info)."', '".connection()->flavor."');");}function
databasesPrint($gf){$j=adminer()->databases();if(DB&&$j&&!in_array(DB,$j))array_unshift($j,DB);echo"<form action=''>\n<p id='dbs'>\n";hidden_fields_get();$Nb=script("mixin(qsl('select'), {onmousedown: dbMouseDown, onchange: dbChange});");echo"<label title='".lang(36)."'>".lang(74).": ".($j?html_select("db",array(""=>"")+$j,DB).$Nb:"<input name='db' value='".h(DB)."' autocapitalize='off' size='19'>\n")."</label>","<input type='submit' value='".lang(20)."'".($j?" class='hidden'":"").">\n";if(support("scheme")){if($gf!="db"&&DB!=""&&connection()->select_db(DB)){echo"<br><label>".lang(75).": ".html_select("ns",array(""=>"")+adminer()->schemas(),$_GET["ns"])."$Nb</label>";if($_GET["ns"]!="")set_schema($_GET["ns"]);}}foreach(array("import","sql","schema","dump","privileges")as$X){if(isset($_GET[$X])){echo
input_hidden($X);break;}}echo"</p></form>\n";}function
tablesPrint(array$T){echo"<ul id='tables'>".script("mixin(qs('#tables'), {onmouseover: menuOver, onmouseout: menuOut});");foreach($T
as$R=>$P){$C=adminer()->tableName($P);if($C!="")echo'<li><a href="'.h(ME).'select='.urlencode($R).'"'.bold($_GET["select"]==$R||$_GET["edit"]==$R,"select")." title='".lang(40)."'>".lang(76)."</a> ",(support("table")||support("indexes")?'<a href="'.h(ME).'table='.urlencode($R).'"'.bold(in_array($R,array($_GET["table"],$_GET["create"],$_GET["indexes"],$_GET["foreign"],$_GET["trigger"],$_GET["check"],$_GET["view"])),(is_view($P)?"view":"structure"))." title='".lang(41)."'>$C</a>":"<span>$C</span>")."\n";}echo"</ul>\n";}}class
Plugins{private
static$va=array('dumpFormat'=>true,'dumpOutput'=>true,'editRowPrint'=>true,'editFunctions'=>true,'config'=>true);var$plugins;var$error='';private$hooks=array();function
__construct($vg){if($vg===null){$vg=array();$Ja="adminer-plugins";if(is_dir($Ja)){foreach(glob("$Ja/*.php")as$p)$Vd=include_once"./$p";}$Gd=" href='https://www.adminer.org/plugins/#use'".target_blank();if(file_exists("$Ja.php")){$Vd=include_once"./$Ja.php";if(is_array($Vd)){foreach($Vd
as$ug)$vg[get_class($ug)]=$ug;}else$this->error
.=lang(77,"<b>$Ja.php</b>",$Gd)."<br>";}foreach(get_declared_classes()as$eb){if(!$vg[$eb]&&preg_match('~^Adminer\w~i',$eb)){$Wg=new
\ReflectionClass($eb);$wb=$Wg->getConstructor();if($wb&&$wb->getNumberOfRequiredParameters())$this->error
.=lang(78,$Gd,"<b>$eb</b>","<b>$Ja.php</b>")."<br>";else$vg[$eb]=new$eb;}}}$this->plugins=$vg;$na=new
Adminer;$vg[]=$na;$Wg=new
\ReflectionObject($na);foreach($Wg->getMethods()as$ef){foreach($vg
as$ug){$C=$ef->getName();if(method_exists($ug,$C))$this->hooks[$C][]=$ug;}}}function
__call($C,array$hg){$wa=array();foreach($hg
as$y=>$X)$wa[]=&$hg[$y];$J=null;foreach($this->hooks[$C]as$ug){$Y=call_user_func_array(array($ug,$C),$wa);if($Y!==null){if(!self::$va[$C])return$Y;$J=$Y+(array)$J;}}return$J;}}abstract
class
Plugin{protected$translations=array();function
description(){return$this->lang('');}function
screenshot(){return"";}protected
function
lang($v,$wf=null){$wa=func_get_args();$wa[0]=idx($this->translations[LANG],$v)?:$v;return
call_user_func_array('Adminer\lang_format',$wa);}}Adminer::$ge=(function_exists('adminer_object')?adminer_object():(is_dir("adminer-plugins")||file_exists("adminer-plugins.php")?new
Plugins(null):new
Adminer));SqlDriver::$fc=array("server"=>"MySQL / MariaDB")+SqlDriver::$fc;if(!defined('Adminer\DRIVER')){define('Adminer\DRIVER',"server");if(extension_loaded("mysqli")&&$_GET["ext"]!="pdo"){class
Db
extends
\MySQLi{static$ge;var$extension="MySQLi",$flavor='';function
__construct(){parent::init();}function
attach($N,$V,$F){mysqli_report(MYSQLI_REPORT_OFF);list($Kd,$wg)=explode(":",$N,2);$Uh=adminer()->connectSsl();if($Uh)$this->ssl_set($Uh['key'],$Uh['cert'],$Uh['ca'],'','');$J=@$this->real_connect(($N!=""?$Kd:ini_get("mysqli.default_host")),($N.$V!=""?$V:ini_get("mysqli.default_user")),($N.$V.$F!=""?$F:ini_get("mysqli.default_pw")),null,(is_numeric($wg)?intval($wg):ini_get("mysqli.default_port")),(is_numeric($wg)?$wg:null),($Uh?($Uh['verify']!==false?2048:64):0));$this->options(MYSQLI_OPT_LOCAL_INFILE,false);return($J?'':$this->error);}function
set_charset($Wa){if(parent::set_charset($Wa))return
true;parent::set_charset('utf8');return$this->query("SET NAMES $Wa");}function
next_result(){return
self::more_results()&&parent::next_result();}function
quote($Q){return"'".$this->escape_string($Q)."'";}}}elseif(extension_loaded("mysql")&&!((ini_bool("sql.safe_mode")||ini_bool("mysql.allow_local_infile"))&&extension_loaded("pdo_mysql"))){class
Db
extends
SqlDb{private$link;function
attach($N,$V,$F){if(ini_bool("mysql.allow_local_infile"))return
lang(79,"'mysql.allow_local_infile'","MySQLi","PDO_MySQL");$this->link=@mysql_connect(($N!=""?$N:ini_get("mysql.default_host")),("$N$V"!=""?$V:ini_get("mysql.default_user")),("$N$V$F"!=""?$F:ini_get("mysql.default_password")),true,131072);if(!$this->link)return
mysql_error();$this->server_info=mysql_get_server_info($this->link);return'';}function
set_charset($Wa){if(function_exists('mysql_set_charset')){if(mysql_set_charset($Wa,$this->link))return
true;mysql_set_charset('utf8',$this->link);}return$this->query("SET NAMES $Wa");}function
quote($Q){return"'".mysql_real_escape_string($Q,$this->link)."'";}function
select_db($Mb){return
mysql_select_db($Mb,$this->link);}function
query($H,$Vi=false){$I=@($Vi?mysql_unbuffered_query($H,$this->link):mysql_query($H,$this->link));$this->error="";if(!$I){$this->errno=mysql_errno($this->link);$this->error=mysql_error($this->link);return
false;}if($I===true){$this->affected_rows=mysql_affected_rows($this->link);$this->info=mysql_info($this->link);return
true;}return
new
Result($I);}}class
Result{var$num_rows;private$result;private$offset=0;function
__construct($I){$this->result=$I;$this->num_rows=mysql_num_rows($I);}function
fetch_assoc(){return
mysql_fetch_assoc($this->result);}function
fetch_row(){return
mysql_fetch_row($this->result);}function
fetch_field(){$J=mysql_fetch_field($this->result,$this->offset++);$J->orgtable=$J->table;$J->charsetnr=($J->blob?63:0);return$J;}function
__destruct(){mysql_free_result($this->result);}}}elseif(extension_loaded("pdo_mysql")){class
Db
extends
PdoDb{var$extension="PDO_MySQL";function
attach($N,$V,$F){$Nf=array(\PDO::MYSQL_ATTR_LOCAL_INFILE=>false);$Uh=adminer()->connectSsl();if($Uh){if($Uh['key'])$Nf[\PDO::MYSQL_ATTR_SSL_KEY]=$Uh['key'];if($Uh['cert'])$Nf[\PDO::MYSQL_ATTR_SSL_CERT]=$Uh['cert'];if($Uh['ca'])$Nf[\PDO::MYSQL_ATTR_SSL_CA]=$Uh['ca'];if(isset($Uh['verify']))$Nf[\PDO::MYSQL_ATTR_SSL_VERIFY_SERVER_CERT]=$Uh['verify'];}return$this->dsn("mysql:charset=utf8;host=".str_replace(":",";unix_socket=",preg_replace('~:(\d)~',';port=\1',$N)),$V,$F,$Nf);}function
set_charset($Wa){return$this->query("SET NAMES $Wa");}function
select_db($Mb){return$this->query("USE ".idf_escape($Mb));}function
query($H,$Vi=false){$this->pdo->setAttribute(\PDO::MYSQL_ATTR_USE_BUFFERED_QUERY,!$Vi);return
parent::query($H,$Vi);}}}class
Driver
extends
SqlDriver{static$Oc=array("MySQLi","MySQL","PDO_MySQL");static$qe="sql";var$unsigned=array("unsigned","zerofill","unsigned zerofill");var$operators=array("=","<",">","<=",">=","!=","LIKE","LIKE %%","REGEXP","IN","FIND_IN_SET","IS NULL","NOT LIKE","NOT REGEXP","NOT IN","IS NOT NULL","SQL");var$functions=array("char_length","date","from_unixtime","lower","round","floor","ceil","sec_to_time","time_to_sec","upper");var$grouping=array("avg","count","count distinct","group_concat","max","min","sum");static
function
connect($N,$V,$F){$g=parent::connect($N,$V,$F);if(is_string($g)){if(function_exists('iconv')&&!is_utf8($g)&&strlen($mh=iconv("windows-1250","utf-8",$g))>strlen($g))$g=$mh;return$g;}$g->set_charset(charset($g));$g->query("SET sql_quote_show_create = 1, autocommit = 1");$g->flavor=(preg_match('~MariaDB~',$g->server_info)?'maria':'mysql');add_driver(DRIVER,($g->flavor=='maria'?"MariaDB":"MySQL"));return$g;}function
__construct(Db$g){parent::__construct($g);$this->types=array(lang(25)=>array("tinyint"=>3,"smallint"=>5,"mediumint"=>8,"int"=>10,"bigint"=>20,"decimal"=>66,"float"=>12,"double"=>21),lang(26)=>array("date"=>10,"datetime"=>19,"timestamp"=>19,"time"=>10,"year"=>4),lang(27)=>array("char"=>255,"varchar"=>65535,"tinytext"=>255,"text"=>65535,"mediumtext"=>16777215,"longtext"=>4294967295),lang(80)=>array("enum"=>65535,"set"=>64),lang(28)=>array("bit"=>20,"binary"=>255,"varbinary"=>65535,"tinyblob"=>255,"blob"=>65535,"mediumblob"=>16777215,"longblob"=>4294967295),lang(30)=>array("geometry"=>0,"point"=>0,"linestring"=>0,"polygon"=>0,"multipoint"=>0,"multilinestring"=>0,"multipolygon"=>0,"geometrycollection"=>0),);$this->insertFunctions=array("char"=>"md5/sha1/password/encrypt/uuid","binary"=>"md5/sha1","date|time"=>"now",);$this->editFunctions=array(number_type()=>"+/-","date"=>"+ interval/- interval","time"=>"addtime/subtime","char|text"=>"concat",);if(min_version('5.7.8',10.2,$g))$this->types[lang(27)]["json"]=4294967295;if(min_version('',10.7,$g)){$this->types[lang(27)]["uuid"]=128;$this->insertFunctions['uuid']='uuid';}if(min_version(9,'',$g)){$this->types[lang(25)]["vector"]=16383;$this->insertFunctions['vector']='string_to_vector';}if(min_version(5.7,10.2,$g))$this->generated=array("STORED","VIRTUAL");}function
unconvertFunction(array$n){return(preg_match("~binary~",$n["type"])?"<code class='jush-sql'>UNHEX</code>":($n["type"]=="bit"?doc_link(array('sql'=>'bit-value-literals.html'),"<code>b''</code>"):(preg_match("~geometry|point|linestring|polygon~",$n["type"])?"<code class='jush-sql'>GeomFromText</code>":"")));}function
insert($R,array$O){return($O?parent::insert($R,$O):queries("INSERT INTO ".table($R)." ()\nVALUES ()"));}function
insertUpdate($R,array$L,array$G){$e=array_keys(reset($L));$Bg="INSERT INTO ".table($R)." (".implode(", ",$e).") VALUES\n";$oj=array();foreach($e
as$y)$oj[$y]="$y = VALUES($y)";$bi="\nON DUPLICATE KEY UPDATE ".implode(", ",$oj);$oj=array();$z=0;foreach($L
as$O){$Y="(".implode(", ",$O).")";if($oj&&(strlen($Bg)+$z+strlen($Y)+strlen($bi)>1e6)){if(!queries($Bg.implode(",\n",$oj).$bi))return
false;$oj=array();$z=0;}$oj[]=$Y;$z+=strlen($Y)+2;}return
queries($Bg.implode(",\n",$oj).$bi);}function
slowQuery($H,$yi){if(min_version('5.7.8','10.1.2')){if($this->conn->flavor=='maria')return"SET STATEMENT max_statement_time=$yi FOR $H";elseif(preg_match('~^(SELECT\b)(.+)~is',$H,$B))return"$B[1] /*+ MAX_EXECUTION_TIME(".($yi*1000).") */ $B[2]";}}function
convertSearch($v,array$X,array$n){return(preg_match('~char|text|enum|set~',$n["type"])&&!preg_match("~^utf8~",$n["collation"])&&preg_match('~[\x80-\xFF]~',$X['val'])?"CONVERT($v USING ".charset($this->conn).")":$v);}function
warnings(){$I=$this->conn->query("SHOW WARNINGS");if($I&&$I->num_rows){ob_start();print_select_result($I);return
ob_get_clean();}}function
tableHelp($C,$oe=false){$Le=($this->conn->flavor=='maria');if(information_schema(DB))return
strtolower("information-schema-".($Le?"$C-table/":str_replace("_","-",$C)."-table.html"));if(DB=="mysql")return($Le?"mysql$C-table/":"system-schema.html");}function
hasCStyleEscapes(){static$Ra;if($Ra===null){$Sh=get_val("SHOW VARIABLES LIKE 'sql_mode'",1,$this->conn);$Ra=(strpos($Sh,'NO_BACKSLASH_ESCAPES')===false);}return$Ra;}function
engines(){$J=array();foreach(get_rows("SHOW ENGINES")as$K){if(preg_match("~YES|DEFAULT~",$K["Support"]))$J[]=$K["Engine"];}return$J;}}function
idf_escape($v){return"`".str_replace("`","``",$v)."`";}function
table($v){return
idf_escape($v);}function
get_databases($fd){$J=get_session("dbs");if($J===null){$H="SELECT SCHEMA_NAME FROM information_schema.SCHEMATA ORDER BY SCHEMA_NAME";$J=($fd?slow_query($H):get_vals($H));restart_session();set_session("dbs",$J);stop_session();}return$J;}function
limit($H,$Z,$_,$D=0,$zh=" "){return" $H$Z".($_?$zh."LIMIT $_".($D?" OFFSET $D":""):"");}function
limit1($R,$H,$Z,$zh="\n"){return
limit($H,$Z,1,0,$zh);}function
db_collation($k,array$jb){$J=null;$i=get_val("SHOW CREATE DATABASE ".idf_escape($k),1);if(preg_match('~ COLLATE ([^ ]+)~',$i,$B))$J=$B[1];elseif(preg_match('~ CHARACTER SET ([^ ]+)~',$i,$B))$J=$jb[$B[1]][-1];return$J;}function
logged_user(){return
get_val("SELECT USER()");}function
tables_list(){return
get_key_vals("SELECT TABLE_NAME, TABLE_TYPE FROM information_schema.TABLES WHERE TABLE_SCHEMA = DATABASE() ORDER BY TABLE_NAME");}function
count_tables(array$j){$J=array();foreach($j
as$k)$J[$k]=count(get_vals("SHOW TABLES IN ".idf_escape($k)));return$J;}function
table_status($C="",$Sc=false){$J=array();foreach(get_rows($Sc?"SELECT TABLE_NAME AS Name, ENGINE AS Engine, TABLE_COMMENT AS Comment FROM information_schema.TABLES WHERE TABLE_SCHEMA = DATABASE() ".($C!=""?"AND TABLE_NAME = ".q($C):"ORDER BY Name"):"SHOW TABLE STATUS".($C!=""?" LIKE ".q(addcslashes($C,"%_\\")):""))as$K){if($K["Engine"]=="InnoDB")$K["Comment"]=preg_replace('~(?:(.+); )?InnoDB free: .*~','\1',$K["Comment"]);if(!isset($K["Engine"]))$K["Comment"]="";if($C!="")$K["Name"]=$C;$J[$K["Name"]]=$K;}return$J;}function
is_view(array$S){return$S["Engine"]===null;}function
fk_support(array$S){return
preg_match('~InnoDB|IBMDB2I'.(min_version(5.6)?'|NDB':'').'~i',$S["Engine"]);}function
fields($R){$Le=(connection()->flavor=='maria');$J=array();foreach(get_rows("SELECT * FROM information_schema.COLUMNS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = ".q($R)." ORDER BY ORDINAL_POSITION")as$K){$n=$K["COLUMN_NAME"];$U=$K["COLUMN_TYPE"];$rd=$K["GENERATION_EXPRESSION"];$Pc=$K["EXTRA"];preg_match('~^(VIRTUAL|PERSISTENT|STORED)~',$Pc,$qd);preg_match('~^([^( ]+)(?:\((.+)\))?( unsigned)?( zerofill)?$~',$U,$Oe);$l=$K["COLUMN_DEFAULT"];if($l!=""){$ne=preg_match('~text|json~',$Oe[1]);if(!$Le&&$ne)$l=preg_replace("~^(_\w+)?('.*')$~",'\2',stripslashes($l));if($Le||$ne){$l=($l=="NULL"?null:preg_replace_callback("~^'(.*)'$~",function($B){return
stripslashes(str_replace("''","'",$B[1]));},$l));}if(!$Le&&preg_match('~binary~',$Oe[1])&&preg_match('~^0x(\w*)$~',$l,$B))$l=pack("H*",$B[1]);}$J[$n]=array("field"=>$n,"full_type"=>$U,"type"=>$Oe[1],"length"=>$Oe[2],"unsigned"=>ltrim($Oe[3].$Oe[4]),"default"=>($qd?($Le?$rd:stripslashes($rd)):$l),"null"=>($K["IS_NULLABLE"]=="YES"),"auto_increment"=>($Pc=="auto_increment"),"on_update"=>(preg_match('~\bon update (\w+)~i',$Pc,$B)?$B[1]:""),"collation"=>$K["COLLATION_NAME"],"privileges"=>array_flip(explode(",","$K[PRIVILEGES],where,order")),"comment"=>$K["COLUMN_COMMENT"],"primary"=>($K["COLUMN_KEY"]=="PRI"),"generated"=>($qd[1]=="PERSISTENT"?"STORED":$qd[1]),);}return$J;}function
indexes($R,$h=null){$J=array();foreach(get_rows("SHOW INDEX FROM ".table($R),$h)as$K){$C=$K["Key_name"];$J[$C]["type"]=($C=="PRIMARY"?"PRIMARY":($K["Index_type"]=="FULLTEXT"?"FULLTEXT":($K["Non_unique"]?($K["Index_type"]=="SPATIAL"?"SPATIAL":"INDEX"):"UNIQUE")));$J[$C]["columns"][]=$K["Column_name"];$J[$C]["lengths"][]=($K["Index_type"]=="SPATIAL"?null:$K["Sub_part"]);$J[$C]["descs"][]=null;}return$J;}function
foreign_keys($R){static$qg='(?:`(?:[^`]|``)+`|"(?:[^"]|"")+")';$J=array();$Cb=get_val("SHOW CREATE TABLE ".table($R),1);if($Cb){preg_match_all("~CONSTRAINT ($qg) FOREIGN KEY ?\\(((?:$qg,? ?)+)\\) REFERENCES ($qg)(?:\\.($qg))? \\(((?:$qg,? ?)+)\\)(?: ON DELETE (".driver()->onActions."))?(?: ON UPDATE (".driver()->onActions."))?~",$Cb,$Pe,PREG_SET_ORDER);foreach($Pe
as$B){preg_match_all("~$qg~",$B[2],$Mh);preg_match_all("~$qg~",$B[5],$qi);$J[idf_unescape($B[1])]=array("db"=>idf_unescape($B[4]!=""?$B[3]:$B[4]),"table"=>idf_unescape($B[4]!=""?$B[4]:$B[3]),"source"=>array_map('Adminer\idf_unescape',$Mh[0]),"target"=>array_map('Adminer\idf_unescape',$qi[0]),"on_delete"=>($B[6]?:"RESTRICT"),"on_update"=>($B[7]?:"RESTRICT"),);}}return$J;}function
view($C){return
array("select"=>preg_replace('~^(?:[^`]|`[^`]*`)*\s+AS\s+~isU','',get_val("SHOW CREATE VIEW ".table($C),1)));}function
collations(){$J=array();foreach(get_rows("SHOW COLLATION")as$K){if($K["Default"])$J[$K["Charset"]][-1]=$K["Collation"];else$J[$K["Charset"]][]=$K["Collation"];}ksort($J);foreach($J
as$y=>$X)sort($J[$y]);return$J;}function
information_schema($k){return($k=="information_schema")||(min_version(5.5)&&$k=="performance_schema");}function
error(){return
h(preg_replace('~^You have an error.*syntax to use~U',"Syntax error",connection()->error));}function
create_database($k,$c){return
queries("CREATE DATABASE ".idf_escape($k).($c?" COLLATE ".q($c):""));}function
drop_databases(array$j){$J=apply_queries("DROP DATABASE",$j,'Adminer\idf_escape');restart_session();set_session("dbs",null);return$J;}function
rename_database($C,$c){$J=false;if(create_database($C,$c)){$T=array();$tj=array();foreach(tables_list()as$R=>$U){if($U=='VIEW')$tj[]=$R;else$T[]=$R;}$J=(!$T&&!$tj)||move_tables($T,$tj,$C);drop_databases($J?array(DB):array());}return$J;}function
auto_increment(){$Ca=" PRIMARY KEY";if($_GET["create"]!=""&&$_POST["auto_increment_col"]){foreach(indexes($_GET["create"])as$w){if(in_array($_POST["fields"][$_POST["auto_increment_col"]]["orig"],$w["columns"],true)){$Ca="";break;}if($w["type"]=="PRIMARY")$Ca=" UNIQUE";}}return" AUTO_INCREMENT$Ca";}function
alter_table($R,$C,array$o,array$hd,$ob,$wc,$c,$Ba,$mg){$b=array();foreach($o
as$n){if($n[1]){$l=$n[1][3];if(preg_match('~ GENERATED~',$l)){$n[1][3]=(connection()->flavor=='maria'?"":$n[1][2]);$n[1][2]=$l;}$b[]=($R!=""?($n[0]!=""?"CHANGE ".idf_escape($n[0]):"ADD"):" ")." ".implode($n[1]).($R!=""?$n[2]:"");}else$b[]="DROP ".idf_escape($n[0]);}$b=array_merge($b,$hd);$P=($ob!==null?" COMMENT=".q($ob):"").($wc?" ENGINE=".q($wc):"").($c?" COLLATE ".q($c):"").($Ba!=""?" AUTO_INCREMENT=$Ba":"");if($R=="")return
queries("CREATE TABLE ".table($C)." (\n".implode(",\n",$b)."\n)$P$mg");if($R!=$C)$b[]="RENAME TO ".table($C);if($P)$b[]=ltrim($P);return($b||$mg?queries("ALTER TABLE ".table($R)."\n".implode(",\n",$b).$mg):true);}function
alter_indexes($R,$b){$Va=array();foreach($b
as$X)$Va[]=($X[2]=="DROP"?"\nDROP INDEX ".idf_escape($X[1]):"\nADD $X[0] ".($X[0]=="PRIMARY"?"KEY ":"").($X[1]!=""?idf_escape($X[1])." ":"")."(".implode(", ",$X[2]).")");return
queries("ALTER TABLE ".table($R).implode(",",$Va));}function
truncate_tables(array$T){return
apply_queries("TRUNCATE TABLE",$T);}function
drop_views(array$tj){return
queries("DROP VIEW ".implode(", ",array_map('Adminer\table',$tj)));}function
drop_tables(array$T){return
queries("DROP TABLE ".implode(", ",array_map('Adminer\table',$T)));}function
move_tables(array$T,array$tj,$qi){$ah=array();foreach($T
as$R)$ah[]=table($R)." TO ".idf_escape($qi).".".table($R);if(!$ah||queries("RENAME TABLE ".implode(", ",$ah))){$Ub=array();foreach($tj
as$R)$Ub[table($R)]=view($R);connection()->select_db($qi);$k=idf_escape(DB);foreach($Ub
as$C=>$sj){if(!queries("CREATE VIEW $C AS ".str_replace(" $k."," ",$sj["select"]))||!queries("DROP VIEW $k.$C"))return
false;}return
true;}return
false;}function
copy_tables(array$T,array$tj,$qi){queries("SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO'");foreach($T
as$R){$C=($qi==DB?table("copy_$R"):idf_escape($qi).".".table($R));if(($_POST["overwrite"]&&!queries("\nDROP TABLE IF EXISTS $C"))||!queries("CREATE TABLE $C LIKE ".table($R))||!queries("INSERT INTO $C SELECT * FROM ".table($R)))return
false;foreach(get_rows("SHOW TRIGGERS LIKE ".q(addcslashes($R,"%_\\")))as$K){$Oi=$K["Trigger"];if(!queries("CREATE TRIGGER ".($qi==DB?idf_escape("copy_$Oi"):idf_escape($qi).".".idf_escape($Oi))." $K[Timing] $K[Event] ON $C FOR EACH ROW\n$K[Statement];"))return
false;}}foreach($tj
as$R){$C=($qi==DB?table("copy_$R"):idf_escape($qi).".".table($R));$sj=view($R);if(($_POST["overwrite"]&&!queries("DROP VIEW IF EXISTS $C"))||!queries("CREATE VIEW $C AS $sj[select]"))return
false;}return
true;}function
trigger($C,$R){if($C=="")return
array();$L=get_rows("SHOW TRIGGERS WHERE `Trigger` = ".q($C));return
reset($L);}function
triggers($R){$J=array();foreach(get_rows("SHOW TRIGGERS LIKE ".q(addcslashes($R,"%_\\")))as$K)$J[$K["Trigger"]]=array($K["Timing"],$K["Event"]);return$J;}function
trigger_options(){return
array("Timing"=>array("BEFORE","AFTER"),"Event"=>array("INSERT","UPDATE","DELETE"),"Type"=>array("FOR EACH ROW"),);}function
routine($C,$U){$ta=array("bool","boolean","integer","double precision","real","dec","numeric","fixed","national char","national varchar");$Nh="(?:\\s|/\\*[\s\S]*?\\*/|(?:#|-- )[^\n]*\n?|--\r?\n)";$yc=driver()->enumLength;$Ti="((".implode("|",array_merge(array_keys(driver()->types()),$ta)).")\\b(?:\\s*\\(((?:[^'\")]|$yc)++)\\))?"."\\s*(zerofill\\s*)?(unsigned(?:\\s+zerofill)?)?)(?:\\s*(?:CHARSET|CHARACTER\\s+SET)\\s*['\"]?([^'\"\\s,]+)['\"]?)?";$qg="$Nh*(".($U=="FUNCTION"?"":driver()->inout).")?\\s*(?:`((?:[^`]|``)*)`\\s*|\\b(\\S+)\\s+)$Ti";$i=get_val("SHOW CREATE $U ".idf_escape($C),2);preg_match("~\\(((?:$qg\\s*,?)*)\\)\\s*".($U=="FUNCTION"?"RETURNS\\s+$Ti\\s+":"")."(.*)~is",$i,$B);$o=array();preg_match_all("~$qg\\s*,?~is",$B[1],$Pe,PREG_SET_ORDER);foreach($Pe
as$gg)$o[]=array("field"=>str_replace("``","`",$gg[2]).$gg[3],"type"=>strtolower($gg[5]),"length"=>preg_replace_callback("~$yc~s",'Adminer\normalize_enum',$gg[6]),"unsigned"=>strtolower(preg_replace('~\s+~',' ',trim("$gg[8] $gg[7]"))),"null"=>true,"full_type"=>$gg[4],"inout"=>strtoupper($gg[1]),"collation"=>strtolower($gg[9]),);return
array("fields"=>$o,"comment"=>get_val("SELECT ROUTINE_COMMENT FROM information_schema.ROUTINES WHERE ROUTINE_SCHEMA = DATABASE() AND ROUTINE_NAME = ".q($C)),)+($U!="FUNCTION"?array("definition"=>$B[11]):array("returns"=>array("type"=>$B[12],"length"=>$B[13],"unsigned"=>$B[15],"collation"=>$B[16]),"definition"=>$B[17],"language"=>"SQL",));}function
routines(){return
get_rows("SELECT ROUTINE_NAME AS SPECIFIC_NAME, ROUTINE_NAME, ROUTINE_TYPE, DTD_IDENTIFIER FROM information_schema.ROUTINES WHERE ROUTINE_SCHEMA = DATABASE()");}function
routine_languages(){return
array();}function
routine_id($C,array$K){return
idf_escape($C);}function
last_id($I){return
get_val("SELECT LAST_INSERT_ID()");}function
explain(Db$g,$H){return$g->query("EXPLAIN ".(min_version(5.1)&&!min_version(5.7)?"PARTITIONS ":"").$H);}function
found_rows(array$S,array$Z){return($Z||$S["Engine"]!="InnoDB"?null:$S["Rows"]);}function
create_sql($R,$Ba,$Zh){$J=get_val("SHOW CREATE TABLE ".table($R),1);if(!$Ba)$J=preg_replace('~ AUTO_INCREMENT=\d+~','',$J);return$J;}function
truncate_sql($R){return"TRUNCATE ".table($R);}function
use_sql($Mb){return"USE ".idf_escape($Mb);}function
trigger_sql($R){$J="";foreach(get_rows("SHOW TRIGGERS LIKE ".q(addcslashes($R,"%_\\")),null,"-- ")as$K)$J
.="\nCREATE TRIGGER ".idf_escape($K["Trigger"])." $K[Timing] $K[Event] ON ".table($K["Table"])." FOR EACH ROW\n$K[Statement];;\n";return$J;}function
show_variables(){return
get_rows("SHOW VARIABLES");}function
show_status(){return
get_rows("SHOW STATUS");}function
process_list(){return
get_rows("SHOW FULL PROCESSLIST");}function
convert_field(array$n){if(preg_match("~binary~",$n["type"]))return"HEX(".idf_escape($n["field"]).")";if($n["type"]=="bit")return"BIN(".idf_escape($n["field"])." + 0)";if(preg_match("~geometry|point|linestring|polygon~",$n["type"]))return(min_version(8)?"ST_":"")."AsWKT(".idf_escape($n["field"]).")";}function
unconvert_field(array$n,$J){if(preg_match("~binary~",$n["type"]))$J="UNHEX($J)";if($n["type"]=="bit")$J="CONVERT(b$J, UNSIGNED)";if(preg_match("~geometry|point|linestring|polygon~",$n["type"])){$Bg=(min_version(8)?"ST_":"");$J=$Bg."GeomFromText($J, $Bg"."SRID($n[field]))";}return$J;}function
support($Tc){return!preg_match("~scheme|sequence|type|view_trigger|materializedview".(min_version(8)?"":"|descidx".(min_version(5.1)?"":"|event|partitioning")).(min_version('8.0.16','10.2.1')?"":"|check")."~",$Tc);}function
kill_process($X){return
queries("KILL ".number($X));}function
connection_id(){return"SELECT CONNECTION_ID()";}function
max_connections(){return
get_val("SELECT @@max_connections");}function
types(){return
array();}function
type_values($u){return"";}function
schemas(){return
array();}function
get_schema(){return"";}function
set_schema($oh,$h=null){return
true;}}define('Adminer\JUSH',Driver::$qe);define('Adminer\SERVER',$_GET[DRIVER]);define('Adminer\DB',$_GET["db"]);define('Adminer\ME',preg_replace('~\?.*~','',relative_uri()).'?'.(sid()?SID.'&':'').(SERVER!==null?DRIVER."=".urlencode(SERVER).'&':'').($_GET["ext"]?"ext=".urlencode($_GET["ext"]).'&':'').(isset($_GET["username"])?"username=".urlencode($_GET["username"]).'&':'').(DB!=""?'db='.urlencode(DB).'&'.(isset($_GET["ns"])?"ns=".urlencode($_GET["ns"])."&":""):''));function
page_header($_i,$m="",$Oa=array(),$Ai=""){page_headers();if(is_ajax()&&$m){page_messages($m);exit;}if(!ob_get_level())ob_start('ob_gzhandler',4096);$Bi=$_i.($Ai!=""?": $Ai":"");$Ci=strip_tags($Bi.(SERVER!=""&&SERVER!="localhost"?h(" - ".SERVER):"")." - ".adminer()->name());echo'<!DOCTYPE html>
<html lang="',LANG,'" dir="',lang(81),'">
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<meta name="robots" content="noindex">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>',$Ci,'</title>
<link rel="stylesheet" href="',h(preg_replace("~\\?.*~","",ME)."?file=default.css&version=5.2.0"),'">
';$Gb=adminer()->css();$Cd=false;$Ad=false;foreach($Gb
as$p){if(strpos($p,"adminer.css")!==false)$Cd=true;if(strpos($p,"adminer-dark.css")!==false)$Ad=true;}$Jb=($Cd?($Ad?null:false):($Ad?:null));$Xe=" media='(prefers-color-scheme: dark)'";if($Jb!==false)echo"<link rel='stylesheet'".($Jb?"":$Xe)." href='".h(preg_replace("~\\?.*~","",ME)."?file=dark.css&version=5.2.0")."'>\n";echo"<meta name='color-scheme' content='".($Jb===null?"light dark":($Jb?"dark":"light"))."'>\n",script_src(preg_replace("~\\?.*~","",ME)."?file=functions.js&version=5.2.0");if(adminer()->head($Jb))echo"<link rel='icon' href='data:image/gif;base64,R0lGODlhEAAQAJEAAAQCBPz+/PwCBAROZCH5BAEAAAAALAAAAAAQABAAAAI2hI+pGO1rmghihiUdvUBnZ3XBQA7f05mOak1RWXrNq5nQWHMKvuoJ37BhVEEfYxQzHjWQ5qIAADs='>\n","<link rel='apple-touch-icon' href='".h(preg_replace("~\\?.*~","",ME)."?file=logo.png&version=5.2.0")."'>\n";foreach($Gb
as$X)echo"<link rel='stylesheet'".(preg_match('~-dark\.~',$X)&&!$Jb?$Xe:"")." href='".h($X)."'>\n";echo"\n<body class='".lang(81)." nojs'>\n";$p=get_temp_dir()."/adminer.version";if(!$_COOKIE["adminer_version"]&&function_exists('openssl_verify')&&file_exists($p)&&filemtime($p)+86400>time()){$rj=unserialize(file_get_contents($p));$Kg="-----BEGIN PUBLIC KEY-----
MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAwqWOVuF5uw7/+Z70djoK
RlHIZFZPO0uYRezq90+7Amk+FDNd7KkL5eDve+vHRJBLAszF/7XKXe11xwliIsFs
DFWQlsABVZB3oisKCBEuI71J4kPH8dKGEWR9jDHFw3cWmoH3PmqImX6FISWbG3B8
h7FIx3jEaw5ckVPVTeo5JRm/1DZzJxjyDenXvBQ/6o9DgZKeNDgxwKzH+sw9/YCO
jHnq1cFpOIISzARlrHMa/43YfeNRAm/tsBXjSxembBPo7aQZLAWHmaj5+K19H10B
nCpz9Y++cipkVEiKRGih4ZEvjoFysEOdRLj6WiD/uUNky4xGeA6LaJqh5XpkFkcQ
fQIDAQAB
-----END PUBLIC KEY-----
";if(openssl_verify($rj["version"],base64_decode($rj["signature"]),$Kg)==1)$_COOKIE["adminer_version"]=$rj["version"];}echo
script("mixin(document.body, {onkeydown: bodyKeydown, onclick: bodyClick".(isset($_COOKIE["adminer_version"])?"":", onload: partial(verifyVersion, '".VERSION."', '".js_escape(ME)."', '".get_token()."')")."});
document.body.classList.replace('nojs', 'js');
const offlineMessage = '".js_escape(lang(82))."';
const thousandsSeparator = '".js_escape(lang(4))."';"),"<div id='help' class='jush-".JUSH." jsonly hidden'></div>\n",script("mixin(qs('#help'), {onmouseover: () => { helpOpen = 1; }, onmouseout: helpMouseout});"),"<div id='content'>\n","<span id='menuopen' class='jsonly'>".icon("move","","menu","")."</span>".script("qs('#menuopen').onclick = event => { qs('#foot').classList.toggle('foot'); event.stopPropagation(); }");if($Oa!==null){$A=substr(preg_replace('~\b(username|db|ns)=[^&]*&~','',ME),0,-1);echo'<p id="breadcrumb"><a href="'.h($A?:".").'">'.get_driver(DRIVER).'</a> » ';$A=substr(preg_replace('~\b(db|ns)=[^&]*&~','',ME),0,-1);$N=adminer()->serverName(SERVER);$N=($N!=""?$N:lang(33));if($Oa===false)echo"$N\n";else{echo"<a href='".h($A)."' accesskey='1' title='Alt+Shift+1'>$N</a> » ";if($_GET["ns"]!=""||(DB!=""&&is_array($Oa)))echo'<a href="'.h($A."&db=".urlencode(DB).(support("scheme")?"&ns=":"")).'">'.h(DB).'</a> » ';if(is_array($Oa)){if($_GET["ns"]!="")echo'<a href="'.h(substr(ME,0,-1)).'">'.h($_GET["ns"]).'</a> » ';foreach($Oa
as$y=>$X){$Wb=(is_array($X)?$X[1]:h($X));if($Wb!="")echo"<a href='".h(ME."$y=").urlencode(is_array($X)?$X[0]:$X)."'>$Wb</a> » ";}}echo"$_i\n";}}echo"<h2>$Bi</h2>\n","<div id='ajaxstatus' class='jsonly hidden'></div>\n";restart_session();page_messages($m);$j=&get_session("dbs");if(DB!=""&&$j&&!in_array(DB,$j,true))$j=null;stop_session();define('Adminer\PAGE_HEADER',1);}function
page_headers(){header("Content-Type: text/html; charset=utf-8");header("Cache-Control: no-cache");header("X-Frame-Options: deny");header("X-XSS-Protection: 0");header("X-Content-Type-Options: nosniff");header("Referrer-Policy: origin-when-cross-origin");foreach(adminer()->csp(csp())as$Fb){$Ed=array();foreach($Fb
as$y=>$X)$Ed[]="$y $X";header("Content-Security-Policy: ".implode("; ",$Ed));}adminer()->headers();}function
csp(){return
array(array("script-src"=>"'self' 'unsafe-inline' 'nonce-".get_nonce()."' 'strict-dynamic'","connect-src"=>"'self'","frame-src"=>"https://www.adminer.org","object-src"=>"'none'","base-uri"=>"'none'","form-action"=>"'self'",),);}function
get_nonce(){static$tf;if(!$tf)$tf=base64_encode(rand_string());return$tf;}function
page_messages($m){$ej=preg_replace('~^[^?]*~','',$_SERVER["REQUEST_URI"]);$df=idx($_SESSION["messages"],$ej);if($df){echo"<div class='message'>".implode("</div>\n<div class='message'>",$df)."</div>".script("messagesPrint();");unset($_SESSION["messages"][$ej]);}if($m)echo"<div class='error'>$m</div>\n";if(adminer()->error)echo"<div class='error'>".adminer()->error."</div>\n";}function
page_footer($gf=""){echo"</div>\n\n<div id='foot' class='foot'>\n<div id='menu'>\n";adminer()->navigation($gf);echo"</div>\n";if($gf!="auth")echo'<form action="" method="post">
<p class="logout">
<span>',h($_GET["username"])."\n",'</span>
<input type="submit" name="logout" value="',lang(83),'" id="logout">
',input_token(),'</form>
';echo"</div>\n\n",script("setupSubmitHighlight(document);");}function
int32($lf){while($lf>=2147483648)$lf-=4294967296;while($lf<=-2147483649)$lf+=4294967296;return(int)$lf;}function
long2str(array$W,$vj){$mh='';foreach($W
as$X)$mh
.=pack('V',$X);if($vj)return
substr($mh,0,end($W));return$mh;}function
str2long($mh,$vj){$W=array_values(unpack('V*',str_pad($mh,4*ceil(strlen($mh)/4),"\0")));if($vj)$W[]=strlen($mh);return$W;}function
xxtea_mx($Bj,$Aj,$ci,$re){return
int32((($Bj>>5&0x7FFFFFF)^$Aj<<2)+(($Aj>>3&0x1FFFFFFF)^$Bj<<4))^int32(($ci^$Aj)+($re^$Bj));}function
encrypt_string($Xh,$y){if($Xh=="")return"";$y=array_values(unpack("V*",pack("H*",md5($y))));$W=str2long($Xh,true);$lf=count($W)-1;$Bj=$W[$lf];$Aj=$W[0];$Lg=floor(6+52/($lf+1));$ci=0;while($Lg-->0){$ci=int32($ci+0x9E3779B9);$nc=$ci>>2&3;for($eg=0;$eg<$lf;$eg++){$Aj=$W[$eg+1];$kf=xxtea_mx($Bj,$Aj,$ci,$y[$eg&3^$nc]);$Bj=int32($W[$eg]+$kf);$W[$eg]=$Bj;}$Aj=$W[0];$kf=xxtea_mx($Bj,$Aj,$ci,$y[$eg&3^$nc]);$Bj=int32($W[$lf]+$kf);$W[$lf]=$Bj;}return
long2str($W,false);}function
decrypt_string($Xh,$y){if($Xh=="")return"";if(!$y)return
false;$y=array_values(unpack("V*",pack("H*",md5($y))));$W=str2long($Xh,false);$lf=count($W)-1;$Bj=$W[$lf];$Aj=$W[0];$Lg=floor(6+52/($lf+1));$ci=int32($Lg*0x9E3779B9);while($ci){$nc=$ci>>2&3;for($eg=$lf;$eg>0;$eg--){$Bj=$W[$eg-1];$kf=xxtea_mx($Bj,$Aj,$ci,$y[$eg&3^$nc]);$Aj=int32($W[$eg]-$kf);$W[$eg]=$Aj;}$Bj=$W[$lf];$kf=xxtea_mx($Bj,$Aj,$ci,$y[$eg&3^$nc]);$Aj=int32($W[0]-$kf);$W[0]=$Aj;$ci=int32($ci-0x9E3779B9);}return
long2str($W,true);}$sg=array();if($_COOKIE["adminer_permanent"]){foreach(explode(" ",$_COOKIE["adminer_permanent"])as$X){list($y)=explode(":",$X);$sg[$y]=$X;}}function
add_invalid_login(){$Ha=get_temp_dir()."/adminer.invalid";foreach(glob("$Ha*")?:array($Ha)as$p){$r=file_open_lock($p);if($r)break;}if(!$r)$r=file_open_lock("$Ha-".rand_string());if(!$r)return;$je=unserialize(stream_get_contents($r));$xi=time();if($je){foreach($je
as$ke=>$X){if($X[0]<$xi)unset($je[$ke]);}}$ie=&$je[adminer()->bruteForceKey()];if(!$ie)$ie=array($xi+30*60,0);$ie[1]++;file_write_unlock($r,serialize($je));}function
check_invalid_login(array&$sg){$je=array();foreach(glob(get_temp_dir()."/adminer.invalid*")as$p){$r=file_open_lock($p);if($r){$je=unserialize(stream_get_contents($r));file_unlock($r);break;}}$ie=idx($je,adminer()->bruteForceKey(),array());$sf=($ie[1]>29?$ie[0]-time():0);if($sf>0)auth_error(lang(84,ceil($sf/60)),$sg);}$Aa=$_POST["auth"];if($Aa){session_regenerate_id();$qj=$Aa["driver"];$N=$Aa["server"];$V=$Aa["username"];$F=(string)$Aa["password"];$k=$Aa["db"];set_password($qj,$N,$V,$F);$_SESSION["db"][$qj][$N][$V][$k]=true;if($Aa["permanent"]){$y=implode("-",array_map('base64_encode',array($qj,$N,$V,$k)));$Fg=adminer()->permanentLogin(true);$sg[$y]="$y:".base64_encode($Fg?encrypt_string($F,$Fg):"");cookie("adminer_permanent",implode(" ",$sg));}if(count($_POST)==1||DRIVER!=$qj||SERVER!=$N||$_GET["username"]!==$V||DB!=$k)redirect(auth_url($qj,$N,$V,$k));}elseif($_POST["logout"]&&(!$_SESSION["token"]||verify_token())){foreach(array("pwds","db","dbs","queries")as$y)set_session($y,null);unset_permanent($sg);redirect(substr(preg_replace('~\b(username|db|ns)=[^&]*&~','',ME),0,-1),lang(85).' '.lang(86));}elseif($sg&&!$_SESSION["pwds"]){session_regenerate_id();$Fg=adminer()->permanentLogin();foreach($sg
as$y=>$X){list(,$db)=explode(":",$X);list($qj,$N,$V,$k)=array_map('base64_decode',explode("-",$y));set_password($qj,$N,$V,decrypt_string(base64_decode($db),$Fg));$_SESSION["db"][$qj][$N][$V][$k]=true;}}function
unset_permanent(array&$sg){foreach($sg
as$y=>$X){list($qj,$N,$V,$k)=array_map('base64_decode',explode("-",$y));if($qj==DRIVER&&$N==SERVER&&$V==$_GET["username"]&&$k==DB)unset($sg[$y]);}cookie("adminer_permanent",implode(" ",$sg));}function
auth_error($m,array&$sg){$Eh=session_name();if(isset($_GET["username"])){header("HTTP/1.1 403 Forbidden");if(($_COOKIE[$Eh]||$_GET[$Eh])&&!$_SESSION["token"])$m=lang(87);else{restart_session();add_invalid_login();$F=get_password();if($F!==null){if($F===false)$m
.=($m?'<br>':'').lang(88,target_blank(),'<code>permanentLogin()</code>');set_password(DRIVER,SERVER,$_GET["username"],null);}unset_permanent($sg);}}if(!$_COOKIE[$Eh]&&$_GET[$Eh]&&ini_bool("session.use_only_cookies"))$m=lang(89);$hg=session_get_cookie_params();cookie("adminer_key",($_COOKIE["adminer_key"]?:rand_string()),$hg["lifetime"]);if(!$_SESSION["token"])$_SESSION["token"]=rand(1,1e6);page_header(lang(37),$m,null);echo"<form action='' method='post'>\n","<div>";if(hidden_fields($_POST,array("auth")))echo"<p class='message'>".lang(90)."\n";echo"</div>\n";adminer()->loginForm();echo"</form>\n";page_footer("auth");exit;}if(isset($_GET["username"])&&!class_exists('Adminer\Db')){unset($_SESSION["pwds"][DRIVER]);unset_permanent($sg);page_header(lang(91),lang(92,implode(", ",Driver::$Oc)),false);page_footer("auth");exit;}$g='';if(isset($_GET["username"])&&is_string(get_password())){list($Kd,$wg)=explode(":",SERVER,2);if(preg_match('~^\s*([-+]?\d+)~',$wg,$B)&&($B[1]<1024||$B[1]>65535))auth_error(lang(93),$sg);check_invalid_login($sg);$Eb=adminer()->credentials();$g=Driver::connect($Eb[0],$Eb[1],$Eb[2]);if(is_object($g)){Db::$ge=$g;Driver::$ge=new
Driver($g);if($g->flavor)save_settings(array("vendor-".DRIVER."-".SERVER=>get_driver(DRIVER)));}}$Je=null;if(!is_object($g)||($Je=adminer()->login($_GET["username"],get_password()))!==true){$m=(is_string($g)?nl_br(h($g)):(is_string($Je)?$Je:lang(94))).(preg_match('~^ | $~',get_password())?'<br>'.lang(95):'');auth_error($m,$sg);}if($_POST["logout"]&&$_SESSION["token"]&&!verify_token()){page_header(lang(83),lang(96));page_footer("db");exit;}if(!$_SESSION["token"])$_SESSION["token"]=rand(1,1e6);stop_session(true);if($Aa&&$_POST["token"])$_POST["token"]=get_token();$m='';if($_POST){if(!verify_token()){$be="max_input_vars";$Ve=ini_get($be);if(extension_loaded("suhosin")){foreach(array("suhosin.request.max_vars","suhosin.post.max_vars")as$y){$X=ini_get($y);if($X&&(!$Ve||$X<$Ve)){$be=$y;$Ve=$X;}}}$m=(!$_POST["token"]&&$Ve?lang(97,"'$be'"):lang(96).' '.lang(98));}}elseif($_SERVER["REQUEST_METHOD"]=="POST"){$m=lang(99,"'post_max_size'");if(isset($_GET["sql"]))$m
.=' '.lang(100);}function
print_select_result($I,$h=null,array$Tf=array(),$_=0){$He=array();$x=array();$e=array();$Ma=array();$Ui=array();$J=array();for($t=0;(!$_||$t<$_)&&($K=$I->fetch_row());$t++){if(!$t){echo"<div class='scrollable'>\n","<table class='nowrap odds'>\n","<thead><tr>";for($pe=0;$pe<count($K);$pe++){$n=$I->fetch_field();$C=$n->name;$Sf=(isset($n->orgtable)?$n->orgtable:"");$Rf=(isset($n->orgname)?$n->orgname:$C);if($Tf&&JUSH=="sql")$He[$pe]=($C=="table"?"table=":($C=="possible_keys"?"indexes=":null));elseif($Sf!=""){if(isset($n->table))$J[$n->table]=$Sf;if(!isset($x[$Sf])){$x[$Sf]=array();foreach(indexes($Sf,$h)as$w){if($w["type"]=="PRIMARY"){$x[$Sf]=array_flip($w["columns"]);break;}}$e[$Sf]=$x[$Sf];}if(isset($e[$Sf][$Rf])){unset($e[$Sf][$Rf]);$x[$Sf][$Rf]=$pe;$He[$pe]=$Sf;}}if($n->charsetnr==63)$Ma[$pe]=true;$Ui[$pe]=$n->type;echo"<th".($Sf!=""||$n->name!=$Rf?" title='".h(($Sf!=""?"$Sf.":"").$Rf)."'":"").">".h($C).($Tf?doc_link(array('sql'=>"explain-output.html#explain_".strtolower($C),'mariadb'=>"explain/#the-columns-in-explain-select",)):"");}echo"</thead>\n";}echo"<tr>";foreach($K
as$y=>$X){$A="";if(isset($He[$y])&&!$e[$He[$y]]){if($Tf&&JUSH=="sql"){$R=$K[array_search("table=",$He)];$A=ME.$He[$y].urlencode($Tf[$R]!=""?$Tf[$R]:$R);}else{$A=ME."edit=".urlencode($He[$y]);foreach($x[$He[$y]]as$hb=>$pe)$A
.="&where".urlencode("[".bracket_escape($hb)."]")."=".urlencode($K[$pe]);}}elseif(is_url($X))$A=$X;if($X===null)$X="<i>NULL</i>";elseif($Ma[$y]&&!is_utf8($X))$X="<i>".lang(46,strlen($X))."</i>";else{$X=h($X);if($Ui[$y]==254)$X="<code>$X</code>";}if($A)$X="<a href='".h($A)."'".(is_url($A)?target_blank():'').">$X</a>";echo"<td".($Ui[$y]<=9||$Ui[$y]==246?" class='number'":"").">$X";}}echo($t?"</table>\n</div>":"<p class='message'>".lang(12))."\n";return$J;}function
referencable_primary($xh){$J=array();foreach(table_status('',true)as$hi=>$R){if($hi!=$xh&&fk_support($R)){foreach(fields($hi)as$n){if($n["primary"]){if($J[$hi]){unset($J[$hi]);break;}$J[$hi]=$n;}}}}return$J;}function
textarea($C,$Y,$L=10,$kb=80){echo"<textarea name='".h($C)."' rows='$L' cols='$kb' class='sqlarea jush-".JUSH."' spellcheck='false' wrap='off'>";if(is_array($Y)){foreach($Y
as$X)echo
h($X[0])."\n\n\n";}else
echo
h($Y);echo"</textarea>";}function
select_input($_a,array$Nf,$Y="",$Hf="",$tg=""){$pi=($Nf?"select":"input");return"<$pi$_a".($Nf?"><option value=''>$tg".optionlist($Nf,$Y,true)."</select>":" size='10' value='".h($Y)."' placeholder='$tg'>").($Hf?script("qsl('$pi').onchange = $Hf;",""):"");}function
json_row($y,$X=null){static$Zc=true;if($Zc)echo"{";if($y!=""){echo($Zc?"":",")."\n\t\"".addcslashes($y,"\r\n\t\"\\/").'": '.($X!==null?'"'.addcslashes($X,"\r\n\"\\/").'"':'null');$Zc=false;}else{echo"\n}\n";$Zc=true;}}function
edit_type($y,array$n,array$jb,array$jd=array(),array$Qc=array()){$U=$n["type"];echo"<td><select name='".h($y)."[type]' class='type' aria-labelledby='label-type'>";if($U&&!array_key_exists($U,driver()->types())&&!isset($jd[$U])&&!in_array($U,$Qc))$Qc[]=$U;$Yh=driver()->structuredTypes();if($jd)$Yh[lang(101)]=$jd;echo
optionlist(array_merge($Qc,$Yh),$U),"</select><td>","<input name='".h($y)."[length]' value='".h($n["length"])."' size='3'".(!$n["length"]&&preg_match('~var(char|binary)$~',$U)?" class='required'":"")." aria-labelledby='label-length'>","<td class='options'>",($jb?"<input list='collations' name='".h($y)."[collation]'".(preg_match('~(char|text|enum|set)$~',$U)?"":" class='hidden'")." value='".h($n["collation"])."' placeholder='(".lang(102).")'>":''),(driver()->unsigned?"<select name='".h($y)."[unsigned]'".(!$U||preg_match(number_type(),$U)?"":" class='hidden'").'><option>'.optionlist(driver()->unsigned,$n["unsigned"]).'</select>':''),(isset($n['on_update'])?"<select name='".h($y)."[on_update]'".(preg_match('~timestamp|datetime~',$U)?"":" class='hidden'").'>'.optionlist(array(""=>"(".lang(103).")","CURRENT_TIMESTAMP"),(preg_match('~^CURRENT_TIMESTAMP~i',$n["on_update"])?"CURRENT_TIMESTAMP":$n["on_update"])).'</select>':''),($jd?"<select name='".h($y)."[on_delete]'".(preg_match("~`~",$U)?"":" class='hidden'")."><option value=''>(".lang(104).")".optionlist(explode("|",driver()->onActions),$n["on_delete"])."</select> ":" ");}function
get_partitions_info($R){$nd="FROM information_schema.PARTITIONS WHERE TABLE_SCHEMA = ".q(DB)." AND TABLE_NAME = ".q($R);$I=connection()->query("SELECT PARTITION_METHOD, PARTITION_EXPRESSION, PARTITION_ORDINAL_POSITION $nd ORDER BY PARTITION_ORDINAL_POSITION DESC LIMIT 1");$J=array();list($J["partition_by"],$J["partition"],$J["partitions"])=$I->fetch_row();$ng=get_key_vals("SELECT PARTITION_NAME, PARTITION_DESCRIPTION $nd AND PARTITION_NAME != '' ORDER BY PARTITION_ORDINAL_POSITION");$J["partition_names"]=array_keys($ng);$J["partition_values"]=array_values($ng);return$J;}function
process_length($z){$_c=driver()->enumLength;return(preg_match("~^\\s*\\(?\\s*$_c(?:\\s*,\\s*$_c)*+\\s*\\)?\\s*\$~",$z)&&preg_match_all("~$_c~",$z,$Pe)?"(".implode(",",$Pe[0]).")":preg_replace('~^[0-9].*~','(\0)',preg_replace('~[^-0-9,+()[\]]~','',$z)));}function
process_type(array$n,$ib="COLLATE"){return" $n[type]".process_length($n["length"]).(preg_match(number_type(),$n["type"])&&in_array($n["unsigned"],driver()->unsigned)?" $n[unsigned]":"").(preg_match('~char|text|enum|set~',$n["type"])&&$n["collation"]?" $ib ".(JUSH=="mssql"?$n["collation"]:q($n["collation"])):"");}function
process_field(array$n,array$Si){if($n["on_update"])$n["on_update"]=str_ireplace("current_timestamp()","CURRENT_TIMESTAMP",$n["on_update"]);return
array(idf_escape(trim($n["field"])),process_type($Si),($n["null"]?" NULL":" NOT NULL"),default_value($n),(preg_match('~timestamp|datetime~',$n["type"])&&$n["on_update"]?" ON UPDATE $n[on_update]":""),(support("comment")&&$n["comment"]!=""?" COMMENT ".q($n["comment"]):""),($n["auto_increment"]?auto_increment():null),);}function
default_value(array$n){$l=$n["default"];$qd=$n["generated"];return($l===null?"":(in_array($qd,driver()->generated)?(JUSH=="mssql"?" AS ($l)".($qd=="VIRTUAL"?"":" $qd")."":" GENERATED ALWAYS AS ($l) $qd"):" DEFAULT ".(!preg_match('~^GENERATED ~i',$l)&&(preg_match('~char|binary|text|json|enum|set~',$n["type"])||preg_match('~^(?![a-z])~i',$l))?(JUSH=="sql"&&preg_match('~text|json~',$n["type"])?"(".q($l).")":q($l)):str_ireplace("current_timestamp()","CURRENT_TIMESTAMP",(JUSH=="sqlite"?"($l)":$l)))));}function
type_class($U){foreach(array('char'=>'text','date'=>'time|year','binary'=>'blob','enum'=>'set',)as$y=>$X){if(preg_match("~$y|$X~",$U))return" class='$y'";}}function
edit_fields(array$o,array$jb,$U="TABLE",array$jd=array()){$o=array_values($o);$Rb=(($_POST?$_POST["defaults"]:get_setting("defaults"))?"":" class='hidden'");$pb=(($_POST?$_POST["comments"]:get_setting("comments"))?"":" class='hidden'");echo"<thead><tr>\n",($U=="PROCEDURE"?"<td>":""),"<th id='label-name'>".($U=="TABLE"?lang(105):lang(106)),"<td id='label-type'>".lang(48)."<textarea id='enum-edit' rows='4' cols='12' wrap='off' style='display: none;'></textarea>".script("qs('#enum-edit').onblur = editingLengthBlur;"),"<td id='label-length'>".lang(107),"<td>".lang(108);if($U=="TABLE")echo"<td id='label-null'>NULL\n","<td><input type='radio' name='auto_increment_col' value=''><abbr id='label-ai' title='".lang(50)."'>AI</abbr>",doc_link(array('sql'=>"example-auto-increment.html",'mariadb'=>"auto_increment/",'sqlite'=>"autoinc.html",'pgsql'=>"datatype-numeric.html#DATATYPE-SERIAL",'mssql'=>"t-sql/statements/create-table-transact-sql-identity-property",)),"<td id='label-default'$Rb>".lang(51),(support("comment")?"<td id='label-comment'$pb>".lang(49):"");echo"<td>".icon("plus","add[".(support("move_col")?0:count($o))."]","+",lang(109)),"</thead>\n<tbody>\n",script("mixin(qsl('tbody'), {onclick: editingClick, onkeydown: editingKeydown, oninput: editingInput});");foreach($o
as$t=>$n){$t++;$Uf=$n[($_POST?"orig":"field")];$cc=(isset($_POST["add"][$t-1])||(isset($n["field"])&&!idx($_POST["drop_col"],$t)))&&(support("drop_col")||$Uf=="");echo"<tr".($cc?"":" style='display: none;'").">\n",($U=="PROCEDURE"?"<td>".html_select("fields[$t][inout]",explode("|",driver()->inout),$n["inout"]):"")."<th>";if($cc)echo"<input name='fields[$t][field]' value='".h($n["field"])."' data-maxlength='64' autocapitalize='off' aria-labelledby='label-name'>";echo
input_hidden("fields[$t][orig]",$Uf);edit_type("fields[$t]",$n,$jb,$jd);if($U=="TABLE")echo"<td>".checkbox("fields[$t][null]",1,$n["null"],"","","block","label-null"),"<td><label class='block'><input type='radio' name='auto_increment_col' value='$t'".($n["auto_increment"]?" checked":"")." aria-labelledby='label-ai'></label>","<td$Rb>".(driver()->generated?html_select("fields[$t][generated]",array_merge(array("","DEFAULT"),driver()->generated),$n["generated"])." ":checkbox("fields[$t][generated]",1,$n["generated"],"","","","label-default")),"<input name='fields[$t][default]' value='".h($n["default"])."' aria-labelledby='label-default'>",(support("comment")?"<td$pb><input name='fields[$t][comment]' value='".h($n["comment"])."' data-maxlength='".(min_version(5.5)?1024:255)."' aria-labelledby='label-comment'>":"");echo"<td>",(support("move_col")?icon("plus","add[$t]","+",lang(109))." ".icon("up","up[$t]","↑",lang(110))." ".icon("down","down[$t]","↓",lang(111))." ":""),($Uf==""||support("drop_col")?icon("cross","drop_col[$t]","x",lang(112)):"");}}function
process_fields(array&$o){$D=0;if($_POST["up"]){$_e=0;foreach($o
as$y=>$n){if(key($_POST["up"])==$y){unset($o[$y]);array_splice($o,$_e,0,array($n));break;}if(isset($n["field"]))$_e=$D;$D++;}}elseif($_POST["down"]){$ld=false;foreach($o
as$y=>$n){if(isset($n["field"])&&$ld){unset($o[key($_POST["down"])]);array_splice($o,$D,0,array($ld));break;}if(key($_POST["down"])==$y)$ld=$n;$D++;}}elseif($_POST["add"]){$o=array_values($o);array_splice($o,key($_POST["add"]),0,array(array()));}elseif(!$_POST["drop_col"])return
false;return
true;}function
normalize_enum(array$B){$X=$B[0];return"'".str_replace("'","''",addcslashes(stripcslashes(str_replace($X[0].$X[0],$X[0],substr($X,1,-1))),'\\'))."'";}function
grant($sd,array$Hg,$e,$Ef){if(!$Hg)return
true;if($Hg==array("ALL PRIVILEGES","GRANT OPTION"))return($sd=="GRANT"?queries("$sd ALL PRIVILEGES$Ef WITH GRANT OPTION"):queries("$sd ALL PRIVILEGES$Ef")&&queries("$sd GRANT OPTION$Ef"));return
queries("$sd ".preg_replace('~(GRANT OPTION)\([^)]*\)~','\1',implode("$e, ",$Hg).$e).$Ef);}function
drop_create($gc,$i,$ic,$ti,$kc,$Ie,$cf,$af,$bf,$Bf,$pf){if($_POST["drop"])query_redirect($gc,$Ie,$cf);elseif($Bf=="")query_redirect($i,$Ie,$bf);elseif($Bf!=$pf){$Db=queries($i);queries_redirect($Ie,$af,$Db&&queries($gc));if($Db)queries($ic);}else
queries_redirect($Ie,$af,queries($ti)&&queries($kc)&&queries($gc)&&queries($i));}function
create_trigger($Ef,array$K){$zi=" $K[Timing] $K[Event]".(preg_match('~ OF~',$K["Event"])?" $K[Of]":"");return"CREATE TRIGGER ".idf_escape($K["Trigger"]).(JUSH=="mssql"?$Ef.$zi:$zi.$Ef).rtrim(" $K[Type]\n$K[Statement]",";").";";}function
create_routine($ih,array$K){$O=array();$o=(array)$K["fields"];ksort($o);foreach($o
as$n){if($n["field"]!="")$O[]=(preg_match("~^(".driver()->inout.")\$~",$n["inout"])?"$n[inout] ":"").idf_escape($n["field"]).process_type($n,"CHARACTER SET");}$Tb=rtrim($K["definition"],";");return"CREATE $ih ".idf_escape(trim($K["name"]))." (".implode(", ",$O).")".($ih=="FUNCTION"?" RETURNS".process_type($K["returns"],"CHARACTER SET"):"").($K["language"]?" LANGUAGE $K[language]":"").(JUSH=="pgsql"?" AS ".q($Tb):"\n$Tb;");}function
remove_definer($H){return
preg_replace('~^([A-Z =]+) DEFINER=`'.preg_replace('~@(.*)~','`@`(%|\1)',logged_user()).'`~','\1',$H);}function
format_foreign_key(array$q){$k=$q["db"];$uf=$q["ns"];return" FOREIGN KEY (".implode(", ",array_map('Adminer\idf_escape',$q["source"])).") REFERENCES ".($k!=""&&$k!=$_GET["db"]?idf_escape($k).".":"").($uf!=""&&$uf!=$_GET["ns"]?idf_escape($uf).".":"").idf_escape($q["table"])." (".implode(", ",array_map('Adminer\idf_escape',$q["target"])).")".(preg_match("~^(".driver()->onActions.")\$~",$q["on_delete"])?" ON DELETE $q[on_delete]":"").(preg_match("~^(".driver()->onActions.")\$~",$q["on_update"])?" ON UPDATE $q[on_update]":"");}function
tar_file($p,$Di){$J=pack("a100a8a8a8a12a12",$p,644,0,0,decoct($Di->size),decoct(time()));$cb=8*32;for($t=0;$t<strlen($J);$t++)$cb+=ord($J[$t]);$J
.=sprintf("%06o",$cb)."\0 ";echo$J,str_repeat("\0",512-strlen($J));$Di->send();echo
str_repeat("\0",511-($Di->size+511)%512);}function
ini_bytes($be){$X=ini_get($be);switch(strtolower(substr($X,-1))){case'g':$X=(int)$X*1024;case'm':$X=(int)$X*1024;case'k':$X=(int)$X*1024;}return$X;}function
doc_link(array$pg,$ui="<sup>?</sup>"){$Ch=connection()->server_info;$rj=preg_replace('~^(\d\.?\d).*~s','\1',$Ch);$gj=array('sql'=>"https://dev.mysql.com/doc/refman/$rj/en/",'sqlite'=>"https://www.sqlite.org/",'pgsql'=>"https://www.postgresql.org/docs/".(connection()->flavor=='cockroach'?"current":$rj)."/",'mssql'=>"https://learn.microsoft.com/en-us/sql/",'oracle'=>"https://www.oracle.com/pls/topic/lookup?ctx=db".preg_replace('~^.* (\d+)\.(\d+)\.\d+\.\d+\.\d+.*~s','\1\2',$Ch)."&id=",);if(connection()->flavor=='maria'){$gj['sql']="https://mariadb.com/kb/en/";$pg['sql']=(isset($pg['mariadb'])?$pg['mariadb']:str_replace(".html","/",$pg['sql']));}return($pg[JUSH]?"<a href='".h($gj[JUSH].$pg[JUSH].(JUSH=='mssql'?"?view=sql-server-ver$rj":""))."'".target_blank().">$ui</a>":"");}function
db_size($k){if(!connection()->select_db($k))return"?";$J=0;foreach(table_status()as$S)$J+=$S["Data_length"]+$S["Index_length"];return
format_number($J);}function
set_utf8mb4($i){static$O=false;if(!$O&&preg_match('~\butf8mb4~i',$i)){$O=true;echo"SET NAMES ".charset(connection()).";\n\n";}}if(isset($_GET["status"]))$_GET["variables"]=$_GET["status"];if(isset($_GET["import"]))$_GET["sql"]=$_GET["import"];if(!(DB!=""?connection()->select_db(DB):isset($_GET["sql"])||isset($_GET["dump"])||isset($_GET["database"])||isset($_GET["processlist"])||isset($_GET["privileges"])||isset($_GET["user"])||isset($_GET["variables"])||$_GET["script"]=="connect"||$_GET["script"]=="kill")){if(DB!=""||$_GET["refresh"]){restart_session();set_session("dbs",null);}if(DB!=""){header("HTTP/1.1 404 Not Found");page_header(lang(36).": ".h(DB),lang(113),true);}else{if($_POST["db"]&&!$m)queries_redirect(substr(ME,0,-1),lang(114),drop_databases($_POST["db"]));page_header(lang(115),$m,false);echo"<p class='links'>\n";foreach(array('database'=>lang(116),'privileges'=>lang(70),'processlist'=>lang(117),'variables'=>lang(118),'status'=>lang(119),)as$y=>$X){if(support($y))echo"<a href='".h(ME)."$y='>$X</a>\n";}echo"<p>".lang(120,get_driver(DRIVER),"<b>".h(connection()->server_info)."</b>","<b>".connection()->extension."</b>")."\n","<p>".lang(121,"<b>".h(logged_user())."</b>")."\n";$j=adminer()->databases();if($j){$qh=support("scheme");$jb=collations();echo"<form action='' method='post'>\n","<table class='checkable odds'>\n",script("mixin(qsl('table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true)});"),"<thead><tr>".(support("database")?"<td>":"")."<th>".lang(36).(get_session("dbs")!==null?" - <a href='".h(ME)."refresh=1'>".lang(122)."</a>":"")."<td>".lang(123)."<td>".lang(124)."<td>".lang(125)." - <a href='".h(ME)."dbsize=1'>".lang(126)."</a>".script("qsl('a').onclick = partial(ajaxSetHtml, '".js_escape(ME)."script=connect');","")."</thead>\n";$j=($_GET["dbsize"]?count_tables($j):array_flip($j));foreach($j
as$k=>$T){$hh=h(ME)."db=".urlencode($k);$u=h("Db-".$k);echo"<tr>".(support("database")?"<td>".checkbox("db[]",$k,in_array($k,(array)$_POST["db"]),"","","",$u):""),"<th><a href='$hh' id='$u'>".h($k)."</a>";$c=h(db_collation($k,$jb));echo"<td>".(support("database")?"<a href='$hh".($qh?"&amp;ns=":"")."&amp;database=' title='".lang(66)."'>$c</a>":$c),"<td align='right'><a href='$hh&amp;schema=' id='tables-".h($k)."' title='".lang(69)."'>".($_GET["dbsize"]?$T:"?")."</a>","<td align='right' id='size-".h($k)."'>".($_GET["dbsize"]?db_size($k):"?"),"\n";}echo"</table>\n",(support("database")?"<div class='footer'><div>\n"."<fieldset><legend>".lang(127)." <span id='selected'></span></legend><div>\n".input_hidden("all").script("qsl('input').onclick = function () { selectCount('selected', formChecked(this, /^db/)); };")."<input type='submit' name='drop' value='".lang(128)."'>".confirm()."\n"."</div></fieldset>\n"."</div></div>\n":""),input_token(),"</form>\n",script("tableCheck();");}if(isset(adminer()->plugins)&&is_array(adminer()->plugins)){echo"<div class='plugins'>\n","<h3>".lang(129)."</h3>\n<ul>\n";foreach(adminer()->plugins
as$ug){$Xb=(method_exists($ug,'description')?$ug->description():"");if(!$Xb){$Wg=new
\ReflectionObject($ug);if(preg_match('~^/[\s*]+(.+)~',$Wg->getDocComment(),$B))$Xb=$B[1];}$rh=(method_exists($ug,'screenshot')?$ug->screenshot():"");echo"<li><b>".get_class($ug)."</b>".h($Xb?": $Xb":"").($rh?" (<a href='".h($rh)."'".target_blank().">".lang(130)."</a>)":"")."\n";}echo"</ul>\n";adminer()->pluginsLinks();echo"</div>\n";}}page_footer("db");exit;}if(support("scheme")){if(DB!=""&&$_GET["ns"]!==""){if(!isset($_GET["ns"]))redirect(preg_replace('~ns=[^&]*&~','',ME)."ns=".get_schema());if(!set_schema($_GET["ns"])){header("HTTP/1.1 404 Not Found");page_header(lang(75).": ".h($_GET["ns"]),lang(131),true);page_footer("ns");exit;}}}class
TmpFile{private$handler;var$size;function
__construct(){$this->handler=tmpfile();}function
write($yb){$this->size+=strlen($yb);fwrite($this->handler,$yb);}function
send(){fseek($this->handler,0);fpassthru($this->handler);fclose($this->handler);}}if(isset($_GET["select"])&&($_POST["edit"]||$_POST["clone"])&&!$_POST["save"])$_GET["edit"]=$_GET["select"];if(isset($_GET["callf"]))$_GET["call"]=$_GET["callf"];if(isset($_GET["function"]))$_GET["procedure"]=$_GET["function"];if(isset($_GET["download"])){$a=$_GET["download"];$o=fields($a);header("Content-Type: application/octet-stream");header("Content-Disposition: attachment; filename=".friendly_url("$a-".implode("_",$_GET["where"])).".".friendly_url($_GET["field"]));$M=array(idf_escape($_GET["field"]));$I=driver()->select($a,$M,array(where($_GET,$o)),$M);$K=($I?$I->fetch_row():array());echo
driver()->value($K[0],$o[$_GET["field"]]);exit;}elseif(isset($_GET["table"])){$a=$_GET["table"];$o=fields($a);if(!$o)$m=error()?:lang(9);$S=table_status1($a);$C=adminer()->tableName($S);page_header(($o&&is_view($S)?$S['Engine']=='materialized view'?lang(132):lang(133):lang(134)).": ".($C!=""?$C:h($a)),$m);$gh=array();foreach($o
as$y=>$n)$gh+=$n["privileges"];adminer()->selectLinks($S,(isset($gh["insert"])||!support("table")?"":null));$ob=$S["Comment"];if($ob!="")echo"<p class='nowrap'>".lang(49).": ".h($ob)."\n";if($o)adminer()->tableStructurePrint($o,$S);if(support("indexes")&&driver()->supportsIndex($S)){echo"<h3 id='indexes'>".lang(135)."</h3>\n";$x=indexes($a);if($x)adminer()->tableIndexesPrint($x);echo'<p class="links"><a href="'.h(ME).'indexes='.urlencode($a).'">'.lang(136)."</a>\n";}if(!is_view($S)){if(fk_support($S)){echo"<h3 id='foreign-keys'>".lang(101)."</h3>\n";$jd=foreign_keys($a);if($jd){echo"<table>\n","<thead><tr><th>".lang(137)."<td>".lang(138)."<td>".lang(104)."<td>".lang(103)."<td></thead>\n";foreach($jd
as$C=>$q){echo"<tr title='".h($C)."'>","<th><i>".implode("</i>, <i>",array_map('Adminer\h',$q["source"]))."</i>";$A=($q["db"]!=""?preg_replace('~db=[^&]*~',"db=".urlencode($q["db"]),ME):($q["ns"]!=""?preg_replace('~ns=[^&]*~',"ns=".urlencode($q["ns"]),ME):ME));echo"<td><a href='".h($A."table=".urlencode($q["table"]))."'>".($q["db"]!=""&&$q["db"]!=DB?"<b>".h($q["db"])."</b>.":"").($q["ns"]!=""&&$q["ns"]!=$_GET["ns"]?"<b>".h($q["ns"])."</b>.":"").h($q["table"])."</a>","(<i>".implode("</i>, <i>",array_map('Adminer\h',$q["target"]))."</i>)","<td>".h($q["on_delete"]),"<td>".h($q["on_update"]),'<td><a href="'.h(ME.'foreign='.urlencode($a).'&name='.urlencode($C)).'">'.lang(139).'</a>',"\n";}echo"</table>\n";}echo'<p class="links"><a href="'.h(ME).'foreign='.urlencode($a).'">'.lang(140)."</a>\n";}if(support("check")){echo"<h3 id='checks'>".lang(141)."</h3>\n";$Ya=driver()->checkConstraints($a);if($Ya){echo"<table>\n";foreach($Ya
as$y=>$X)echo"<tr title='".h($y)."'>","<td><code class='jush-".JUSH."'>".h($X),"<td><a href='".h(ME.'check='.urlencode($a).'&name='.urlencode($y))."'>".lang(139)."</a>","\n";echo"</table>\n";}echo'<p class="links"><a href="'.h(ME).'check='.urlencode($a).'">'.lang(142)."</a>\n";}}if(support(is_view($S)?"view_trigger":"trigger")){echo"<h3 id='triggers'>".lang(143)."</h3>\n";$Ri=triggers($a);if($Ri){echo"<table>\n";foreach($Ri
as$y=>$X)echo"<tr valign='top'><td>".h($X[0])."<td>".h($X[1])."<th>".h($y)."<td><a href='".h(ME.'trigger='.urlencode($a).'&name='.urlencode($y))."'>".lang(139)."</a>\n";echo"</table>\n";}echo'<p class="links"><a href="'.h(ME).'trigger='.urlencode($a).'">'.lang(144)."</a>\n";}}elseif(isset($_GET["schema"])){page_header(lang(69),"",array(),h(DB.($_GET["ns"]?".$_GET[ns]":"")));$ji=array();$ki=array();$da=($_GET["schema"]?:$_COOKIE["adminer_schema-".str_replace(".","_",DB)]);preg_match_all('~([^:]+):([-0-9.]+)x([-0-9.]+)(_|$)~',$da,$Pe,PREG_SET_ORDER);foreach($Pe
as$t=>$B){$ji[$B[1]]=array($B[2],$B[3]);$ki[]="\n\t'".js_escape($B[1])."': [ $B[2], $B[3] ]";}$Gi=0;$Ia=-1;$oh=array();$Vg=array();$De=array();$ua=driver()->allFields();foreach(table_status('',true)as$R=>$S){if(is_view($S))continue;$xg=0;$oh[$R]["fields"]=array();foreach($ua[$R]as$n){$xg+=1.25;$n["pos"]=$xg;$oh[$R]["fields"][$n["field"]]=$n;}$oh[$R]["pos"]=($ji[$R]?:array($Gi,0));foreach(adminer()->foreignKeys($R)as$X){if(!$X["db"]){$Be=$Ia;if(idx($ji[$R],1)||idx($ji[$X["table"]],1))$Be=min(idx($ji[$R],1,0),idx($ji[$X["table"]],1,0))-1;else$Ia-=.1;while($De[(string)$Be])$Be-=.0001;$oh[$R]["references"][$X["table"]][(string)$Be]=array($X["source"],$X["target"]);$Vg[$X["table"]][$R][(string)$Be]=$X["target"];$De[(string)$Be]=true;}}$Gi=max($Gi,$oh[$R]["pos"][0]+2.5+$xg);}echo'<div id="schema" style="height: ',$Gi,'em;">
<script',nonce(),'>
qs(\'#schema\').onselectstart = () => false;
const tablePos = {',implode(",",$ki)."\n",'};
const em = qs(\'#schema\').offsetHeight / ',$Gi,';
document.onmousemove = schemaMousemove;
document.onmouseup = partialArg(schemaMouseup, \'',js_escape(DB),'\');
</script>
';foreach($oh
as$C=>$R){echo"<div class='table' style='top: ".$R["pos"][0]."em; left: ".$R["pos"][1]."em;'>",'<a href="'.h(ME).'table='.urlencode($C).'"><b>'.h($C)."</b></a>",script("qsl('div').onmousedown = schemaMousedown;");foreach($R["fields"]as$n){$X='<span'.type_class($n["type"]).' title="'.h($n["type"].($n["length"]?"($n[length])":"").($n["null"]?" NULL":'')).'">'.h($n["field"]).'</span>';echo"<br>".($n["primary"]?"<i>$X</i>":$X);}foreach((array)$R["references"]as$ri=>$Xg){foreach($Xg
as$Be=>$Sg){$Ce=$Be-idx($ji[$C],1);$t=0;foreach($Sg[0]as$Mh)echo"\n<div class='references' title='".h($ri)."' id='refs$Be-".($t++)."' style='left: $Ce"."em; top: ".$R["fields"][$Mh]["pos"]."em; padding-top: .5em;'>"."<div style='border-top: 1px solid gray; width: ".(-$Ce)."em;'></div></div>";}}foreach((array)$Vg[$C]as$ri=>$Xg){foreach($Xg
as$Be=>$e){$Ce=$Be-idx($ji[$C],1);$t=0;foreach($e
as$qi)echo"\n<div class='references arrow' title='".h($ri)."' id='refd$Be-".($t++)."' style='left: $Ce"."em; top: ".$R["fields"][$qi]["pos"]."em;'>"."<div style='height: .5em; border-bottom: 1px solid gray; width: ".(-$Ce)."em;'></div>"."</div>";}}echo"\n</div>\n";}foreach($oh
as$C=>$R){foreach((array)$R["references"]as$ri=>$Xg){foreach($Xg
as$Be=>$Sg){$ff=$Gi;$Te=-10;foreach($Sg[0]as$y=>$Mh){$yg=$R["pos"][0]+$R["fields"][$Mh]["pos"];$zg=$oh[$ri]["pos"][0]+$oh[$ri]["fields"][$Sg[1][$y]]["pos"];$ff=min($ff,$yg,$zg);$Te=max($Te,$yg,$zg);}echo"<div class='references' id='refl$Be' style='left: $Be"."em; top: $ff"."em; padding: .5em 0;'><div style='border-right: 1px solid gray; margin-top: 1px; height: ".($Te-$ff)."em;'></div></div>\n";}}}echo'</div>
<p class="links"><a href="',h(ME."schema=".urlencode($da)),'" id="schema-link">',lang(145),'</a>
';}elseif(isset($_GET["dump"])){$a=$_GET["dump"];if($_POST&&!$m){save_settings(array_intersect_key($_POST,array_flip(array("output","format","db_style","types","routines","events","table_style","auto_increment","triggers","data_style"))),"adminer_export");$T=array_flip((array)$_POST["tables"])+array_flip((array)$_POST["data"]);$Mc=dump_headers((count($T)==1?key($T):DB),(DB==""||count($T)>1));$me=preg_match('~sql~',$_POST["format"]);if($me){echo"-- Adminer ".VERSION." ".get_driver(DRIVER)." ".str_replace("\n"," ",connection()->server_info)." dump\n\n";if(JUSH=="sql"){echo"SET NAMES utf8;
SET time_zone = '+00:00';
SET foreign_key_checks = 0;
".($_POST["data_style"]?"SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO';
":"")."
";connection()->query("SET time_zone = '+00:00'");connection()->query("SET sql_mode = ''");}}$Zh=$_POST["db_style"];$j=array(DB);if(DB==""){$j=$_POST["databases"];if(is_string($j))$j=explode("\n",rtrim(str_replace("\r","",$j),"\n"));}foreach((array)$j
as$k){adminer()->dumpDatabase($k);if(connection()->select_db($k)){if($me&&preg_match('~CREATE~',$Zh)&&($i=get_val("SHOW CREATE DATABASE ".idf_escape($k),1))){set_utf8mb4($i);if($Zh=="DROP+CREATE")echo"DROP DATABASE IF EXISTS ".idf_escape($k).";\n";echo"$i;\n";}if($me){if($Zh)echo
use_sql($k).";\n\n";$bg="";if($_POST["types"]){foreach(types()as$u=>$U){$Ac=type_values($u);if($Ac)$bg
.=($Zh!='DROP+CREATE'?"DROP TYPE IF EXISTS ".idf_escape($U).";;\n":"")."CREATE TYPE ".idf_escape($U)." AS ENUM ($Ac);\n\n";else$bg
.="-- Could not export type $U\n\n";}}if($_POST["routines"]){foreach(routines()as$K){$C=$K["ROUTINE_NAME"];$ih=$K["ROUTINE_TYPE"];$i=create_routine($ih,array("name"=>$C)+routine($K["SPECIFIC_NAME"],$ih));set_utf8mb4($i);$bg
.=($Zh!='DROP+CREATE'?"DROP $ih IF EXISTS ".idf_escape($C).";;\n":"")."$i;\n\n";}}if($_POST["events"]){foreach(get_rows("SHOW EVENTS",null,"-- ")as$K){$i=remove_definer(get_val("SHOW CREATE EVENT ".idf_escape($K["Name"]),3));set_utf8mb4($i);$bg
.=($Zh!='DROP+CREATE'?"DROP EVENT IF EXISTS ".idf_escape($K["Name"]).";;\n":"")."$i;;\n\n";}}echo($bg&&JUSH=='sql'?"DELIMITER ;;\n\n$bg"."DELIMITER ;\n\n":$bg);}if($_POST["table_style"]||$_POST["data_style"]){$tj=array();foreach(table_status('',true)as$C=>$S){$R=(DB==""||in_array($C,(array)$_POST["tables"]));$Kb=(DB==""||in_array($C,(array)$_POST["data"]));if($R||$Kb){$Di=null;if($Mc=="tar"){$Di=new
TmpFile;ob_start(array($Di,'write'),1e5);}adminer()->dumpTable($C,($R?$_POST["table_style"]:""),(is_view($S)?2:0));if(is_view($S))$tj[]=$C;elseif($Kb){$o=fields($C);adminer()->dumpData($C,$_POST["data_style"],"SELECT *".convert_fields($o,$o)." FROM ".table($C));}if($me&&$_POST["triggers"]&&$R&&($Ri=trigger_sql($C)))echo"\nDELIMITER ;;\n$Ri\nDELIMITER ;\n";if($Mc=="tar"){ob_end_flush();tar_file((DB!=""?"":"$k/")."$C.csv",$Di);}elseif($me)echo"\n";}}if(function_exists('Adminer\foreign_keys_sql')){foreach(table_status('',true)as$C=>$S){$R=(DB==""||in_array($C,(array)$_POST["tables"]));if($R&&!is_view($S))echo
foreign_keys_sql($C);}}foreach($tj
as$sj)adminer()->dumpTable($sj,$_POST["table_style"],1);if($Mc=="tar")echo
pack("x512");}}}adminer()->dumpFooter();exit;}page_header(lang(72),$m,($_GET["export"]!=""?array("table"=>$_GET["export"]):array()),h(DB));echo'
<form action="" method="post">
<table class="layout">
';$Ob=array('','USE','DROP+CREATE','CREATE');$li=array('','DROP+CREATE','CREATE');$Lb=array('','TRUNCATE+INSERT','INSERT');if(JUSH=="sql")$Lb[]='INSERT+UPDATE';$K=get_settings("adminer_export");if(!$K)$K=array("output"=>"text","format"=>"sql","db_style"=>(DB!=""?"":"CREATE"),"table_style"=>"DROP+CREATE","data_style"=>"INSERT");if(!isset($K["events"])){$K["routines"]=$K["events"]=($_GET["dump"]=="");$K["triggers"]=$K["table_style"];}echo"<tr><th>".lang(146)."<td>".html_radios("output",adminer()->dumpOutput(),$K["output"])."\n","<tr><th>".lang(147)."<td>".html_radios("format",adminer()->dumpFormat(),$K["format"])."\n",(JUSH=="sqlite"?"":"<tr><th>".lang(36)."<td>".html_select('db_style',$Ob,$K["db_style"]).(support("type")?checkbox("types",1,$K["types"],lang(31)):"").(support("routine")?checkbox("routines",1,$K["routines"],lang(148)):"").(support("event")?checkbox("events",1,$K["events"],lang(149)):"")),"<tr><th>".lang(124)."<td>".html_select('table_style',$li,$K["table_style"]).checkbox("auto_increment",1,$K["auto_increment"],lang(50)).(support("trigger")?checkbox("triggers",1,$K["triggers"],lang(143)):""),"<tr><th>".lang(150)."<td>".html_select('data_style',$Lb,$K["data_style"]),'</table>
<p><input type="submit" value="',lang(72),'">
',input_token(),'
<table>
',script("qsl('table').onclick = dumpClick;");$Cg=array();if(DB!=""){$ab=($a!=""?"":" checked");echo"<thead><tr>","<th style='text-align: left;'><label class='block'><input type='checkbox' id='check-tables'$ab>".lang(124)."</label>".script("qs('#check-tables').onclick = partial(formCheck, /^tables\\[/);",""),"<th style='text-align: right;'><label class='block'>".lang(150)."<input type='checkbox' id='check-data'$ab></label>".script("qs('#check-data').onclick = partial(formCheck, /^data\\[/);",""),"</thead>\n";$tj="";$ni=tables_list();foreach($ni
as$C=>$U){$Bg=preg_replace('~_.*~','',$C);$ab=($a==""||$a==(substr($a,-1)=="%"?"$Bg%":$C));$Eg="<tr><td>".checkbox("tables[]",$C,$ab,$C,"","block");if($U!==null&&!preg_match('~table~i',$U))$tj
.="$Eg\n";else
echo"$Eg<td align='right'><label class='block'><span id='Rows-".h($C)."'></span>".checkbox("data[]",$C,$ab)."</label>\n";$Cg[$Bg]++;}echo$tj;if($ni)echo
script("ajaxSetHtml('".js_escape(ME)."script=db');");}else{echo"<thead><tr><th style='text-align: left;'>","<label class='block'><input type='checkbox' id='check-databases'".($a==""?" checked":"").">".lang(36)."</label>",script("qs('#check-databases').onclick = partial(formCheck, /^databases\\[/);",""),"</thead>\n";$j=adminer()->databases();if($j){foreach($j
as$k){if(!information_schema($k)){$Bg=preg_replace('~_.*~','',$k);echo"<tr><td>".checkbox("databases[]",$k,$a==""||$a=="$Bg%",$k,"","block")."\n";$Cg[$Bg]++;}}}else
echo"<tr><td><textarea name='databases' rows='10' cols='20'></textarea>";}echo'</table>
</form>
';$Zc=true;foreach($Cg
as$y=>$X){if($y!=""&&$X>1){echo($Zc?"<p>":" ")."<a href='".h(ME)."dump=".urlencode("$y%")."'>".h($y)."</a>";$Zc=false;}}}elseif(isset($_GET["privileges"])){page_header(lang(70));echo'<p class="links"><a href="'.h(ME).'user=">'.lang(151)."</a>";$I=connection()->query("SELECT User, Host FROM mysql.".(DB==""?"user":"db WHERE ".q(DB)." LIKE Db")." ORDER BY Host, User");$sd=$I;if(!$I)$I=connection()->query("SELECT SUBSTRING_INDEX(CURRENT_USER, '@', 1) AS User, SUBSTRING_INDEX(CURRENT_USER, '@', -1) AS Host");echo"<form action=''><p>\n";hidden_fields_get();echo
input_hidden("db",DB),($sd?"":input_hidden("grant")),"<table class='odds'>\n","<thead><tr><th>".lang(34)."<th>".lang(33)."<th></thead>\n";while($K=$I->fetch_assoc())echo'<tr><td>'.h($K["User"])."<td>".h($K["Host"]).'<td><a href="'.h(ME.'user='.urlencode($K["User"]).'&host='.urlencode($K["Host"])).'">'.lang(10)."</a>\n";if(!$sd||DB!="")echo"<tr><td><input name='user' autocapitalize='off'><td><input name='host' value='localhost' autocapitalize='off'><td><input type='submit' value='".lang(10)."'>\n";echo"</table>\n","</form>\n";}elseif(isset($_GET["sql"])){if(!$m&&$_POST["export"]){save_settings(array("output"=>$_POST["output"],"format"=>$_POST["format"]),"adminer_import");dump_headers("sql");adminer()->dumpTable("","");adminer()->dumpData("","table",$_POST["query"]);adminer()->dumpFooter();exit;}restart_session();$Id=&get_session("queries");$Hd=&$Id[DB];if(!$m&&$_POST["clear"]){$Hd=array();redirect(remove_from_uri("history"));}stop_session();page_header((isset($_GET["import"])?lang(71):lang(63)),$m);if(!$m&&$_POST){$r=false;if(!isset($_GET["import"]))$H=$_POST["query"];elseif($_POST["webfile"]){$Qh=adminer()->importServerPath();$r=@fopen((file_exists($Qh)?$Qh:"compress.zlib://$Qh.gz"),"rb");$H=($r?fread($r,1e6):false);}else$H=get_file("sql_file",true,";");if(is_string($H)){if(function_exists('memory_get_usage')&&($Ye=ini_bytes("memory_limit"))!="-1")@ini_set("memory_limit",max($Ye,strval(2*strlen($H)+memory_get_usage()+8e6)));if($H!=""&&strlen($H)<1e6){$Lg=$H.(preg_match("~;[ \t\r\n]*\$~",$H)?"":";");if(!$Hd||first(end($Hd))!=$Lg){restart_session();$Hd[]=array($Lg,time());set_session("queries",$Id);stop_session();}}$Nh="(?:\\s|/\\*[\s\S]*?\\*/|(?:#|-- )[^\n]*\n?|--\r?\n)";$Vb=";";$D=0;$vc=true;$h=connect();if($h&&DB!=""){$h->select_db(DB);if($_GET["ns"]!="")set_schema($_GET["ns"],$h);}$nb=0;$Cc=array();$ig='[\'"'.(JUSH=="sql"?'`#':(JUSH=="sqlite"?'`[':(JUSH=="mssql"?'[':''))).']|/\*|--'.(JUSH=='sql'?' ':'').'|$'.(JUSH=="pgsql"?'|\$[^$]*\$':'');$Hi=microtime(true);$oa=get_settings("adminer_import");$mc=adminer()->dumpFormat();unset($mc["sql"]);while($H!=""){if(!$D&&preg_match("~^$Nh*+DELIMITER\\s+(\\S+)~i",$H,$B)){$Vb=preg_quote($B[1]);$H=substr($H,strlen($B[0]));}elseif(!$D&&JUSH=='pgsql'&&preg_match("~^($Nh*+COPY\\s+)[^;]+\\s+FROM\\s+stdin;~i",$H,$B)){$Vb="\n\\\\\\.\r?\n";$D=strlen($B[0]);}else{preg_match("($Vb\\s*|$ig)",$H,$B,PREG_OFFSET_CAPTURE,$D);list($ld,$xg)=$B[0];if(!$ld&&$r&&!feof($r))$H
.=fread($r,1e5);else{if(!$ld&&rtrim($H)=="")break;$D=$xg+strlen($ld);if($ld&&!preg_match("(^$Vb)",$ld)){$Sa=driver()->hasCStyleEscapes()||(JUSH=="pgsql"&&($xg>0&&strtolower($H[$xg-1])=="e"));$qg=($ld=='/*'?'\*/':($ld=='['?']':(preg_match('~^-- |^#~',$ld)?"\n":preg_quote($ld).($Sa?'|\\\\.':''))));while(preg_match("($qg|\$)s",$H,$B,PREG_OFFSET_CAPTURE,$D)){$mh=$B[0][0];if(!$mh&&$r&&!feof($r))$H
.=fread($r,1e5);else{$D=$B[0][1]+strlen($mh);if(!$mh||$mh[0]!="\\")break;}}}else{$vc=false;$Lg=substr($H,0,$xg+($Vb[0]=="\n"?3:0));$nb++;$Eg="<pre id='sql-$nb'><code class='jush-".JUSH."'>".adminer()->sqlCommandQuery($Lg)."</code></pre>\n";if(JUSH=="sqlite"&&preg_match("~^$Nh*+ATTACH\\b~i",$Lg,$B)){echo$Eg,"<p class='error'>".lang(152)."\n";$Cc[]=" <a href='#sql-$nb'>$nb</a>";if($_POST["error_stops"])break;}else{if(!$_POST["only_errors"]){echo$Eg;ob_flush();flush();}$Vh=microtime(true);if(connection()->multi_query($Lg)&&$h&&preg_match("~^$Nh*+USE\\b~i",$Lg))$h->query($Lg);do{$I=connection()->store_result();if(connection()->error){echo($_POST["only_errors"]?$Eg:""),"<p class='error'>".lang(153).(connection()->errno?" (".connection()->errno.")":"").": ".error()."\n";$Cc[]=" <a href='#sql-$nb'>$nb</a>";if($_POST["error_stops"])break
2;}else{$xi=" <span class='time'>(".format_time($Vh).")</span>".(strlen($Lg)<1000?" <a href='".h(ME)."sql=".urlencode(trim($Lg))."'>".lang(10)."</a>":"");$qa=connection()->affected_rows;$wj=($_POST["only_errors"]?"":driver()->warnings());$xj="warnings-$nb";if($wj)$xi
.=", <a href='#$xj'>".lang(45)."</a>".script("qsl('a').onclick = partial(toggle, '$xj');","");$Kc=null;$Tf=null;$Lc="explain-$nb";if(is_object($I)){$_=$_POST["limit"];$Tf=print_select_result($I,$h,array(),$_);if(!$_POST["only_errors"]){echo"<form action='' method='post'>\n";$vf=$I->num_rows;echo"<p class='sql-footer'>".($vf?($_&&$vf>$_?lang(154,$_):"").lang(155,$vf):""),$xi;if($h&&preg_match("~^($Nh|\\()*+SELECT\\b~i",$Lg)&&($Kc=explain($h,$Lg)))echo", <a href='#$Lc'>Explain</a>".script("qsl('a').onclick = partial(toggle, '$Lc');","");$u="export-$nb";echo", <a href='#$u'>".lang(72)."</a>".script("qsl('a').onclick = partial(toggle, '$u');","")."<span id='$u' class='hidden'>: ".html_select("output",adminer()->dumpOutput(),$oa["output"])." ".html_select("format",$mc,$oa["format"]).input_hidden("query",$Lg)."<input type='submit' name='export' value='".lang(72)."'>".input_token()."</span>\n"."</form>\n";}}else{if(preg_match("~^$Nh*+(CREATE|DROP|ALTER)$Nh++(DATABASE|SCHEMA)\\b~i",$Lg)){restart_session();set_session("dbs",null);stop_session();}if(!$_POST["only_errors"])echo"<p class='message' title='".h(connection()->info)."'>".lang(156,$qa)."$xi\n";}echo($wj?"<div id='$xj' class='hidden'>\n$wj</div>\n":"");if($Kc){echo"<div id='$Lc' class='hidden explain'>\n";print_select_result($Kc,$h,$Tf);echo"</div>\n";}}$Vh=microtime(true);}while(connection()->next_result());}$H=substr($H,$D);$D=0;}}}}if($vc)echo"<p class='message'>".lang(157)."\n";elseif($_POST["only_errors"])echo"<p class='message'>".lang(158,$nb-count($Cc))," <span class='time'>(".format_time($Hi).")</span>\n";elseif($Cc&&$nb>1)echo"<p class='error'>".lang(153).": ".implode("",$Cc)."\n";}else
echo"<p class='error'>".upload_error($H)."\n";}echo'
<form action="" method="post" enctype="multipart/form-data" id="form">
';$Ic="<input type='submit' value='".lang(159)."' title='Ctrl+Enter'>";if(!isset($_GET["import"])){$Lg=$_GET["sql"];if($_POST)$Lg=$_POST["query"];elseif($_GET["history"]=="all")$Lg=$Hd;elseif($_GET["history"]!="")$Lg=idx($Hd[$_GET["history"]],0);echo"<p>";textarea("query",$Lg,20);echo
script(($_POST?"":"qs('textarea').focus();\n")."qs('#form').onsubmit = partial(sqlSubmit, qs('#form'), '".js_escape(remove_from_uri("sql|limit|error_stops|only_errors|history"))."');"),"<p>";adminer()->sqlPrintAfter();echo"$Ic\n",lang(160).": <input type='number' name='limit' class='size' value='".h($_POST?$_POST["limit"]:$_GET["limit"])."'>\n";}else{echo"<fieldset><legend>".lang(161)."</legend><div>";$yd=(extension_loaded("zlib")?"[.gz]":"");echo(ini_bool("file_uploads")?"SQL$yd (&lt; ".ini_get("upload_max_filesize")."B): <input type='file' name='sql_file[]' multiple>\n$Ic":lang(162)),"</div></fieldset>\n";$Sd=adminer()->importServerPath();if($Sd)echo"<fieldset><legend>".lang(163)."</legend><div>",lang(164,"<code>".h($Sd)."$yd</code>"),' <input type="submit" name="webfile" value="'.lang(165).'">',"</div></fieldset>\n";echo"<p>";}echo
checkbox("error_stops",1,($_POST?$_POST["error_stops"]:isset($_GET["import"])||$_GET["error_stops"]),lang(166))."\n",checkbox("only_errors",1,($_POST?$_POST["only_errors"]:isset($_GET["import"])||$_GET["only_errors"]),lang(167))."\n",input_token();if(!isset($_GET["import"])&&$Hd){print_fieldset("history",lang(168),$_GET["history"]!="");for($X=end($Hd);$X;$X=prev($Hd)){$y=key($Hd);list($Lg,$xi,$qc)=$X;echo'<a href="'.h(ME."sql=&history=$y").'">'.lang(10)."</a>"." <span class='time' title='".@date('Y-m-d',$xi)."'>".@date("H:i:s",$xi)."</span>"." <code class='jush-".JUSH."'>".shorten_utf8(ltrim(str_replace("\n"," ",str_replace("\r","",preg_replace('~^(#|-- ).*~m','',$Lg)))),80,"</code>").($qc?" <span class='time'>($qc)</span>":"")."<br>\n";}echo"<input type='submit' name='clear' value='".lang(169)."'>\n","<a href='".h(ME."sql=&history=all")."'>".lang(170)."</a>\n","</div></fieldset>\n";}echo'</form>
';}elseif(isset($_GET["edit"])){$a=$_GET["edit"];$o=fields($a);$Z=(isset($_GET["select"])?($_POST["check"]&&count($_POST["check"])==1?where_check($_POST["check"][0],$o):""):where($_GET,$o));$dj=(isset($_GET["select"])?$_POST["edit"]:$Z);foreach($o
as$C=>$n){if(!isset($n["privileges"][$dj?"update":"insert"])||adminer()->fieldName($n)==""||$n["generated"])unset($o[$C]);}if($_POST&&!$m&&!isset($_GET["select"])){$Ie=$_POST["referer"];if($_POST["insert"])$Ie=($dj?null:$_SERVER["REQUEST_URI"]);elseif(!preg_match('~^.+&select=.+$~',$Ie))$Ie=ME."select=".urlencode($a);$x=indexes($a);$Yi=unique_array($_GET["where"],$x);$Og="\nWHERE $Z";if(isset($_POST["delete"]))queries_redirect($Ie,lang(171),driver()->delete($a,$Og,$Yi?0:1));else{$O=array();foreach($o
as$C=>$n){$X=process_input($n);if($X!==false&&$X!==null)$O[idf_escape($C)]=$X;}if($dj){if(!$O)redirect($Ie);queries_redirect($Ie,lang(172),driver()->update($a,$O,$Og,$Yi?0:1));if(is_ajax()){page_headers();page_messages($m);exit;}}else{$I=driver()->insert($a,$O);$Ae=($I?last_id($I):0);queries_redirect($Ie,lang(173,($Ae?" $Ae":"")),$I);}}}$K=null;if($_POST["save"])$K=(array)$_POST["fields"];elseif($Z){$M=array();foreach($o
as$C=>$n){if(isset($n["privileges"]["select"])){$ya=($_POST["clone"]&&$n["auto_increment"]?"''":convert_field($n));$M[]=($ya?"$ya AS ":"").idf_escape($C);}}$K=array();if(!support("table"))$M=array("*");if($M){$I=driver()->select($a,$M,array($Z),$M,array(),(isset($_GET["select"])?2:1));if(!$I)$m=error();else{$K=$I->fetch_assoc();if(!$K)$K=false;}if(isset($_GET["select"])&&(!$K||$I->fetch_assoc()))$K=null;}}if(!support("table")&&!$o){if(!$Z){$I=driver()->select($a,array("*"),array(),array("*"));$K=($I?$I->fetch_assoc():false);if(!$K)$K=array(driver()->primary=>"");}if($K){foreach($K
as$y=>$X){if(!$Z)$K[$y]=null;$o[$y]=array("field"=>$y,"null"=>($y!=driver()->primary),"auto_increment"=>($y==driver()->primary));}}}edit_form($a,$o,$K,$dj,$m);}elseif(isset($_GET["create"])){$a=$_GET["create"];$kg=array();foreach(array('HASH','LINEAR HASH','KEY','LINEAR KEY','RANGE','LIST')as$y)$kg[$y]=$y;$Ug=referencable_primary($a);$jd=array();foreach($Ug
as$hi=>$n)$jd[str_replace("`","``",$hi)."`".str_replace("`","``",$n["field"])]=$hi;$Wf=array();$S=array();if($a!=""){$Wf=fields($a);$S=table_status1($a);if(count($S)<2)$m=lang(9);}$K=$_POST;$K["fields"]=(array)$K["fields"];if($K["auto_increment_col"])$K["fields"][$K["auto_increment_col"]]["auto_increment"]=true;if($_POST)save_settings(array("comments"=>$_POST["comments"],"defaults"=>$_POST["defaults"]));if($_POST&&!process_fields($K["fields"])&&!$m){if($_POST["drop"])queries_redirect(substr(ME,0,-1),lang(174),drop_tables(array($a)));else{$o=array();$ua=array();$hj=false;$hd=array();$Vf=reset($Wf);$sa=" FIRST";foreach($K["fields"]as$y=>$n){$q=$jd[$n["type"]];$Si=($q!==null?$Ug[$q]:$n);if($n["field"]!=""){if(!$n["generated"])$n["default"]=null;$Jg=process_field($n,$Si);$ua[]=array($n["orig"],$Jg,$sa);if(!$Vf||$Jg!==process_field($Vf,$Vf)){$o[]=array($n["orig"],$Jg,$sa);if($n["orig"]!=""||$sa)$hj=true;}if($q!==null)$hd[idf_escape($n["field"])]=($a!=""&&JUSH!="sqlite"?"ADD":" ").format_foreign_key(array('table'=>$jd[$n["type"]],'source'=>array($n["field"]),'target'=>array($Si["field"]),'on_delete'=>$n["on_delete"],));$sa=" AFTER ".idf_escape($n["field"]);}elseif($n["orig"]!=""){$hj=true;$o[]=array($n["orig"]);}if($n["orig"]!=""){$Vf=next($Wf);if(!$Vf)$sa="";}}$mg="";if(support("partitioning")){if(isset($kg[$K["partition_by"]])){$hg=array();foreach($K
as$y=>$X){if(preg_match('~^partition~',$y))$hg[$y]=$X;}foreach($hg["partition_names"]as$y=>$C){if($C==""){unset($hg["partition_names"][$y]);unset($hg["partition_values"][$y]);}}if($hg!=get_partitions_info($a)){$ng=array();if($hg["partition_by"]=='RANGE'||$hg["partition_by"]=='LIST'){foreach($hg["partition_names"]as$y=>$C){$Y=$hg["partition_values"][$y];$ng[]="\n  PARTITION ".idf_escape($C)." VALUES ".($hg["partition_by"]=='RANGE'?"LESS THAN":"IN").($Y!=""?" ($Y)":" MAXVALUE");}}$mg
.="\nPARTITION BY $hg[partition_by]($hg[partition])";if($ng)$mg
.=" (".implode(",",$ng)."\n)";elseif($hg["partitions"])$mg
.=" PARTITIONS ".(+$hg["partitions"]);}}elseif(preg_match("~partitioned~",$S["Create_options"]))$mg
.="\nREMOVE PARTITIONING";}$Ze=lang(175);if($a==""){cookie("adminer_engine",$K["Engine"]);$Ze=lang(176);}$C=trim($K["name"]);queries_redirect(ME.(support("table")?"table=":"select=").urlencode($C),$Ze,alter_table($a,$C,(JUSH=="sqlite"&&($hj||$hd)?$ua:$o),$hd,($K["Comment"]!=$S["Comment"]?$K["Comment"]:null),($K["Engine"]&&$K["Engine"]!=$S["Engine"]?$K["Engine"]:""),($K["Collation"]&&$K["Collation"]!=$S["Collation"]?$K["Collation"]:""),($K["Auto_increment"]!=""?number($K["Auto_increment"]):""),$mg));}}page_header(($a!=""?lang(43):lang(73)),$m,array("table"=>$a),h($a));if(!$_POST){$Ui=driver()->types();$K=array("Engine"=>$_COOKIE["adminer_engine"],"fields"=>array(array("field"=>"","type"=>(isset($Ui["int"])?"int":(isset($Ui["integer"])?"integer":"")),"on_update"=>"")),"partition_names"=>array(""),);if($a!=""){$K=$S;$K["name"]=$a;$K["fields"]=array();if(!$_GET["auto_increment"])$K["Auto_increment"]="";foreach($Wf
as$n){$n["generated"]=$n["generated"]?:(isset($n["default"])?"DEFAULT":"");$K["fields"][]=$n;}if(support("partitioning")){$K+=get_partitions_info($a);$K["partition_names"][]="";$K["partition_values"][]="";}}}$jb=collations();if(is_array(reset($jb)))$jb=call_user_func_array('array_merge',array_values($jb));$xc=driver()->engines();foreach($xc
as$wc){if(!strcasecmp($wc,$K["Engine"])){$K["Engine"]=$wc;break;}}echo'
<form action="" method="post" id="form">
<p>
';if(support("columns")||$a==""){echo
lang(177).": <input name='name'".($a==""&&!$_POST?" autofocus":"")." data-maxlength='64' value='".h($K["name"])."' autocapitalize='off'>\n",($xc?html_select("Engine",array(""=>"(".lang(178).")")+$xc,$K["Engine"]).on_help("event.target.value",1).script("qsl('select').onchange = helpClose;")."\n":"");if($jb)echo"<datalist id='collations'>".optionlist($jb)."</datalist>\n",(preg_match("~sqlite|mssql~",JUSH)?"":"<input list='collations' name='Collation' value='".h($K["Collation"])."' placeholder='(".lang(102).")'>\n");echo"<input type='submit' value='".lang(14)."'>\n";}if(support("columns")){echo"<div class='scrollable'>\n","<table id='edit-fields' class='nowrap'>\n";edit_fields($K["fields"],$jb,"TABLE",$jd);echo"</table>\n",script("editFields();"),"</div>\n<p>\n",lang(50).": <input type='number' name='Auto_increment' class='size' value='".h($K["Auto_increment"])."'>\n",checkbox("defaults",1,($_POST?$_POST["defaults"]:get_setting("defaults")),lang(179),"columnShow(this.checked, 5)","jsonly");$qb=($_POST?$_POST["comments"]:get_setting("comments"));echo(support("comment")?checkbox("comments",1,$qb,lang(49),"editingCommentsClick(this, true);","jsonly").' '.(preg_match('~\n~',$K["Comment"])?"<textarea name='Comment' rows='2' cols='20'".($qb?"":" class='hidden'").">".h($K["Comment"])."</textarea>":'<input name="Comment" value="'.h($K["Comment"]).'" data-maxlength="'.(min_version(5.5)?2048:60).'"'.($qb?"":" class='hidden'").'>'):''),'<p>
<input type="submit" value="',lang(14),'">
';}echo'
';if($a!="")echo'<input type="submit" name="drop" value="',lang(128),'">',confirm(lang(180,$a));if(support("partitioning")){$lg=preg_match('~RANGE|LIST~',$K["partition_by"]);print_fieldset("partition",lang(181),$K["partition_by"]);echo"<p>".html_select("partition_by",array(""=>"")+$kg,$K["partition_by"]).on_help("event.target.value.replace(/./, 'PARTITION BY \$&')",1).script("qsl('select').onchange = partitionByChange;"),"(<input name='partition' value='".h($K["partition"])."'>)\n",lang(182).": <input type='number' name='partitions' class='size".($lg||!$K["partition_by"]?" hidden":"")."' value='".h($K["partitions"])."'>\n","<table id='partition-table'".($lg?"":" class='hidden'").">\n","<thead><tr><th>".lang(183)."<th>".lang(184)."</thead>\n";foreach($K["partition_names"]as$y=>$X)echo'<tr>','<td><input name="partition_names[]" value="'.h($X).'" autocapitalize="off">',($y==count($K["partition_names"])-1?script("qsl('input').oninput = partitionNameChange;"):''),'<td><input name="partition_values[]" value="'.h(idx($K["partition_values"],$y)).'">';echo"</table>\n</div></fieldset>\n";}echo
input_token(),'</form>
';}elseif(isset($_GET["indexes"])){$a=$_GET["indexes"];$Xd=array("PRIMARY","UNIQUE","INDEX");$S=table_status1($a,true);if(preg_match('~MyISAM|M?aria'.(min_version(5.6,'10.0.5')?'|InnoDB':'').'~i',$S["Engine"]))$Xd[]="FULLTEXT";if(preg_match('~MyISAM|M?aria'.(min_version(5.7,'10.2.2')?'|InnoDB':'').'~i',$S["Engine"]))$Xd[]="SPATIAL";$x=indexes($a);$G=array();if(JUSH=="mongo"){$G=$x["_id_"];unset($Xd[0]);unset($x["_id_"]);}$K=$_POST;if($K)save_settings(array("index_options"=>$K["options"]));if($_POST&&!$m&&!$_POST["add"]&&!$_POST["drop_col"]){$b=array();foreach($K["indexes"]as$w){$C=$w["name"];if(in_array($w["type"],$Xd)){$e=array();$Fe=array();$Yb=array();$O=array();ksort($w["columns"]);foreach($w["columns"]as$y=>$d){if($d!=""){$z=idx($w["lengths"],$y);$Wb=idx($w["descs"],$y);$O[]=idf_escape($d).($z?"(".(+$z).")":"").($Wb?" DESC":"");$e[]=$d;$Fe[]=($z?:null);$Yb[]=$Wb;}}$Jc=$x[$C];if($Jc){ksort($Jc["columns"]);ksort($Jc["lengths"]);ksort($Jc["descs"]);if($w["type"]==$Jc["type"]&&array_values($Jc["columns"])===$e&&(!$Jc["lengths"]||array_values($Jc["lengths"])===$Fe)&&array_values($Jc["descs"])===$Yb){unset($x[$C]);continue;}}if($e)$b[]=array($w["type"],$C,$O);}}foreach($x
as$C=>$Jc)$b[]=array($Jc["type"],$C,"DROP");if(!$b)redirect(ME."table=".urlencode($a));queries_redirect(ME."table=".urlencode($a),lang(185),alter_indexes($a,$b));}page_header(lang(135),$m,array("table"=>$a),h($a));$o=array_keys(fields($a));if($_POST["add"]){foreach($K["indexes"]as$y=>$w){if($w["columns"][count($w["columns"])]!="")$K["indexes"][$y]["columns"][]="";}$w=end($K["indexes"]);if($w["type"]||array_filter($w["columns"],'strlen'))$K["indexes"][]=array("columns"=>array(1=>""));}if(!$K){foreach($x
as$y=>$w){$x[$y]["name"]=$y;$x[$y]["columns"][]="";}$x[]=array("columns"=>array(1=>""));$K["indexes"]=$x;}$Fe=(JUSH=="sql"||JUSH=="mssql");$Hh=($_POST?$_POST["options"]:get_setting("index_options"));echo'
<form action="" method="post">
<div class="scrollable">
<table class="nowrap">
<thead><tr>
<th id="label-type">',lang(186),'<th><input type="submit" class="wayoff">',lang(187).($Fe?"<span class='idxopts".($Hh?"":" hidden")."'> (".lang(188).")</span>":"");if($Fe||support("descidx"))echo
checkbox("options",1,$Hh,lang(108),"indexOptionsShow(this.checked)","jsonly")."\n";echo'<th id="label-name">',lang(189),'<th><noscript>',icon("plus","add[0]","+",lang(109)),'</noscript>
</thead>
';if($G){echo"<tr><td>PRIMARY<td>";foreach($G["columns"]as$y=>$d)echo
select_input(" disabled",$o,$d),"<label><input disabled type='checkbox'>".lang(58)."</label> ";echo"<td><td>\n";}$pe=1;foreach($K["indexes"]as$w){if(!$_POST["drop_col"]||$pe!=key($_POST["drop_col"])){echo"<tr><td>".html_select("indexes[$pe][type]",array(-1=>"")+$Xd,$w["type"],($pe==count($K["indexes"])?"indexesAddRow.call(this);":""),"label-type"),"<td>";ksort($w["columns"]);$t=1;foreach($w["columns"]as$y=>$d){echo"<span>".select_input(" name='indexes[$pe][columns][$t]' title='".lang(47)."'",($o?array_combine($o,$o):$o),$d,"partial(".($t==count($w["columns"])?"indexesAddColumn":"indexesChangeColumn").", '".js_escape(JUSH=="sql"?"":$_GET["indexes"]."_")."')"),"<span class='idxopts".($Hh?"":" hidden")."'>",($Fe?"<input type='number' name='indexes[$pe][lengths][$t]' class='size' value='".h(idx($w["lengths"],$y))."' title='".lang(107)."'>":""),(support("descidx")?checkbox("indexes[$pe][descs][$t]",1,idx($w["descs"],$y),lang(58)):""),"</span> </span>";$t++;}echo"<td><input name='indexes[$pe][name]' value='".h($w["name"])."' autocapitalize='off' aria-labelledby='label-name'>\n","<td>".icon("cross","drop_col[$pe]","x",lang(112)).script("qsl('button').onclick = partial(editingRemoveRow, 'indexes\$1[type]');");}$pe++;}echo'</table>
</div>
<p>
<input type="submit" value="',lang(14),'">
',input_token(),'</form>
';}elseif(isset($_GET["database"])){$K=$_POST;if($_POST&&!$m&&!$_POST["add"]){$C=trim($K["name"]);if($_POST["drop"]){$_GET["db"]="";queries_redirect(remove_from_uri("db|database"),lang(190),drop_databases(array(DB)));}elseif(DB!==$C){if(DB!=""){$_GET["db"]=$C;queries_redirect(preg_replace('~\bdb=[^&]*&~','',ME)."db=".urlencode($C),lang(191),rename_database($C,$K["collation"]));}else{$j=explode("\n",str_replace("\r","",$C));$ai=true;$_e="";foreach($j
as$k){if(count($j)==1||$k!=""){if(!create_database($k,$K["collation"]))$ai=false;$_e=$k;}}restart_session();set_session("dbs",null);queries_redirect(ME."db=".urlencode($_e),lang(192),$ai);}}else{if(!$K["collation"])redirect(substr(ME,0,-1));query_redirect("ALTER DATABASE ".idf_escape($C).(preg_match('~^[a-z0-9_]+$~i',$K["collation"])?" COLLATE $K[collation]":""),substr(ME,0,-1),lang(193));}}page_header(DB!=""?lang(66):lang(116),$m,array(),h(DB));$jb=collations();$C=DB;if($_POST)$C=$K["name"];elseif(DB!="")$K["collation"]=db_collation(DB,$jb);elseif(JUSH=="sql"){foreach(get_vals("SHOW GRANTS")as$sd){if(preg_match('~ ON (`(([^\\\\`]|``|\\\\.)*)%`\.\*)?~',$sd,$B)&&$B[1]){$C=stripcslashes(idf_unescape("`$B[2]`"));break;}}}echo'
<form action="" method="post">
<p>
',($_POST["add"]||strpos($C,"\n")?'<textarea autofocus name="name" rows="10" cols="40">'.h($C).'</textarea><br>':'<input name="name" autofocus value="'.h($C).'" data-maxlength="64" autocapitalize="off">')."\n".($jb?html_select("collation",array(""=>"(".lang(102).")")+$jb,$K["collation"]).doc_link(array('sql'=>"charset-charsets.html",'mariadb'=>"supported-character-sets-and-collations/",'mssql'=>"relational-databases/system-functions/sys-fn-helpcollations-transact-sql",)):""),'<input type="submit" value="',lang(14),'">
';if(DB!="")echo"<input type='submit' name='drop' value='".lang(128)."'>".confirm(lang(180,DB))."\n";elseif(!$_POST["add"]&&$_GET["db"]=="")echo
icon("plus","add[0]","+",lang(109))."\n";echo
input_token(),'</form>
';}elseif(isset($_GET["scheme"])){$K=$_POST;if($_POST&&!$m){$A=preg_replace('~ns=[^&]*&~','',ME)."ns=";if($_POST["drop"])query_redirect("DROP SCHEMA ".idf_escape($_GET["ns"]),$A,lang(194));else{$C=trim($K["name"]);$A
.=urlencode($C);if($_GET["ns"]=="")query_redirect("CREATE SCHEMA ".idf_escape($C),$A,lang(195));elseif($_GET["ns"]!=$C)query_redirect("ALTER SCHEMA ".idf_escape($_GET["ns"])." RENAME TO ".idf_escape($C),$A,lang(196));else
redirect($A);}}page_header($_GET["ns"]!=""?lang(67):lang(68),$m);if(!$K)$K["name"]=$_GET["ns"];echo'
<form action="" method="post">
<p><input name="name" autofocus value="',h($K["name"]),'" autocapitalize="off">
<input type="submit" value="',lang(14),'">
';if($_GET["ns"]!="")echo"<input type='submit' name='drop' value='".lang(128)."'>".confirm(lang(180,$_GET["ns"]))."\n";echo
input_token(),'</form>
';}elseif(isset($_GET["call"])){$ca=($_GET["name"]?:$_GET["call"]);page_header(lang(197).": ".h($ca),$m);$ih=routine($_GET["call"],(isset($_GET["callf"])?"FUNCTION":"PROCEDURE"));$Td=array();$bg=array();foreach($ih["fields"]as$t=>$n){if(substr($n["inout"],-3)=="OUT")$bg[$t]="@".idf_escape($n["field"])." AS ".idf_escape($n["field"]);if(!$n["inout"]||substr($n["inout"],0,2)=="IN")$Td[]=$t;}if(!$m&&$_POST){$Ta=array();foreach($ih["fields"]as$y=>$n){$X="";if(in_array($y,$Td)){$X=process_input($n);if($X===false)$X="''";if(isset($bg[$y]))connection()->query("SET @".idf_escape($n["field"])." = $X");}$Ta[]=(isset($bg[$y])?"@".idf_escape($n["field"]):$X);}$H=(isset($_GET["callf"])?"SELECT":"CALL")." ".table($ca)."(".implode(", ",$Ta).")";$Vh=microtime(true);$I=connection()->multi_query($H);$qa=connection()->affected_rows;echo
adminer()->selectQuery($H,$Vh,!$I);if(!$I)echo"<p class='error'>".error()."\n";else{$h=connect();if($h)$h->select_db(DB);do{$I=connection()->store_result();if(is_object($I))print_select_result($I,$h);else
echo"<p class='message'>".lang(198,$qa)." <span class='time'>".@date("H:i:s")."</span>\n";}while(connection()->next_result());if($bg)print_select_result(connection()->query("SELECT ".implode(", ",$bg)));}}echo'
<form action="" method="post">
';if($Td){echo"<table class='layout'>\n";foreach($Td
as$y){$n=$ih["fields"][$y];$C=$n["field"];echo"<tr><th>".adminer()->fieldName($n);$Y=idx($_POST["fields"],$C);if($Y!=""){if($n["type"]=="set")$Y=implode(",",$Y);}input($n,$Y,idx($_POST["function"],$C,""));echo"\n";}echo"</table>\n";}echo'<p>
<input type="submit" value="',lang(197),'">
',input_token(),'</form>

<pre>
';function
pre_tr($mh){return
preg_replace('~^~m','<tr>',preg_replace('~\|~','<td>',preg_replace('~\|$~m',"",rtrim($mh))));}$R='(\+--[-+]+\+\n)';$K='(\| .* \|\n)';echo
preg_replace_callback("~^$R?$K$R?($K*)$R?~m",function($B){$ad=pre_tr($B[2]);return"<table>\n".($B[1]?"<thead>$ad</thead>\n":$ad).pre_tr($B[4])."\n</table>";},preg_replace('~(\n(    -|mysql)&gt; )(.+)~',"\\1<code class='jush-sql'>\\3</code>",preg_replace('~(.+)\n---+\n~',"<b>\\1</b>\n",h($ih['comment']))));echo'</pre>
';}elseif(isset($_GET["foreign"])){$a=$_GET["foreign"];$C=$_GET["name"];$K=$_POST;if($_POST&&!$m&&!$_POST["add"]&&!$_POST["change"]&&!$_POST["change-js"]){if(!$_POST["drop"]){$K["source"]=array_filter($K["source"],'strlen');ksort($K["source"]);$qi=array();foreach($K["source"]as$y=>$X)$qi[$y]=$K["target"][$y];$K["target"]=$qi;}if(JUSH=="sqlite")$I=recreate_table($a,$a,array(),array(),array(" $C"=>($K["drop"]?"":" ".format_foreign_key($K))));else{$b="ALTER TABLE ".table($a);$I=($C==""||queries("$b DROP ".(JUSH=="sql"?"FOREIGN KEY ":"CONSTRAINT ").idf_escape($C)));if(!$K["drop"])$I=queries("$b ADD".format_foreign_key($K));}queries_redirect(ME."table=".urlencode($a),($K["drop"]?lang(199):($C!=""?lang(200):lang(201))),$I);if(!$K["drop"])$m=lang(202);}page_header(lang(203),$m,array("table"=>$a),h($a));if($_POST){ksort($K["source"]);if($_POST["add"])$K["source"][]="";elseif($_POST["change"]||$_POST["change-js"])$K["target"]=array();}elseif($C!=""){$jd=foreign_keys($a);$K=$jd[$C];$K["source"][]="";}else{$K["table"]=$a;$K["source"]=array("");}echo'
<form action="" method="post">
';$Mh=array_keys(fields($a));if($K["db"]!="")connection()->select_db($K["db"]);if($K["ns"]!=""){$Xf=get_schema();set_schema($K["ns"]);}$Tg=array_keys(array_filter(table_status('',true),'Adminer\fk_support'));$qi=array_keys(fields(in_array($K["table"],$Tg)?$K["table"]:reset($Tg)));$Hf="this.form['change-js'].value = '1'; this.form.submit();";echo"<p><label>".lang(204).": ".html_select("table",$Tg,$K["table"],$Hf)."</label>\n";if(support("scheme")){$ph=array_filter(adminer()->schemas(),function($oh){return!preg_match('~^information_schema$~i',$oh);});echo"<label>".lang(75).": ".html_select("ns",$ph,$K["ns"]!=""?$K["ns"]:$_GET["ns"],$Hf)."</label>";if($K["ns"]!="")set_schema($Xf);}elseif(JUSH!="sqlite"){$Pb=array();foreach(adminer()->databases()as$k){if(!information_schema($k))$Pb[]=$k;}echo"<label>".lang(74).": ".html_select("db",$Pb,$K["db"]!=""?$K["db"]:$_GET["db"],$Hf)."</label>";}echo
input_hidden("change-js"),'<noscript><p><input type="submit" name="change" value="',lang(205),'"></noscript>
<table>
<thead><tr><th id="label-source">',lang(137),'<th id="label-target">',lang(138),'</thead>
';$pe=0;foreach($K["source"]as$y=>$X){echo"<tr>","<td>".html_select("source[".(+$y)."]",array(-1=>"")+$Mh,$X,($pe==count($K["source"])-1?"foreignAddRow.call(this);":""),"label-source"),"<td>".html_select("target[".(+$y)."]",$qi,idx($K["target"],$y),"","label-target");$pe++;}echo'</table>
<p>
<label>',lang(104),': ',html_select("on_delete",array(-1=>"")+explode("|",driver()->onActions),$K["on_delete"]),'</label>
<label>',lang(103),': ',html_select("on_update",array(-1=>"")+explode("|",driver()->onActions),$K["on_update"]),'</label>
',doc_link(array('sql'=>"innodb-foreign-key-constraints.html",'mariadb'=>"foreign-keys/",'pgsql'=>"sql-createtable.html#SQL-CREATETABLE-REFERENCES",'mssql'=>"t-sql/statements/create-table-transact-sql",'oracle'=>"SQLRF01111",)),'<p>
<input type="submit" value="',lang(14),'">
<noscript><p><input type="submit" name="add" value="',lang(206),'"></noscript>
';if($C!="")echo'<input type="submit" name="drop" value="',lang(128),'">',confirm(lang(180,$C));echo
input_token(),'</form>
';}elseif(isset($_GET["view"])){$a=$_GET["view"];$K=$_POST;$Yf="VIEW";if(JUSH=="pgsql"&&$a!=""){$P=table_status1($a);$Yf=strtoupper($P["Engine"]);}if($_POST&&!$m){$C=trim($K["name"]);$ya=" AS\n$K[select]";$Ie=ME."table=".urlencode($C);$Ze=lang(207);$U=($_POST["materialized"]?"MATERIALIZED VIEW":"VIEW");if(!$_POST["drop"]&&$a==$C&&JUSH!="sqlite"&&$U=="VIEW"&&$Yf=="VIEW")query_redirect((JUSH=="mssql"?"ALTER":"CREATE OR REPLACE")." VIEW ".table($C).$ya,$Ie,$Ze);else{$si=$C."_adminer_".uniqid();drop_create("DROP $Yf ".table($a),"CREATE $U ".table($C).$ya,"DROP $U ".table($C),"CREATE $U ".table($si).$ya,"DROP $U ".table($si),($_POST["drop"]?substr(ME,0,-1):$Ie),lang(208),$Ze,lang(209),$a,$C);}}if(!$_POST&&$a!=""){$K=view($a);$K["name"]=$a;$K["materialized"]=($Yf!="VIEW");if(!$m)$m=error();}page_header(($a!=""?lang(42):lang(210)),$m,array("table"=>$a),h($a));echo'
<form action="" method="post">
<p>',lang(189),': <input name="name" value="',h($K["name"]),'" data-maxlength="64" autocapitalize="off">
',(support("materializedview")?" ".checkbox("materialized",1,$K["materialized"],lang(132)):""),'<p>';textarea("select",$K["select"]);echo'<p>
<input type="submit" value="',lang(14),'">
';if($a!="")echo'<input type="submit" name="drop" value="',lang(128),'">',confirm(lang(180,$a));echo
input_token(),'</form>
';}elseif(isset($_GET["event"])){$aa=$_GET["event"];$he=array("YEAR","QUARTER","MONTH","DAY","HOUR","MINUTE","WEEK","SECOND","YEAR_MONTH","DAY_HOUR","DAY_MINUTE","DAY_SECOND","HOUR_MINUTE","HOUR_SECOND","MINUTE_SECOND");$Wh=array("ENABLED"=>"ENABLE","DISABLED"=>"DISABLE","SLAVESIDE_DISABLED"=>"DISABLE ON SLAVE");$K=$_POST;if($_POST&&!$m){if($_POST["drop"])query_redirect("DROP EVENT ".idf_escape($aa),substr(ME,0,-1),lang(211));elseif(in_array($K["INTERVAL_FIELD"],$he)&&isset($Wh[$K["STATUS"]])){$nh="\nON SCHEDULE ".($K["INTERVAL_VALUE"]?"EVERY ".q($K["INTERVAL_VALUE"])." $K[INTERVAL_FIELD]".($K["STARTS"]?" STARTS ".q($K["STARTS"]):"").($K["ENDS"]?" ENDS ".q($K["ENDS"]):""):"AT ".q($K["STARTS"]))." ON COMPLETION".($K["ON_COMPLETION"]?"":" NOT")." PRESERVE";queries_redirect(substr(ME,0,-1),($aa!=""?lang(212):lang(213)),queries(($aa!=""?"ALTER EVENT ".idf_escape($aa).$nh.($aa!=$K["EVENT_NAME"]?"\nRENAME TO ".idf_escape($K["EVENT_NAME"]):""):"CREATE EVENT ".idf_escape($K["EVENT_NAME"]).$nh)."\n".$Wh[$K["STATUS"]]." COMMENT ".q($K["EVENT_COMMENT"]).rtrim(" DO\n$K[EVENT_DEFINITION]",";").";"));}}page_header(($aa!=""?lang(214).": ".h($aa):lang(215)),$m);if(!$K&&$aa!=""){$L=get_rows("SELECT * FROM information_schema.EVENTS WHERE EVENT_SCHEMA = ".q(DB)." AND EVENT_NAME = ".q($aa));$K=reset($L);}echo'
<form action="" method="post">
<table class="layout">
<tr><th>',lang(189),'<td><input name="EVENT_NAME" value="',h($K["EVENT_NAME"]),'" data-maxlength="64" autocapitalize="off">
<tr><th title="datetime">',lang(216),'<td><input name="STARTS" value="',h("$K[EXECUTE_AT]$K[STARTS]"),'">
<tr><th title="datetime">',lang(217),'<td><input name="ENDS" value="',h($K["ENDS"]),'">
<tr><th>',lang(218),'<td><input type="number" name="INTERVAL_VALUE" value="',h($K["INTERVAL_VALUE"]),'" class="size"> ',html_select("INTERVAL_FIELD",$he,$K["INTERVAL_FIELD"]),'<tr><th>',lang(119),'<td>',html_select("STATUS",$Wh,$K["STATUS"]),'<tr><th>',lang(49),'<td><input name="EVENT_COMMENT" value="',h($K["EVENT_COMMENT"]),'" data-maxlength="64">
<tr><th><td>',checkbox("ON_COMPLETION","PRESERVE",$K["ON_COMPLETION"]=="PRESERVE",lang(219)),'</table>
<p>';textarea("EVENT_DEFINITION",$K["EVENT_DEFINITION"]);echo'<p>
<input type="submit" value="',lang(14),'">
';if($aa!="")echo'<input type="submit" name="drop" value="',lang(128),'">',confirm(lang(180,$aa));echo
input_token(),'</form>
';}elseif(isset($_GET["procedure"])){$ca=($_GET["name"]?:$_GET["procedure"]);$ih=(isset($_GET["function"])?"FUNCTION":"PROCEDURE");$K=$_POST;$K["fields"]=(array)$K["fields"];if($_POST&&!process_fields($K["fields"])&&!$m){$Uf=routine($_GET["procedure"],$ih);$si="$K[name]_adminer_".uniqid();foreach($K["fields"]as$y=>$n){if($n["field"]=="")unset($K["fields"][$y]);}drop_create("DROP $ih ".routine_id($ca,$Uf),create_routine($ih,$K),"DROP $ih ".routine_id($K["name"],$K),create_routine($ih,array("name"=>$si)+$K),"DROP $ih ".routine_id($si,$K),substr(ME,0,-1),lang(220),lang(221),lang(222),$ca,$K["name"]);}page_header(($ca!=""?(isset($_GET["function"])?lang(223):lang(224)).": ".h($ca):(isset($_GET["function"])?lang(225):lang(226))),$m);if(!$_POST){if($ca=="")$K["language"]="sql";else{$K=routine($_GET["procedure"],$ih);$K["name"]=$ca;}}$jb=get_vals("SHOW CHARACTER SET");sort($jb);$jh=routine_languages();echo($jb?"<datalist id='collations'>".optionlist($jb)."</datalist>":""),'
<form action="" method="post" id="form">
<p>',lang(189),': <input name="name" value="',h($K["name"]),'" data-maxlength="64" autocapitalize="off">
',($jh?"<label>".lang(19).": ".html_select("language",$jh,$K["language"])."</label>\n":""),'<input type="submit" value="',lang(14),'">
<div class="scrollable">
<table class="nowrap">
';edit_fields($K["fields"],$jb,$ih);if(isset($_GET["function"])){echo"<tr><td>".lang(227);edit_type("returns",$K["returns"],$jb,array(),(JUSH=="pgsql"?array("void","trigger"):array()));}echo'</table>
',script("editFields();"),'</div>
<p>';textarea("definition",$K["definition"]);echo'<p>
<input type="submit" value="',lang(14),'">
';if($ca!="")echo'<input type="submit" name="drop" value="',lang(128),'">',confirm(lang(180,$ca));echo
input_token(),'</form>
';}elseif(isset($_GET["sequence"])){$ea=$_GET["sequence"];$K=$_POST;if($_POST&&!$m){$A=substr(ME,0,-1);$C=trim($K["name"]);if($_POST["drop"])query_redirect("DROP SEQUENCE ".idf_escape($ea),$A,lang(228));elseif($ea=="")query_redirect("CREATE SEQUENCE ".idf_escape($C),$A,lang(229));elseif($ea!=$C)query_redirect("ALTER SEQUENCE ".idf_escape($ea)." RENAME TO ".idf_escape($C),$A,lang(230));else
redirect($A);}page_header($ea!=""?lang(231).": ".h($ea):lang(232),$m);if(!$K)$K["name"]=$ea;echo'
<form action="" method="post">
<p><input name="name" value="',h($K["name"]),'" autocapitalize="off">
<input type="submit" value="',lang(14),'">
';if($ea!="")echo"<input type='submit' name='drop' value='".lang(128)."'>".confirm(lang(180,$ea))."\n";echo
input_token(),'</form>
';}elseif(isset($_GET["type"])){$fa=$_GET["type"];$K=$_POST;if($_POST&&!$m){$A=substr(ME,0,-1);if($_POST["drop"])query_redirect("DROP TYPE ".idf_escape($fa),$A,lang(233));else
query_redirect("CREATE TYPE ".idf_escape(trim($K["name"]))." $K[as]",$A,lang(234));}page_header($fa!=""?lang(235).": ".h($fa):lang(236),$m);if(!$K)$K["as"]="AS ";echo'
<form action="" method="post">
<p>
';if($fa!=""){$Ui=driver()->types();$Ac=type_values($Ui[$fa]);if($Ac)echo"<code class='jush-".JUSH."'>ENUM (".h($Ac).")</code>\n<p>";echo"<input type='submit' name='drop' value='".lang(128)."'>".confirm(lang(180,$fa))."\n";}else{echo
lang(189).": <input name='name' value='".h($K['name'])."' autocapitalize='off'>\n",doc_link(array('pgsql'=>"datatype-enum.html",),"?");textarea("as",$K["as"]);echo"<p><input type='submit' value='".lang(14)."'>\n";}echo
input_token(),'</form>
';}elseif(isset($_GET["check"])){$a=$_GET["check"];$C=$_GET["name"];$K=$_POST;if($K&&!$m){if(JUSH=="sqlite")$I=recreate_table($a,$a,array(),array(),array(),"",array(),"$C",($K["drop"]?"":$K["clause"]));else{$I=($C==""||queries("ALTER TABLE ".table($a)." DROP CONSTRAINT ".idf_escape($C)));if(!$K["drop"])$I=queries("ALTER TABLE ".table($a)." ADD".($K["name"]!=""?" CONSTRAINT ".idf_escape($K["name"]):"")." CHECK ($K[clause])");}queries_redirect(ME."table=".urlencode($a),($K["drop"]?lang(237):($C!=""?lang(238):lang(239))),$I);}page_header(($C!=""?lang(240).": ".h($C):lang(142)),$m,array("table"=>$a));if(!$K){$bb=driver()->checkConstraints($a);$K=array("name"=>$C,"clause"=>$bb[$C]);}echo'
<form action="" method="post">
<p>';if(JUSH!="sqlite")echo
lang(189).': <input name="name" value="'.h($K["name"]).'" data-maxlength="64" autocapitalize="off"> ';echo
doc_link(array('sql'=>"create-table-check-constraints.html",'mariadb'=>"constraint/",'pgsql'=>"ddl-constraints.html#DDL-CONSTRAINTS-CHECK-CONSTRAINTS",'mssql'=>"relational-databases/tables/create-check-constraints",'sqlite'=>"lang_createtable.html#check_constraints",),"?"),'<p>';textarea("clause",$K["clause"]);echo'<p><input type="submit" value="',lang(14),'">
';if($C!="")echo'<input type="submit" name="drop" value="',lang(128),'">',confirm(lang(180,$C));echo
input_token(),'</form>
';}elseif(isset($_GET["trigger"])){$a=$_GET["trigger"];$C="$_GET[name]";$Qi=trigger_options();$K=(array)trigger($C,$a)+array("Trigger"=>$a."_bi");if($_POST){if(!$m&&in_array($_POST["Timing"],$Qi["Timing"])&&in_array($_POST["Event"],$Qi["Event"])&&in_array($_POST["Type"],$Qi["Type"])){$Ef=" ON ".table($a);$gc="DROP TRIGGER ".idf_escape($C).(JUSH=="pgsql"?$Ef:"");$Ie=ME."table=".urlencode($a);if($_POST["drop"])query_redirect($gc,$Ie,lang(241));else{if($C!="")queries($gc);queries_redirect($Ie,($C!=""?lang(242):lang(243)),queries(create_trigger($Ef,$_POST)));if($C!="")queries(create_trigger($Ef,$K+array("Type"=>reset($Qi["Type"]))));}}$K=$_POST;}page_header(($C!=""?lang(244).": ".h($C):lang(245)),$m,array("table"=>$a));echo'
<form action="" method="post" id="form">
<table class="layout">
<tr><th>',lang(246),'<td>',html_select("Timing",$Qi["Timing"],$K["Timing"],"triggerChange(/^".preg_quote($a,"/")."_[ba][iud]$/, '".js_escape($a)."', this.form);"),'<tr><th>',lang(247),'<td>',html_select("Event",$Qi["Event"],$K["Event"],"this.form['Timing'].onchange();"),(in_array("UPDATE OF",$Qi["Event"])?" <input name='Of' value='".h($K["Of"])."' class='hidden'>":""),'<tr><th>',lang(48),'<td>',html_select("Type",$Qi["Type"],$K["Type"]),'</table>
<p>',lang(189),': <input name="Trigger" value="',h($K["Trigger"]),'" data-maxlength="64" autocapitalize="off">
',script("qs('#form')['Timing'].onchange();"),'<p>';textarea("Statement",$K["Statement"]);echo'<p>
<input type="submit" value="',lang(14),'">
';if($C!="")echo'<input type="submit" name="drop" value="',lang(128),'">',confirm(lang(180,$C));echo
input_token(),'</form>
';}elseif(isset($_GET["user"])){$ga=$_GET["user"];$Hg=array(""=>array("All privileges"=>""));foreach(get_rows("SHOW PRIVILEGES")as$K){foreach(explode(",",($K["Privilege"]=="Grant option"?"":$K["Context"]))as$zb)$Hg[$zb][$K["Privilege"]]=$K["Comment"];}$Hg["Server Admin"]+=$Hg["File access on server"];$Hg["Databases"]["Create routine"]=$Hg["Procedures"]["Create routine"];unset($Hg["Procedures"]["Create routine"]);$Hg["Columns"]=array();foreach(array("Select","Insert","Update","References")as$X)$Hg["Columns"][$X]=$Hg["Tables"][$X];unset($Hg["Server Admin"]["Usage"]);foreach($Hg["Tables"]as$y=>$X)unset($Hg["Databases"][$y]);$of=array();if($_POST){foreach($_POST["objects"]as$y=>$X)$of[$X]=(array)$of[$X]+idx($_POST["grants"],$y,array());}$td=array();$Cf="";if(isset($_GET["host"])&&($I=connection()->query("SHOW GRANTS FOR ".q($ga)."@".q($_GET["host"])))){while($K=$I->fetch_row()){if(preg_match('~GRANT (.*) ON (.*) TO ~',$K[0],$B)&&preg_match_all('~ *([^(,]*[^ ,(])( *\([^)]+\))?~',$B[1],$Pe,PREG_SET_ORDER)){foreach($Pe
as$X){if($X[1]!="USAGE")$td["$B[2]$X[2]"][$X[1]]=true;if(preg_match('~ WITH GRANT OPTION~',$K[0]))$td["$B[2]$X[2]"]["GRANT OPTION"]=true;}}if(preg_match("~ IDENTIFIED BY PASSWORD '([^']+)~",$K[0],$B))$Cf=$B[1];}}if($_POST&&!$m){$Df=(isset($_GET["host"])?q($ga)."@".q($_GET["host"]):"''");if($_POST["drop"])query_redirect("DROP USER $Df",ME."privileges=",lang(248));else{$qf=q($_POST["user"])."@".q($_POST["host"]);$og=$_POST["pass"];if($og!=''&&!$_POST["hashed"]&&!min_version(8)){$og=get_val("SELECT PASSWORD(".q($og).")");$m=!$og;}$Db=false;if(!$m){if($Df!=$qf){$Db=queries((min_version(5)?"CREATE USER":"GRANT USAGE ON *.* TO")." $qf IDENTIFIED BY ".(min_version(8)?"":"PASSWORD ").q($og));$m=!$Db;}elseif($og!=$Cf)queries("SET PASSWORD FOR $qf = ".q($og));}if(!$m){$fh=array();foreach($of
as$xf=>$sd){if(isset($_GET["grant"]))$sd=array_filter($sd);$sd=array_keys($sd);if(isset($_GET["grant"]))$fh=array_diff(array_keys(array_filter($of[$xf],'strlen')),$sd);elseif($Df==$qf){$Af=array_keys((array)$td[$xf]);$fh=array_diff($Af,$sd);$sd=array_diff($sd,$Af);unset($td[$xf]);}if(preg_match('~^(.+)\s*(\(.*\))?$~U',$xf,$B)&&(!grant("REVOKE",$fh,$B[2]," ON $B[1] FROM $qf")||!grant("GRANT",$sd,$B[2]," ON $B[1] TO $qf"))){$m=true;break;}}}if(!$m&&isset($_GET["host"])){if($Df!=$qf)queries("DROP USER $Df");elseif(!isset($_GET["grant"])){foreach($td
as$xf=>$fh){if(preg_match('~^(.+)(\(.*\))?$~U',$xf,$B))grant("REVOKE",array_keys($fh),$B[2]," ON $B[1] FROM $qf");}}}queries_redirect(ME."privileges=",(isset($_GET["host"])?lang(249):lang(250)),!$m);if($Db)connection()->query("DROP USER $qf");}}page_header((isset($_GET["host"])?lang(34).": ".h("$ga@$_GET[host]"):lang(151)),$m,array("privileges"=>array('',lang(70))));$K=$_POST;if($K)$td=$of;else{$K=$_GET+array("host"=>get_val("SELECT SUBSTRING_INDEX(CURRENT_USER, '@', -1)"));$K["pass"]=$Cf;if($Cf!="")$K["hashed"]=true;$td[(DB==""||$td?"":idf_escape(addcslashes(DB,"%_\\"))).".*"]=array();}echo'<form action="" method="post">
<table class="layout">
<tr><th>',lang(33),'<td><input name="host" data-maxlength="60" value="',h($K["host"]),'" autocapitalize="off">
<tr><th>',lang(34),'<td><input name="user" data-maxlength="80" value="',h($K["user"]),'" autocapitalize="off">
<tr><th>',lang(35),'<td><input name="pass" id="pass" value="',h($K["pass"]),'" autocomplete="new-password">
',($K["hashed"]?"":script("typePassword(qs('#pass'));")),(min_version(8)?"":checkbox("hashed",1,$K["hashed"],lang(251),"typePassword(this.form['pass'], this.checked);")),'</table>

',"<table class='odds'>\n","<thead><tr><th colspan='2'>".lang(70).doc_link(array('sql'=>"grant.html#priv_level"));$t=0;foreach($td
as$xf=>$sd){echo'<th>'.($xf!="*.*"?"<input name='objects[$t]' value='".h($xf)."' size='10' autocapitalize='off'>":input_hidden("objects[$t]","*.*")."*.*");$t++;}echo"</thead>\n";foreach(array(""=>"","Server Admin"=>lang(33),"Databases"=>lang(36),"Tables"=>lang(134),"Columns"=>lang(47),"Procedures"=>lang(252),)as$zb=>$Wb){foreach((array)$Hg[$zb]as$Gg=>$ob){echo"<tr><td".($Wb?">$Wb<td":" colspan='2'").' lang="en" title="'.h($ob).'">'.h($Gg);$t=0;foreach($td
as$xf=>$sd){$C="'grants[$t][".h(strtoupper($Gg))."]'";$Y=$sd[strtoupper($Gg)];if($zb=="Server Admin"&&$xf!=(isset($td["*.*"])?"*.*":".*"))echo"<td>";elseif(isset($_GET["grant"]))echo"<td><select name=$C><option><option value='1'".($Y?" selected":"").">".lang(253)."<option value='0'".($Y=="0"?" selected":"").">".lang(254)."</select>";else
echo"<td align='center'><label class='block'>","<input type='checkbox' name=$C value='1'".($Y?" checked":"").($Gg=="All privileges"?" id='grants-$t-all'>":">".($Gg=="Grant option"?"":script("qsl('input').onclick = function () { if (this.checked) formUncheck('grants-$t-all'); };"))),"</label>";$t++;}}}echo"</table>\n",'<p>
<input type="submit" value="',lang(14),'">
';if(isset($_GET["host"]))echo'<input type="submit" name="drop" value="',lang(128),'">',confirm(lang(180,"$ga@$_GET[host]"));echo
input_token(),'</form>
';}elseif(isset($_GET["processlist"])){if(support("kill")){if($_POST&&!$m){$ve=0;foreach((array)$_POST["kill"]as$X){if(kill_process($X))$ve++;}queries_redirect(ME."processlist=",lang(255,$ve),$ve||!$_POST["kill"]);}}page_header(lang(117),$m);echo'
<form action="" method="post">
<div class="scrollable">
<table class="nowrap checkable odds">
',script("mixin(qsl('table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true)});");$t=-1;foreach(process_list()as$t=>$K){if(!$t){echo"<thead><tr lang='en'>".(support("kill")?"<th>":"");foreach($K
as$y=>$X)echo"<th>$y".doc_link(array('sql'=>"show-processlist.html#processlist_".strtolower($y),'pgsql'=>"monitoring-stats.html#PG-STAT-ACTIVITY-VIEW",'oracle'=>"REFRN30223",));echo"</thead>\n";}echo"<tr>".(support("kill")?"<td>".checkbox("kill[]",$K[JUSH=="sql"?"Id":"pid"],0):"");foreach($K
as$y=>$X)echo"<td>".((JUSH=="sql"&&$y=="Info"&&preg_match("~Query|Killed~",$K["Command"])&&$X!="")||(JUSH=="pgsql"&&$y=="current_query"&&$X!="<IDLE>")||(JUSH=="oracle"&&$y=="sql_text"&&$X!="")?"<code class='jush-".JUSH."'>".shorten_utf8($X,100,"</code>").' <a href="'.h(ME.($K["db"]!=""?"db=".urlencode($K["db"])."&":"")."sql=".urlencode($X)).'">'.lang(256).'</a>':h($X));echo"\n";}echo'</table>
</div>
<p>
';if(support("kill"))echo($t+1)."/".lang(257,max_connections()),"<p><input type='submit' value='".lang(258)."'>\n";echo
input_token(),'</form>
',script("tableCheck();");}elseif(isset($_GET["select"])){$a=$_GET["select"];$S=table_status1($a);$x=indexes($a);$o=fields($a);$jd=column_foreign_keys($a);$zf=$S["Oid"];$pa=get_settings("adminer_import");$gh=array();$e=array();$th=array();$Qf=array();$wi="";foreach($o
as$y=>$n){$C=adminer()->fieldName($n);$mf=html_entity_decode(strip_tags($C),ENT_QUOTES);if(isset($n["privileges"]["select"])&&$C!=""){$e[$y]=$mf;if(is_shortable($n))$wi=adminer()->selectLengthProcess();}if(isset($n["privileges"]["where"])&&$C!="")$th[$y]=$mf;if(isset($n["privileges"]["order"])&&$C!="")$Qf[$y]=$mf;$gh+=$n["privileges"];}list($M,$ud)=adminer()->selectColumnsProcess($e,$x);$M=array_unique($M);$ud=array_unique($ud);$le=count($ud)<count($M);$Z=adminer()->selectSearchProcess($o,$x);$Pf=adminer()->selectOrderProcess($o,$x);$_=adminer()->selectLimitProcess();if($_GET["val"]&&is_ajax()){header("Content-Type: text/plain; charset=utf-8");foreach($_GET["val"]as$Zi=>$K){$ya=convert_field($o[key($K)]);$M=array($ya?:idf_escape(key($K)));$Z[]=where_check($Zi,$o);$J=driver()->select($a,$M,$Z,$M);if($J)echo
first($J->fetch_row());}exit;}$G=$bj=null;foreach($x
as$w){if($w["type"]=="PRIMARY"){$G=array_flip($w["columns"]);$bj=($M?$G:array());foreach($bj
as$y=>$X){if(in_array(idf_escape($y),$M))unset($bj[$y]);}break;}}if($zf&&!$G){$G=$bj=array($zf=>0);$x[]=array("type"=>"PRIMARY","columns"=>array($zf));}if($_POST&&!$m){$zj=$Z;if(!$_POST["all"]&&is_array($_POST["check"])){$bb=array();foreach($_POST["check"]as$Xa)$bb[]=where_check($Xa,$o);$zj[]="((".implode(") OR (",$bb)."))";}$zj=($zj?"\nWHERE ".implode(" AND ",$zj):"");if($_POST["export"]){save_settings(array("output"=>$_POST["output"],"format"=>$_POST["format"]),"adminer_import");dump_headers($a);adminer()->dumpTable($a,"");$nd=($M?implode(", ",$M):"*").convert_fields($e,$o,$M)."\nFROM ".table($a);$wd=($ud&&$le?"\nGROUP BY ".implode(", ",$ud):"").($Pf?"\nORDER BY ".implode(", ",$Pf):"");$H="SELECT $nd$zj$wd";if(is_array($_POST["check"])&&!$G){$Xi=array();foreach($_POST["check"]as$X)$Xi[]="(SELECT".limit($nd,"\nWHERE ".($Z?implode(" AND ",$Z)." AND ":"").where_check($X,$o).$wd,1).")";$H=implode(" UNION ALL ",$Xi);}adminer()->dumpData($a,"table",$H);adminer()->dumpFooter();exit;}if(!adminer()->selectEmailProcess($Z,$jd)){if($_POST["save"]||$_POST["delete"]){$I=true;$qa=0;$O=array();if(!$_POST["delete"]){foreach($_POST["fields"]as$C=>$X){$X=process_input($o[$C]);if($X!==null&&($_POST["clone"]||$X!==false))$O[idf_escape($C)]=($X!==false?$X:idf_escape($C));}}if($_POST["delete"]||$O){$H=($_POST["clone"]?"INTO ".table($a)." (".implode(", ",array_keys($O)).")\nSELECT ".implode(", ",$O)."\nFROM ".table($a):"");if($_POST["all"]||($G&&is_array($_POST["check"]))||$le){$I=($_POST["delete"]?driver()->delete($a,$zj):($_POST["clone"]?queries("INSERT $H$zj".driver()->insertReturning($a)):driver()->update($a,$O,$zj)));$qa=connection()->affected_rows;if(is_object($I))$qa+=$I->num_rows;}else{foreach((array)$_POST["check"]as$X){$yj="\nWHERE ".($Z?implode(" AND ",$Z)." AND ":"").where_check($X,$o);$I=($_POST["delete"]?driver()->delete($a,$yj,1):($_POST["clone"]?queries("INSERT".limit1($a,$H,$yj)):driver()->update($a,$O,$yj,1)));if(!$I)break;$qa+=connection()->affected_rows;}}}$Ze=lang(259,$qa);if($_POST["clone"]&&$I&&$qa==1){$Ae=last_id($I);if($Ae)$Ze=lang(173," $Ae");}queries_redirect(remove_from_uri($_POST["all"]&&$_POST["delete"]?"page":""),$Ze,$I);if(!$_POST["delete"]){$_g=(array)$_POST["fields"];edit_form($a,array_intersect_key($o,$_g),$_g,!$_POST["clone"],$m);page_footer();exit;}}elseif(!$_POST["import"]){if(!$_POST["val"])$m=lang(260);else{$I=true;$qa=0;foreach($_POST["val"]as$Zi=>$K){$O=array();foreach($K
as$y=>$X){$y=bracket_escape($y,true);$O[idf_escape($y)]=(preg_match('~char|text~',$o[$y]["type"])||$X!=""?adminer()->processInput($o[$y],$X):"NULL");}$I=driver()->update($a,$O," WHERE ".($Z?implode(" AND ",$Z)." AND ":"").where_check($Zi,$o),($le||$G?0:1)," ");if(!$I)break;$qa+=connection()->affected_rows;}queries_redirect(remove_from_uri(),lang(259,$qa),$I);}}elseif(!is_string($Xc=get_file("csv_file",true)))$m=upload_error($Xc);elseif(!preg_match('~~u',$Xc))$m=lang(261);else{save_settings(array("output"=>$pa["output"],"format"=>$_POST["separator"]),"adminer_import");$I=true;$kb=array_keys($o);preg_match_all('~(?>"[^"]*"|[^"\r\n]+)+~',$Xc,$Pe);$qa=count($Pe[0]);driver()->begin();$zh=($_POST["separator"]=="csv"?",":($_POST["separator"]=="tsv"?"\t":";"));$L=array();foreach($Pe[0]as$y=>$X){preg_match_all("~((?>\"[^\"]*\")+|[^$zh]*)$zh~",$X.$zh,$Qe);if(!$y&&!array_diff($Qe[1],$kb)){$kb=$Qe[1];$qa--;}else{$O=array();foreach($Qe[1]as$t=>$hb)$O[idf_escape($kb[$t])]=($hb==""&&$o[$kb[$t]]["null"]?"NULL":q(preg_match('~^".*"$~s',$hb)?str_replace('""','"',substr($hb,1,-1)):$hb));$L[]=$O;}}$I=(!$L||driver()->insertUpdate($a,$L,$G));if($I)driver()->commit();queries_redirect(remove_from_uri("page"),lang(262,$qa),$I);driver()->rollback();}}}$hi=adminer()->tableName($S);if(is_ajax()){page_headers();ob_start();}else
page_header(lang(52).": $hi",$m);$O=null;if(isset($gh["insert"])||!support("table")){$hg=array();foreach((array)$_GET["where"]as$X){if(isset($jd[$X["col"]])&&count($jd[$X["col"]])==1&&($X["op"]=="="||(!$X["op"]&&(is_array($X["val"])||!preg_match('~[_%]~',$X["val"])))))$hg["set"."[".bracket_escape($X["col"])."]"]=$X["val"];}$O=$hg?"&".http_build_query($hg):"";}adminer()->selectLinks($S,$O);if(!$e&&support("table"))echo"<p class='error'>".lang(263).($o?".":": ".error())."\n";else{echo"<form action='' id='form'>\n","<div style='display: none;'>";hidden_fields_get();echo(DB!=""?input_hidden("db",DB).(isset($_GET["ns"])?input_hidden("ns",$_GET["ns"]):""):""),input_hidden("select",$a),"</div>\n";adminer()->selectColumnsPrint($M,$e);adminer()->selectSearchPrint($Z,$th,$x);adminer()->selectOrderPrint($Pf,$Qf,$x);adminer()->selectLimitPrint($_);adminer()->selectLengthPrint($wi);adminer()->selectActionPrint($x);echo"</form>\n";$E=$_GET["page"];$md=null;if($E=="last"){$md=get_val(count_rows($a,$Z,$le,$ud));$E=floor(max(0,intval($md)-1)/$_);}$uh=$M;$vd=$ud;if(!$uh){$uh[]="*";$_b=convert_fields($e,$o,$M);if($_b)$uh[]=substr($_b,2);}foreach($M
as$y=>$X){$n=$o[idf_unescape($X)];if($n&&($ya=convert_field($n)))$uh[$y]="$ya AS $X";}if(!$le&&$bj){foreach($bj
as$y=>$X){$uh[]=idf_escape($y);if($vd)$vd[]=idf_escape($y);}}$I=driver()->select($a,$uh,$Z,$vd,$Pf,$_,$E,true);if(!$I)echo"<p class='error'>".error()."\n";else{if(JUSH=="mssql"&&$E)$I->seek($_*$E);$uc=array();echo"<form action='' method='post' enctype='multipart/form-data'>\n";$L=array();while($K=$I->fetch_assoc()){if($E&&JUSH=="oracle")unset($K["RNUM"]);$L[]=$K;}if($_GET["page"]!="last"&&$_&&$ud&&$le&&JUSH=="sql")$md=get_val(" SELECT FOUND_ROWS()");if(!$L)echo"<p class='message'>".lang(12)."\n";else{$Ga=adminer()->backwardKeys($a,$hi);echo"<div class='scrollable'>","<table id='table' class='nowrap checkable odds'>",script("mixin(qs('#table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true), onkeydown: editingKeydown});"),"<thead><tr>".(!$ud&&$M?"":"<td><input type='checkbox' id='all-page' class='jsonly'>".script("qs('#all-page').onclick = partial(formCheck, /check/);","")." <a href='".h($_GET["modify"]?remove_from_uri("modify"):$_SERVER["REQUEST_URI"]."&modify=1")."'>".lang(264)."</a>");$nf=array();$pd=array();reset($M);$Qg=1;foreach($L[0]as$y=>$X){if(!isset($bj[$y])){$X=idx($_GET["columns"],key($M))?:array();$n=$o[$M?($X?$X["col"]:current($M)):$y];$C=($n?adminer()->fieldName($n,$Qg):($X["fun"]?"*":h($y)));if($C!=""){$Qg++;$nf[$y]=$C;$d=idf_escape($y);$Ld=remove_from_uri('(order|desc)[^=]*|page').'&order%5B0%5D='.urlencode($y);$Wb="&desc%5B0%5D=1";echo"<th id='th[".h(bracket_escape($y))."]'>".script("mixin(qsl('th'), {onmouseover: partial(columnMouse), onmouseout: partial(columnMouse, ' hidden')});","");$od=apply_sql_function($X["fun"],$C);$Lh=isset($n["privileges"]["order"])||$od;echo($Lh?'<a href="'.h($Ld.($Pf[0]==$d||$Pf[0]==$y||(!$Pf&&$le&&$ud[0]==$d)?$Wb:'')).'">'."$od</a>":$od),"<span class='column hidden'>";if($Lh)echo"<a href='".h($Ld.$Wb)."' title='".lang(58)."' class='text'> ↓</a>";if(!$X["fun"]&&isset($n["privileges"]["where"]))echo'<a href="#fieldset-search" title="'.lang(55).'" class="text jsonly"> =</a>',script("qsl('a').onclick = partial(selectSearch, '".js_escape($y)."');");echo"</span>";}$pd[$y]=$X["fun"];next($M);}}$Fe=array();if($_GET["modify"]){foreach($L
as$K){foreach($K
as$y=>$X)$Fe[$y]=max($Fe[$y],min(40,strlen(utf8_decode($X))));}}echo($Ga?"<th>".lang(265):"")."</thead>\n";if(is_ajax())ob_end_clean();foreach(adminer()->rowDescriptions($L,$jd)as$lf=>$K){$Yi=unique_array($L[$lf],$x);if(!$Yi){$Yi=array();foreach($L[$lf]as$y=>$X){if(!preg_match('~^(COUNT\((\*|(DISTINCT )?`(?:[^`]|``)+`)\)|(AVG|GROUP_CONCAT|MAX|MIN|SUM)\(`(?:[^`]|``)+`\))$~',$y))$Yi[$y]=$X;}}$Zi="";foreach($Yi
as$y=>$X){$n=(array)$o[$y];if((JUSH=="sql"||JUSH=="pgsql")&&preg_match('~char|text|enum|set~',$n["type"])&&strlen($X)>64){$y=(strpos($y,'(')?$y:idf_escape($y));$y="MD5(".(JUSH!='sql'||preg_match("~^utf8~",$n["collation"])?$y:"CONVERT($y USING ".charset(connection()).")").")";$X=md5($X);}$Zi
.="&".($X!==null?urlencode("where[".bracket_escape($y)."]")."=".urlencode($X===false?"f":$X):"null%5B%5D=".urlencode($y));}echo"<tr>".(!$ud&&$M?"":"<td>".checkbox("check[]",substr($Zi,1),in_array(substr($Zi,1),(array)$_POST["check"])).($le||information_schema(DB)?"":" <a href='".h(ME."edit=".urlencode($a).$Zi)."' class='edit'>".lang(266)."</a>"));foreach($K
as$y=>$X){if(isset($nf[$y])){$n=(array)$o[$y];$X=driver()->value($X,$n);if($X!=""&&(!isset($uc[$y])||$uc[$y]!=""))$uc[$y]=(is_mail($X)?$nf[$y]:"");$A="";if(preg_match('~blob|bytea|raw|file~',$n["type"])&&$X!="")$A=ME.'download='.urlencode($a).'&field='.urlencode($y).$Zi;if(!$A&&$X!==null){foreach((array)$jd[$y]as$q){if(count($jd[$y])==1||end($q["source"])==$y){$A="";foreach($q["source"]as$t=>$Mh)$A
.=where_link($t,$q["target"][$t],$L[$lf][$Mh]);$A=($q["db"]!=""?preg_replace('~([?&]db=)[^&]+~','\1'.urlencode($q["db"]),ME):ME).'select='.urlencode($q["table"]).$A;if($q["ns"])$A=preg_replace('~([?&]ns=)[^&]+~','\1'.urlencode($q["ns"]),$A);if(count($q["source"])==1)break;}}}if($y=="COUNT(*)"){$A=ME."select=".urlencode($a);$t=0;foreach((array)$_GET["where"]as$W){if(!array_key_exists($W["col"],$Yi))$A
.=where_link($t++,$W["col"],$W["val"],$W["op"]);}foreach($Yi
as$re=>$W)$A
.=where_link($t++,$re,$W);}$Md=select_value($X,$A,$n,$wi);$u=h("val[$Zi][".bracket_escape($y)."]");$Ag=idx(idx($_POST["val"],$Zi),bracket_escape($y));$pc=!is_array($K[$y])&&is_utf8($Md)&&$L[$lf][$y]==$K[$y]&&!$pd[$y]&&!$n["generated"];$ui=preg_match('~text|json|lob~',$n["type"]);echo"<td id='$u'".(preg_match(number_type(),$n["type"])&&($X===null||is_numeric(strip_tags($Md)))?" class='number'":"");if(($_GET["modify"]&&$pc&&$X!==null)||$Ag!==null){$zd=h($Ag!==null?$Ag:$K[$y]);echo">".($ui?"<textarea name='$u' cols='30' rows='".(substr_count($K[$y],"\n")+1)."'>$zd</textarea>":"<input name='$u' value='$zd' size='$Fe[$y]'>");}else{$Ke=strpos($Md,"<i>…</i>");echo" data-text='".($Ke?2:($ui?1:0))."'".($pc?"":" data-warning='".h(lang(267))."'").">$Md";}}}if($Ga)echo"<td>";adminer()->backwardKeysPrint($Ga,$L[$lf]);echo"</tr>\n";}if(is_ajax())exit;echo"</table>\n","</div>\n";}if(!is_ajax()){if($L||$E){$Hc=true;if($_GET["page"]!="last"){if(!$_||(count($L)<$_&&($L||!$E)))$md=($E?$E*$_:0)+count($L);elseif(JUSH!="sql"||!$le){$md=($le?false:found_rows($S,$Z));if(intval($md)<max(1e4,2*($E+1)*$_))$md=first(slow_query(count_rows($a,$Z,$le,$ud)));else$Hc=false;}}$fg=($_&&($md===false||$md>$_||$E));if($fg)echo(($md===false?count($L)+1:$md-$E*$_)>$_?'<p><a href="'.h(remove_from_uri("page")."&page=".($E+1)).'" class="loadmore">'.lang(268).'</a>'.script("qsl('a').onclick = partial(selectLoadMore, $_, '".lang(269)."…');",""):''),"\n";echo"<div class='footer'><div>\n";if($fg){$Se=($md===false?$E+(count($L)>=$_?2:1):floor(($md-1)/$_));echo"<fieldset>";if(JUSH!="simpledb"){echo"<legend><a href='".h(remove_from_uri("page"))."'>".lang(270)."</a></legend>",script("qsl('a').onclick = function () { pageClick(this.href, +prompt('".lang(270)."', '".($E+1)."')); return false; };"),pagination(0,$E).($E>5?" …":"");for($t=max(1,$E-4);$t<min($Se,$E+5);$t++)echo
pagination($t,$E);if($Se>0)echo($E+5<$Se?" …":""),($Hc&&$md!==false?pagination($Se,$E):" <a href='".h(remove_from_uri("page")."&page=last")."' title='~$Se'>".lang(271)."</a>");}else
echo"<legend>".lang(270)."</legend>",pagination(0,$E).($E>1?" …":""),($E?pagination($E,$E):""),($Se>$E?pagination($E+1,$E).($Se>$E+1?" …":""):"");echo"</fieldset>\n";}echo"<fieldset>","<legend>".lang(272)."</legend>";$dc=($Hc?"":"~ ").$md;$If="const checked = formChecked(this, /check/); selectCount('selected', this.checked ? '$dc' : checked); selectCount('selected2', this.checked || !checked ? '$dc' : checked);";echo
checkbox("all",1,0,($md!==false?($Hc?"":"~ ").lang(155,$md):""),$If)."\n","</fieldset>\n";if(adminer()->selectCommandPrint())echo'<fieldset',($_GET["modify"]?'':' class="jsonly"'),'><legend>',lang(264),'</legend><div>
<input type="submit" value="',lang(14),'"',($_GET["modify"]?'':' title="'.lang(260).'"'),'>
</div></fieldset>
<fieldset><legend>',lang(127),' <span id="selected"></span></legend><div>
<input type="submit" name="edit" value="',lang(10),'">
<input type="submit" name="clone" value="',lang(256),'">
<input type="submit" name="delete" value="',lang(18),'">',confirm(),'</div></fieldset>
';$kd=adminer()->dumpFormat();foreach((array)$_GET["columns"]as$d){if($d["fun"]){unset($kd['sql']);break;}}if($kd){print_fieldset("export",lang(72)." <span id='selected2'></span>");$cg=adminer()->dumpOutput();echo($cg?html_select("output",$cg,$pa["output"])." ":""),html_select("format",$kd,$pa["format"])," <input type='submit' name='export' value='".lang(72)."'>\n","</div></fieldset>\n";}adminer()->selectEmailPrint(array_filter($uc,'strlen'),$e);echo"</div></div>\n";}if(adminer()->selectImportPrint())echo"<div>","<a href='#import'>".lang(71)."</a>",script("qsl('a').onclick = partial(toggle, 'import');",""),"<span id='import'".($_POST["import"]?"":" class='hidden'").">: ","<input type='file' name='csv_file'> ",html_select("separator",array("csv"=>"CSV,","csv;"=>"CSV;","tsv"=>"TSV"),$pa["format"])," <input type='submit' name='import' value='".lang(71)."'>","</span>","</div>";echo
input_token(),"</form>\n",(!$ud&&$M?"":script("tableCheck();"));}}}if(is_ajax()){ob_end_clean();exit;}}elseif(isset($_GET["variables"])){$P=isset($_GET["status"]);page_header($P?lang(119):lang(118));$pj=($P?show_status():show_variables());if(!$pj)echo"<p class='message'>".lang(12)."\n";else{echo"<table>\n";foreach($pj
as$K){echo"<tr>";$y=array_shift($K);echo"<th><code class='jush-".JUSH.($P?"status":"set")."'>".h($y)."</code>";foreach($K
as$X)echo"<td>".nl_br(h($X));}echo"</table>\n";}}elseif(isset($_GET["script"])){header("Content-Type: text/javascript; charset=utf-8");if($_GET["script"]=="db"){$di=array("Data_length"=>0,"Index_length"=>0,"Data_free"=>0);foreach(table_status()as$C=>$S){json_row("Comment-$C",h($S["Comment"]));if(!is_view($S)){foreach(array("Engine","Collation")as$y)json_row("$y-$C",h($S[$y]));foreach($di+array("Auto_increment"=>0,"Rows"=>0)as$y=>$X){if($S[$y]!=""){$X=format_number($S[$y]);if($X>=0)json_row("$y-$C",($y=="Rows"&&$X&&$S["Engine"]==(JUSH=="pgsql"?"table":"InnoDB")?"~ $X":$X));if(isset($di[$y]))$di[$y]+=($S["Engine"]!="InnoDB"||$y!="Data_free"?$S[$y]:0);}elseif(array_key_exists($y,$S))json_row("$y-$C","?");}}}foreach($di
as$y=>$X)json_row("sum-$y",format_number($X));json_row("");}elseif($_GET["script"]=="kill")connection()->query("KILL ".number($_POST["kill"]));else{foreach(count_tables(adminer()->databases())as$k=>$X){json_row("tables-$k",$X);json_row("size-$k",db_size($k));}json_row("");}exit;}else{$oi=array_merge((array)$_POST["tables"],(array)$_POST["views"]);if($oi&&!$m&&!$_POST["search"]){$I=true;$Ze="";if(JUSH=="sql"&&$_POST["tables"]&&count($_POST["tables"])>1&&($_POST["drop"]||$_POST["truncate"]||$_POST["copy"]))queries("SET foreign_key_checks = 0");if($_POST["truncate"]){if($_POST["tables"])$I=truncate_tables($_POST["tables"]);$Ze=lang(273);}elseif($_POST["move"]){$I=move_tables((array)$_POST["tables"],(array)$_POST["views"],$_POST["target"]);$Ze=lang(274);}elseif($_POST["copy"]){$I=copy_tables((array)$_POST["tables"],(array)$_POST["views"],$_POST["target"]);$Ze=lang(275);}elseif($_POST["drop"]){if($_POST["views"])$I=drop_views($_POST["views"]);if($I&&$_POST["tables"])$I=drop_tables($_POST["tables"]);$Ze=lang(276);}elseif(JUSH=="sqlite"&&$_POST["check"]){foreach((array)$_POST["tables"]as$R){foreach(get_rows("PRAGMA integrity_check(".q($R).")")as$K)$Ze
.="<b>".h($R)."</b>: ".h($K["integrity_check"])."<br>";}}elseif(JUSH!="sql"){$I=(JUSH=="sqlite"?queries("VACUUM"):apply_queries("VACUUM".($_POST["optimize"]?"":" ANALYZE"),$_POST["tables"]));$Ze=lang(277);}elseif(!$_POST["tables"])$Ze=lang(9);elseif($I=queries(($_POST["optimize"]?"OPTIMIZE":($_POST["check"]?"CHECK":($_POST["repair"]?"REPAIR":"ANALYZE")))." TABLE ".implode(", ",array_map('Adminer\idf_escape',$_POST["tables"])))){while($K=$I->fetch_assoc())$Ze
.="<b>".h($K["Table"])."</b>: ".h($K["Msg_text"])."<br>";}queries_redirect(substr(ME,0,-1),$Ze,$I);}page_header(($_GET["ns"]==""?lang(36).": ".h(DB):lang(75).": ".h($_GET["ns"])),$m,true);if(adminer()->homepage()){if($_GET["ns"]!==""){echo"<h3 id='tables-views'>".lang(278)."</h3>\n";$ni=tables_list();if(!$ni)echo"<p class='message'>".lang(9)."\n";else{echo"<form action='' method='post'>\n";if(support("table")){echo"<fieldset><legend>".lang(279)." <span id='selected2'></span></legend><div>","<input type='search' name='query' value='".h($_POST["query"])."'>",script("qsl('input').onkeydown = partialArg(bodyKeydown, 'search');","")," <input type='submit' name='search' value='".lang(55)."'>\n","</div></fieldset>\n";if($_POST["search"]&&$_POST["query"]!=""){$_GET["where"][0]["op"]=driver()->convertOperator("LIKE %%");search_tables();}}echo"<div class='scrollable'>\n","<table class='nowrap checkable odds'>\n",script("mixin(qsl('table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true)});"),'<thead><tr class="wrap">','<td><input id="check-all" type="checkbox" class="jsonly">'.script("qs('#check-all').onclick = partial(formCheck, /^(tables|views)\[/);",""),'<th>'.lang(134),'<td>'.lang(280).doc_link(array('sql'=>'storage-engines.html')),'<td>'.lang(123).doc_link(array('sql'=>'charset-charsets.html','mariadb'=>'supported-character-sets-and-collations/')),'<td>'.lang(281).doc_link(array('sql'=>'show-table-status.html','pgsql'=>'functions-admin.html#FUNCTIONS-ADMIN-DBOBJECT','oracle'=>'REFRN20286')),'<td>'.lang(282).doc_link(array('sql'=>'show-table-status.html','pgsql'=>'functions-admin.html#FUNCTIONS-ADMIN-DBOBJECT')),'<td>'.lang(283).doc_link(array('sql'=>'show-table-status.html')),'<td>'.lang(50).doc_link(array('sql'=>'example-auto-increment.html','mariadb'=>'auto_increment/')),'<td>'.lang(284).doc_link(array('sql'=>'show-table-status.html','pgsql'=>'catalog-pg-class.html#CATALOG-PG-CLASS','oracle'=>'REFRN20286')),(support("comment")?'<td>'.lang(49).doc_link(array('sql'=>'show-table-status.html','pgsql'=>'functions-info.html#FUNCTIONS-INFO-COMMENT-TABLE')):''),"</thead>\n";$T=0;foreach($ni
as$C=>$U){$sj=($U!==null&&!preg_match('~table|sequence~i',$U));$u=h("Table-".$C);echo'<tr><td>'.checkbox(($sj?"views[]":"tables[]"),$C,in_array("$C",$oi,true),"","","",$u),'<th>'.(support("table")||support("indexes")?"<a href='".h(ME)."table=".urlencode($C)."' title='".lang(41)."' id='$u'>".h($C).'</a>':h($C));if($sj)echo'<td colspan="6"><a href="'.h(ME)."view=".urlencode($C).'" title="'.lang(42).'">'.(preg_match('~materialized~i',$U)?lang(132):lang(133)).'</a>','<td align="right"><a href="'.h(ME)."select=".urlencode($C).'" title="'.lang(40).'">?</a>';else{foreach(array("Engine"=>array(),"Collation"=>array(),"Data_length"=>array("create",lang(43)),"Index_length"=>array("indexes",lang(136)),"Data_free"=>array("edit",lang(44)),"Auto_increment"=>array("auto_increment=1&create",lang(43)),"Rows"=>array("select",lang(40)),)as$y=>$A){$u=" id='$y-".h($C)."'";echo($A?"<td align='right'>".(support("table")||$y=="Rows"||(support("indexes")&&$y!="Data_length")?"<a href='".h(ME."$A[0]=").urlencode($C)."'$u title='$A[1]'>?</a>":"<span$u>?</span>"):"<td id='$y-".h($C)."'>");}$T++;}echo(support("comment")?"<td id='Comment-".h($C)."'>":""),"\n";}echo"<tr><td><th>".lang(257,count($ni)),"<td>".h(JUSH=="sql"?get_val("SELECT @@default_storage_engine"):""),"<td>".h(db_collation(DB,collations()));foreach(array("Data_length","Index_length","Data_free")as$y)echo"<td align='right' id='sum-$y'>";echo"\n","</table>\n","</div>\n";if(!information_schema(DB)){echo"<div class='footer'><div>\n";$mj="<input type='submit' value='".lang(285)."'> ".on_help("'VACUUM'");$Lf="<input type='submit' name='optimize' value='".lang(286)."'> ".on_help(JUSH=="sql"?"'OPTIMIZE TABLE'":"'VACUUM OPTIMIZE'");echo"<fieldset><legend>".lang(127)." <span id='selected'></span></legend><div>".(JUSH=="sqlite"?$mj."<input type='submit' name='check' value='".lang(287)."'> ".on_help("'PRAGMA integrity_check'"):(JUSH=="pgsql"?$mj.$Lf:(JUSH=="sql"?"<input type='submit' value='".lang(288)."'> ".on_help("'ANALYZE TABLE'").$Lf."<input type='submit' name='check' value='".lang(287)."'> ".on_help("'CHECK TABLE'")."<input type='submit' name='repair' value='".lang(289)."'> ".on_help("'REPAIR TABLE'"):"")))."<input type='submit' name='truncate' value='".lang(290)."'> ".on_help(JUSH=="sqlite"?"'DELETE'":"'TRUNCATE".(JUSH=="pgsql"?"'":" TABLE'")).confirm()."<input type='submit' name='drop' value='".lang(128)."'>".on_help("'DROP TABLE'").confirm()."\n";$j=(support("scheme")?adminer()->schemas():adminer()->databases());if(count($j)!=1&&JUSH!="sqlite"){$k=(isset($_POST["target"])?$_POST["target"]:(support("scheme")?$_GET["ns"]:DB));echo"<p><label>".lang(291).": ",($j?html_select("target",$j,$k):'<input name="target" value="'.h($k).'" autocapitalize="off">'),"</label> <input type='submit' name='move' value='".lang(292)."'>",(support("copy")?" <input type='submit' name='copy' value='".lang(293)."'> ".checkbox("overwrite",1,$_POST["overwrite"],lang(294)):""),"\n";}echo"<input type='hidden' name='all' value=''>",script("qsl('input').onclick = function () { selectCount('selected', formChecked(this, /^(tables|views)\[/));".(support("table")?" selectCount('selected2', formChecked(this, /^tables\[/) || $T);":"")." }"),input_token(),"</div></fieldset>\n","</div></div>\n";}echo"</form>\n",script("tableCheck();");}echo"<p class='links'><a href='".h(ME)."create='>".lang(73)."</a>\n",(support("view")?"<a href='".h(ME)."view='>".lang(210)."</a>\n":"");if(support("routine")){echo"<h3 id='routines'>".lang(148)."</h3>\n";$kh=routines();if($kh){echo"<table class='odds'>\n",'<thead><tr><th>'.lang(189).'<td>'.lang(48).'<td>'.lang(227)."<td></thead>\n";foreach($kh
as$K){$C=($K["SPECIFIC_NAME"]==$K["ROUTINE_NAME"]?"":"&name=".urlencode($K["ROUTINE_NAME"]));echo'<tr>','<th><a href="'.h(ME.($K["ROUTINE_TYPE"]!="PROCEDURE"?'callf=':'call=').urlencode($K["SPECIFIC_NAME"]).$C).'">'.h($K["ROUTINE_NAME"]).'</a>','<td>'.h($K["ROUTINE_TYPE"]),'<td>'.h($K["DTD_IDENTIFIER"]),'<td><a href="'.h(ME.($K["ROUTINE_TYPE"]!="PROCEDURE"?'function=':'procedure=').urlencode($K["SPECIFIC_NAME"]).$C).'">'.lang(139)."</a>";}echo"</table>\n";}echo'<p class="links">'.(support("procedure")?'<a href="'.h(ME).'procedure=">'.lang(226).'</a>':'').'<a href="'.h(ME).'function=">'.lang(225)."</a>\n";}if(support("sequence")){echo"<h3 id='sequences'>".lang(295)."</h3>\n";$Bh=get_vals("SELECT sequence_name FROM information_schema.sequences WHERE sequence_schema = current_schema() ORDER BY sequence_name");if($Bh){echo"<table class='odds'>\n","<thead><tr><th>".lang(189)."</thead>\n";foreach($Bh
as$X)echo"<tr><th><a href='".h(ME)."sequence=".urlencode($X)."'>".h($X)."</a>\n";echo"</table>\n";}echo"<p class='links'><a href='".h(ME)."sequence='>".lang(232)."</a>\n";}if(support("type")){echo"<h3 id='user-types'>".lang(31)."</h3>\n";$kj=types();if($kj){echo"<table class='odds'>\n","<thead><tr><th>".lang(189)."</thead>\n";foreach($kj
as$X)echo"<tr><th><a href='".h(ME)."type=".urlencode($X)."'>".h($X)."</a>\n";echo"</table>\n";}echo"<p class='links'><a href='".h(ME)."type='>".lang(236)."</a>\n";}if(support("event")){echo"<h3 id='events'>".lang(149)."</h3>\n";$L=get_rows("SHOW EVENTS");if($L){echo"<table>\n","<thead><tr><th>".lang(189)."<td>".lang(296)."<td>".lang(216)."<td>".lang(217)."<td></thead>\n";foreach($L
as$K)echo"<tr>","<th>".h($K["Name"]),"<td>".($K["Execute at"]?lang(297)."<td>".$K["Execute at"]:lang(218)." ".$K["Interval value"]." ".$K["Interval field"]."<td>$K[Starts]"),"<td>$K[Ends]",'<td><a href="'.h(ME).'event='.urlencode($K["Name"]).'">'.lang(139).'</a>';echo"</table>\n";$Fc=get_val("SELECT @@event_scheduler");if($Fc&&$Fc!="ON")echo"<p class='error'><code class='jush-sqlset'>event_scheduler</code>: ".h($Fc)."\n";}echo'<p class="links"><a href="'.h(ME).'event=">'.lang(215)."</a>\n";}if($ni)echo
script("ajaxSetHtml('".js_escape(ME)."script=db');");}}}page_footer();