<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */

/**
 * Enable, adjust and copy this code for each store you run
 *
 * Store #0, default one
 *
 * if (isHttpHost("example.com")) {
 *    $_SERVER["MAGE_RUN_CODE"] = "default";
 *    $_SERVER["MAGE_RUN_TYPE"] = "store";
 * }
 *
 * @param string $host
 * @return bool
 */
function isHttpHost(string $host)
{
    if (!isset($_SERVER['HTTP_HOST'])) {
        return false;
    }
    return $_SERVER['HTTP_HOST'] === $host;
}

if (isHttpHost("mcprod.britwyn.co.nz")
) {
    $_SERVER["MAGE_RUN_CODE"] = "admin";
    $_SERVER["MAGE_RUN_TYPE"] = "store";
} else if (isHttpHost("mcstaging.asicsnz.co.nz")
    || isHttpHost("www.asics.co.nz")
    || isHttpHost("www.asics.com")
    || isHttpHost("www.preprod.asics.com")
) {
    $_SERVER["MAGE_RUN_CODE"] = "asics_view";
    $_SERVER["MAGE_RUN_TYPE"] = "store";
}
