define(
    [
        'Magento_Checkout/js/model/quote',
        'jquery',
        'uiRegistry',
        'mage/translate',
        'Magento_Checkout/js/view/payment/default',
        'Magento_Checkout/js/action/place-order',
        'Magento_Checkout/js/action/set-billing-address',
        'Verifone_Hosted/js/action/set-payment-method',
        'Magento_Checkout/js/action/select-payment-method',
        'Magento_Checkout/js/model/payment/additional-validators',
        'Magento_Checkout/js/model/full-screen-loader',
        'Magento_Ui/js/model/messageList',
        'Magento_Customer/js/customer-data',
        'Magento_Checkout/js/model/error-processor',
        'Magento_SalesRule/js/action/set-coupon-code',
        'Magento_SalesRule/js/action/cancel-coupon',
        'Asics_Verifone/js/model/checkout-registry',
        'domReady!' // awaits for DOM to be loaded
    ],
    function (
        quote,
        $,
        registry,
        $t,
        Component,
        placeOrderAction,
        setBillingAddressAction,
        setPaymentMethodAction,
        selectPaymentMethodAction,
        additionalValidators,
        fullScreenLoader,
        globalMessageList,
        customerData,
        errorProcessor,
        setCouponCodeAction,
        cancelCouponAction,
        checkoutRegistry
    ) {
        'use strict';
        return Component.extend({
            defaults: {
                template: 'Verifone_Hosted/payment/verifone_hosted',
                code: "verifone_hosted",
                customRedirect: true,
                shouldPlaceOrder: true,
                merchantLogos: []
            },

            initialize: function () {
                var self = this;
                this._super();

                setCouponCodeAction.registerSuccessCallback(function () {
                    self.refreshVerifonIframe();
                });
                cancelCouponAction.registerSuccessCallback(function () {
                    self.refreshVerifonIframe();
                });
                quote.billingAddress.subscribe(function (newAddress) {
                    let addressSameAsShippingEl = $('#billing-address-same-as-shipping-' + self.code);
                    if (addressSameAsShippingEl.length > 0 && !addressSameAsShippingEl.is(":checked")
                        && newAddress == null) {
                        let verifonIframeBtn = $(".payment-method._active .action.checkout").parent()
                            .siblings('#payment_form_container_iframe');
                        if (verifonIframeBtn.length > 0) {
                            verifonIframeBtn.remove();
                        }
                    }
                });

                let verifoneConfig = window.checkoutConfig.payment.verifone_hosted;

                if (typeof verifoneConfig.merchantUICustomOptions !== 'undefined') {
                    let merchantLogos = verifoneConfig.merchantUICustomOptions.logos;
                    let index = 0, logoItem;
                    for (index = 0; index < merchantLogos.length; ++index) {
                        logoItem = merchantLogos[index];
                        if (!logoItem.Width) {
                            logoItem.Width = 80;
                        }
                        if (!logoItem.Height) {
                            logoItem.Height = 45;
                        }
                    }
                    this.merchantLogos = merchantLogos;
                }
                /* End - Custom codes */
            },

            refreshVerifonIframe: function () {
                let verifonIframeBtn = $(".payment-method._active .action.checkout").parent()
                    .siblings('#payment_form_container_iframe');
                if (verifonIframeBtn.length > 0) {
                    verifonIframeBtn.remove();
                    $('#continue_verifone').trigger('click');
                }
            },

            continueToVerifone: function (data, event) {
                let self = this,
                    settings = window.checkoutConfig.payment.verifone_hosted;

                /* Start - Custom codes */
                if (quote.billingAddress() != null) {
                    if (this.validate() && additionalValidators.validate()) {
                        if (settings.shouldPlaceOrder !== '1') {
                            this.selectPaymentMethod();
                        }
                        checkoutRegistry.preventGetPaymentInformation();
                        var setBillingInfo = setBillingAddressAction();
                        setBillingInfo.done(function() {
                            self.placeOrder();
                        }).fail(function(response) {
                            checkoutRegistry.allowGetPaymentInformation();
                            if (response.status != 401) {
                                let error = {
                                    message: $t('Something went wrong with your request. Please try again later.')
                                };
                                try {
                                    error = JSON.parse(response.responseText);
                                } catch (exception) {
                                }
                                self.messageContainer.addErrorMessage(error);
                            }
                        });
                        return false;
                    }
                } else {
                    self.verifyBillingAddressForm(self.messageContainer);
                }
                /* End - Custom codes */
            },

            verifyBillingAddressForm: function (messageContainer) {
                let billingAddressForm = $(".payment-method._active .billing-address-form");
                let updateBillingAddressBtn = $(".payment-method._active button.action-update");
                if (billingAddressForm.length && updateBillingAddressBtn.length
                    && billingAddressForm.is(':visible')) {
                    registry.get('checkoutProvider').trigger('billingAddressverifone_hosted.data.validate');
                }
                messageContainer.addErrorMessage(
                    {
                        message: $t('Please enter the required information and click on the "Confirm Address" button!')
                    }
                );
            },

            isShowLegend: function () {
                return true;
            },

            placeOrder: function() {
                var self = this;

                var settings = window.checkoutConfig.payment.verifone_hosted;

                if (settings.shouldPlaceOrder === '1') {
                    let dataBeforeClear = customerData.get('checkout-data')();
                    placeOrderAction(self.getData(), self.messageContainer)
                    .done(function () {
                        if (dataBeforeClear) {
                            customerData.set('checkout-data', dataBeforeClear);
                        }
                        self.redirect(settings);
                    }).fail(function (e) {
                        fullScreenLoader.stopLoader();
                        globalMessageList.addErrorMessage({
                            message: e.responseJSON.message
                        });
                    });
                } else {
                    self.redirect(settings);
                }

                return false;
            },

            redirect: function(settings) {
                var self = this;
                let url = settings.redirectUrl;
                $.ajax({
                    showLoader: true,
                    url: url,
                    type: 'get',
                    context: this,
                    data: {isAjax: 1,email: quote.guestEmail},
                    dataType: 'json',
                    success: function (response, data) {
                        if (response.result === "success") {
                            customerData.invalidate(['cart']);
                            if (response.method === "iframe") {
                                //custom code
                                const popupBackBtn = '.verifone_iframe_container-popup_checkout-back-btn';
                                const containerPopup = '#verifone_iframe_container-popup';

                                const options = {
                                    type: 'popup',
                                    responsive: true,
                                    innerScroll: true,
                                    modalClass: 'verifone-iframe-modal',
                                    overlayClass: 'verifone-iframe-overlay',
                                    closed: function () {
                                        fullScreenLoader.startLoader();
                                        window.location.reload();
                                    },
                                    outerClickHandler: function () {
                                        return false;
                                    },
                                    title: '',
                                    buttons: []
                                };

                                /**
                                 * Only opening the popup if customers are in the payment section
                                 */
                                if (self.isPaymentStepUrl(window.location.href)) {
                                    $(containerPopup).modal(options).modal('openModal');

                                    $(popupBackBtn).on('click', function () {
                                        $(containerPopup).modal('closeModal');
                                    });

                                    // reload page if back button clicked
                                    window.addEventListener('hashchange', function (event) {
                                        if (self.isPaymentStepUrl(event.oldURL)
                                            && self.isShippingStepUrl(event.newURL)
                                        ) {
                                            fullScreenLoader.startLoader();
                                            window.location.reload();
                                        }
                                    });

                                    function loadIframe(src, containerId) {
                                        var script = document.createElement('script');
                                        script.src = src;
                                        script.async = true;
                                        document.getElementById(containerId).append(script);
                                    }

                                    loadIframe(
                                        response.url,
                                        'verifone_iframe_container'
                                    );
                                    setTimeout(function() {
                                        $('iframe').css("outline","none");
                                        $('iframe').css("border","none");
                                        $('iframe').css("height","100%");
                                    }, 1000);
                                }
                            } else if (typeof response.redirect !== "undefined") {
                                if (settings.shouldPlaceOrder !== '1') {
                                    setPaymentMethodAction();
                                }
                                window.location.href = response.redirect;
                            } else {
                                fullScreenLoader.stopLoader();
                            }
                        } else {
                            globalMessageList.addErrorMessage({
                                message: response.messages
                            });

                            // redirect to cancel the order and load the original quote
                            if (settings.shouldPlaceOrder === '1') {
                                window.location.href = url;
                            }
                        }
                    },
                    error: function (response, data) {
                        console.log('Verifone redirect response error: ' + JSON.stringify(response));
                        console.log('Verifone redirect data error: ' + data);
                        alert('An error occurred. Try again!');
                    },
                    complete: function (response) {
                        fullScreenLoader.stopLoader();
                    }
                });
            },

            isShippingStepUrl: function (urlString) {
                var url = URL.parse(urlString);

                return url
                    && url.pathname.match(/.*\/checkout\/?/) !== null
                    && url.hash === '#shipping';
            },

            isPaymentStepUrl: function (urlString) {
                var url = URL.parse(urlString);

                return url
                    && url.pathname.match(/.*\/checkout\/?/) !== null
                    && url.hash === '#payment';
            },

            clearCheckoutData: function () {
                var clearData = {
                    'selectedShippingAddress': null,
                    'shippingAddressFromData': null,
                    'newCustomerShippingAddress': null,
                    'selectedShippingRate': null,
                    'selectedPaymentMethod': null,
                    'selectedBillingAddress': null,
                    'billingAddressFromData': null,
                    'newCustomerBillingAddress': null
                };
                customerData.set('checkout-data', clearData);
            },

            /**
             * Close Verifone popup
             */
            closeModalPopup: function () {
                let paymentMethod = quote.paymentMethod();
                if (paymentMethod && paymentMethod.method === this.code) {
                    let containerPopup = $('#verifone_iframe_container-popup'),
                        popupBackBtn = $('.verifone_iframe_container-popup_checkout-back-btn');
                    if (containerPopup.length && popupBackBtn.length) {
                        popupBackBtn.click();
                    }
                }
            }
        });
    });
