define([
    'jquery',
    'mage/url',
    'mage/translate',
    'jquery-ui-modules/widget',
], function ($,url, $t) {
    'use strict';

    return function (widget) {
        $.widget('mage.SwatchRenderer', widget, {
            options: {
                selectorAddToCartBtn: '#product-addtocart-button',
            },
            /**
             * Render controls
             *
             * @private
             */
            _RenderControls: function () {
                var $widget = this,
                    container = this.element,
                    classes = this.options.classes,
                    chooseText = this.options.jsonConfig.chooseText,
                    showTooltip = this.options.showTooltip;

                $widget.optionsMap = {};

                $.each(this.options.jsonConfig.attributes, function () {
                    var item = this,
                        controlLabelId = 'option-label-' + item.code + '-' + item.id,
                        options = $widget._RenderSwatchOptions(item, controlLabelId),
                        select = $widget._RenderSwatchSelect(item, chooseText),
                        input = $widget._RenderFormInput(item),
                        listLabel = '',
                        label = '',
                        labelExtra = '';

                    // Show only swatch controls
                    if ($widget.options.onlySwatches && !$widget.options.jsonSwatchConfig.hasOwnProperty(item.id)) {
                        return;
                    }

                    if ($widget.options.enableControlLabel) {
                        label += '<div class="product-detail__swatch-label-container">';
                        label +=
                            '<span id="' + controlLabelId + '" class="' + classes.attributeLabelClass + '">' +
                            $('<i></i>').text(item.label).html() +
                            labelExtra +
                            '</span>' +
                            '<span class="' + classes.attributeSelectedOptionLabelClass + '"></span>';

                        label += '</div>';
                    }

                    if ($widget.inProductList) {
                        $widget.productForm.append(input);
                        input = '';
                        listLabel = 'aria-label="' + $('<i></i>').text(item.label).html() + '"';
                    } else {
                        listLabel = 'aria-labelledby="' + controlLabelId + '"';
                    }

                    // Create new control
                    container.append(
                        '<div class="' + classes.attributeClass + ' ' + item.code + '" ' +
                            'data-attribute-code="' + item.code + '" ' +
                            'data-attribute-id="' + item.id + '">' +
                            label +
                            '<div aria-activedescendant="" ' +
                                'tabindex="0" ' +
                                'aria-invalid="false" ' +
                                'aria-required="true" ' +
                                'role="listbox" ' + listLabel +
                                'class="' + classes.attributeOptionsWrapper + ' clearfix">' +
                                options + select +
                            '</div>' + input +
                        '</div>'
                    );

                    $widget.optionsMap[item.id] = {};

                    // Aggregate options array to hash (key => value)
                    $.each(item.options, function () {
                        if (this.products.length > 0) {
                            $widget.optionsMap[item.id][this.id] = {
                                price: parseInt(
                                    $widget.options.jsonConfig.optionPrices[this.products[0]].finalPrice.amount,
                                    10
                                ),
                                products: this.products
                            };
                        }
                    });
                });

                if (showTooltip === 1) {
                    // Connect Tooltip
                    container
                        .find('[data-option-type="1"], [data-option-type="2"],' +
                            ' [data-option-type="0"], [data-option-type="3"]')
                        .SwatchRendererTooltip();
                }

                // Hide all elements below more button
                $('.' + classes.moreButton).nextAll().hide();

                // Handle events like click or change
                $widget._EventListener();

                // Rewind options
                $widget._Rewind(container);

                //Emulate click on all swatches from Request
                $widget._EmulateSelected($.parseQuery());
                $widget._EmulateSelected($widget._getSelectedAttributes());
            },
            /**
             * Event for swatch options
             *
             * @param {Object} $this
             * @param {Object} $widget
             * @private
             */
            _OnClick: function ($this, $widget) {

                var $parent = $this.parents('.' + $widget.options.classes.attributeClass),
                    $wrapper = $this.parents('.' + $widget.options.classes.attributeOptionsWrapper),
                    $label = $parent.find('.' + $widget.options.classes.attributeSelectedOptionLabelClass),
                    attributeId = $parent.data('attribute-id'),
                    $input = $parent.find('.' + $widget.options.classes.attributeInput),
                    checkAdditionalData = JSON.parse(this.options.jsonSwatchConfig[attributeId]['additional_data']),
                    $priceBox = $widget.element.parents($widget.options.selectorProduct)
                        .find(this.options.selectorProductPrice);

                if ($widget.inProductList) {
                    $input = $widget.productForm.find(
                        '.' + $widget.options.classes.attributeInput + '[name="super_attribute[' + attributeId + ']"]'
                    );
                }

                if ($this.hasClass('disabled')) {
                    return;
                }

                if ($this.hasClass('selected')) {
                    $(this.options.selectorAddToCartBtn).text($t('Select Size')).addClass('not-allowed').attr('title', 'Select Size')
                    $parent.removeAttr('data-option-selected').find('.selected').removeClass('selected');
                    $input.val('');
                    $label.text('');
                    $this.attr('aria-checked', false);

                    //hide availability
                    document.querySelector('#productDetailAvailabilityContainer').classList.remove('size-selected')
                } else {
                    $(this.options.selectorAddToCartBtn).text($t('Add to Cart')).removeClass('not-allowed').attr('title', 'Add to Cart')
                    $parent.attr('data-option-selected', $this.data('option-id')).find('.selected').removeClass('selected');
                    $label.text($this.data('option-label'));
                    $input.val($this.data('option-id'));
                    $input.attr('data-attr-name', this._getAttributeCodeById(attributeId));
                    $this.addClass('selected');
                    $widget._toggleCheckedAttributes($this, $wrapper);

                    //show availability
                    document.querySelector('#productDetailAvailabilityContainer').classList.add('size-selected')
                }

                $widget._Rebuild();

                if ($priceBox.is(':data(mage-priceBox)')) {
                    $widget._UpdatePrice();
                }

                $(document).trigger('updateMsrpPriceBlock',
                    [
                        this._getSelectedOptionPriceIndex(),
                        $widget.options.jsonConfig.optionPrices,
                        $priceBox
                    ]);

                if (parseInt(checkAdditionalData['update_product_preview_image'], 10) === 1) {
                    $widget._loadMedia();
                }





                //update select dropdown quantity
                var productId = $this.data('product-id');
                var getStockQtyUrl = url.build('overdosecatalog/index/index');



                document.body.querySelector('.box-tocart').classList.add('loading');
                $.ajax({
                    url : getStockQtyUrl,
                    type: 'GET',
                    cache: false,
                    data: {
                        productId: productId
                    },
                    dataType:'json',
                    success: function(data) {
                        // if (data) {
                        //     $('#estimated-time-frame').html(data.estimateblock);
                        // }

                        var stockQty = (data.stockQty>=10)?10:data.stockQty;

                        var quantitySelect = document.body.querySelector('#qty');
                        var quantityOptions = '';
                        for(var i=1; i<=stockQty; i++){
                            quantityOptions+= '<option value="' + i + '">' + i + '</option>'
                        }

                        if(stockQty < 1){
                            quantityOptions = '<option value="0">0</option>';
                        }

                        document.body.querySelector('.box-tocart').classList.remove('loading');
                        quantitySelect.innerHTML = quantityOptions;
                    }
                });




                $input.trigger('change');
            },
                    /**
         * Render swatch options by part of config
         *
         * @param {Object} config
         * @param {String} controlId
         * @returns {String}
         * @private
         */
        _RenderSwatchOptions: function (config, controlId) {
            var optionConfig = this.options.jsonSwatchConfig[config.id],
                optionClass = this.options.classes.optionClass,
                sizeConfig = this.options.jsonSwatchImageSizeConfig,
                moreLimit = parseInt(this.options.numberToShow, 10),
                moreClass = this.options.classes.moreButton,
                moreText = this.options.moreButtonText,
                countAttributes = 0,
                html = '';

            if (!this.options.jsonSwatchConfig.hasOwnProperty(config.id)) {
                return '';
            }

            //convert config.options into obj for better data extraction
            var configOptionsTransformed = {};
            config.options.forEach((option)=>{configOptionsTransformed[option.id] = option;});








            //create newConfigOptions to replace config.options because config.options doesn't include out of stock configurable products for some dumb reason >:(
            var newConfigOptions = [];


            // for(var key in optionConfig) {
            //     if(key !== 'additional_data'){
            //         newConfigOptions.push({
            //             id: key,
            //             label: optionConfig[key].label,
            //             products: (configOptionsTransformed[key])?configOptionsTransformed[key].products:[]
            //         })
            //     }
            // }




            //configurable option sort order
            var configurableProductSortOrderObj = this.options.jsonConfig.index;


            for(var sortOrderKey in configurableProductSortOrderObj){
                if(configurableProductSortOrderObj[sortOrderKey]){
                    var configOptionKey = configurableProductSortOrderObj[sortOrderKey][config.id];

                    newConfigOptions.push({
                        id: configOptionKey,
                        label: optionConfig[configOptionKey].label,
                        products: (configOptionsTransformed[configOptionKey])?configOptionsTransformed[configOptionKey].products:[]
                    })
                }
            }









            //rearrange this array

            //loop through newConfigOptions instead of config.options
            $.each(newConfigOptions, function (index) {
                var id,
                    type,
                    value,
                    thumb,
                    label,
                    width,
                    height,
                    attr,
                    swatchImageWidth,
                    swatchImageHeight;

                if (!optionConfig.hasOwnProperty(this.id)) {
                    return '';
                }

                // Add more button
                if (moreLimit === countAttributes++) {
                    html += '<a href="#" class="' + moreClass + '"><span>' + moreText + '</span></a>';
                }

                id = this.id;
                type = parseInt(optionConfig[id].type, 10);
                value = optionConfig[id].hasOwnProperty('value') ?
                    $('<i></i>').text(optionConfig[id].value).html() : '';
                thumb = optionConfig[id].hasOwnProperty('thumb') ? optionConfig[id].thumb : '';
                width = _.has(sizeConfig, 'swatchThumb') ? sizeConfig.swatchThumb.width : 110;
                height = _.has(sizeConfig, 'swatchThumb') ? sizeConfig.swatchThumb.height : 90;
                label = this.label ? $('<i></i>').text(this.label).html() : '';
                attr =
                    ' id="' + controlId + '-item-' + id + '"' +
                    ' index="' + index + '"' +
                    ' aria-checked="false"' +
                    ' aria-describedby="' + controlId + '"' +
                    ' tabindex="0"' +
                    ' data-option-type="' + type + '"' +
                    ' data-option-id="' + id + '"' +
                    ' data-option-label="' + label + '"' +
                    ' aria-label="' + label + '"' +
                    ' role="option"' +
                    ' data-thumb-width="' + width + '"' +
                    ' data-thumb-height="' + height + '"';


                if(this.products.length > 0){
                    attr += ' data-product-id="' + this.products[0]  + '"'
                }

                attr += thumb !== '' ? ' data-option-tooltip-thumb="' + thumb + '"' : '';
                attr += value !== '' ? ' data-option-tooltip-value="' + value + '"' : '';

                swatchImageWidth = _.has(sizeConfig, 'swatchImage') ? sizeConfig.swatchImage.width : 30;
                swatchImageHeight = _.has(sizeConfig, 'swatchImage') ? sizeConfig.swatchImage.height : 20;

                if (!this.hasOwnProperty('products') || this.products.length <= 0) {
                    attr += ' data-option-empty="true"';
                }

                if (type === 0) {
                    // Text
                    html += '<div class="' + optionClass + ' text" ' + attr + '>' + (value ? value : label) +
                        '</div>';
                } else if (type === 1) {
                    // Color
                    html += '<div class="' + optionClass + ' color" ' + attr +
                        ' style="background: ' + value +
                        ' no-repeat center; background-size: initial;">' + '' +
                        '</div>';
                } else if (type === 2) {
                    // Image
                    html += '<div class="' + optionClass + ' image" ' + attr +
                        ' style="background: url(' + value + ') no-repeat center; background-size: initial;width:' +
                        swatchImageWidth + 'px; height:' + swatchImageHeight + 'px">' + '' +
                        '</div>';
                } else if (type === 3) {
                    // Clear
                    html += '<div class="' + optionClass + '" ' + attr + '></div>';
                } else {
                    // Default
                    html += '<div class="' + optionClass + '" ' + attr + '>' + label + '</div>';
                }
            });

            return html;
        },
        });
        return $.mage.SwatchRenderer;
    };
});
