define([
    'ko',
    'Magento_Checkout/js/model/quote',
    'Magento_SalesRule/js/model/coupon'
], function (ko, quote, coupon) {
    'use strict';

    var totals = quote.getTotals(),
        couponCode = coupon.getCouponCode(),
        isApplied = coupon.getIsApplied();

    if (totals()) {
        couponCode(totals()['coupon_code']);
    }

    isApplied(couponCode() != null);

    return function(Component) {
        return Component.extend({
            defaults: {
                customIsApplied: ko.observable(isApplied()),
                links: {
                    customIsApplied: 'checkoutProvider:couponIsApplied'
                },
                exports: {
                    customIsApplied: 'checkoutProvider:couponIsApplied'
                }
            },

            /**
             * Coupon code application procedure
             */
            apply: function () {
                this._super();

                if (this.validate()) {
                    this.customIsApplied(true);
                }
            },

            /**
             * Cancel using coupon
             */
            cancel: function () {
                this._super();

                if (this.validate()) {
                    this.customIsApplied(false);
                }
            },
        });
    }
});
