define([
    "jquery",
    'uiComponent',
    'Magento_Checkout/js/model/quote',
    'matchMedia'
], function ($, Component, quote, mediaCheck) {
    'use strict';

    return Component.extend({
        options:{
            originPaymentBtnSelector: '.checkout-payment-method .payment-methods-container > .actions-toolbar .action.primary.checkout',
            clonePaymentBtnSelector: '#opc-sidebar .sidebar-proceed-button .action.checkout',
            clonePaymentBtnParentSelector: '#opc-sidebar .sidebar-proceed-button'
        },

        /**
         * @param {HTMLElement} element
         */
        calcPadding: function(element) {
            mediaCheck({
                media: '(min-width: 1025px)',
                entry: function() {
                    var initPadding = parseInt(
                        window.getComputedStyle(element, null).getPropertyValue('padding-top')
                    );

                    window.addEventListener('scroll', function() {
                        element.style.paddingTop = Math.max(
                            0, initPadding - document.documentElement.scrollTop
                        ) + 'px';
                    });
                }
            });
        },

        mainBtnClick:function() {
            var self = this;
            $(self.options.originPaymentBtnSelector).click();
        },

        isBtnVisible:function(el) {
            var self = this;
            mediaCheck({
                media: '(min-width: 1025px)',
                entry: function() {
                     $(self.options.clonePaymentBtnParentSelector).hide();
                },
                exit: function() {
                    $(self.options.clonePaymentBtnParentSelectorr).show();
                }
            });
        },

        getCartQty: function () {
            let items = quote.getItems() || [];
            console.log(quote)
            return items.reduce(function (total, item) {
                return total + item.qty;
            }, 0);
        },
    });
});
