define([
    'jquery',
    'Magento_Checkout/js/model/quote',
    'mage/url'
], function($, quote, url) {
    'use strict';

    return function(Component) {

        return Component.extend({

            /**
             * Set selected customer shipping address
             */
            selectAddress: function() {
                this._super();

                this.updateEstimationField();
            },

            /**
             * Update estimate's field after click on selecting address
             */
            updateEstimationField: function() {
                var address = quote.shippingAddress();

                if (address) {
                    var postcode = address.postcode;

                    if (postcode) {
                        $.ajax({
                            url : url.build('estimate/index/update'),
                            type: 'POST',
                            data: {
                                postcode: postcode
                            },
                            dataType:'json',
                            success: function(data) {
                                if (data) {
                                    $('#estimated-time-frame').html(data.estimateblock);
                                }
                            }
                        });
                    }
                }
            }

        });

    };
});
