define([
    'jquery',
    'Magento_Ui/js/grid/columns/column'
], function ($, Column) {
    'use strict';

    return Column.extend({
        hasValue: function(row) {
            if($('.authorization-link--Logout').length && this.getValue(row)){
                return true;
            }
            return false;
        },

        getValue: function (row) {
            return row['extension_attributes']['has_tier_price'];
        },

        getDiscountText: function (row) {
            return row['extension_attributes']['discount_text'];
        },

        getReviewHtml: function (row) {
            return '<div data-bv-show="inline_rating" data-bv-seo="false" data-bv-product-id="'+row['extension_attributes']['formatted_sku']+'" data-bv-redirect-url="'+row['url']+'"></div>'
        }
    });
});
