
define([
    'jquery',
    'mage/cookies'
], function ($) {
    'use strict';

    $.widget('overdose.shoefinder', {
        _create: function () {
            var data = [],
                self = this;

            if (data.length === 0 && $.cookie('shoe-selected') && $.cookie('shoe-selected') !== 'null') {
                data = JSON.parse($.cookie('shoe-selected'));
            }

            $('#btn-stated').click(function () {
                $('#odsf-started').hide();
                $('#shoefinder-wapper').show();
            });

            $('.header-button__mobile-menu').on('click', function() {
                $('#odsf-popup-btn').toggleClass('menu-opened');
            });

            $('.odsf-question').click(function () {
                $('img', this).toggleClass('active');
                $('.explanation-content').toggleClass('active');
            });

            $('.odsf-answer').click(function () {
                var answer = $(this),
                    nextStep = parseInt(answer.attr('data-step')),
                    value = answer.attr('data-value'),
                    progressBar = $('.progressbar-step'),
                    jump = 1,
                    back = $('#odsf-back-btn');

                data[nextStep - 1] = value;

                if (value === 'trail') {
                    nextStep = 4;
                    jump = 2;
                }

                if (answer.parents().eq(5).hasClass('modal-content')) {
                    $.cookie('shoe-step', nextStep - 1);
                    $.cookie('shoe-selected', JSON.stringify(data));
                }

                answer.parent().parent().removeClass('active');
                $('#odsf-step-' + nextStep).addClass('active');
                progressBar.removeClass('progressbar-step-' + (nextStep - jump));
                progressBar.addClass('progressbar-step-' + nextStep);
                scroll(0,0);
                $('.modal-inner-wrap').scrollTop(0);
                if (nextStep > 1 && nextStep < 6) {
                    back.show().attr('data-back-step', nextStep - 1);

                    if (value === 'trail') {
                        back.addClass('trail');
                    }
                    if (value === 'road') {
                        back.removeClass('trail');
                    }
                } else {
                    back.hide();
                }

                if (nextStep === 6) {
                    if (answer.parents().eq(5).hasClass('modal-content')) {
                        var selected = JSON.parse($.cookie('shoe-selected'));

                        if (selected) {
                            data = $.merge(selected, data);
                        }
                    }

                    $.ajax({
                        method: 'GET',
                        cache: true,
                        showLoader: true,
                        url: self.options.findUrl,
                        data: {
                            data: JSON.stringify(data)
                        },
                        success: function (response) {
                            $.cookie('shoe-step', null);
                            $.cookie('shoe-selected', null);
                            window.location.href = response;
                        }
                    });
                }

            });

            $('#odsf-back-btn').click(function () {
                var backBtn = $(this),
                    backStep = parseInt(backBtn.attr('data-back-step')),
                    progressBar = $('.progressbar-step'),
                    selected = JSON.parse($.cookie('shoe-selected')),
                    jump = 1;

                if (backBtn.parents().eq(3).hasClass('modal-content')) {
                    backBtn.click(function () {
                        $.cookie('shoe-step', parseInt($.cookie('shoe-step')) - 1);
                        $.cookie('shoe-selected', JSON.stringify(selected));
                    })
                }

                $('#odsf-step-' + (backStep + 1)).removeClass('active');

                if (selected[2] === 'trail' && backStep === 3) {
                    backStep = 2;
                    jump = 2;
                }

                $('#odsf-step-' + backStep).addClass('active');
                backBtn.attr('data-back-step', backStep - 1);
                progressBar.removeClass('progressbar-step-' + (backStep + jump));
                progressBar.addClass('progressbar-step-' + backStep);
                scroll(0,0);
                $('.modal-inner-wrap').scrollTop(0);
                if (backStep === 1) {
                    backBtn.hide();
                }
            })
        }
    });
    return $.overdose.shoefinder;
});
