<?php

namespace Overdose\ShoeFinder\Controller\Index;

use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Framework\Controller\Result\JsonFactory;

/**
 * Class Find
 * @package Overdose\ShoeFinder\Controller\Index
 */
class Find extends Action
{
    /**
     * @var JsonFactory
     */
    protected $jsonFactory;

    /**
     * Find constructor.
     * @param Context $context
     * @param JsonFactory $jsonFactory
     */
    public function __construct(
        Context $context,
        JsonFactory $jsonFactory
    )
    {
        $this->jsonFactory = $jsonFactory;

        parent::__construct($context);
    }

    public function execute()
    {
        $data = json_decode($this->getRequest()->getParam('data'), true);

        if ($data[2] === 'trail') {
            $category = 'trail-running-shoes';
        } else {
            $category = $data[3];
        }

        $this->_url->addQueryParams(['asics_cushion' => $data['5'], 'asics_pronation' => $data['4'], 'shoe_finder' => 1]);
        $result = $this->_url->getUrl($data[1] . '/shoes/' . $category);

        return $this->jsonFactory->create()->setData($result);
    }
}
